/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.meta.rocksdb;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.entity.LocalFileMetaOutter;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rhea.serialization.Serializers;
import com.alipay.sofa.jraft.rhea.storage.zip.ZipStrategyManager;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter;
import com.alipay.sofa.jraft.util.CRC64;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.Utils;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.File;
import java.nio.file.Paths;
import java.util.concurrent.locks.Lock;
import java.util.zip.Checksum;
import org.apache.commons.io.FileUtils;
import org.apache.rocketmq.mqtt.meta.rocksdb.RocksDBEngine;
import org.rocksdb.Checkpoint;
import org.rocksdb.RocksDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBSnapshot {
    private static Logger logger = LoggerFactory.getLogger(RocksDBSnapshot.class);
    private static final String SNAPSHOT_DIR = "sd";
    private static final String SNAPSHOT_ARCHIVE = "sd.zip";
    private final RocksDBEngine rocksDBEngine;

    public RocksDBSnapshot(RocksDBEngine rocksDBEngine) {
        this.rocksDBEngine = rocksDBEngine;
    }

    public void onSnapshotSave(SnapshotWriter writer, Closure done) {
        String writerPath = writer.getPath();
        String snapshotPath = Paths.get(writerPath, SNAPSHOT_DIR).toString();
        this.writeSnapshot(snapshotPath);
        this.compressSnapshot(writer, this.writeMetadata(null), done);
    }

    public boolean onSnapshotLoad(SnapshotReader reader) {
        LocalFileMetaOutter.LocalFileMeta meta = (LocalFileMetaOutter.LocalFileMeta)reader.getFileMeta(SNAPSHOT_ARCHIVE);
        String readerPath = reader.getPath();
        if (meta == null) {
            logger.error("Can't find rdb snapshot file, path={}.", (Object)readerPath);
            return false;
        }
        String snapshotPath = Paths.get(readerPath, SNAPSHOT_DIR).toString();
        try {
            this.decompressSnapshot(readerPath, meta);
            this.readSnapshot(snapshotPath);
            File tmp = new File(snapshotPath);
            if (tmp.exists()) {
                FileUtils.forceDelete((File)new File(snapshotPath));
            }
            return true;
        }
        catch (Throwable t) {
            logger.error("onSnapshotLoad  failed", t);
            return false;
        }
    }

    private void writeSnapshot(String snapshotPath) {
        Lock lock = this.rocksDBEngine.getReadWriteLock().writeLock();
        lock.lock();
        try (Checkpoint checkpoint = Checkpoint.create((RocksDB)this.rocksDBEngine.getRdb());){
            String tempPath = snapshotPath + "_temp";
            File tempFile = new File(tempPath);
            FileUtils.deleteDirectory((File)tempFile);
            checkpoint.createCheckpoint(tempPath);
            File snapshotFile = new File(snapshotPath);
            FileUtils.deleteDirectory((File)snapshotFile);
            if (!Utils.atomicMoveFile((File)tempFile, (File)snapshotFile, (boolean)true)) {
                throw new RuntimeException("Fail to rename [" + tempPath + "] to [" + snapshotPath + "].");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("writeSnapshot failed " + snapshotPath, e);
        }
        finally {
            lock.unlock();
        }
    }

    private void compressSnapshot(SnapshotWriter writer, LocalFileMetaOutter.LocalFileMeta.Builder metaBuilder, Closure done) {
        String writerPath = writer.getPath();
        String outputFile = Paths.get(writerPath, SNAPSHOT_ARCHIVE).toString();
        try {
            CRC64 checksum = new CRC64();
            ZipStrategyManager.getDefault().compress(writerPath, SNAPSHOT_DIR, outputFile, (Checksum)checksum);
            metaBuilder.setChecksum(Long.toHexString(checksum.getValue()));
            if (writer.addFile(SNAPSHOT_ARCHIVE, (Message)metaBuilder.build())) {
                done.run(Status.OK());
            } else {
                done.run(new Status(RaftError.EIO, "Fail to add snapshot file: %s", new Object[]{writerPath}));
            }
        }
        catch (Throwable t) {
            logger.error("compressSnapshot failed", t);
            done.run(new Status(RaftError.EIO, "Fail to compress snapshot at %s, error is %s", new Object[]{writerPath, t.getMessage()}));
        }
    }

    private void decompressSnapshot(String readerPath, LocalFileMetaOutter.LocalFileMeta meta) throws Throwable {
        String sourceFile = Paths.get(readerPath, SNAPSHOT_ARCHIVE).toString();
        CRC64 checksum = new CRC64();
        ZipStrategyManager.getDefault().deCompress(sourceFile, readerPath, (Checksum)checksum);
        if (meta.hasChecksum()) {
            Requires.requireTrue((boolean)meta.getChecksum().equals(Long.toHexString(checksum.getValue())), (Object)"Snapshot checksum failed");
        }
    }

    private void readSnapshot(String snapshotPath) {
        Lock lock = this.rocksDBEngine.getReadWriteLock().readLock();
        lock.lock();
        try {
            File snapshotFile = new File(snapshotPath);
            if (!snapshotFile.exists()) {
                logger.error("Snapshot file [{}] not exists.", (Object)snapshotPath);
                return;
            }
            this.rocksDBEngine.closeRocksDB();
            File dbFile = new File(this.rocksDBEngine.getRdbPath());
            FileUtils.deleteDirectory((File)dbFile);
            if (!Utils.atomicMoveFile((File)snapshotFile, (File)dbFile, (boolean)true)) {
                throw new RuntimeException("Fail to rename [" + snapshotPath + "] to [" + this.rocksDBEngine.getRdbPath() + "].");
            }
            this.rocksDBEngine.openRocksDB();
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to read snapshot from path: " + snapshotPath, e);
        }
        finally {
            lock.unlock();
        }
    }

    private LocalFileMetaOutter.LocalFileMeta.Builder writeMetadata(LocalFileMetaOutter.LocalFileMeta metadata) {
        if (metadata == null) {
            return LocalFileMetaOutter.LocalFileMeta.newBuilder();
        }
        return LocalFileMetaOutter.LocalFileMeta.newBuilder().setUserMeta(ByteString.copyFrom((byte[])Serializers.getDefault().writeObject((Object)metadata)));
    }
}

