/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.client;

import com.alipay.sofa.jraft.util.Requires;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FutureGroup<V>
extends CompletableFuture<V> {
    private final List<CompletableFuture<V>> futures;
    private volatile CompletableFuture<V>[] array;

    public FutureGroup(List<CompletableFuture<V>> futures) {
        this.futures = (List)Requires.requireNonNull(futures, (String)"futures");
    }

    public List<CompletableFuture<V>> futures() {
        return this.futures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<V>[] toArray() {
        if (this.array == null) {
            FutureGroup futureGroup = this;
            synchronized (futureGroup) {
                if (this.array == null) {
                    CompletableFuture[] temp = new CompletableFuture[this.futures.size()];
                    this.futures.toArray(temp);
                    this.array = temp;
                }
            }
        }
        return this.array;
    }

    public int size() {
        return this.futures.size();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean result = true;
        for (CompletableFuture<V> f : this.futures) {
            result = result && f.cancel(mayInterruptIfRunning);
        }
        return result;
    }

    @Override
    public boolean isCancelled() {
        for (CompletableFuture<V> f : this.futures) {
            if (f.isCancelled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDone() {
        for (CompletableFuture<V> f : this.futures) {
            if (f.isDone()) continue;
            return false;
        }
        return true;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException("get");
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException("get");
    }
}

