/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.client;

import com.alipay.sofa.jraft.rhea.client.LoadBalancer;
import com.alipay.sofa.jraft.rhea.util.Maps;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class RoundRobinLoadBalancer
implements LoadBalancer {
    private static final ConcurrentMap<Long, RoundRobinLoadBalancer> container = Maps.newConcurrentMapLong();
    private static final AtomicIntegerFieldUpdater<RoundRobinLoadBalancer> indexUpdater = AtomicIntegerFieldUpdater.newUpdater(RoundRobinLoadBalancer.class, "index");
    private volatile int index = 0;

    public static RoundRobinLoadBalancer getInstance(long regionId) {
        RoundRobinLoadBalancer instance = (RoundRobinLoadBalancer)container.get(regionId);
        if (instance == null) {
            RoundRobinLoadBalancer newInstance = new RoundRobinLoadBalancer();
            instance = container.putIfAbsent(regionId, newInstance);
            if (instance == null) {
                instance = newInstance;
            }
        }
        return instance;
    }

    @Override
    public <T> T select(List<T> elements) {
        if (elements == null) {
            throw new NullPointerException("elements");
        }
        int size = elements.size();
        if (size == 1) {
            return elements.get(0);
        }
        int roundRobinIndex = indexUpdater.getAndIncrement(this) & Integer.MAX_VALUE;
        return elements.get(roundRobinIndex % size);
    }
}

