/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.client.failover.impl;

import com.alipay.sofa.jraft.rhea.client.FutureGroup;
import com.alipay.sofa.jraft.rhea.client.failover.RetryCallable;
import com.alipay.sofa.jraft.rhea.errors.ApiExceptionHelper;
import com.alipay.sofa.jraft.rhea.util.Attachable;
import com.alipay.sofa.jraft.rhea.util.Maps;
import com.alipay.sofa.jraft.rhea.util.StackTraceUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapFailoverFuture<K, V>
extends CompletableFuture<Map<K, V>>
implements Attachable<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(MapFailoverFuture.class);
    private final int retriesLeft;
    private final RetryCallable<Map<K, V>> retryCallable;
    private final Object attachments;

    public MapFailoverFuture(int retriesLeft, RetryCallable<Map<K, V>> retryCallable) {
        this(retriesLeft, retryCallable, null);
    }

    public MapFailoverFuture(int retriesLeft, RetryCallable<Map<K, V>> retryCallable, Object attachments) {
        this.retriesLeft = retriesLeft;
        this.retryCallable = retryCallable;
        this.attachments = attachments;
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        if (this.retriesLeft > 0 && ApiExceptionHelper.isInvalidEpoch(ex)) {
            LOG.warn("[InvalidEpoch-Failover] cause: {}, [{}] retries left.", (Object)StackTraceUtil.stackTrace(ex), (Object)this.retriesLeft);
            FutureGroup<Map<K, V>> futureGroup = this.retryCallable.run(ex);
            CompletableFuture.allOf(futureGroup.toArray()).whenComplete((ignored, throwable) -> {
                if (throwable == null) {
                    HashMap all = Maps.newHashMap();
                    for (CompletableFuture partOf : futureGroup.futures()) {
                        all.putAll((Map)partOf.join());
                    }
                    super.complete(all);
                } else {
                    super.completeExceptionally((Throwable)throwable);
                }
            });
            return false;
        }
        if (this.retriesLeft <= 0) {
            LOG.error("[InvalidEpoch-Failover] cause: {}, {} retries left.", (Object)StackTraceUtil.stackTrace(ex), (Object)this.retriesLeft);
        }
        return super.completeExceptionally(ex);
    }

    @Override
    public Object getAttachments() {
        return this.attachments;
    }
}

