/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.client.pd;

import com.alipay.sofa.jraft.rhea.StoreEngine;
import com.alipay.sofa.jraft.rhea.metadata.Peer;
import com.alipay.sofa.jraft.rhea.metadata.Region;
import com.alipay.sofa.jraft.rhea.metadata.RegionStats;
import com.alipay.sofa.jraft.rhea.metadata.StoreStats;
import com.alipay.sofa.jraft.rhea.metadata.TimeInterval;
import com.alipay.sofa.jraft.rhea.metrics.KVMetrics;
import com.alipay.sofa.jraft.rhea.rocks.support.RocksStatistics;
import com.alipay.sofa.jraft.rhea.storage.BaseRawKVStore;
import com.alipay.sofa.jraft.rhea.storage.RocksRawKVStore;
import com.alipay.sofa.jraft.rhea.storage.StorageType;
import com.codahale.metrics.Counter;
import org.rocksdb.TickerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsCollector {
    private static final Logger LOG = LoggerFactory.getLogger(StatsCollector.class);
    private final StoreEngine storeEngine;
    private final BaseRawKVStore<?> rawKVStore;
    private final RocksRawKVStore rocksRawKVStore;

    public StatsCollector(StoreEngine storeEngine) {
        this.storeEngine = storeEngine;
        this.rawKVStore = storeEngine.getRawKVStore();
        RocksRawKVStore store = null;
        if (storeEngine.getStoreOpts().getStorageType() == StorageType.RocksDB) {
            store = (RocksRawKVStore)this.rawKVStore;
        }
        this.rocksRawKVStore = store;
    }

    public StoreStats collectStoreStats(TimeInterval timeInterval) {
        StoreStats stats = new StoreStats();
        stats.setStoreId(this.storeEngine.getStoreId());
        stats.setCapacity(this.storeEngine.getTotalSpace());
        stats.setAvailable(this.storeEngine.getUsableSpace());
        stats.setRegionCount(this.storeEngine.getRegionCount());
        stats.setLeaderRegionCount(this.storeEngine.getLeaderRegionCount());
        stats.setStartTime(this.storeEngine.getStartTime());
        stats.setBusy(this.storeEngine.isBusy());
        stats.setUsedSize(this.storeEngine.getStoreUsedSpace());
        stats.setBytesWritten(this.getStoreBytesWritten(true));
        stats.setBytesRead(this.getStoreBytesRead(true));
        stats.setKeysWritten(this.getStoreKeysWritten(true));
        stats.setKeysRead(this.getStoreKeysRead(true));
        stats.setInterval(timeInterval);
        LOG.info("Collect [StoreStats]: {}.", (Object)stats);
        return stats;
    }

    public RegionStats collectRegionStats(Region region, TimeInterval timeInterval) {
        RegionStats stats = new RegionStats();
        stats.setRegionId(region.getId());
        stats.setLeader(new Peer(region.getId(), this.storeEngine.getStoreId(), this.storeEngine.getSelfEndpoint()));
        stats.setBytesWritten(this.getRegionBytesWritten(region, true));
        stats.setBytesRead(this.getRegionBytesRead(region, true));
        stats.setKeysWritten(this.getRegionKeysWritten(region, true));
        stats.setKeysRead(this.getRegionKeysRead(region, true));
        stats.setApproximateKeys(this.rawKVStore.getApproximateKeysInRange(region.getStartKey(), region.getEndKey()));
        stats.setInterval(timeInterval);
        LOG.info("Collect [RegionStats]: {}.", (Object)stats);
        return stats;
    }

    public long getStoreBytesWritten(boolean reset) {
        if (this.rocksRawKVStore == null) {
            return 0L;
        }
        if (reset) {
            return RocksStatistics.getAndResetTickerCount(this.rocksRawKVStore, TickerType.BYTES_WRITTEN);
        }
        return RocksStatistics.getTickerCount(this.rocksRawKVStore, TickerType.BYTES_WRITTEN);
    }

    public long getStoreBytesRead(boolean reset) {
        if (this.rocksRawKVStore == null) {
            return 0L;
        }
        if (reset) {
            return RocksStatistics.getAndResetTickerCount(this.rocksRawKVStore, TickerType.BYTES_READ) + RocksStatistics.getAndResetTickerCount(this.rocksRawKVStore, TickerType.NUMBER_MULTIGET_BYTES_READ);
        }
        return RocksStatistics.getTickerCount(this.rocksRawKVStore, TickerType.BYTES_READ) + RocksStatistics.getTickerCount(this.rocksRawKVStore, TickerType.NUMBER_MULTIGET_BYTES_READ);
    }

    public long getStoreKeysWritten(boolean reset) {
        if (this.rocksRawKVStore == null) {
            return 0L;
        }
        if (reset) {
            return RocksStatistics.getAndResetTickerCount(this.rocksRawKVStore, TickerType.NUMBER_KEYS_WRITTEN);
        }
        return RocksStatistics.getTickerCount(this.rocksRawKVStore, TickerType.NUMBER_KEYS_WRITTEN);
    }

    public long getStoreKeysRead(boolean reset) {
        if (this.rocksRawKVStore == null) {
            return 0L;
        }
        if (reset) {
            return RocksStatistics.getAndResetTickerCount(this.rocksRawKVStore, TickerType.NUMBER_KEYS_READ) + RocksStatistics.getAndResetTickerCount(this.rocksRawKVStore, TickerType.NUMBER_MULTIGET_KEYS_READ);
        }
        return RocksStatistics.getTickerCount(this.rocksRawKVStore, TickerType.NUMBER_KEYS_READ) + RocksStatistics.getTickerCount(this.rocksRawKVStore, TickerType.NUMBER_MULTIGET_KEYS_READ);
    }

    public long getRegionBytesWritten(Region region, boolean reset) {
        Counter counter = KVMetrics.counter("rhea-region-bytes-written", String.valueOf(region.getId()));
        long value = counter.getCount();
        if (reset) {
            counter.dec(value);
        }
        return value;
    }

    public long getRegionBytesRead(Region region, boolean reset) {
        Counter counter = KVMetrics.counter("rhea-region-bytes-read", String.valueOf(region.getId()));
        long value = counter.getCount();
        if (reset) {
            counter.dec(value);
        }
        return value;
    }

    public long getRegionKeysWritten(Region region, boolean reset) {
        Counter counter = KVMetrics.counter("rhea-region-keys-written", String.valueOf(region.getId()));
        long value = counter.getCount();
        if (reset) {
            counter.dec(value);
        }
        return value;
    }

    public long getRegionKeysRead(Region region, boolean reset) {
        Counter counter = KVMetrics.counter("rhea-region-keys-read", String.valueOf(region.getId()));
        long value = counter.getCount();
        if (reset) {
            counter.dec(value);
        }
        return value;
    }
}

