/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.protocol.ssl;

import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.net.ssl.SSLEngine;
import org.apache.rocketmq.mqtt.cs.config.ConnectConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class SslFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SslFactory.class);
    private static final String CERT_FILE_NAME = "mqtt.crt";
    private static final String KEY_FILE_NAME = "mqtt.key";
    @Resource
    private ConnectConf connectConf;
    private SslContext sslContext;

    @PostConstruct
    private void initSslContext() {
        if (!this.connectConf.isEnableTlsSever()) {
            return;
        }
        try {
            InputStream certStream = new ClassPathResource(CERT_FILE_NAME).getInputStream();
            InputStream keyStream = new ClassPathResource(KEY_FILE_NAME).getInputStream();
            SslContextBuilder contextBuilder = SslContextBuilder.forServer((InputStream)certStream, (InputStream)keyStream);
            contextBuilder.clientAuth(ClientAuth.OPTIONAL);
            contextBuilder.sslProvider(OpenSsl.isAvailable() ? SslProvider.OPENSSL : SslProvider.JDK);
            if (this.connectConf.isNeedClientAuth()) {
                LOG.info("client tls authentication is required.");
                contextBuilder.clientAuth(ClientAuth.REQUIRE);
                contextBuilder.trustManager(certStream);
            }
            this.sslContext = contextBuilder.build();
        }
        catch (IOException e) {
            throw new RuntimeException("failed to initialize ssl context.", e);
        }
    }

    public SSLEngine buildSslEngine(SocketChannel ch) {
        SSLEngine sslEngine = this.sslContext.newEngine(ch.alloc());
        sslEngine.setEnabledCipherSuites(sslEngine.getSupportedCipherSuites());
        sslEngine.setUseClientMode(false);
        sslEngine.setNeedClientAuth(this.connectConf.isNeedClientAuth());
        return sslEngine;
    }
}

