/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.session;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.rocketmq.mqtt.common.model.Message;
import org.apache.rocketmq.mqtt.common.model.Queue;
import org.apache.rocketmq.mqtt.common.model.QueueOffset;
import org.apache.rocketmq.mqtt.common.model.Subscription;
import org.apache.rocketmq.mqtt.common.model.WillMessage;
import org.apache.rocketmq.mqtt.cs.channel.ChannelInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class Session {
    private static Logger logger = LoggerFactory.getLogger(Session.class);
    private final long startTime = System.currentTimeMillis();
    private Channel channel;
    private volatile boolean destroyed = false;
    private volatile int loadStatus = -1;
    private volatile int pullSize;
    private String clientId;
    private String channelId;
    private WillMessage willMessage;
    private AtomicBoolean needPersistOffset = new AtomicBoolean(false);
    private ConcurrentMap<String, Map<Queue, QueueOffset>> offsetMap = new ConcurrentHashMap<String, Map<Queue, QueueOffset>>(16);
    private Map<String, Subscription> subscriptions = new ConcurrentHashMap<String, Subscription>();
    private ConcurrentMap<Subscription, Map<Queue, LinkedHashSet<Message>>> sendingMessages = new ConcurrentHashMap<Subscription, Map<Queue, LinkedHashSet<Message>>>(16);
    private ConcurrentMap<Subscription, Integer> loadStatusMap = new ConcurrentHashMap<Subscription, Integer>();

    public ConcurrentMap<Subscription, Integer> getLoadStatusMap() {
        return this.loadStatusMap;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public boolean isClean() {
        return Boolean.TRUE.equals(ChannelInfo.getCleanSessionFlag(this.channel));
    }

    public boolean isLoaded() {
        return this.loadStatus == 1;
    }

    public void setLoaded() {
        this.loadStatus = 1;
    }

    public void setLoading() {
        this.loadStatus = 0;
    }

    public boolean isLoading() {
        return this.loadStatus == 0;
    }

    public void resetLoad() {
        this.loadStatus = -1;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public WillMessage getWillMessage() {
        return this.willMessage;
    }

    public void setWillMessage(WillMessage willMessage) {
        this.willMessage = willMessage;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public int getPullSize() {
        return this.pullSize;
    }

    public void setPullSize(int pullSize) {
        this.pullSize = pullSize;
    }

    public void destroy() {
        this.destroyed = true;
        this.offsetMap.clear();
        this.sendingMessages.clear();
        this.subscriptions.clear();
    }

    public Map<Subscription, Map<Queue, QueueOffset>> offsetMapSnapshot() {
        HashMap<Subscription, Map<Queue, QueueOffset>> tmp = new HashMap<Subscription, Map<Queue, QueueOffset>>(8);
        for (String queueName : this.offsetMap.keySet()) {
            Subscription subscription = this.subscriptions.get(queueName);
            if (subscription == null) continue;
            HashMap queueMap = new HashMap(((Map)this.offsetMap.get(queueName)).size());
            tmp.put(subscription, queueMap);
            queueMap.putAll((Map)this.offsetMap.get(queueName));
        }
        return tmp;
    }

    public Set<Subscription> subscriptionSnapshot() {
        HashSet<Subscription> tmp = new HashSet<Subscription>();
        tmp.addAll(this.subscriptions.values());
        return tmp;
    }

    public void removeSubscription(Subscription subscription) {
        if (subscription == null) {
            throw new RuntimeException("subscription is null");
        }
        this.offsetMap.remove(subscription.toQueueName());
        this.sendingMessages.remove(subscription);
        this.subscriptions.remove(subscription.getTopicFilter());
    }

    public void freshQueue(Subscription subscription, Set<Queue> queues) {
        if (subscription == null) {
            throw new RuntimeException("subscription is null");
        }
        if (queues == null) {
            logger.warn("queues is null when freshQueue,{},{}", (Object)this.getClientId(), (Object)subscription);
            return;
        }
        if (!this.subscriptions.containsKey(subscription.getTopicFilter())) {
            return;
        }
        String queueName = subscription.toQueueName();
        if (!this.offsetMap.containsKey(queueName)) {
            this.offsetMap.putIfAbsent(queueName, new ConcurrentHashMap(16));
        }
        for (Queue memQueue : ((Map)this.offsetMap.get(queueName)).keySet()) {
            if (queues.contains(memQueue)) continue;
            ((Map)this.offsetMap.get(queueName)).remove(memQueue);
        }
        for (Queue nowQueue : queues) {
            if (((Map)this.offsetMap.get(queueName)).containsKey(nowQueue)) continue;
            QueueOffset queueOffset = new QueueOffset();
            ((Map)this.offsetMap.get(queueName)).put(nowQueue, queueOffset);
            this.markPersistOffsetFlag(true);
        }
        if (!this.sendingMessages.containsKey(subscription)) {
            this.sendingMessages.putIfAbsent(subscription, new ConcurrentHashMap(16));
        }
        for (Queue memQueue : ((Map)this.sendingMessages.get(subscription)).keySet()) {
            if (queues.contains(memQueue)) continue;
            ((Map)this.sendingMessages.get(subscription)).remove(memQueue);
        }
        if (queues.isEmpty()) {
            logger.warn("queues is empty when freshQueue,{},{}", (Object)this.getClientId(), (Object)subscription);
        }
    }

    public void addOffset(String queueName, Map<Queue, QueueOffset> map) {
        if (queueName == null) {
            throw new RuntimeException("queueName is null");
        }
        if (!this.offsetMap.containsKey(queueName)) {
            this.offsetMap.putIfAbsent(queueName, new ConcurrentHashMap(16));
        }
        ((Map)this.offsetMap.get(queueName)).putAll(map);
    }

    public void addOffset(Map<String, Map<Queue, QueueOffset>> offsetMapParam) {
        if (offsetMapParam != null && !offsetMapParam.isEmpty()) {
            for (String queueName : offsetMapParam.keySet()) {
                if (!this.subscriptions.containsKey(queueName)) continue;
                this.addOffset(queueName, offsetMapParam.get(queueName));
            }
        }
    }

    public void addSubscription(Set<Subscription> subscriptionsParam) {
        if (CollectionUtils.isEmpty(subscriptionsParam)) {
            return;
        }
        for (Subscription subscription : subscriptionsParam) {
            this.addSubscription(subscription);
        }
    }

    public void addSubscription(Subscription subscriptionParam) {
        if (subscriptionParam != null) {
            this.subscriptions.put(subscriptionParam.getTopicFilter(), subscriptionParam);
        }
    }

    public QueueOffset getQueueOffset(Subscription subscription, Queue queue) {
        if (subscription == null) {
            throw new RuntimeException("subscription is null");
        }
        if (queue == null) {
            throw new RuntimeException("queue is null");
        }
        String queueName = subscription.toQueueName();
        Map queueQueueOffsetMap = (Map)this.offsetMap.get(queueName);
        if (queueQueueOffsetMap != null) {
            return (QueueOffset)queueQueueOffsetMap.get(queue);
        }
        return null;
    }

    public Map<Queue, QueueOffset> getQueueOffset(Subscription subscription) {
        if (subscription == null) {
            throw new RuntimeException("subscription is null");
        }
        String queueName = subscription.toQueueName();
        return (Map)this.offsetMap.get(queueName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSendingMessages(Subscription subscription, Queue queue, List<Message> messages) {
        String queueName;
        Map queueOffsetMap;
        if (subscription == null) {
            throw new RuntimeException("subscription is null");
        }
        if (queue == null) {
            throw new RuntimeException("queue is null");
        }
        if (messages == null || messages.isEmpty()) {
            return false;
        }
        if (!this.subscriptions.containsKey(subscription.getTopicFilter())) {
            return false;
        }
        if (!this.sendingMessages.containsKey(subscription)) {
            this.sendingMessages.putIfAbsent(subscription, new ConcurrentHashMap(16));
        }
        if (!((Map)this.sendingMessages.get(subscription)).containsKey(queue)) {
            ((Map)this.sendingMessages.get(subscription)).putIfAbsent(queue, new LinkedHashSet(8));
        }
        if ((queueOffsetMap = (Map)this.offsetMap.get(queueName = subscription.toQueueName())) == null || !queueOffsetMap.containsKey(queue)) {
            logger.warn("not found queueOffset,{},{},{}", new Object[]{this.getClientId(), subscription, queue});
            return false;
        }
        boolean add = false;
        QueueOffset queueOffset = (QueueOffset)queueOffsetMap.get(queue);
        for (Message message : messages) {
            if (message.getOffset() < queueOffset.getOffset() && queueOffset.getOffset() != Long.MAX_VALUE) continue;
            Session session = this;
            synchronized (session) {
                if (((LinkedHashSet)((Map)this.sendingMessages.get(subscription)).get(queue)).add(message.copy())) {
                    add = true;
                }
            }
        }
        return add;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message rollNext(Subscription subscription, Queue pendingQueue, long pendingDownSeqId) {
        if (subscription == null) {
            throw new RuntimeException("subscription is null");
        }
        if (pendingQueue == null) {
            throw new RuntimeException("queue is null");
        }
        Map queueSendingMsgs = (Map)this.sendingMessages.get(subscription);
        if (queueSendingMsgs == null || queueSendingMsgs.isEmpty()) {
            return null;
        }
        LinkedHashSet messages = (LinkedHashSet)queueSendingMsgs.get(pendingQueue);
        if (messages == null) {
            return null;
        }
        Message nextMessage = null;
        Session session = this;
        synchronized (session) {
            if (messages.isEmpty()) {
                return null;
            }
            Message message = (Message)messages.iterator().next();
            if (message.getOffset() != pendingDownSeqId) {
                return null;
            }
            messages.remove(message);
            this.updateQueueOffset(subscription, pendingQueue, message);
            this.markPersistOffsetFlag(true);
            if (!messages.isEmpty()) {
                nextMessage = (Message)messages.iterator().next();
            }
        }
        return nextMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendingMessageIsEmpty(Subscription subscription, Queue queue) {
        if (subscription == null) {
            throw new RuntimeException("subscription is null");
        }
        if (queue == null) {
            throw new RuntimeException("queue is null");
        }
        Map queueSendingMsgs = (Map)this.sendingMessages.get(subscription);
        if (queueSendingMsgs == null || queueSendingMsgs.isEmpty()) {
            return true;
        }
        LinkedHashSet messages = (LinkedHashSet)queueSendingMsgs.get(queue);
        if (messages == null) {
            return true;
        }
        Session session = this;
        synchronized (session) {
            return messages.size() <= 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message nextSendMessageByOrder(Subscription subscription, Queue queue) {
        if (subscription == null) {
            throw new RuntimeException("subscription is null");
        }
        if (queue == null) {
            throw new RuntimeException("queue is null");
        }
        Map tmp = (Map)this.sendingMessages.get(subscription);
        if (tmp != null && !tmp.isEmpty()) {
            LinkedHashSet messages = (LinkedHashSet)tmp.get(queue);
            if (messages == null) {
                return null;
            }
            Session session = this;
            synchronized (session) {
                return messages.isEmpty() ? null : (Message)messages.iterator().next();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> pendMessageList(Subscription subscription, Queue queue) {
        if (subscription == null) {
            throw new RuntimeException("subscription is null");
        }
        if (queue == null) {
            throw new RuntimeException("queue is null");
        }
        ArrayList<Message> list = new ArrayList<Message>();
        Map tmp = (Map)this.sendingMessages.get(subscription);
        if (tmp != null && !tmp.isEmpty()) {
            LinkedHashSet messages = (LinkedHashSet)tmp.get(queue);
            if (messages == null) {
                return null;
            }
            Session session = this;
            synchronized (session) {
                if (!messages.isEmpty()) {
                    for (Message message : messages) {
                        if (message.getAck() != -1) continue;
                        list.add(message);
                    }
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(Subscription subscription, Queue pendingQueue, long pendingDownSeqId) {
        if (subscription == null) {
            throw new RuntimeException("subscription is null");
        }
        if (pendingQueue == null) {
            throw new RuntimeException("queue is null");
        }
        Map queueSendingMsgs = (Map)this.sendingMessages.get(subscription);
        if (queueSendingMsgs == null || queueSendingMsgs.isEmpty()) {
            return;
        }
        LinkedHashSet messages = (LinkedHashSet)queueSendingMsgs.get(pendingQueue);
        if (messages == null) {
            return;
        }
        Session session = this;
        synchronized (session) {
            if (messages.isEmpty()) {
                return;
            }
            boolean flag = true;
            Iterator iterator = messages.iterator();
            while (iterator.hasNext()) {
                Message message = (Message)iterator.next();
                if (message.getOffset() == pendingDownSeqId) {
                    message.setAck(1);
                }
                if (message.getAck() != 1) {
                    flag = false;
                }
                if (!flag) continue;
                this.updateQueueOffset(subscription, pendingQueue, message);
                this.markPersistOffsetFlag(true);
                iterator.remove();
            }
        }
    }

    private void updateQueueOffset(Subscription subscription, Queue queue, Message message) {
        String queueName = subscription.toQueueName();
        Map queueOffsetMap = (Map)this.offsetMap.get(queueName);
        if (queueOffsetMap == null || !queueOffsetMap.containsKey(queue)) {
            logger.warn("failed update queue offset,not found queueOffset,{},{},{}", new Object[]{this.getClientId(), subscription, queue});
            return;
        }
        QueueOffset queueOffset = (QueueOffset)queueOffsetMap.get(queue);
        queueOffset.setOffset(message.getOffset() + 1L);
    }

    public boolean markPersistOffsetFlag(boolean flag) {
        return this.needPersistOffset.compareAndSet(!flag, flag);
    }

    public boolean getPersistOffsetFlag() {
        return this.needPersistOffset.get();
    }
}

