/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.websocket;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import org.eclipse.paho.client.mqttv3.internal.security.SSLSocketFactoryFactory;
import org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketSecureNetworkModule;
import org.eclipse.paho.client.mqttv3.spi.NetworkModuleFactory;

public class WebSocketSecureNetworkModuleFactory
implements NetworkModuleFactory {
    @Override
    public Set<String> getSupportedUriSchemes() {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("wss")));
    }

    @Override
    public void validateURI(URI brokerUri) throws IllegalArgumentException {
    }

    @Override
    public NetworkModule createNetworkModule(URI brokerUri, MqttConnectOptions options, String clientId) throws MqttException {
        String[] enabledCiphers;
        String host = brokerUri.getHost();
        int port = brokerUri.getPort();
        if (port == -1) {
            port = 443;
        }
        SocketFactory factory = options.getSocketFactory();
        SSLSocketFactoryFactory wSSFactoryFactory = null;
        if (factory == null) {
            wSSFactoryFactory = new SSLSocketFactoryFactory();
            Properties sslClientProps = options.getSSLProperties();
            if (sslClientProps != null) {
                wSSFactoryFactory.initialize(sslClientProps, null);
            }
            factory = wSSFactoryFactory.createSocketFactory(null);
        } else if (!(factory instanceof SSLSocketFactory)) {
            throw ExceptionHelper.createMqttException(32105);
        }
        WebSocketSecureNetworkModule netModule = new WebSocketSecureNetworkModule((SSLSocketFactory)factory, brokerUri.toString(), host, port, clientId, options.getCustomWebSocketHeaders());
        netModule.setSSLhandshakeTimeout(options.getConnectionTimeout());
        netModule.setSSLHostnameVerifier(options.getSSLHostnameVerifier());
        netModule.setHttpsHostnameVerificationEnabled(options.isHttpsHostnameVerificationEnabled());
        if (wSSFactoryFactory != null && (enabledCiphers = wSSFactoryFactory.getEnabledCipherSuites(null)) != null) {
            netModule.setEnabledCiphers(enabledCiphers);
        }
        return netModule;
    }
}

