/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import antlr.Token;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.semantics.Nsset;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.IQualifiers;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.definitions.references.INamespaceResolvedReference;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.internal.definitions.AmbiguousDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinitionBase;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.InterfaceDefinition;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.definitions.VariableDefinition;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.BaseDefinitionNode;
import org.apache.royale.compiler.internal.tree.as.BaseTypedDefinitionNode;
import org.apache.royale.compiler.internal.tree.as.BlockNode;
import org.apache.royale.compiler.internal.tree.as.CatchNode;
import org.apache.royale.compiler.internal.tree.as.ClassNode;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.internal.tree.as.IterationFlowNode;
import org.apache.royale.compiler.internal.tree.as.LanguageIdentifierNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.internal.tree.as.MemberedNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceIdentifierNode;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.as.PackageNode;
import org.apache.royale.compiler.internal.tree.as.ParameterNode;
import org.apache.royale.compiler.internal.tree.as.VariableNode;
import org.apache.royale.compiler.internal.tree.as.metadata.DefaultPropertyTagNode;
import org.apache.royale.compiler.internal.tree.as.metadata.EffectTagNode;
import org.apache.royale.compiler.internal.tree.as.metadata.EventTagNode;
import org.apache.royale.compiler.internal.tree.as.metadata.MetaTagsNode;
import org.apache.royale.compiler.internal.tree.as.metadata.StyleTagNode;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IFileNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.ILanguageIdentifierNode;
import org.apache.royale.compiler.tree.as.IScopedDefinitionNode;
import org.apache.royale.compiler.tree.as.IScopedNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagNode;
import org.apache.royale.compiler.tree.mxml.IMXMLMetadataNode;
import org.apache.royale.compiler.workspaces.IWorkspace;

public class IdentifierNode
extends ExpressionNodeBase
implements IIdentifierNode {
    private String name;
    private IDefinition idDef = null;

    public static IdentifierNode createEmptyIdentifierNodeAfterToken(Token token) {
        IdentifierNode result = new IdentifierNode("");
        result.startAfter(token);
        result.endAfter(token);
        return result;
    }

    public IdentifierNode(String name) {
        this.name = name;
    }

    public IdentifierNode(String name, Token token) {
        this.name = name;
        this.span(token);
    }

    public IdentifierNode(String name, IASToken token) {
        this.name = name;
        this.span(token);
    }

    public IdentifierNode(IASToken token) {
        this.name = token.getText();
        this.span(token);
    }

    protected IdentifierNode(IdentifierNode other) {
        super(other);
        this.name = other.name;
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.IdentifierID;
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    @Override
    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        FunctionNode fn;
        if ("arguments".equals(this.name) && !this.isMemberRef() && !this.isQualifiedRef() && set.contains((Object)PostProcessStep.POPULATE_SCOPE) && (fn = (FunctionNode)this.getAncestorOfType(FunctionNode.class)) != null) {
            fn.needsArguments = true;
        }
    }

    @Override
    public void normalize(boolean fillInOffsets) {
    }

    @Override
    protected void fillInOffsets() {
    }

    @Override
    public IScopedNode getScopeNode() {
        IASNode parent = this.getParent();
        if (parent instanceof IterationFlowNode) {
            return null;
        }
        if (parent instanceof DefaultPropertyTagNode) {
            IASNode node = parent.getAncestorOfType(BlockNode.class);
            if (node instanceof BlockNode) {
                int childCount = node.getChildCount();
                boolean descend = false;
                for (int i = 0; i < childCount; ++i) {
                    IASNode child = node.getChild(i);
                    if (!descend && child instanceof MetaTagsNode) {
                        IMetaTagNode[] allTags = ((MetaTagsNode)child).getAllTags();
                        for (int t = 0; t < allTags.length; ++t) {
                            if (allTags[t] != parent) continue;
                            descend = true;
                            break;
                        }
                    }
                    if (!descend || !(child instanceof MemberedNode)) continue;
                    return ((MemberedNode)child).getScopedNode().getScopeNode();
                }
            }
        } else if (parent instanceof EventTagNode || parent instanceof EffectTagNode || parent instanceof StyleTagNode) {
            IASNode parentNode = parent.getParent();
            if (parentNode instanceof MetaTagsNode) {
                IDefinitionNode decoratedNode = ((MetaTagsNode)parentNode).getDecoratedDefinition();
                if (decoratedNode instanceof MemberedNode) {
                    return ((MemberedNode)decoratedNode).getScopedNode().getScopeNode();
                }
            } else if (parentNode instanceof IMXMLMetadataNode) {
                return ((IScopedDefinitionNode)((IMXMLMetadataNode)parentNode).getParent()).getScopedNode();
            }
        } else {
            if (parent instanceof ParameterNode && ((ParameterNode)parent).getTypeNode() != null && ((ParameterNode)parent).getTypeNode().equals(this) || parent instanceof VariableNode && ((VariableNode)parent).getTypeNode() != null && ((VariableNode)parent).getTypeNode().equals(this)) {
                while (!(parent instanceof MemberedNode) && !(parent instanceof IFileNode)) {
                    parent = parent.getParent();
                }
                return ((NodeBase)parent).getScopeNode();
            }
            if (parent instanceof ParameterNode && parent.getParent() instanceof CatchNode) {
                return (CatchNode)parent.getParent();
            }
            if (parent instanceof ClassNode && ((ClassNode)parent).getBaseClassNode() != null && ((ClassNode)parent).getBaseClassNode().equals(this)) {
                while (!(parent instanceof PackageNode) && !(parent instanceof IFileNode)) {
                    parent = parent.getParent();
                }
                return ((NodeBase)parent).getScopeNode();
            }
        }
        return super.getScopeNode();
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        sb.append('\"');
        sb.append(this.getName());
        sb.append('\"');
        return true;
    }

    @Override
    public IDefinition resolve(ICompilerProject project) {
        boolean isMemberRef;
        if (DefinitionBase.getPerformanceCachingEnabled() && this.idDef != null) {
            return this.idDef;
        }
        ASScope asScope = this.getASScope();
        if (asScope == null) {
            return null;
        }
        if (this.isAttributeIdentifier()) {
            return null;
        }
        if (this.isPartOfPackageReference()) {
            return null;
        }
        IDefinition result = null;
        String name = this.getName();
        IQualifiers qualifier = null;
        if (this.isQualifiedRef() && (qualifier = this.resolveQualifier(project)) == null) {
            return null;
        }
        boolean wasMemberRef = isMemberRef = this.isMemberRef();
        if (isMemberRef && this.baseIsPackage()) {
            ExpressionNodeBase base = this.getBaseExpression();
            String packageName = base.computeSimpleReference();
            packageName = project.getActualPackageName(packageName);
            Workspace workspace = (Workspace)project.getWorkspace();
            qualifier = workspace.getPackageNamespaceDefinitionCache().get(packageName, false);
            isMemberRef = false;
        }
        if (this.isNameNode()) {
            BaseDefinitionNode defNode = this.getParentAsDefinition();
            if (defNode != null) {
                result = defNode.getDefinition();
            }
        } else if (isMemberRef) {
            result = this.resolveMemberRef(project, asScope, name, qualifier);
        } else if (qualifier == null) {
            ClassDefinitionBase cdef;
            IDefinition memberResult;
            VariableDefinition varDef;
            DependencyType dt = this.getDependencyType();
            if (dt != null) {
                result = asScope.findProperty(project, name, dt, this.isTypeRef());
            }
            if (result != null && name.equals("graphics") && result.getParent() instanceof ITypeDefinition && ((ITypeDefinition)result.getParent()).isInstanceOf("mx.core.UIComponent", project)) {
                result = asScope.findProperty(project, "royalegraphics", this.getDependencyType(), this.isTypeRef());
            }
            if (this.isLegacyCodegen(project) && result != null && this.getParent().getNodeID() == ASTNodeID.FunctionCallID && result instanceof VariableDefinition && (varDef = (VariableDefinition)result).getVariableClassification() == IVariableDefinition.VariableClassification.LOCAL && (memberResult = asScope.getPropertyFromDef(project, cdef = asScope.getContainingClass(), name, false)) instanceof FunctionDefinition) {
                result = memberResult;
            }
        } else {
            result = asScope.findPropertyQualified(project, qualifier, name, this.getDependencyType(), this.isTypeRef());
            if (result == null && wasMemberRef && this.baseIsPackage()) {
                result = this.resolveMemberRef(project, asScope, name, null);
            }
        }
        if (result != null && project instanceof RoyaleProject && ((RoyaleProject)project).apiReportFile != null) {
            if (this.isMemberRef()) {
                if (this.parent.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
                    MemberAccessExpressionNode mae = (MemberAccessExpressionNode)this.parent;
                    if (mae.getRightOperandNode() == this && mae.getLeftOperandNode().getNodeID() == ASTNodeID.IdentifierID) {
                        ITypeDefinition parentDef = mae.getLeftOperandNode().resolveType(project);
                        if (parentDef instanceof IClassDefinition) {
                            ((RoyaleProject)project).addToAPIReport((IClassDefinition)parentDef, result);
                        } else {
                            ((RoyaleProject)project).addToAPIReport(result);
                        }
                    } else {
                        ((RoyaleProject)project).addToAPIReport(result);
                    }
                } else {
                    ((RoyaleProject)project).addToAPIReport(result);
                }
            } else {
                ((RoyaleProject)project).addToAPIReport(result);
            }
        }
        this.idDef = result;
        return result;
    }

    @Override
    public ITypeDefinition resolveType(ICompilerProject project) {
        IDefinition def = this.resolve(project);
        if (def != null) {
            if (SemanticUtils.isXMLish(def.getParent(), project)) {
                return project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
            }
            return def.resolveType(project);
        }
        return null;
    }

    @Override
    protected IdentifierNode copy() {
        return new IdentifierNode(this);
    }

    @Override
    public boolean isDynamicExpression(ICompilerProject project) {
        if (this.isPackageReference()) {
            return false;
        }
        return super.isDynamicExpression(project);
    }

    @Override
    public Name getMName(ICompilerProject project) {
        ExpressionNodeBase baseExpr;
        ITypeDefinition leftDef;
        MemberAccessExpressionNode mae;
        IDefinition def = this.resolve(project);
        if (this.canEarlyBind(project, def)) {
            return ((DefinitionBase)def).getMName(project);
        }
        if (def == null && this.getParent().getNodeID() == ASTNodeID.MemberAccessExpressionID && (mae = (MemberAccessExpressionNode)this.getParent()).getRightOperandNode() == this && (leftDef = mae.getLeftOperandNode().resolveType(project)) != null && !leftDef.isDynamic()) {
            INamespaceReference nr = leftDef.getNamespaceReference();
            INamespaceDefinition nd = nr.resolveNamespaceReference(project);
            ImmutableSet nsset = ImmutableSet.of((Object)nd);
            return IdentifierNode.makeName((Set<INamespaceDefinition>)nsset, this.getName(), this.isAttributeIdentifier());
        }
        ASScope scope = this.getASScope();
        if (this.isQualifiedRef()) {
            Nsset namespaceSet;
            int nameKind;
            IQualifiers qual = this.resolveQualifier(project);
            if (qual != null) {
                if (qual.getNamespaceCount() == 1) {
                    ExpressionNodeBase baseExpr2;
                    NamespaceDefinition ns = (NamespaceDefinition)qual.getFirst();
                    int n = nameKind = this.isAttributeIdentifier() ? 13 : 7;
                    if (this.isMemberRef() && (baseExpr2 = this.getBaseExpression()) instanceof LanguageIdentifierNode && ((LanguageIdentifierNode)baseExpr2).getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.SUPER) {
                        ITypeDefinition baseType = baseExpr2.resolveType(project);
                        Object nsset = ImmutableSet.of((Object)ns);
                        nsset = scope.adjustNamespaceSetForSuper(baseType, (Set<INamespaceDefinition>)nsset);
                        ns = (NamespaceDefinition)nsset.iterator().next();
                    }
                    namespaceSet = ns == NamespaceDefinition.getAnyNamespaceReference() ? null : new Nsset(ns.getAETNamespace());
                } else {
                    Set<INamespaceDefinition> nsset = qual.getNamespaceSet();
                    nameKind = this.isAttributeIdentifier() ? 14 : 9;
                    namespaceSet = SemanticUtils.convertSetINamespaceToNsset(nsset);
                }
            } else {
                namespaceSet = null;
                nameKind = this.isAttributeIdentifier() ? 16 : 15;
            }
            return new Name(nameKind, namespaceSet, this.getName());
        }
        Name name = null;
        if (this.isMemberRef() && (baseExpr = this.getBaseExpression()) != null) {
            if (this.baseIsPackage()) {
                String packageName = baseExpr.computeSimpleReference();
                Workspace workspace = (Workspace)project.getWorkspace();
                INamespaceDefinition.ILanguageNamespaceDefinition qualifier = workspace.getPackageNamespaceDefinitionCache().get(packageName, false);
                return new Name(this.isAttributeIdentifier() ? 13 : 7, new Nsset(((INamespaceResolvedReference)((Object)qualifier)).resolveAETNamespace(project)), this.getName());
            }
            Set<INamespaceDefinition> namespaceSet = null;
            ITypeDefinition baseType = baseExpr.resolveType(project);
            if (baseType instanceof InterfaceDefinition) {
                namespaceSet = ((InterfaceDefinition)baseType).getInterfaceNamespaceSet(project);
            } else if (baseExpr instanceof LanguageIdentifierNode && ((LanguageIdentifierNode)baseExpr).getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.SUPER) {
                namespaceSet = scope.getNamespaceSetForSuper(project, baseType);
            }
            if (namespaceSet != null) {
                return IdentifierNode.makeName(namespaceSet, this.getName(), this.isAttributeIdentifier());
            }
        }
        if (this.isNameNode()) {
            BaseDefinitionNode defNode = this.getParentAsDefinition();
            name = defNode.getDefinition().getMName(project);
        } else if (scope != null) {
            Set<INamespaceDefinition> namespaceSet = null;
            namespaceSet = this.isMemberRef() ? scope.getNamespaceSet(project) : scope.getNamespaceSetForName(project, this.getName());
            name = IdentifierNode.makeName(namespaceSet, this.getName(), this.isAttributeIdentifier());
        }
        return name;
    }

    @Override
    String computeSimpleReference() {
        return this.getName();
    }

    @Override
    IReference computeTypeReference() {
        if (this.name == "") {
            return null;
        }
        IReference typeRef = null;
        IWorkspace w = this.getWorkspace();
        switch (this.getRefType()) {
            case PACKAGE_QUALIFIED: {
                ExpressionNodeBase baseExpr = this.getBaseExpression();
                typeRef = ReferenceFactory.packageQualifiedReference(w, baseExpr.computeSimpleReference(), this.computeSimpleReference(), false);
                break;
            }
            case LEXICAL: {
                typeRef = ReferenceFactory.lexicalReference(w, this.computeSimpleReference());
                break;
            }
            default: {
                typeRef = ReferenceFactory.notATypeReference(w, this.computeSimpleReference());
            }
        }
        return typeRef;
    }

    @Override
    public INamespaceReference computeNamespaceReference() {
        if (this.name == "") {
            return null;
        }
        INamespaceReference nsRef = null;
        Workspace w = (Workspace)this.getWorkspace();
        switch (this.getRefType()) {
            case PACKAGE_QUALIFIED: {
                ExpressionNodeBase baseExpr = this.getBaseExpression();
                nsRef = NamespaceDefinition.createNamespaceReference(this.getASScope(), this.getName(), w.getPackageNamespaceDefinitionCache().get(baseExpr.computeSimpleReference(), false));
                break;
            }
            case LEXICAL: {
                nsRef = NamespaceDefinition.createNamespaceReference(this.getASScope(), this.getName(), null);
                break;
            }
            case NAMESPACE_QUALIFIED: {
                ExpressionNodeBase qualExpr = this.getQualifierExpression();
                nsRef = NamespaceDefinition.createNamespaceReference(this.getASScope(), this.getName(), qualExpr.computeNamespaceReference());
                break;
            }
            case MEMBER: {
                ExpressionNodeBase baseExpr = this.getBaseExpression();
                IReference base = baseExpr.computeTypeReference();
                nsRef = NamespaceDefinition.createNamespaceReference(this.getASScope(), this.getName(), null, base);
                break;
            }
        }
        return nsRef;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IIdentifierNode.IdentifierType getIdentifierType() {
        return IIdentifierNode.IdentifierType.NAME;
    }

    public void setReferenceValue(IDefinition definition) {
    }

    public boolean isImplicit() {
        return this.getAbsoluteStart() == this.getAbsoluteEnd();
    }

    private REF_TYPE getRefType() {
        if (this.isMemberRef()) {
            if (this.baseIsPackage()) {
                return REF_TYPE.PACKAGE_QUALIFIED;
            }
            return REF_TYPE.MEMBER;
        }
        if (this.isQualifiedRef()) {
            return REF_TYPE.NAMESPACE_QUALIFIED;
        }
        return REF_TYPE.LEXICAL;
    }

    protected boolean isAttributeIdentifier() {
        ExpressionNodeBase p = this.getParentExpression();
        if (p != null) {
            return p.isAttributeExpr(this);
        }
        return false;
    }

    private boolean isQualifiedRef() {
        ExpressionNodeBase expr = this.getParentExpression();
        if (expr != null) {
            return expr.isQualifiedExpr(this);
        }
        return false;
    }

    private boolean isPartOfPackageReference() {
        ExpressionNodeBase expr = this.getParentExpression();
        MemberAccessExpressionNode memExpr = null;
        while (expr instanceof MemberAccessExpressionNode) {
            memExpr = (MemberAccessExpressionNode)expr;
            expr = expr.getParentExpression();
        }
        if (memExpr != null) {
            return memExpr.isPackageReference();
        }
        return false;
    }

    public boolean isMemberRef() {
        ExpressionNodeBase expr = this.getParentExpression();
        boolean memberRef = false;
        if (expr != null) {
            return expr.isPartOfMemberRef(this);
        }
        return memberRef;
    }

    private IDefinition resolveMemberRef(ICompilerProject project, ASScope asScope, String name, IQualifiers qualifier) {
        IDefinition result = null;
        ITypeDefinition baseType = null;
        ExpressionNodeBase baseExpr = this.getBaseExpression();
        if (baseExpr != null && (baseType = baseExpr.resolveType(project)) != null) {
            boolean isSuper = false;
            if (baseType instanceof IClassDefinition) {
                IdentifierNode idBase;
                if (!((RoyaleProject)project).useStrictXML() && SemanticUtils.isXMLish(baseType, project)) {
                    return null;
                }
                if (baseExpr instanceof IdentifierNode && (idBase = (IdentifierNode)baseExpr) instanceof ILanguageIdentifierNode && (((ILanguageIdentifierNode)((Object)idBase)).getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.THIS || ((ILanguageIdentifierNode)((Object)idBase)).getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.SUPER) && ((ILanguageIdentifierNode)((Object)idBase)).getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.SUPER) {
                    isSuper = true;
                }
            }
            if (qualifier != null) {
                result = asScope.getQualifiedPropertyFromDef(project, (IDefinition)baseType, name, qualifier, isSuper);
            } else if (name.equals("graphics") && baseType.isInstanceOf("mx.core.UIComponent", project)) {
                result = asScope.getPropertyFromDef(project, baseType, "royalegraphics", isSuper);
                if (result == null) {
                    result = asScope.getPropertyFromDef(project, baseType, name, isSuper);
                }
            } else {
                result = asScope.getPropertyFromDef(project, baseType, name, isSuper);
            }
        }
        return result;
    }

    private IQualifiers resolveQualifier(ICompilerProject project) {
        IQualifiers qual = null;
        ExpressionNodeBase qualExpr = this.getQualifierExpression();
        if (qualExpr != null) {
            if (qualExpr instanceof NamespaceIdentifierNode) {
                qual = ((NamespaceIdentifierNode)qualExpr).resolveQualifier(project);
            } else {
                IDefinition def = qualExpr.resolve(project);
                if (def instanceof NamespaceDefinition) {
                    qual = (NamespaceDefinition)def;
                }
            }
        }
        return qual;
    }

    private ExpressionNodeBase getQualifierExpression() {
        ExpressionNodeBase expr = this.getParentExpression();
        if (expr != null) {
            return expr.getQualifier(this);
        }
        return null;
    }

    private boolean baseIsPackage() {
        ExpressionNodeBase expr = this.getParentExpression();
        if (expr instanceof MemberAccessExpressionNode) {
            return ((MemberAccessExpressionNode)expr).stemIsPackage();
        }
        return false;
    }

    private BaseDefinitionNode getParentAsDefinition() {
        IASNode p = this.getParent();
        BaseDefinitionNode def = p instanceof BaseDefinitionNode ? (BaseDefinitionNode)p : null;
        return def;
    }

    private boolean isNameNode() {
        BaseDefinitionNode parent = this.getParentAsDefinition();
        return parent != null && parent.getNameExpressionNode() == this;
    }

    protected boolean canEarlyBind(ICompilerProject project, IDefinition def) {
        return def instanceof DefinitionBase && !AmbiguousDefinition.isAmbiguous(def) && !SemanticUtils.isXMLish(def.getParent(), project);
    }

    private static Name makeName(Set<INamespaceDefinition> namespaceSet, String name, boolean isAttr) {
        int nameKind = isAttr ? 14 : 9;
        Nsset nsSet = SemanticUtils.convertSetINamespaceToNsset(namespaceSet);
        Name n = new Name(nameKind, nsSet, name);
        return n;
    }

    protected boolean isTypeRef() {
        IASNode parent;
        DependencyType dt = this.getDependencyType();
        if (dt == DependencyType.SIGNATURE || dt == DependencyType.INHERITANCE) {
            return true;
        }
        return dt == DependencyType.EXPRESSION && (parent = this.getParent()) instanceof BaseTypedDefinitionNode && this == ((BaseTypedDefinitionNode)parent).getTypeNode();
    }

    public boolean isLegacyCodegen(ICompilerProject project) {
        if (!(project instanceof RoyaleProject)) {
            return false;
        }
        Integer compatibilityVersion = ((RoyaleProject)project).getCompatibilityVersion();
        if (compatibilityVersion == null) {
            return false;
        }
        return compatibilityVersion <= 0x4060000;
    }

    private static enum REF_TYPE {
        PACKAGE_QUALIFIED,
        LEXICAL,
        RUNTIME,
        NAMESPACE_QUALIFIED,
        MEMBER;

    }
}

