/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.tree.as.IOperatorNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.TokenVisitor;
import org.apache.royale.linter.problems.ILinterProblem;

public class StrictEqualityRule
extends LinterRule {
    @Override
    public Map<Integer, TokenVisitor> getTokenVisitors() {
        HashMap<Integer, TokenVisitor> result = new HashMap<Integer, TokenVisitor>();
        result.put(94, (token, tokenQuery, problems) -> problems.add(new StrictEqualityLinterProblem(token)));
        result.put(95, (token, tokenQuery, problems) -> problems.add(new StrictEqualityLinterProblem(token)));
        return result;
    }

    public static class StrictEqualityLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Must use ${requiredTokenText} instead of ${tokenText}";
        public String tokenText;
        public String requiredTokenText;

        public StrictEqualityLinterProblem(IASToken token) {
            super(token);
            this.tokenText = token.getText();
            if (IOperatorNode.OperatorType.EQUAL.getOperatorText().equals(this.tokenText)) {
                this.requiredTokenText = IOperatorNode.OperatorType.STRICT_EQUAL.getOperatorText();
            } else if (IOperatorNode.OperatorType.NOT_EQUAL.getOperatorText().equals(this.tokenText)) {
                this.requiredTokenText = IOperatorNode.OperatorType.STRICT_NOT_EQUAL.getOperatorText();
            }
        }
    }
}

