/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.config;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.royale.compiler.internal.config.annotations.DefaultArgumentValue;
import org.apache.royale.linter.config.ConfigurationBuffer;

public class ConfigurationInfo {
    public static final int NOT_SET = -2;
    public static final int INFINITE_ARGS = -1;
    protected int argcount = -2;
    protected String[] defaultArgValues = null;
    protected Class<?> argNameGeneratorClass;
    protected String[] argnames;
    protected Class<?>[] argtypes;
    protected String[] prerequisites = null;
    protected String[] softPrerequisites = null;
    protected boolean allowMultiple = false;
    protected String[] aliases = null;
    protected boolean isAdvanced = false;
    protected boolean isHidden = false;
    protected boolean isDisplayed = true;
    protected boolean isRequired = false;
    protected boolean isGreedy = false;
    protected boolean isPath = false;
    protected String deprecatedMessage = null;
    protected boolean isDeprecated = false;
    protected String deprecatedReplacement;
    protected String deprecatedSince;
    protected boolean isRemoved = false;
    protected boolean isRoyaleOnly = false;
    private Method setter;
    private Method getter;
    public boolean isCompcOnly = false;

    public ConfigurationInfo() {
        this.argcount = -2;
        this.argnames = null;
    }

    public ConfigurationInfo(int argcount) {
        this.argcount = argcount;
        this.argnames = null;
    }

    public ConfigurationInfo(String[] argnames) {
        this.argcount = argnames.length;
        this.argnames = argnames;
    }

    public ConfigurationInfo(int argcount, String argname) {
        this.argcount = argcount;
        this.argnames = new String[]{argname};
    }

    public ConfigurationInfo(int argcount, String[] argnames) {
        this.argcount = argcount;
        this.argnames = argnames;
    }

    public final int getArgCount() {
        return this.argcount;
    }

    public final String[] getDefaultArgValues() {
        return this.defaultArgValues;
    }

    private static String classToArgName(Class<?> c) {
        String className = c.getName();
        if (className.startsWith("java.lang.")) {
            className = className.substring("java.lang.".length());
        }
        return className.toLowerCase();
    }

    public String getArgName(int argnum) {
        if (this.argNameGeneratorClass != null) {
            try {
                Method getArgNameMethod = this.argNameGeneratorClass.getMethod("getArgumentName", Integer.TYPE);
                return (String)getArgNameMethod.invoke(null, argnum);
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
        if (this.argnames == null || this.argnames.length == 0) {
            return ConfigurationInfo.classToArgName(this.getArgType(argnum));
        }
        if (argnum >= this.argnames.length) {
            return this.argnames[this.argnames.length - 1];
        }
        return this.argnames[argnum];
    }

    public final Class<?> getArgType(int argnum) {
        if (argnum >= this.argtypes.length) {
            return this.argtypes[this.argtypes.length - 1];
        }
        return this.argtypes[argnum];
    }

    public String[] getPrerequisites() {
        return this.prerequisites;
    }

    public String[] getSoftPrerequisites() {
        return this.softPrerequisites;
    }

    public boolean allowMultiple() {
        return this.allowMultiple;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public boolean isAdvanced() {
        return this.isAdvanced;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isDisplayed() {
        return this.isDisplayed;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean isGreedy() {
        return this.isGreedy;
    }

    public boolean isPath() {
        return this.isPath;
    }

    public boolean doChecksum() {
        return true;
    }

    public String getDeprecatedMessage() {
        return this.deprecatedMessage;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public String getDeprecatedReplacement() {
        return this.deprecatedReplacement;
    }

    public String getDeprecatedSince() {
        return this.deprecatedSince;
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }

    public boolean isRoyaleOnly() {
        return this.isRoyaleOnly;
    }

    protected final void setSetterMethod(Method setter) {
        Class<?>[] pt = setter.getParameterTypes();
        assert (pt.length >= 2) : "coding error: config setter must take at least 2 args!";
        this.setter = setter;
        if (pt.length == 2) {
            Class<?> c = pt[1];
            if (ConfigurationBuffer.isSupportedListType(c)) {
                if (this.argcount == -2) {
                    this.argcount = -1;
                }
                this.argtypes = new Class[]{String.class};
                return;
            }
            if (ConfigurationBuffer.isSupportedValueType(c)) {
                assert (this.argcount == -2) : "coding error: value object setter cannot override argcount";
                assert (this.argnames == null) : "coding error: value object setter cannot override argnames";
                Field[] fields = c.getFields();
                this.argcount = fields.length;
                assert (this.argcount > 0) : "coding error: " + setter + " value object " + c.getName() + " must contain at least one public field";
                this.argnames = new String[fields.length];
                this.argtypes = new Class[fields.length];
                for (int f = 0; f < fields.length; ++f) {
                    this.argnames[f] = ConfigurationBuffer.c2h(fields[f].getName());
                    this.argtypes[f] = fields[f].getType();
                }
                return;
            }
        }
        assert (this.argcount == -2 || this.argcount == pt.length - 1) : "coding error: the argument count must match the number of setter arguments";
        this.argcount = pt.length - 1;
        DefaultArgumentValue defaultArgValuesAnno = setter.getAnnotation(DefaultArgumentValue.class);
        if (defaultArgValuesAnno != null) {
            this.defaultArgValues = defaultArgValuesAnno.value();
        }
        this.argtypes = new Class[pt.length - 1];
        for (int i = 1; i < pt.length; ++i) {
            assert (ConfigurationBuffer.isSupportedSimpleType(pt[i])) : "coding error: " + setter.getClass().getName() + "." + setter.getName() + " parameter " + i + " is not a supported type!";
            this.argtypes[i - 1] = pt[i];
        }
    }

    protected final Method getSetterMethod() {
        return this.setter;
    }

    protected final void setGetterMethod(Method getter) {
        this.getter = getter;
    }

    protected final Method getGetterMethod() {
        return this.getter;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").add("alias", (Object)this.arrayAsString(this.getAliases())).add("argcount", this.getArgCount()).add("argnames", (Object)this.arrayAsString(this.argnames)).add("argtypes", (Object)this.arrayAsString(this.argtypes)).add("deprecated", this.isDeprecated()).add("deprecatedMessage", (Object)this.getDeprecatedMessage()).add("deprecatedReplacement", (Object)this.getDeprecatedReplacement()).add("deprecatedSince", (Object)this.getDeprecatedSince()).add("getter", (Object)(this.getGetterMethod() == null ? "null" : this.getGetterMethod().getName())).add("setter", (Object)(this.getSetterMethod() == null ? "null" : this.getSetterMethod().getName())).add("required", this.isRequired()).add("Prerequisites", (Object)this.arrayAsString(this.getPrerequisites())).add("softPrerequisites", (Object)this.arrayAsString(this.getSoftPrerequisites())).add("advanced", this.isAdvanced()).add("allow multiple", this.allowMultiple()).add("displayed", this.isDisplayed()).add("greedy", this.isGreedy()).add("hidden", this.isHidden()).add("removed", this.isRemoved()).add("path", this.isPath()).toString();
    }

    private String arrayAsString(Object[] array) {
        if (array == null) {
            return "";
        }
        return "[" + Joiner.on((String)",").join(array) + "]";
    }
}

