/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.royale;

import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.mxml.js.IMXMLJSEmitter;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.royale.compiler.internal.codegen.mxml.MXMLSubEmitter;
import org.apache.royale.compiler.internal.codegen.mxml.royale.MXMLDescriptorSpecifier;
import org.apache.royale.compiler.internal.codegen.mxml.royale.MXMLEventSpecifier;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;

public class JSRoyaleBasicMXMLDescriptorEmitter
extends MXMLSubEmitter
implements ISubEmitter<MXMLDescriptorSpecifier> {
    private boolean useGoogReflectObjectProperty = false;

    public JSRoyaleBasicMXMLDescriptorEmitter(IMXMLJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(MXMLDescriptorSpecifier root) {
        RoyaleJSProject project = (RoyaleJSProject)this.getMXMLWalker().getProject();
        this.useGoogReflectObjectProperty = project.config != null && project.config.getMxmlReflectObjectProperty();
        this.outputDescriptorSpecifier(root, true);
    }

    protected void writeSimpleDescriptor(String name, String type, String value, boolean writeNewline) {
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(name);
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.writeDelimiter(writeNewline);
        if (type != null) {
            this.write(type);
            this.writeDelimiter(writeNewline);
        }
        this.write(value);
    }

    protected void writeDelimiter(boolean writeNewline) {
        if (writeNewline) {
            this.writeNewline(ASEmitterTokens.COMMA);
        } else {
            this.writeToken(ASEmitterTokens.COMMA);
        }
    }

    private void outputDescriptorSpecifier(MXMLDescriptorSpecifier root, boolean writeNewline) {
        if (root.isTopNode) {
            int count = 0;
            for (MXMLDescriptorSpecifier md : root.propertySpecifiers) {
                if (md.name == null) continue;
                ++count;
            }
            this.write("" + count);
            this.writeNewline(ASEmitterTokens.COMMA);
        }
        this.outputPropertySpecifiers(root, writeNewline);
        if (!root.isProperty) {
            boolean isLastChild;
            this.outputStyleSpecifiers(root, writeNewline);
            this.outputEventSpecifiers(root, writeNewline);
            if (!root.isTopNode) {
                this.writeDelimiter(writeNewline);
                if (root.childrenSpecifier == null) {
                    this.write(ASEmitterTokens.NULL);
                } else {
                    this.outputChildren(root.childrenSpecifier, writeNewline);
                }
            }
            boolean bl = isLastChild = root.parent != null && root.parent.propertySpecifiers.indexOf(root) == root.parent.propertySpecifiers.size() - 1;
            if (!isLastChild && !root.isTopNode) {
                this.writeDelimiter(writeNewline);
            }
        }
    }

    private void outputPropertySpecifiers(MXMLDescriptorSpecifier root, boolean writeNewline) {
        MXMLDescriptorSpecifier model = null;
        MXMLDescriptorSpecifier beads = null;
        for (MXMLDescriptorSpecifier md : root.propertySpecifiers) {
            if (md.name == null || !md.name.equals("model")) continue;
            model = md;
            break;
        }
        if (model != null) {
            this.outputPropertySpecifier(model, writeNewline);
        }
        for (MXMLDescriptorSpecifier md : root.propertySpecifiers) {
            if (md.name == null) continue;
            if (!md.name.equals("model") && !md.name.equals("beads")) {
                this.outputPropertySpecifier(md, writeNewline);
                continue;
            }
            if (!md.name.equals("beads")) continue;
            beads = md;
        }
        if (beads != null) {
            this.outputPropertySpecifier(beads, writeNewline);
        }
    }

    private void outputEventSpecifiers(MXMLDescriptorSpecifier root, boolean writeNewline) {
        int count = 0;
        for (MXMLEventSpecifier me : root.eventSpecifiers) {
            if (me.name == null) continue;
            ++count;
        }
        this.write("" + count);
        for (MXMLEventSpecifier me : root.eventSpecifiers) {
            this.writeDelimiter(writeNewline);
            this.outputEventSpecifier(me, writeNewline);
        }
    }

    private void outputStyleSpecifiers(MXMLDescriptorSpecifier root, boolean writeNewline) {
        this.write("0");
        this.writeDelimiter(writeNewline);
    }

    private void outputPropertySpecifier(MXMLDescriptorSpecifier specifier, boolean writeNewline) {
        String id;
        if (specifier.isProperty) {
            if (this.useGoogReflectObjectProperty) {
                this.write(JSGoogEmitterTokens.GOOG_REFLECT_OBJECTPROPERTY);
                this.write(ASEmitterTokens.PAREN_OPEN);
            }
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(specifier.name);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            if (this.useGoogReflectObjectProperty) {
                MXMLDescriptorSpecifier parentSpecifier = specifier.parent;
                id = parentSpecifier.id != null ? parentSpecifier.id : parentSpecifier.effectiveId;
                this.write(ASEmitterTokens.COMMA);
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.THIS);
                if (id != null) {
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write(id);
                }
                this.write(ASEmitterTokens.PAREN_CLOSE);
            }
        } else {
            this.write(specifier.name);
        }
        this.writeDelimiter(writeNewline);
        if (specifier.isProperty) {
            if (specifier.value != null) {
                this.write(ASEmitterTokens.TRUE);
                this.writeDelimiter(writeNewline);
                this.write(specifier.value);
            } else {
                this.write(specifier.hasArray ? ASEmitterTokens.NULL : ASEmitterTokens.FALSE);
                this.writeDelimiter(writeNewline);
                this.write(ASEmitterTokens.SQUARE_OPEN);
                this.indentPush();
                this.writeNewline();
                this.outputDescriptorSpecifier(specifier, writeNewline);
                this.indentPop();
                this.writeNewline();
                this.write(ASEmitterTokens.SQUARE_CLOSE);
            }
            if (specifier.parent != null) {
                this.writeDelimiter(writeNewline);
            }
        } else {
            for (MXMLDescriptorSpecifier md : specifier.propertySpecifiers) {
                if (md.name == null || !md.name.equals("mxmlContent")) continue;
                specifier.childrenSpecifier = md;
                specifier.propertySpecifiers.remove(md);
                break;
            }
            if (specifier.id != null || specifier.effectiveId != null) {
                this.write("" + (specifier.propertySpecifiers.size() + 1));
                this.writeDelimiter(writeNewline);
                String idPropName = specifier.effectiveId != null ? "_id" : "id";
                id = specifier.id != null ? specifier.id : specifier.effectiveId;
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(idPropName);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.writeDelimiter(writeNewline);
                this.write(ASEmitterTokens.TRUE);
                this.writeDelimiter(writeNewline);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(id);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.writeDelimiter(writeNewline);
            } else {
                this.write("" + specifier.propertySpecifiers.size());
                this.writeDelimiter(writeNewline);
            }
            this.outputDescriptorSpecifier(specifier, writeNewline);
        }
    }

    public void outputEventSpecifier(MXMLEventSpecifier specifier, boolean writeNewline) {
        String handler = ASEmitterTokens.THIS.getToken() + ASEmitterTokens.MEMBER_ACCESS.getToken() + specifier.eventHandler;
        if (MXMLEventSpecifier.nameMap.contains(specifier.name)) {
            specifier.name = specifier.name.toLowerCase();
        } else if (specifier.name.equals("doubleClick")) {
            specifier.name = "dblclick";
        } else if (specifier.name.equals("mouseWheel")) {
            specifier.name = "wheel";
        }
        this.writeSimpleDescriptor(specifier.name, null, handler, writeNewline);
    }

    private void outputChildren(MXMLDescriptorSpecifier children, boolean writeNewline) {
        this.write(ASEmitterTokens.SQUARE_OPEN.getToken());
        if (writeNewline) {
            this.indentPush();
            this.writeNewline();
        }
        this.outputDescriptorSpecifier(children, writeNewline);
        if (writeNewline) {
            this.indentPop();
            this.writeNewline();
        }
        this.write(ASEmitterTokens.SQUARE_CLOSE.getToken());
    }
}

