/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs.pass;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import org.apache.royale.compiler.internal.codegen.typedefs.pass.AbstractCompilerPass;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ReferenceModel;

public class CollectTypesPass
extends AbstractCompilerPass {
    public CollectTypesPass(ReferenceModel model, AbstractCompiler compiler) {
        super(model, compiler);
    }

    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        return n.isRoot() || n.isNormalBlock() || n.isScript();
    }

    public void visit(NodeTraversal t, Node n, Node parent) {
        for (Node child : n.children()) {
            if (child.isVar()) {
                this.visitVar(child);
                continue;
            }
            if (child.isFunction()) {
                this.visitFunction(child);
                continue;
            }
            if (!child.isExprResult()) continue;
            this.visitExprResult(child);
        }
    }

    private void visitExprResult(Node child) {
        JSDocInfo comment = null;
        Node container = child.getFirstChild();
        if (container.isAssign()) {
            comment = container.getJSDocInfo();
            Node left = container.getFirstChild();
            Node right = container.getLastChild();
            if (left.isName() && right.isFunction()) {
                if (comment.isConstructor() || comment.isInterface()) {
                    this.model.addClass(container, left.getString());
                }
            } else if (left.isGetProp() && right.isFunction()) {
                boolean isConstructor;
                boolean bl = isConstructor = comment != null && (comment.isConstructor() || comment.isInterface());
                if (isConstructor) {
                    this.model.addClass(container, left.getQualifiedName());
                }
            }
        } else {
            boolean isConstructor;
            comment = container.getJSDocInfo();
            boolean bl = isConstructor = comment != null && comment.getTypedefType() != null;
            if (isConstructor) {
                this.model.addTypeDef(container, container.getQualifiedName());
            }
        }
    }

    private void visitFunction(Node child) {
        boolean isConstructor;
        JSDocInfo comment = child.getJSDocInfo();
        boolean bl = isConstructor = comment != null && (comment.isConstructor() || comment.isInterface());
        if (isConstructor) {
            this.model.addClass(child, child.getFirstChild().getString());
        } else {
            this.model.addFunction(child, child.getFirstChild().getString());
        }
    }

    private void visitVar(Node child) {
        JSDocInfo comment = child.getJSDocInfo();
        Node first = child.getFirstChild();
        if (first.isName()) {
            Node subFirst = first.getFirstChild();
            if (subFirst != null && subFirst.isObjectLit()) {
                if (!comment.hasEnumParameterType()) {
                    this.model.addNamespace(child, first.getQualifiedName());
                }
            } else if (subFirst != null && subFirst.isFunction()) {
                boolean isConstructor;
                boolean bl = isConstructor = comment != null && (comment.isConstructor() || comment.isInterface());
                if (isConstructor) {
                    this.model.addClass(child, first.getString());
                }
            } else {
                boolean isConstructor;
                boolean bl = isConstructor = comment != null && comment.getTypedefType() != null;
                if (isConstructor) {
                    this.model.addTypeDef(child, first.getString());
                } else if (comment != null && comment.isConstant()) {
                    this.model.addConstant(child, first.getString());
                }
            }
        }
    }
}

