/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import com.google.common.base.Strings;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDesignLayerNode;
import org.apache.royale.compiler.tree.mxml.IMXMLInstanceNode;
import org.apache.royale.compiler.tree.mxml.IMXMLPropertySpecifierNode;
import org.apache.royale.compiler.tree.mxml.IMXMLSpecifierNode;

class MXMLDesignLayerNode
extends MXMLInstanceNode
implements IMXMLDesignLayerNode {
    MXMLDesignLayerNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLDesignLayerID;
    }

    @Override
    public String getName() {
        return "DesignLayer";
    }

    @Override
    public int getHoistedChildCount() {
        int result = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            IASNode child = this.getChild(i);
            if (child instanceof IMXMLSpecifierNode) continue;
            if (child instanceof IMXMLDesignLayerNode) {
                IMXMLDesignLayerNode designLayerNode = (IMXMLDesignLayerNode)child;
                result += designLayerNode.getHoistedChildCount();
                continue;
            }
            if (child instanceof IMXMLInstanceNode) {
                ++result;
                continue;
            }
            throw new IllegalStateException(child.getNodeID() + " is unexpected child of DesignLayer.");
        }
        return result;
    }

    @Override
    public boolean skipCodeGeneration() {
        IMXMLPropertySpecifierNode[] propertySpecifierNodes = this.getPropertySpecifierNodes();
        boolean hasNoPropertySpecifiers = propertySpecifierNodes == null || propertySpecifierNodes.length == 0;
        boolean hasNoID = Strings.isNullOrEmpty((String)this.getID());
        return hasNoPropertySpecifiers && hasNoID;
    }
}

