/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.units;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.common.Multiname;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.embedding.EmbedAttribute;
import org.apache.royale.compiler.embedding.IEmbedData;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.abc.ABCScopeBuilder;
import org.apache.royale.compiler.internal.as.codegen.CodeGeneratorManager;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.embedding.EmbedData;
import org.apache.royale.compiler.internal.embedding.transcoders.SkinTranscoder;
import org.apache.royale.compiler.internal.embedding.transcoders.TranscoderBase;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.DefinitionPriority;
import org.apache.royale.compiler.internal.scopes.ASFileScope;
import org.apache.royale.compiler.internal.scopes.ASFileScopeProvider;
import org.apache.royale.compiler.internal.scopes.ASProjectScope;
import org.apache.royale.compiler.internal.tree.as.FileNode;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.units.CompilationUnitBase;
import org.apache.royale.compiler.internal.units.requests.ABCBytesRequestResult;
import org.apache.royale.compiler.internal.units.requests.ABCFileScopeRequestResult;
import org.apache.royale.compiler.internal.units.requests.EmbedFileScopeRequestResult;
import org.apache.royale.compiler.internal.units.requests.SWFTagsRequestResult;
import org.apache.royale.compiler.internal.units.requests.SyntaxTreeRequestResult;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.InvalidABCByteCodeProblem;
import org.apache.royale.compiler.problems.NoScopesInABCCompilationUnitProblem;
import org.apache.royale.compiler.problems.UnknownSuperclassProblem;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IFileNode;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.units.requests.IABCBytesRequestResult;
import org.apache.royale.compiler.units.requests.IFileScopeRequestResult;
import org.apache.royale.compiler.units.requests.IOutgoingDependenciesRequestResult;
import org.apache.royale.compiler.units.requests.ISWFTagsRequestResult;
import org.apache.royale.compiler.units.requests.ISyntaxTreeRequestResult;
import org.apache.royale.swc.ISWCFileEntry;

public class EmbedCompilationUnit
extends CompilationUnitBase {
    private final EmbedData embedData;

    private static String getSourcePath(EmbedData data) {
        ISWCFileEntry swcFile = data.getSWCSource();
        if (swcFile != null) {
            return swcFile.getContainingSWCPath();
        }
        return (String)data.getAttribute(EmbedAttribute.SOURCE);
    }

    public EmbedCompilationUnit(CompilerProject project, EmbedData data) {
        super(project, EmbedCompilationUnit.getSourcePath(data), DefinitionPriority.BasePriority.SOURCE_LIST, true);
        this.embedData = data;
    }

    @Override
    public ICompilationUnit.UnitType getCompilationUnitType() {
        return ICompilationUnit.UnitType.EMBED_UNIT;
    }

    @Override
    public String getName() {
        return this.embedData.getQName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ISyntaxTreeRequestResult handleSyntaxTreeRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
        try {
            this.getProject().clearScopeCacheForCompilationUnit(this);
            TranscoderBase transcoder = (TranscoderBase)this.embedData.getTranscoder();
            if (transcoder instanceof SkinTranscoder) {
                List<ICompilerProblem> noProblems = Collections.emptyList();
                SyntaxTreeRequestResult syntaxTreeRequestResult = new SyntaxTreeRequestResult(this.getRootFileSpecification().getLastModified(), noProblems);
                return syntaxTreeRequestResult;
            }
            LinkedList<ICompilerProblem> problems = new LinkedList<ICompilerProblem>();
            IFileNode fileNode = transcoder.buildAST(problems, this.getAbsoluteFilename());
            ASFileScope fileScope = ((NodeBase)((Object)fileNode)).getFileScope();
            this.addScopeToProjectScope(new ASFileScope[]{fileScope});
            this.markClassAsEmbed(fileScope);
            SyntaxTreeRequestResult syntaxTreeRequestResult = new SyntaxTreeRequestResult(fileNode, ((FileNode)fileNode).getIncludeHandler().getIncludedFiles(), this.getRootFileSpecification().getLastModified(), problems);
            return syntaxTreeRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
        }
    }

    @Override
    protected void verifyAST(IASNode ast) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IFileScopeRequestResult handleFileScopeRequest() throws InterruptedException {
        TranscoderBase transcoder = (TranscoderBase)this.embedData.getTranscoder();
        if (transcoder instanceof SkinTranscoder) {
            List<IASScope> scopeList = null;
            LinkedList<ICompilerProblem> problems = new LinkedList<ICompilerProblem>();
            IFileSpecification rootSource = this.getRootFileSpecification();
            try {
                IABCBytesRequestResult abcResult = this.getABCBytesRequest().get();
                this.startProfile(ICompilationUnit.Operation.GET_FILESCOPE);
                String path = rootSource.getPath();
                ABCScopeBuilder abcScopeBuilder = new ABCScopeBuilder(this.getProject().getWorkspace(), abcResult.getABCBytes(), path, ASFileScopeProvider.getInstance());
                scopeList = abcScopeBuilder.build();
                if (scopeList.isEmpty()) {
                    problems.add(new NoScopesInABCCompilationUnitProblem(path));
                }
                for (IASScope scope : scopeList) {
                    this.markClassAsEmbed((ASFileScope)scope);
                }
                ABCFileScopeRequestResult aBCFileScopeRequestResult = new ABCFileScopeRequestResult((Collection<ICompilerProblem>)problems, (Collection<IASScope>)scopeList);
                return aBCFileScopeRequestResult;
            }
            catch (Exception e) {
                InvalidABCByteCodeProblem problem = new InvalidABCByteCodeProblem(rootSource.getPath());
                problems.add(problem);
                ABCFileScopeRequestResult aBCFileScopeRequestResult = new ABCFileScopeRequestResult((Collection<ICompilerProblem>)problems, (Collection<IASScope>)Collections.emptyList());
                return aBCFileScopeRequestResult;
            }
            finally {
                this.stopProfile(ICompilationUnit.Operation.GET_FILESCOPE);
            }
        }
        ISyntaxTreeRequestResult syntaxTreeResult = this.getSyntaxTreeRequest().get();
        FileNode rootNode = (FileNode)syntaxTreeResult.getAST();
        if (rootNode == null) {
            return new EmbedFileScopeRequestResult(null);
        }
        this.startProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        try {
            IASScope fileScope = rootNode.getScope();
            assert (fileScope instanceof ASFileScope) : "Expect ASFileScope as the top-level scope, but found " + fileScope.getClass();
            EmbedFileScopeRequestResult embedFileScopeRequestResult = new EmbedFileScopeRequestResult((ASFileScope)fileScope);
            return embedFileScopeRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IABCBytesRequestResult handleABCBytesRequest() throws InterruptedException {
        TranscoderBase transcoder = (TranscoderBase)this.embedData.getTranscoder();
        if (transcoder instanceof SkinTranscoder) {
            this.startProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
            try {
                LinkedList<ICompilerProblem> problems = new LinkedList<ICompilerProblem>();
                byte[] bytes = transcoder.buildABC(this.getProject(), problems);
                ICompilerProblem[] problemsArray = problems.toArray(new ICompilerProblem[problems.size()]);
                HashSet<IEmbedData> iembeds = new HashSet<IEmbedData>();
                iembeds.add(this.embedData);
                ABCBytesRequestResult aBCBytesRequestResult = new ABCBytesRequestResult(bytes, problemsArray, iembeds);
                return aBCBytesRequestResult;
            }
            finally {
                this.stopProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
            }
        }
        ISyntaxTreeRequestResult syntaxTreeResult = this.getSyntaxTreeRequest().get();
        IASNode rootNode = syntaxTreeResult.getAST();
        if (rootNode == null) {
            return new ABCBytesRequestResult(syntaxTreeResult.getProblems());
        }
        this.startProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        try {
            ABCBytesRequestResult aBCBytesRequestResult = CodeGeneratorManager.getCodeGenerator().generate(this.getFilenameNoPath(), rootNode, this.getProject());
            return aBCBytesRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ISWFTagsRequestResult handleSWFTagsRequest() throws InterruptedException {
        IABCBytesRequestResult abc = this.getABCBytesRequest().get();
        this.startProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        try {
            String qname = this.getName();
            String tagName = qname == null || "".equals(qname) ? "script" : qname.replace('.', '/');
            Collection<IEmbedData> embeds = abc.getEmbeds();
            if (embeds.size() == 0) {
                embeds = Collections.singleton(this.embedData);
            }
            SWFTagsRequestResult sWFTagsRequestResult = new SWFTagsRequestResult(abc.getABCBytes(), tagName, embeds);
            return sWFTagsRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IOutgoingDependenciesRequestResult handleOutgoingDependenciesRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        try {
            IOutgoingDependenciesRequestResult result;
            LinkedList<ICompilerProblem> problems = new LinkedList<ICompilerProblem>();
            this.analyze(problems);
            IOutgoingDependenciesRequestResult iOutgoingDependenciesRequestResult = result = new IOutgoingDependenciesRequestResult(){

                @Override
                public ICompilerProblem[] getProblems() {
                    return IOutgoingDependenciesRequestResult.NO_PROBLEMS;
                }
            };
            return iOutgoingDependenciesRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        }
    }

    public EmbedData getEmbedData() {
        return this.embedData;
    }

    private void analyze(Collection<ICompilerProblem> problems) {
        if (this.embedData.generatedClassExtendsAnother()) {
            ASProjectScope projectScope = this.getProject().getScope();
            IDefinition[] baseDefs = projectScope.findAllDefinitionsByName(Multiname.crackDottedQName(this.getProject(), this.embedData.getTranscoder().getBaseClassQName()));
            if (baseDefs == null || baseDefs.length == 0) {
                IDefinition[] subDefs = projectScope.findAllDefinitionsByName(Multiname.crackDottedQName(this.getProject(), this.embedData.getQName()));
                UnknownSuperclassProblem problem = new UnknownSuperclassProblem(subDefs[0], this.embedData.getTranscoder().getBaseClassQName());
                problems.add(problem);
            } else {
                ICompilationUnit referencedCU = projectScope.getCompilationUnitForScope(baseDefs[0].getContainingScope());
                this.getProject().addDependency((ICompilationUnit)this, referencedCU, DependencyType.INHERITANCE, baseDefs[0].getQualifiedName());
            }
        }
    }

    private void markClassAsEmbed(ASFileScope fileScope) {
        LinkedList<IDefinition> definitions = new LinkedList<IDefinition>();
        fileScope.collectExternallyVisibleDefinitions(definitions, false);
        for (IDefinition definition : definitions) {
            if (!(definition instanceof ClassDefinition)) continue;
            ClassDefinition classDefinition = (ClassDefinition)definition;
            classDefinition.setGeneratedEmbedClass();
            classDefinition.setExcludedClass();
        }
    }
}

