// //////////////////////////////////////////////////////////////////////////////
// 
// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
// 
// http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// 
// //////////////////////////////////////////////////////////////////////////////
package
{
    /**
     *  The MaterialIconType class list all possible icons
     *  found in https://material.io/icons/ to use with the
     *  Icon class.
     *
     *  New site https://fonts.google.com/icons
     *
     *  @langversion 3.0
     *  @playerversion Flash 10.2
     *  @playerversion AIR 2.6
     *  @productversion Royale 0.9.3
     */
    public class MaterialIconType
    {
        /**
         *  constructor.
         *
         *  @langversion 3.0
         *  @playerversion Flash 10.2
         *  @playerversion AIR 2.6
         *  @productversion Royale 0.9.3
         */
        public function MaterialIconType()
        {
            super();
        }

        public static const _10K:String = '10k';
        public static const _10MP:String = '10mp';
        public static const _11MP:String = '11mp';
        public static const _123:String = '123';
        public static const _12MP:String = '12mp';
        public static const _13MP:String = '13mp';
        public static const _14MP:String = '14mp';
        public static const _15MP:String = '15mp';
        public static const _16MP:String = '16mp';
        public static const _17MP:String = '17mp';
        public static const _18_UP_RATING:String = '18_up_rating';
        public static const _18MP:String = '18mp';
        public static const _19MP:String = '19mp';
        public static const _1K:String = '1k';
        public static const _1K_PLUS:String = '1k_plus';
        public static const _1X_MOBILEDATA:String = '1x_mobiledata';
        public static const _1X_MOBILEDATA_BADGE:String = '1x_mobiledata_badge';
        public static const _20MP:String = '20mp';
        public static const _21MP:String = '21mp';
        public static const _22MP:String = '22mp';
        public static const _23MP:String = '23mp';
        public static const _24MP:String = '24mp';
        public static const _2D:String = '2d';
        public static const _2K:String = '2k';
        public static const _2K_PLUS:String = '2k_plus';
        public static const _2MP:String = '2mp';
        public static const _30FPS:String = '30fps';
        public static const _30FPS_SELECT:String = '30fps_select';
        public static const _360:String = '360';
        public static const _3D_ROTATION:String = '3d_rotation';
        public static const _3G_MOBILEDATA:String = '3g_mobiledata';
        public static const _3G_MOBILEDATA_BADGE:String = '3g_mobiledata_badge';
        public static const _3K:String = '3k';
        public static const _3K_PLUS:String = '3k_plus';
        public static const _3MP:String = '3mp';
        public static const _3P:String = '3p';
        public static const _4G_MOBILEDATA:String = '4g_mobiledata';
        public static const _4G_MOBILEDATA_BADGE:String = '4g_mobiledata_badge';
        public static const _4G_PLUS_MOBILEDATA:String = '4g_plus_mobiledata';
        public static const _4K:String = '4k';
        public static const _4K_PLUS:String = '4k_plus';
        public static const _4MP:String = '4mp';
        public static const _50MP:String = '50mp';
        public static const _5G:String = '5g';
        public static const _5G_MOBILEDATA_BADGE:String = '5g_mobiledata_badge';
        public static const _5K:String = '5k';
        public static const _5K_PLUS:String = '5k_plus';
        public static const _5MP:String = '5mp';
        public static const _6_FT_APART:String = '6_ft_apart';
        public static const _60FPS:String = '60fps';
        public static const _60FPS_SELECT:String = '60fps_select';
        public static const _6K:String = '6k';
        public static const _6K_PLUS:String = '6k_plus';
        public static const _6MP:String = '6mp';
        public static const _7K:String = '7k';
        public static const _7K_PLUS:String = '7k_plus';
        public static const _7MP:String = '7mp';
        public static const _8K:String = '8k';
        public static const _8K_PLUS:String = '8k_plus';
        public static const _8MP:String = '8mp';
        public static const _9K:String = '9k';
        public static const _9K_PLUS:String = '9k_plus';
        public static const _9MP:String = '9mp';
        public static const ABC:String = 'abc';
        public static const AC_UNIT:String = 'ac_unit';
        public static const ACCESS_ALARM:String = 'access_alarm';
        public static const ACCESS_ALARMS:String = 'access_alarms';
        public static const ACCESS_TIME:String = 'access_time';
        public static const ACCESS_TIME_FILLED:String = 'access_time_filled';
        public static const ACCESSIBILITY:String = 'accessibility';
        public static const ACCESSIBILITY_NEW:String = 'accessibility_new';
        public static const ACCESSIBLE:String = 'accessible';
        public static const ACCESSIBLE_FORWARD:String = 'accessible_forward';
        public static const ACCOUNT_BALANCE:String = 'account_balance';
        public static const ACCOUNT_BALANCE_WALLET:String = 'account_balance_wallet';
        public static const ACCOUNT_BOX:String = 'account_box';
        public static const ACCOUNT_CHILD:String = 'account_child';
        public static const ACCOUNT_CHILD_INVERT:String = 'account_child_invert';
        public static const ACCOUNT_CIRCLE:String = 'account_circle';
        public static const ACCOUNT_CIRCLE_FULL:String = 'account_circle_full';
        public static const ACCOUNT_CIRCLE_OFF:String = 'account_circle_off';
        public static const ACCOUNT_TREE:String = 'account_tree';
        public static const ACTION_KEY:String = 'action_key';
        public static const ACTIVITY_ZONE:String = 'activity_zone';
        public static const ACUTE:String = 'acute';
        public static const AD:String = 'ad';
        public static const AD_GROUP:String = 'ad_group';
        public static const AD_GROUP_OFF:String = 'ad_group_off';
        public static const AD_OFF:String = 'ad_off';
        public static const AD_UNITS:String = 'ad_units';
        public static const ADB:String = 'adb';
        public static const ADD:String = 'add';
        public static const ADD_A_PHOTO:String = 'add_a_photo';
        public static const ADD_AD:String = 'add_ad';
        public static const ADD_ALARM:String = 'add_alarm';
        public static const ADD_ALERT:String = 'add_alert';
        public static const ADD_BOX:String = 'add_box';
        public static const ADD_BUSINESS:String = 'add_business';
        public static const ADD_CALL:String = 'add_call';
        public static const ADD_CARD:String = 'add_card';
        public static const ADD_CHART:String = 'add_chart';
        public static const ADD_CIRCLE:String = 'add_circle';
        public static const ADD_CIRCLE_OUTLINE:String = 'add_circle_outline';
        public static const ADD_COMMENT:String = 'add_comment';
        public static const ADD_HOME:String = 'add_home';
        public static const ADD_HOME_WORK:String = 'add_home_work';
        public static const ADD_IC_CALL:String = 'add_ic_call';
        public static const ADD_LINK:String = 'add_link';
        public static const ADD_LOCATION:String = 'add_location';
        public static const ADD_LOCATION_ALT:String = 'add_location_alt';
        public static const ADD_MODERATOR:String = 'add_moderator';
        public static const ADD_NOTES:String = 'add_notes';
        public static const ADD_PHOTO_ALTERNATE:String = 'add_photo_alternate';
        public static const ADD_REACTION:String = 'add_reaction';
        public static const ADD_ROAD:String = 'add_road';
        public static const ADD_SHOPPING_CART:String = 'add_shopping_cart';
        public static const ADD_SHORTCUT_TO_DRIVE:String = 'add_shortcut_to_drive';
        public static const ADD_TASK:String = 'add_task';
        public static const ADD_TO_DRIVE:String = 'add_to_drive';
        public static const ADD_TO_HOME_SCREEN:String = 'add_to_home_screen';
        public static const ADD_TO_PHOTOS:String = 'add_to_photos';
        public static const ADD_TO_QUEUE:String = 'add_to_queue';
        public static const ADDCHART:String = 'addchart';
        public static const ADF_SCANNER:String = 'adf_scanner';
        public static const ADJUST:String = 'adjust';
        public static const ADMIN_MEDS:String = 'admin_meds';
        public static const ADMIN_PANEL_SETTINGS:String = 'admin_panel_settings';
        public static const ADS_CLICK:String = 'ads_click';
        public static const AGENDER:String = 'agender';
        public static const AGRICULTURE:String = 'agriculture';
        public static const AIR:String = 'air';
        public static const AIR_FRESHENER:String = 'air_freshener';
        public static const AIR_PURIFIER:String = 'air_purifier';
        public static const AIR_PURIFIER_GEN:String = 'air_purifier_gen';
        public static const AIRLINE_SEAT_FLAT:String = 'airline_seat_flat';
        public static const AIRLINE_SEAT_FLAT_ANGLED:String = 'airline_seat_flat_angled';
        public static const AIRLINE_SEAT_INDIVIDUAL_SUITE:String = 'airline_seat_individual_suite';
        public static const AIRLINE_SEAT_LEGROOM_EXTRA:String = 'airline_seat_legroom_extra';
        public static const AIRLINE_SEAT_LEGROOM_NORMAL:String = 'airline_seat_legroom_normal';
        public static const AIRLINE_SEAT_LEGROOM_REDUCED:String = 'airline_seat_legroom_reduced';
        public static const AIRLINE_SEAT_RECLINE_EXTRA:String = 'airline_seat_recline_extra';
        public static const AIRLINE_SEAT_RECLINE_NORMAL:String = 'airline_seat_recline_normal';
        public static const AIRLINE_STOPS:String = 'airline_stops';
        public static const AIRLINES:String = 'airlines';
        public static const AIRPLANE_TICKET:String = 'airplane_ticket';
        public static const AIRPLANEMODE_ACTIVE:String = 'airplanemode_active';
        public static const AIRPLANEMODE_INACTIVE:String = 'airplanemode_inactive';
        public static const AIRPLAY:String = 'airplay';
        public static const AIRPORT_SHUTTLE:String = 'airport_shuttle';
        public static const AIRWARE:String = 'airware';
        public static const AIRWAVE:String = 'airwave';
        public static const ALARM:String = 'alarm';
        public static const ALARM_ADD:String = 'alarm_add';
        public static const ALARM_OFF:String = 'alarm_off';
        public static const ALARM_ON:String = 'alarm_on';
        public static const ALARM_SMART_WAKE:String = 'alarm_smart_wake';
        public static const ALBUM:String = 'album';
        public static const ALIGN_CENTER:String = 'align_center';
        public static const ALIGN_END:String = 'align_end';
        public static const ALIGN_FLEX_CENTER:String = 'align_flex_center';
        public static const ALIGN_FLEX_END:String = 'align_flex_end';
        public static const ALIGN_FLEX_START:String = 'align_flex_start';
        public static const ALIGN_HORIZONTAL_CENTER:String = 'align_horizontal_center';
        public static const ALIGN_HORIZONTAL_LEFT:String = 'align_horizontal_left';
        public static const ALIGN_HORIZONTAL_RIGHT:String = 'align_horizontal_right';
        public static const ALIGN_ITEMS_STRETCH:String = 'align_items_stretch';
        public static const ALIGN_JUSTIFY_CENTER:String = 'align_justify_center';
        public static const ALIGN_JUSTIFY_FLEX_END:String = 'align_justify_flex_end';
        public static const ALIGN_JUSTIFY_FLEX_START:String = 'align_justify_flex_start';
        public static const ALIGN_JUSTIFY_SPACE_AROUND:String = 'align_justify_space_around';
        public static const ALIGN_JUSTIFY_SPACE_BETWEEN:String = 'align_justify_space_between';
        public static const ALIGN_JUSTIFY_SPACE_EVEN:String = 'align_justify_space_even';
        public static const ALIGN_JUSTIFY_STRETCH:String = 'align_justify_stretch';
        public static const ALIGN_SELF_STRETCH:String = 'align_self_stretch';
        public static const ALIGN_SPACE_AROUND:String = 'align_space_around';
        public static const ALIGN_SPACE_BETWEEN:String = 'align_space_between';
        public static const ALIGN_SPACE_EVEN:String = 'align_space_even';
        public static const ALIGN_START:String = 'align_start';
        public static const ALIGN_STRETCH:String = 'align_stretch';
        public static const ALIGN_VERTICAL_BOTTOM:String = 'align_vertical_bottom';
        public static const ALIGN_VERTICAL_CENTER:String = 'align_vertical_center';
        public static const ALIGN_VERTICAL_TOP:String = 'align_vertical_top';
        public static const ALL_INBOX:String = 'all_inbox';
        public static const ALL_INCLUSIVE:String = 'all_inclusive';
        public static const ALL_MATCH:String = 'all_match';
        public static const ALL_OUT:String = 'all_out';
        public static const ALLERGIES:String = 'allergies';
        public static const ALLERGY:String = 'allergy';
        public static const ALT_ROUTE:String = 'alt_route';
        public static const ALTERNATE_EMAIL:String = 'alternate_email';
        public static const ALTITUDE:String = 'altitude';
        public static const AMBIENT_SCREEN:String = 'ambient_screen';
        public static const AMBULANCE:String = 'ambulance';
        public static const AMEND:String = 'amend';
        public static const AMP_ERROR:String = 'amp_error';
        public static const AMP_STORIES:String = 'amp_stories';
        public static const ANALYTICS:String = 'analytics';
        public static const ANCHOR:String = 'anchor';
        public static const ANDROID:String = 'android';
        public static const ANIMATION:String = 'animation';
        public static const ANNOUNCEMENT:String = 'announcement';
        public static const AOD:String = 'aod';
        public static const AOD_TABLET:String = 'aod_tablet';
        public static const AOD_WATCH:String = 'aod_watch';
        public static const APARTMENT:String = 'apartment';
        public static const API:String = 'api';
        public static const APK_DOCUMENT:String = 'apk_document';
        public static const APK_INSTALL:String = 'apk_install';
        public static const APP_BADGING:String = 'app_badging';
        public static const APP_BLOCKING:String = 'app_blocking';
        public static const APP_PROMO:String = 'app_promo';
        public static const APP_REGISTRATION:String = 'app_registration';
        public static const APP_SETTINGS_ALT:String = 'app_settings_alt';
        public static const APP_SHORTCUT:String = 'app_shortcut';
        public static const APPAREL:String = 'apparel';
        public static const APPROVAL:String = 'approval';
        public static const APPROVAL_DELEGATION:String = 'approval_delegation';
        public static const APPS:String = 'apps';
        public static const APPS_OUTAGE:String = 'apps_outage';
        public static const AQ:String = 'aq';
        public static const AQ_INDOOR:String = 'aq_indoor';
        public static const AR_ON_YOU:String = 'ar_on_you';
        public static const AR_STICKERS:String = 'ar_stickers';
        public static const ARCHITECTURE:String = 'architecture';
        public static const ARCHIVE:String = 'archive';
        public static const AREA_CHART:String = 'area_chart';
        public static const ARMING_COUNTDOWN:String = 'arming_countdown';
        public static const ARROW_AND_EDGE:String = 'arrow_and_edge';
        public static const ARROW_BACK:String = 'arrow_back';
        public static const ARROW_BACK_IOS:String = 'arrow_back_ios';
        public static const ARROW_BACK_IOS_NEW:String = 'arrow_back_ios_new';
        public static const ARROW_CIRCLE_DOWN:String = 'arrow_circle_down';
        public static const ARROW_CIRCLE_LEFT:String = 'arrow_circle_left';
        public static const ARROW_CIRCLE_RIGHT:String = 'arrow_circle_right';
        public static const ARROW_CIRCLE_UP:String = 'arrow_circle_up';
        public static const ARROW_DOWNWARD:String = 'arrow_downward';
        public static const ARROW_DOWNWARD_ALT:String = 'arrow_downward_alt';
        public static const ARROW_DROP_DOWN:String = 'arrow_drop_down';
        public static const ARROW_DROP_DOWN_CIRCLE:String = 'arrow_drop_down_circle';
        public static const ARROW_DROP_UP:String = 'arrow_drop_up';
        public static const ARROW_FORWARD:String = 'arrow_forward';
        public static const ARROW_FORWARD_IOS:String = 'arrow_forward_ios';
        public static const ARROW_INSERT:String = 'arrow_insert';
        public static const ARROW_LEFT:String = 'arrow_left';
        public static const ARROW_LEFT_ALT:String = 'arrow_left_alt';
        public static const ARROW_OR_EDGE:String = 'arrow_or_edge';
        public static const ARROW_OUTWARD:String = 'arrow_outward';
        public static const ARROW_RANGE:String = 'arrow_range';
        public static const ARROW_RIGHT:String = 'arrow_right';
        public static const ARROW_RIGHT_ALT:String = 'arrow_right_alt';
        public static const ARROW_SELECTOR_TOOL:String = 'arrow_selector_tool';
        public static const ARROW_SPLIT:String = 'arrow_split';
        public static const ARROW_TOP_LEFT:String = 'arrow_top_left';
        public static const ARROW_TOP_RIGHT:String = 'arrow_top_right';
        public static const ARROW_UPWARD:String = 'arrow_upward';
        public static const ARROW_UPWARD_ALT:String = 'arrow_upward_alt';
        public static const ARROWS_MORE_DOWN:String = 'arrows_more_down';
        public static const ARROWS_MORE_UP:String = 'arrows_more_up';
        public static const ARROWS_OUTWARD:String = 'arrows_outward';
        public static const ART_TRACK:String = 'art_track';
        public static const ARTICLE:String = 'article';
        public static const ARTICLE_SHORTCUT:String = 'article_shortcut';
        public static const ARTIST:String = 'artist';
        public static const ASPECT_RATIO:String = 'aspect_ratio';
        public static const ASSESSMENT:String = 'assessment';
        public static const ASSIGNMENT:String = 'assignment';
        public static const ASSIGNMENT_ADD:String = 'assignment_add';
        public static const ASSIGNMENT_IND:String = 'assignment_ind';
        public static const ASSIGNMENT_LATE:String = 'assignment_late';
        public static const ASSIGNMENT_RETURN:String = 'assignment_return';
        public static const ASSIGNMENT_RETURNED:String = 'assignment_returned';
        public static const ASSIGNMENT_TURNED_IN:String = 'assignment_turned_in';
        public static const ASSIST_WALKER:String = 'assist_walker';
        public static const ASSISTANT:String = 'assistant';
        public static const ASSISTANT_DEVICE:String = 'assistant_device';
        public static const ASSISTANT_DIRECTION:String = 'assistant_direction';
        public static const ASSISTANT_NAVIGATION:String = 'assistant_navigation';
        public static const ASSISTANT_ON_HUB:String = 'assistant_on_hub';
        public static const ASSISTANT_PHOTO:String = 'assistant_photo';
        public static const ASSURED_WORKLOAD:String = 'assured_workload';
        public static const ASTERISK:String = 'asterisk';
        public static const ASTROPHOTOGRAPHY_AUTO:String = 'astrophotography_auto';
        public static const ASTROPHOTOGRAPHY_OFF:String = 'astrophotography_off';
        public static const ATM:String = 'atm';
        public static const ATR:String = 'atr';
        public static const ATTACH_EMAIL:String = 'attach_email';
        public static const ATTACH_FILE:String = 'attach_file';
        public static const ATTACH_FILE_ADD:String = 'attach_file_add';
        public static const ATTACH_FILE_OFF:String = 'attach_file_off';
        public static const ATTACH_MONEY:String = 'attach_money';
        public static const ATTACHMENT:String = 'attachment';
        public static const ATTRACTIONS:String = 'attractions';
        public static const ATTRIBUTION:String = 'attribution';
        public static const AUDIO_DESCRIPTION:String = 'audio_description';
        public static const AUDIO_FILE:String = 'audio_file';
        public static const AUDIO_VIDEO_RECEIVER:String = 'audio_video_receiver';
        public static const AUDIOTRACK:String = 'audiotrack';
        public static const AUTO_ACTIVITY_ZONE:String = 'auto_activity_zone';
        public static const AUTO_AWESOME:String = 'auto_awesome';
        public static const AUTO_AWESOME_MOSAIC:String = 'auto_awesome_mosaic';
        public static const AUTO_AWESOME_MOTION:String = 'auto_awesome_motion';
        public static const AUTO_DELETE:String = 'auto_delete';
        public static const AUTO_DETECT_VOICE:String = 'auto_detect_voice';
        public static const AUTO_FIX:String = 'auto_fix';
        public static const AUTO_FIX_HIGH:String = 'auto_fix_high';
        public static const AUTO_FIX_NORMAL:String = 'auto_fix_normal';
        public static const AUTO_FIX_OFF:String = 'auto_fix_off';
        public static const AUTO_GRAPH:String = 'auto_graph';
        public static const AUTO_LABEL:String = 'auto_label';
        public static const AUTO_MEETING_ROOM:String = 'auto_meeting_room';
        public static const AUTO_MODE:String = 'auto_mode';
        public static const AUTO_READ_PAUSE:String = 'auto_read_pause';
        public static const AUTO_READ_PLAY:String = 'auto_read_play';
        public static const AUTO_SCHEDULE:String = 'auto_schedule';
        public static const AUTO_STORIES:String = 'auto_stories';
        public static const AUTO_TIMER:String = 'auto_timer';
        public static const AUTO_TOWING:String = 'auto_towing';
        public static const AUTO_TRANSMISSION:String = 'auto_transmission';
        public static const AUTO_VIDEOCAM:String = 'auto_videocam';
        public static const AUTOFPS_SELECT:String = 'autofps_select';
        public static const AUTOPAUSE:String = 'autopause';
        public static const AUTOPAY:String = 'autopay';
        public static const AUTOPLAY:String = 'autoplay';
        public static const AUTORENEW:String = 'autorenew';
        public static const AUTOSTOP:String = 'autostop';
        public static const AV_TIMER:String = 'av_timer';
        public static const AVG_PACE:String = 'avg_pace';
        public static const AVG_TIME:String = 'avg_time';
        public static const AWARD_STAR:String = 'award_star';
        public static const AZM:String = 'azm';
        public static const BABY_CHANGING_STATION:String = 'baby_changing_station';
        public static const BACK_HAND:String = 'back_hand';
        public static const BACK_TO_TAB:String = 'back_to_tab';
        public static const BACKGROUND_BLUR_FULL:String = 'background_blur_full';
        public static const BACKGROUND_BLUR_LIGHT:String = 'background_blur_light';
        public static const BACKGROUND_DOT_LARGE:String = 'background_dot_large';
        public static const BACKGROUND_DOT_SMALL:String = 'background_dot_small';
        public static const BACKGROUND_GRID_SMALL:String = 'background_grid_small';
        public static const BACKGROUND_REPLACE:String = 'background_replace';
        public static const BACKLIGHT_HIGH:String = 'backlight_high';
        public static const BACKLIGHT_HIGH_OFF:String = 'backlight_high_off';
        public static const BACKLIGHT_LOW:String = 'backlight_low';
        public static const BACKPACK:String = 'backpack';
        public static const BACKSPACE:String = 'backspace';
        public static const BACKUP:String = 'backup';
        public static const BACKUP_TABLE:String = 'backup_table';
        public static const BADGE:String = 'badge';
        public static const BADGE_CRITICAL_BATTERY:String = 'badge_critical_battery';
        public static const BAKERY_DINING:String = 'bakery_dining';
        public static const BALANCE:String = 'balance';
        public static const BALCONY:String = 'balcony';
        public static const BALLOT:String = 'ballot';
        public static const BAR_CHART:String = 'bar_chart';
        public static const BAR_CHART_4_BARS:String = 'bar_chart_4_bars';
        public static const BARCODE:String = 'barcode';
        public static const BARCODE_READER:String = 'barcode_reader';
        public static const BARCODE_SCANNER:String = 'barcode_scanner';
        public static const BAREFOOT:String = 'barefoot';
        public static const BATCH_PREDICTION:String = 'batch_prediction';
        public static const BATH_OUTDOOR:String = 'bath_outdoor';
        public static const BATH_PRIVATE:String = 'bath_private';
        public static const BATH_PUBLIC_LARGE:String = 'bath_public_large';
        public static const BATHROOM:String = 'bathroom';
        public static const BATHTUB:String = 'bathtub';
        public static const BATTERY_0_BAR:String = 'battery_0_bar';
        public static const BATTERY_1_BAR:String = 'battery_1_bar';
        public static const BATTERY_2_BAR:String = 'battery_2_bar';
        public static const BATTERY_20:String = 'battery_20';
        public static const BATTERY_3_BAR:String = 'battery_3_bar';
        public static const BATTERY_30:String = 'battery_30';
        public static const BATTERY_4_BAR:String = 'battery_4_bar';
        public static const BATTERY_5_BAR:String = 'battery_5_bar';
        public static const BATTERY_50:String = 'battery_50';
        public static const BATTERY_6_BAR:String = 'battery_6_bar';
        public static const BATTERY_60:String = 'battery_60';
        public static const BATTERY_80:String = 'battery_80';
        public static const BATTERY_90:String = 'battery_90';
        public static const BATTERY_ALERT:String = 'battery_alert';
        public static const BATTERY_CHANGE:String = 'battery_change';
        public static const BATTERY_CHARGING_20:String = 'battery_charging_20';
        public static const BATTERY_CHARGING_30:String = 'battery_charging_30';
        public static const BATTERY_CHARGING_50:String = 'battery_charging_50';
        public static const BATTERY_CHARGING_60:String = 'battery_charging_60';
        public static const BATTERY_CHARGING_80:String = 'battery_charging_80';
        public static const BATTERY_CHARGING_90:String = 'battery_charging_90';
        public static const BATTERY_CHARGING_FULL:String = 'battery_charging_full';
        public static const BATTERY_ERROR:String = 'battery_error';
        public static const BATTERY_FULL:String = 'battery_full';
        public static const BATTERY_FULL_ALT:String = 'battery_full_alt';
        public static const BATTERY_HORIZ_000:String = 'battery_horiz_000';
        public static const BATTERY_HORIZ_050:String = 'battery_horiz_050';
        public static const BATTERY_HORIZ_075:String = 'battery_horiz_075';
        public static const BATTERY_LOW:String = 'battery_low';
        public static const BATTERY_PLUS:String = 'battery_plus';
        public static const BATTERY_PROFILE:String = 'battery_profile';
        public static const BATTERY_SAVER:String = 'battery_saver';
        public static const BATTERY_SHARE:String = 'battery_share';
        public static const BATTERY_STATUS_GOOD:String = 'battery_status_good';
        public static const BATTERY_STD:String = 'battery_std';
        public static const BATTERY_UNKNOWN:String = 'battery_unknown';
        public static const BATTERY_VERT_005:String = 'battery_vert_005';
        public static const BATTERY_VERT_020:String = 'battery_vert_020';
        public static const BATTERY_VERT_050:String = 'battery_vert_050';
        public static const BATTERY_VERY_LOW:String = 'battery_very_low';
        public static const BEACH_ACCESS:String = 'beach_access';
        public static const BED:String = 'bed';
        public static const BEDROOM_BABY:String = 'bedroom_baby';
        public static const BEDROOM_CHILD:String = 'bedroom_child';
        public static const BEDROOM_PARENT:String = 'bedroom_parent';
        public static const BEDTIME:String = 'bedtime';
        public static const BEDTIME_OFF:String = 'bedtime_off';
        public static const BEENHERE:String = 'beenhere';
        public static const BENTO:String = 'bento';
        public static const BIA:String = 'bia';
        public static const BID_LANDSCAPE:String = 'bid_landscape';
        public static const BID_LANDSCAPE_DISABLED:String = 'bid_landscape_disabled';
        public static const BIGTOP_UPDATES:String = 'bigtop_updates';
        public static const BIKE_SCOOTER:String = 'bike_scooter';
        public static const BIOTECH:String = 'biotech';
        public static const BLANKET:String = 'blanket';
        public static const BLENDER:String = 'blender';
        public static const BLIND:String = 'blind';
        public static const BLINDS:String = 'blinds';
        public static const BLINDS_CLOSED:String = 'blinds_closed';
        public static const BLOCK:String = 'block';
        public static const BLOCK_FLIPPED:String = 'block_flipped';
        public static const BLOOD_PRESSURE:String = 'blood_pressure';
        public static const BLOODTYPE:String = 'bloodtype';
        public static const BLUENOTE:String = 'bluenote';
        public static const BLUETOOTH:String = 'bluetooth';
        public static const BLUETOOTH_AUDIO:String = 'bluetooth_audio';
        public static const BLUETOOTH_CONNECTED:String = 'bluetooth_connected';
        public static const BLUETOOTH_DISABLED:String = 'bluetooth_disabled';
        public static const BLUETOOTH_DRIVE:String = 'bluetooth_drive';
        public static const BLUETOOTH_SEARCHING:String = 'bluetooth_searching';
        public static const BLUR_CIRCULAR:String = 'blur_circular';
        public static const BLUR_LINEAR:String = 'blur_linear';
        public static const BLUR_MEDIUM:String = 'blur_medium';
        public static const BLUR_OFF:String = 'blur_off';
        public static const BLUR_ON:String = 'blur_on';
        public static const BLUR_SHORT:String = 'blur_short';
        public static const BNAGENT:String = 'bnagent';
        public static const BODY_FAT:String = 'body_fat';
        public static const BODY_SYSTEM:String = 'body_system';
        public static const BOLT:String = 'bolt';
        public static const BOMB:String = 'bomb';
        public static const BOOK:String = 'book';
        public static const BOOK_2:String = 'book_2';
        public static const BOOK_3:String = 'book_3';
        public static const BOOK_4:String = 'book_4';
        public static const BOOK_5:String = 'book_5';
        public static const BOOK_ONLINE:String = 'book_online';
        public static const BOOKMARK:String = 'bookmark';
        public static const BOOKMARK_ADD:String = 'bookmark_add';
        public static const BOOKMARK_ADDED:String = 'bookmark_added';
        public static const BOOKMARK_BORDER:String = 'bookmark_border';
        public static const BOOKMARK_MANAGER:String = 'bookmark_manager';
        public static const BOOKMARK_REMOVE:String = 'bookmark_remove';
        public static const BOOKMARKS:String = 'bookmarks';
        public static const BORDER_ALL:String = 'border_all';
        public static const BORDER_BOTTOM:String = 'border_bottom';
        public static const BORDER_CLEAR:String = 'border_clear';
        public static const BORDER_COLOR:String = 'border_color';
        public static const BORDER_HORIZONTAL:String = 'border_horizontal';
        public static const BORDER_INNER:String = 'border_inner';
        public static const BORDER_LEFT:String = 'border_left';
        public static const BORDER_OUTER:String = 'border_outer';
        public static const BORDER_RIGHT:String = 'border_right';
        public static const BORDER_STYLE:String = 'border_style';
        public static const BORDER_TOP:String = 'border_top';
        public static const BORDER_VERTICAL:String = 'border_vertical';
        public static const BOTTOM_APP_BAR:String = 'bottom_app_bar';
        public static const BOTTOM_DRAWER:String = 'bottom_drawer';
        public static const BOTTOM_NAVIGATION:String = 'bottom_navigation';
        public static const BOTTOM_PANEL_CLOSE:String = 'bottom_panel_close';
        public static const BOTTOM_PANEL_OPEN:String = 'bottom_panel_open';
        public static const BOTTOM_RIGHT_CLICK:String = 'bottom_right_click';
        public static const BOTTOM_SHEETS:String = 'bottom_sheets';
        public static const BOX:String = 'box';
        public static const BOX_ADD:String = 'box_add';
        public static const BOX_EDIT:String = 'box_edit';
        public static const BOY:String = 'boy';
        public static const BRAND_AWARENESS:String = 'brand_awareness';
        public static const BRAND_FAMILY:String = 'brand_family';
        public static const BRANDING_WATERMARK:String = 'branding_watermark';
        public static const BREAKFAST_DINING:String = 'breakfast_dining';
        public static const BREAKING_NEWS:String = 'breaking_news';
        public static const BREAKING_NEWS_ALT_1:String = 'breaking_news_alt_1';
        public static const BREASTFEEDING:String = 'breastfeeding';
        public static const BRIGHTNESS_1:String = 'brightness_1';
        public static const BRIGHTNESS_2:String = 'brightness_2';
        public static const BRIGHTNESS_3:String = 'brightness_3';
        public static const BRIGHTNESS_4:String = 'brightness_4';
        public static const BRIGHTNESS_5:String = 'brightness_5';
        public static const BRIGHTNESS_6:String = 'brightness_6';
        public static const BRIGHTNESS_7:String = 'brightness_7';
        public static const BRIGHTNESS_ALERT:String = 'brightness_alert';
        public static const BRIGHTNESS_AUTO:String = 'brightness_auto';
        public static const BRIGHTNESS_EMPTY:String = 'brightness_empty';
        public static const BRIGHTNESS_HIGH:String = 'brightness_high';
        public static const BRIGHTNESS_LOW:String = 'brightness_low';
        public static const BRIGHTNESS_MEDIUM:String = 'brightness_medium';
        public static const BRING_YOUR_OWN_IP:String = 'bring_your_own_ip';
        public static const BROADCAST_ON_HOME:String = 'broadcast_on_home';
        public static const BROADCAST_ON_PERSONAL:String = 'broadcast_on_personal';
        public static const BROKEN_IMAGE:String = 'broken_image';
        public static const BROWSE:String = 'browse';
        public static const BROWSE_ACTIVITY:String = 'browse_activity';
        public static const BROWSE_GALLERY:String = 'browse_gallery';
        public static const BROWSER_NOT_SUPPORTED:String = 'browser_not_supported';
        public static const BROWSER_UPDATED:String = 'browser_updated';
        public static const BRUNCH_DINING:String = 'brunch_dining';
        public static const BRUSH:String = 'brush';
        public static const BUBBLE:String = 'bubble';
        public static const BUBBLE_CHART:String = 'bubble_chart';
        public static const BUBBLES:String = 'bubbles';
        public static const BUG_REPORT:String = 'bug_report';
        public static const BUILD:String = 'build';
        public static const BUILD_CIRCLE:String = 'build_circle';
        public static const BUNGALOW:String = 'bungalow';
        public static const BURST_MODE:String = 'burst_mode';
        public static const BUS_ALERT:String = 'bus_alert';
        public static const BUSINESS:String = 'business';
        public static const BUSINESS_CENTER:String = 'business_center';
        public static const BUSINESS_CHIP:String = 'business_chip';
        public static const BUSINESS_MESSAGES:String = 'business_messages';
        public static const BUTTONS_ALT:String = 'buttons_alt';
        public static const CABIN:String = 'cabin';
        public static const CABLE:String = 'cable';
        public static const CACHED:String = 'cached';
        public static const CAKE:String = 'cake';
        public static const CAKE_ADD:String = 'cake_add';
        public static const CALCULATE:String = 'calculate';
        public static const CALENDAR_ADD_ON:String = 'calendar_add_on';
        public static const CALENDAR_APPS_SCRIPT:String = 'calendar_apps_script';
        public static const CALENDAR_CLOCK:String = 'calendar_clock';
        public static const CALENDAR_MONTH:String = 'calendar_month';
        public static const CALENDAR_TODAY:String = 'calendar_today';
        public static const CALENDAR_VIEW_DAY:String = 'calendar_view_day';
        public static const CALENDAR_VIEW_MONTH:String = 'calendar_view_month';
        public static const CALENDAR_VIEW_WEEK:String = 'calendar_view_week';
        public static const CALL:String = 'call';
        public static const CALL_END:String = 'call_end';
        public static const CALL_LOG:String = 'call_log';
        public static const CALL_MADE:String = 'call_made';
        public static const CALL_MERGE:String = 'call_merge';
        public static const CALL_MISSED:String = 'call_missed';
        public static const CALL_MISSED_OUTGOING:String = 'call_missed_outgoing';
        public static const CALL_QUALITY:String = 'call_quality';
        public static const CALL_RECEIVED:String = 'call_received';
        public static const CALL_SPLIT:String = 'call_split';
        public static const CALL_TO_ACTION:String = 'call_to_action';
        public static const CAMERA:String = 'camera';
        public static const CAMERA_ALT:String = 'camera_alt';
        public static const CAMERA_ENHANCE:String = 'camera_enhance';
        public static const CAMERA_FRONT:String = 'camera_front';
        public static const CAMERA_INDOOR:String = 'camera_indoor';
        public static const CAMERA_OUTDOOR:String = 'camera_outdoor';
        public static const CAMERA_REAR:String = 'camera_rear';
        public static const CAMERA_ROLL:String = 'camera_roll';
        public static const CAMERA_VIDEO:String = 'camera_video';
        public static const CAMERASWITCH:String = 'cameraswitch';
        public static const CAMPAIGN:String = 'campaign';
        public static const CAMPING:String = 'camping';
        public static const CANCEL:String = 'cancel';
        public static const CANCEL_PRESENTATION:String = 'cancel_presentation';
        public static const CANCEL_SCHEDULE_SEND:String = 'cancel_schedule_send';
        public static const CANDLE:String = 'candle';
        public static const CANDLESTICK_CHART:String = 'candlestick_chart';
        public static const CAPTIVE_PORTAL:String = 'captive_portal';
        public static const CAPTURE:String = 'capture';
        public static const CAR_CRASH:String = 'car_crash';
        public static const CAR_RENTAL:String = 'car_rental';
        public static const CAR_REPAIR:String = 'car_repair';
        public static const CAR_TAG:String = 'car_tag';
        public static const CARD_GIFTCARD:String = 'card_giftcard';
        public static const CARD_MEMBERSHIP:String = 'card_membership';
        public static const CARD_TRAVEL:String = 'card_travel';
        public static const CARDIOLOGY:String = 'cardiology';
        public static const CARDS:String = 'cards';
        public static const CARPENTER:String = 'carpenter';
        public static const CARRY_ON_BAG:String = 'carry_on_bag';
        public static const CARRY_ON_BAG_CHECKED:String = 'carry_on_bag_checked';
        public static const CARRY_ON_BAG_INACTIVE:String = 'carry_on_bag_inactive';
        public static const CARRY_ON_BAG_QUESTION:String = 'carry_on_bag_question';
        public static const CASES:String = 'cases';
        public static const CASINO:String = 'casino';
        public static const CAST:String = 'cast';
        public static const CAST_CONNECTED:String = 'cast_connected';
        public static const CAST_FOR_EDUCATION:String = 'cast_for_education';
        public static const CAST_PAUSE:String = 'cast_pause';
        public static const CAST_WARNING:String = 'cast_warning';
        public static const CASTLE:String = 'castle';
        public static const CATCHING_POKEMON:String = 'catching_pokemon';
        public static const CATEGORY:String = 'category';
        public static const CELEBRATION:String = 'celebration';
        public static const CELL_MERGE:String = 'cell_merge';
        public static const CELL_TOWER:String = 'cell_tower';
        public static const CELL_WIFI:String = 'cell_wifi';
        public static const CENTER_FOCUS_STRONG:String = 'center_focus_strong';
        public static const CENTER_FOCUS_WEAK:String = 'center_focus_weak';
        public static const CHAIR:String = 'chair';
        public static const CHAIR_ALT:String = 'chair_alt';
        public static const CHALET:String = 'chalet';
        public static const CHANGE_CIRCLE:String = 'change_circle';
        public static const CHANGE_HISTORY:String = 'change_history';
        public static const CHARGER:String = 'charger';
        public static const CHARGING_STATION:String = 'charging_station';
        public static const CHART_DATA:String = 'chart_data';
        public static const CHAT:String = 'chat';
        public static const CHAT_ADD_ON:String = 'chat_add_on';
        public static const CHAT_APPS_SCRIPT:String = 'chat_apps_script';
        public static const CHAT_BUBBLE:String = 'chat_bubble';
        public static const CHAT_BUBBLE_OUTLINE:String = 'chat_bubble_outline';
        public static const CHAT_ERROR:String = 'chat_error';
        public static const CHAT_INFO:String = 'chat_info';
        public static const CHAT_PASTE_GO:String = 'chat_paste_go';
        public static const CHECK:String = 'check';
        public static const CHECK_BOX:String = 'check_box';
        public static const CHECK_BOX_OUTLINE_BLANK:String = 'check_box_outline_blank';
        public static const CHECK_CIRCLE:String = 'check_circle';
        public static const CHECK_CIRCLE_OUTLINE:String = 'check_circle_outline';
        public static const CHECK_IN_OUT:String = 'check_in_out';
        public static const CHECK_INDETERMINATE_SMALL:String = 'check_indeterminate_small';
        public static const CHECK_SMALL:String = 'check_small';
        public static const CHECKBOOK:String = 'checkbook';
        public static const CHECKED_BAG:String = 'checked_bag';
        public static const CHECKED_BAG_QUESTION:String = 'checked_bag_question';
        public static const CHECKLIST:String = 'checklist';
        public static const CHECKLIST_RTL:String = 'checklist_rtl';
        public static const CHECKROOM:String = 'checkroom';
        public static const CHEER:String = 'cheer';
        public static const CHESS:String = 'chess';
        public static const CHEVRON_LEFT:String = 'chevron_left';
        public static const CHEVRON_RIGHT:String = 'chevron_right';
        public static const CHILD_CARE:String = 'child_care';
        public static const CHILD_FRIENDLY:String = 'child_friendly';
        public static const CHIP_EXTRACTION:String = 'chip_extraction';
        public static const CHIPS:String = 'chips';
        public static const CHROME_MAXIMIZE:String = 'chrome_maximize';
        public static const CHROME_MINIMIZE:String = 'chrome_minimize';
        public static const CHROME_READER_MODE:String = 'chrome_reader_mode';
        public static const CHROME_RESTORE:String = 'chrome_restore';
        public static const CHROME_TOTE:String = 'chrome_tote';
        public static const CHROMECAST_2:String = 'chromecast_2';
        public static const CHROMECAST_DEVICE:String = 'chromecast_device';
        public static const CHRONIC:String = 'chronic';
        public static const CHURCH:String = 'church';
        public static const CINEMATIC_BLUR:String = 'cinematic_blur';
        public static const CIRCLE:String = 'circle';
        public static const CIRCLE_NOTIFICATIONS:String = 'circle_notifications';
        public static const CIRCLES:String = 'circles';
        public static const CIRCLES_EXT:String = 'circles_ext';
        public static const CLARIFY:String = 'clarify';
        public static const CLASS:String = 'class';
        public static const CLEAN_HANDS:String = 'clean_hands';
        public static const CLEANING:String = 'cleaning';
        public static const CLEANING_BUCKET:String = 'cleaning_bucket';
        public static const CLEANING_SERVICES:String = 'cleaning_services';
        public static const CLEAR:String = 'clear';
        public static const CLEAR_ALL:String = 'clear_all';
        public static const CLEAR_DAY:String = 'clear_day';
        public static const CLEAR_NIGHT:String = 'clear_night';
        public static const CLIMATE_MINI_SPLIT:String = 'climate_mini_split';
        public static const CLINICAL_NOTES:String = 'clinical_notes';
        public static const CLOCK_LOADER_10:String = 'clock_loader_10';
        public static const CLOCK_LOADER_20:String = 'clock_loader_20';
        public static const CLOCK_LOADER_40:String = 'clock_loader_40';
        public static const CLOCK_LOADER_60:String = 'clock_loader_60';
        public static const CLOCK_LOADER_80:String = 'clock_loader_80';
        public static const CLOCK_LOADER_90:String = 'clock_loader_90';
        public static const CLOSE:String = 'close';
        public static const CLOSE_FULLSCREEN:String = 'close_fullscreen';
        public static const CLOSE_SMALL:String = 'close_small';
        public static const CLOSED_CAPTION:String = 'closed_caption';
        public static const CLOSED_CAPTION_DISABLED:String = 'closed_caption_disabled';
        public static const CLOSED_CAPTION_OFF:String = 'closed_caption_off';
        public static const CLOUD:String = 'cloud';
        public static const CLOUD_CIRCLE:String = 'cloud_circle';
        public static const CLOUD_DOMAINS:String = 'cloud_domains';
        public static const CLOUD_DONE:String = 'cloud_done';
        public static const CLOUD_DOWNLOAD:String = 'cloud_download';
        public static const CLOUD_OFF:String = 'cloud_off';
        public static const CLOUD_QUEUE:String = 'cloud_queue';
        public static const CLOUD_SYNC:String = 'cloud_sync';
        public static const CLOUD_UPLOAD:String = 'cloud_upload';
        public static const CLOUDBUILD:String = 'cloudbuild';
        public static const CLOUDY:String = 'cloudy';
        public static const CLOUDY_FILLED:String = 'cloudy_filled';
        public static const CLOUDY_SNOWING:String = 'cloudy_snowing';
        public static const CO_PRESENT:String = 'co_present';
        public static const CO2:String = 'co2';
        public static const CODE:String = 'code';
        public static const CODE_BLOCKS:String = 'code_blocks';
        public static const CODE_OFF:String = 'code_off';
        public static const COFFEE:String = 'coffee';
        public static const COFFEE_MAKER:String = 'coffee_maker';
        public static const COGNITION:String = 'cognition';
        public static const COLLAPSE_ALL:String = 'collapse_all';
        public static const COLLAPSE_CONTENT:String = 'collapse_content';
        public static const COLLECTIONS:String = 'collections';
        public static const COLLECTIONS_BOOKMARK:String = 'collections_bookmark';
        public static const COLOR_LENS:String = 'color_lens';
        public static const COLORIZE:String = 'colorize';
        public static const COLORS:String = 'colors';
        public static const COMEDY_MASK:String = 'comedy_mask';
        public static const COMIC_BUBBLE:String = 'comic_bubble';
        public static const COMMENT:String = 'comment';
        public static const COMMENT_BANK:String = 'comment_bank';
        public static const COMMENTS_DISABLED:String = 'comments_disabled';
        public static const COMMIT:String = 'commit';
        public static const COMMUNICATION:String = 'communication';
        public static const COMMUNITIES:String = 'communities';
        public static const COMMUTE:String = 'commute';
        public static const COMPARE:String = 'compare';
        public static const COMPARE_ARROWS:String = 'compare_arrows';
        public static const COMPASS_CALIBRATION:String = 'compass_calibration';
        public static const COMPONENT_EXCHANGE:String = 'component_exchange';
        public static const COMPOST:String = 'compost';
        public static const COMPRESS:String = 'compress';
        public static const COMPUTER:String = 'computer';
        public static const CONCIERGE:String = 'concierge';
        public static const CONDITIONS:String = 'conditions';
        public static const CONFIRMATION_NUMBER:String = 'confirmation_number';
        public static const CONGENITAL:String = 'congenital';
        public static const CONNECT_WITHOUT_CONTACT:String = 'connect_without_contact';
        public static const CONNECTED_TV:String = 'connected_tv';
        public static const CONNECTING_AIRPORTS:String = 'connecting_airports';
        public static const CONSTRUCTION:String = 'construction';
        public static const CONTACT_EMERGENCY:String = 'contact_emergency';
        public static const CONTACT_MAIL:String = 'contact_mail';
        public static const CONTACT_PAGE:String = 'contact_page';
        public static const CONTACT_PHONE:String = 'contact_phone';
        public static const CONTACT_SUPPORT:String = 'contact_support';
        public static const CONTACTLESS:String = 'contactless';
        public static const CONTACTLESS_OFF:String = 'contactless_off';
        public static const CONTACTS:String = 'contacts';
        public static const CONTACTS_PRODUCT:String = 'contacts_product';
        public static const CONTENT_COPY:String = 'content_copy';
        public static const CONTENT_CUT:String = 'content_cut';
        public static const CONTENT_PASTE:String = 'content_paste';
        public static const CONTENT_PASTE_GO:String = 'content_paste_go';
        public static const CONTENT_PASTE_OFF:String = 'content_paste_off';
        public static const CONTENT_PASTE_SEARCH:String = 'content_paste_search';
        public static const CONTRACT:String = 'contract';
        public static const CONTRACT_DELETE:String = 'contract_delete';
        public static const CONTRACT_EDIT:String = 'contract_edit';
        public static const CONTRAST:String = 'contrast';
        public static const CONTRAST_RTL_OFF:String = 'contrast_rtl_off';
        public static const CONTROL_CAMERA:String = 'control_camera';
        public static const CONTROL_POINT:String = 'control_point';
        public static const CONTROL_POINT_DUPLICATE:String = 'control_point_duplicate';
        public static const CONTROLLER_GEN:String = 'controller_gen';
        public static const CONVERSION_PATH:String = 'conversion_path';
        public static const CONVERSION_PATH_OFF:String = 'conversion_path_off';
        public static const CONVEYOR_BELT:String = 'conveyor_belt';
        public static const COOKIE:String = 'cookie';
        public static const COOKIE_OFF:String = 'cookie_off';
        public static const COOKING:String = 'cooking';
        public static const COOL_TO_DRY:String = 'cool_to_dry';
        public static const COPY_ALL:String = 'copy_all';
        public static const COPYRIGHT:String = 'copyright';
        public static const CORONAVIRUS:String = 'coronavirus';
        public static const CORPORATE_FARE:String = 'corporate_fare';
        public static const COTTAGE:String = 'cottage';
        public static const COUNTER_0:String = 'counter_0';
        public static const COUNTER_1:String = 'counter_1';
        public static const COUNTER_2:String = 'counter_2';
        public static const COUNTER_3:String = 'counter_3';
        public static const COUNTER_4:String = 'counter_4';
        public static const COUNTER_5:String = 'counter_5';
        public static const COUNTER_6:String = 'counter_6';
        public static const COUNTER_7:String = 'counter_7';
        public static const COUNTER_8:String = 'counter_8';
        public static const COUNTER_9:String = 'counter_9';
        public static const COUNTERTOPS:String = 'countertops';
        public static const CREATE:String = 'create';
        public static const CREATE_NEW_FOLDER:String = 'create_new_folder';
        public static const CREDIT_CARD:String = 'credit_card';
        public static const CREDIT_CARD_GEAR:String = 'credit_card_gear';
        public static const CREDIT_CARD_HEART:String = 'credit_card_heart';
        public static const CREDIT_CARD_OFF:String = 'credit_card_off';
        public static const CREDIT_SCORE:String = 'credit_score';
        public static const CRIB:String = 'crib';
        public static const CRISIS_ALERT:String = 'crisis_alert';
        public static const CROP:String = 'crop';
        public static const CROP_16_9:String = 'crop_16_9';
        public static const CROP_3_2:String = 'crop_3_2';
        public static const CROP_5_4:String = 'crop_5_4';
        public static const CROP_7_5:String = 'crop_7_5';
        public static const CROP_9_16:String = 'crop_9_16';
        public static const CROP_DIN:String = 'crop_din';
        public static const CROP_FREE:String = 'crop_free';
        public static const CROP_LANDSCAPE:String = 'crop_landscape';
        public static const CROP_ORIGINAL:String = 'crop_original';
        public static const CROP_PORTRAIT:String = 'crop_portrait';
        public static const CROP_ROTATE:String = 'crop_rotate';
        public static const CROP_SQUARE:String = 'crop_square';
        public static const CROSSWORD:String = 'crossword';
        public static const CROWDSOURCE:String = 'crowdsource';
        public static const CRUELTY_FREE:String = 'cruelty_free';
        public static const CSS:String = 'css';
        public static const CSV:String = 'csv';
        public static const CURRENCY_BITCOIN:String = 'currency_bitcoin';
        public static const CURRENCY_EXCHANGE:String = 'currency_exchange';
        public static const CURRENCY_FRANC:String = 'currency_franc';
        public static const CURRENCY_LIRA:String = 'currency_lira';
        public static const CURRENCY_POUND:String = 'currency_pound';
        public static const CURRENCY_RUBLE:String = 'currency_ruble';
        public static const CURRENCY_RUPEE:String = 'currency_rupee';
        public static const CURRENCY_YEN:String = 'currency_yen';
        public static const CURRENCY_YUAN:String = 'currency_yuan';
        public static const CURTAINS:String = 'curtains';
        public static const CURTAINS_CLOSED:String = 'curtains_closed';
        public static const CUSTOM_TYPOGRAPHY:String = 'custom_typography';
        public static const CUT:String = 'cut';
        public static const CYCLE:String = 'cycle';
        public static const CYCLONE:String = 'cyclone';
        public static const DANGEROUS:String = 'dangerous';
        public static const DARK_MODE:String = 'dark_mode';
        public static const DASHBOARD:String = 'dashboard';
        public static const DASHBOARD_CUSTOMIZE:String = 'dashboard_customize';
        public static const DATA_ALERT:String = 'data_alert';
        public static const DATA_ARRAY:String = 'data_array';
        public static const DATA_CHECK:String = 'data_check';
        public static const DATA_EXPLORATION:String = 'data_exploration';
        public static const DATA_INFO_ALERT:String = 'data_info_alert';
        public static const DATA_LOSS_PREVENTION:String = 'data_loss_prevention';
        public static const DATA_OBJECT:String = 'data_object';
        public static const DATA_SAVER_OFF:String = 'data_saver_off';
        public static const DATA_SAVER_ON:String = 'data_saver_on';
        public static const DATA_TABLE:String = 'data_table';
        public static const DATA_THRESHOLDING:String = 'data_thresholding';
        public static const DATA_USAGE:String = 'data_usage';
        public static const DATABASE:String = 'database';
        public static const DATASET:String = 'dataset';
        public static const DATASET_LINKED:String = 'dataset_linked';
        public static const DATE_RANGE:String = 'date_range';
        public static const DEBLUR:String = 'deblur';
        public static const DECEASED:String = 'deceased';
        public static const DECIMAL_DECREASE:String = 'decimal_decrease';
        public static const DECIMAL_INCREASE:String = 'decimal_increase';
        public static const DECK:String = 'deck';
        public static const DEHAZE:String = 'dehaze';
        public static const DELETE:String = 'delete';
        public static const DELETE_FOREVER:String = 'delete_forever';
        public static const DELETE_HISTORY:String = 'delete_history';
        public static const DELETE_OUTLINE:String = 'delete_outline';
        public static const DELETE_SWEEP:String = 'delete_sweep';
        public static const DELIVERY_DINING:String = 'delivery_dining';
        public static const DEMOGRAPHY:String = 'demography';
        public static const DENSITY_LARGE:String = 'density_large';
        public static const DENSITY_MEDIUM:String = 'density_medium';
        public static const DENSITY_SMALL:String = 'density_small';
        public static const DENTISTRY:String = 'dentistry';
        public static const DEPARTURE_BOARD:String = 'departure_board';
        public static const DEPLOYED_CODE:String = 'deployed_code';
        public static const DEPLOYED_CODE_ACCOUNT:String = 'deployed_code_account';
        public static const DEPLOYED_CODE_ALERT:String = 'deployed_code_alert';
        public static const DEPLOYED_CODE_HISTORY:String = 'deployed_code_history';
        public static const DEPLOYED_CODE_UPDATE:String = 'deployed_code_update';
        public static const DERMATOLOGY:String = 'dermatology';
        public static const DESCRIPTION:String = 'description';
        public static const DESELECT:String = 'deselect';
        public static const DESIGN_SERVICES:String = 'design_services';
        public static const DESK:String = 'desk';
        public static const DESKPHONE:String = 'deskphone';
        public static const DESKTOP_ACCESS_DISABLED:String = 'desktop_access_disabled';
        public static const DESKTOP_MAC:String = 'desktop_mac';
        public static const DESKTOP_WINDOWS:String = 'desktop_windows';
        public static const DESTRUCTION:String = 'destruction';
        public static const DETAILS:String = 'details';
        public static const DETECTION_AND_ZONE:String = 'detection_and_zone';
        public static const DETECTOR:String = 'detector';
        public static const DETECTOR_ALARM:String = 'detector_alarm';
        public static const DETECTOR_BATTERY:String = 'detector_battery';
        public static const DETECTOR_CO:String = 'detector_co';
        public static const DETECTOR_OFFLINE:String = 'detector_offline';
        public static const DETECTOR_SMOKE:String = 'detector_smoke';
        public static const DETECTOR_STATUS:String = 'detector_status';
        public static const DEVELOPER_BOARD:String = 'developer_board';
        public static const DEVELOPER_BOARD_OFF:String = 'developer_board_off';
        public static const DEVELOPER_GUIDE:String = 'developer_guide';
        public static const DEVELOPER_MODE:String = 'developer_mode';
        public static const DEVELOPER_MODE_TV:String = 'developer_mode_tv';
        public static const DEVICE_HUB:String = 'device_hub';
        public static const DEVICE_RESET:String = 'device_reset';
        public static const DEVICE_THERMOSTAT:String = 'device_thermostat';
        public static const DEVICE_UNKNOWN:String = 'device_unknown';
        public static const DEVICES:String = 'devices';
        public static const DEVICES_FOLD:String = 'devices_fold';
        public static const DEVICES_OFF:String = 'devices_off';
        public static const DEVICES_OTHER:String = 'devices_other';
        public static const DEVICES_WEARABLES:String = 'devices_wearables';
        public static const DEW_POINT:String = 'dew_point';
        public static const DIAGNOSIS:String = 'diagnosis';
        public static const DIALER_SIP:String = 'dialer_sip';
        public static const DIALOGS:String = 'dialogs';
        public static const DIALPAD:String = 'dialpad';
        public static const DIAMOND:String = 'diamond';
        public static const DICTIONARY:String = 'dictionary';
        public static const DIFFERENCE:String = 'difference';
        public static const DIGITAL_OUT_OF_HOME:String = 'digital_out_of_home';
        public static const DIGITAL_WELLBEING:String = 'digital_wellbeing';
        public static const DINING:String = 'dining';
        public static const DINNER_DINING:String = 'dinner_dining';
        public static const DIRECTIONS:String = 'directions';
        public static const DIRECTIONS_ALT:String = 'directions_alt';
        public static const DIRECTIONS_ALT_OFF:String = 'directions_alt_off';
        public static const DIRECTIONS_BIKE:String = 'directions_bike';
        public static const DIRECTIONS_BOAT:String = 'directions_boat';
        public static const DIRECTIONS_BOAT_FILLED:String = 'directions_boat_filled';
        public static const DIRECTIONS_BUS:String = 'directions_bus';
        public static const DIRECTIONS_BUS_FILLED:String = 'directions_bus_filled';
        public static const DIRECTIONS_CAR:String = 'directions_car';
        public static const DIRECTIONS_CAR_FILLED:String = 'directions_car_filled';
        public static const DIRECTIONS_OFF:String = 'directions_off';
        public static const DIRECTIONS_RAILWAY:String = 'directions_railway';
        public static const DIRECTIONS_RAILWAY_FILLED:String = 'directions_railway_filled';
        public static const DIRECTIONS_RUN:String = 'directions_run';
        public static const DIRECTIONS_SUBWAY:String = 'directions_subway';
        public static const DIRECTIONS_SUBWAY_FILLED:String = 'directions_subway_filled';
        public static const DIRECTIONS_TRANSIT:String = 'directions_transit';
        public static const DIRECTIONS_TRANSIT_FILLED:String = 'directions_transit_filled';
        public static const DIRECTIONS_WALK:String = 'directions_walk';
        public static const DIRECTORY_SYNC:String = 'directory_sync';
        public static const DIRTY_LENS:String = 'dirty_lens';
        public static const DISABLED_BY_DEFAULT:String = 'disabled_by_default';
        public static const DISABLED_VISIBLE:String = 'disabled_visible';
        public static const DISC_FULL:String = 'disc_full';
        public static const DISCOUNT:String = 'discount';
        public static const DISCOVER_TUNE:String = 'discover_tune';
        public static const DISHWASHER:String = 'dishwasher';
        public static const DISHWASHER_GEN:String = 'dishwasher_gen';
        public static const DISPLAY_EXTERNAL_INPUT:String = 'display_external_input';
        public static const DISPLAY_SETTINGS:String = 'display_settings';
        public static const DISTANCE:String = 'distance';
        public static const DIVERSITY_1:String = 'diversity_1';
        public static const DIVERSITY_2:String = 'diversity_2';
        public static const DIVERSITY_3:String = 'diversity_3';
        public static const DIVERSITY_4:String = 'diversity_4';
        public static const DNS:String = 'dns';
        public static const DO_DISTURB:String = 'do_disturb';
        public static const DO_DISTURB_ALT:String = 'do_disturb_alt';
        public static const DO_DISTURB_OFF:String = 'do_disturb_off';
        public static const DO_DISTURB_ON:String = 'do_disturb_on';
        public static const DO_NOT_DISTURB:String = 'do_not_disturb';
        public static const DO_NOT_DISTURB_ALT:String = 'do_not_disturb_alt';
        public static const DO_NOT_DISTURB_OFF:String = 'do_not_disturb_off';
        public static const DO_NOT_DISTURB_ON:String = 'do_not_disturb_on';
        public static const DO_NOT_DISTURB_ON_TOTAL_SILENCE:String = 'do_not_disturb_on_total_silence';
        public static const DO_NOT_STEP:String = 'do_not_step';
        public static const DO_NOT_TOUCH:String = 'do_not_touch';
        public static const DOCK:String = 'dock';
        public static const DOCK_TO_BOTTOM:String = 'dock_to_bottom';
        public static const DOCK_TO_LEFT:String = 'dock_to_left';
        public static const DOCK_TO_RIGHT:String = 'dock_to_right';
        public static const DOCS_ADD_ON:String = 'docs_add_on';
        public static const DOCS_APPS_SCRIPT:String = 'docs_apps_script';
        public static const DOCUMENT_SCANNER:String = 'document_scanner';
        public static const DOMAIN:String = 'domain';
        public static const DOMAIN_ADD:String = 'domain_add';
        public static const DOMAIN_DISABLED:String = 'domain_disabled';
        public static const DOMAIN_VERIFICATION:String = 'domain_verification';
        public static const DOMAIN_VERIFICATION_OFF:String = 'domain_verification_off';
        public static const DOMINO_MASK:String = 'domino_mask';
        public static const DONE:String = 'done';
        public static const DONE_ALL:String = 'done_all';
        public static const DONE_OUTLINE:String = 'done_outline';
        public static const DONUT_LARGE:String = 'donut_large';
        public static const DONUT_SMALL:String = 'donut_small';
        public static const DOOR_BACK:String = 'door_back';
        public static const DOOR_FRONT:String = 'door_front';
        public static const DOOR_OPEN:String = 'door_open';
        public static const DOOR_SENSOR:String = 'door_sensor';
        public static const DOOR_SLIDING:String = 'door_sliding';
        public static const DOORBELL:String = 'doorbell';
        public static const DOORBELL_3P:String = 'doorbell_3p';
        public static const DOORBELL_CHIME:String = 'doorbell_chime';
        public static const DOUBLE_ARROW:String = 'double_arrow';
        public static const DOWNHILL_SKIING:String = 'downhill_skiing';
        public static const DOWNLOAD:String = 'download';
        public static const DOWNLOAD_2:String = 'download_2';
        public static const DOWNLOAD_DONE:String = 'download_done';
        public static const DOWNLOAD_FOR_OFFLINE:String = 'download_for_offline';
        public static const DOWNLOADING:String = 'downloading';
        public static const DRAFT:String = 'draft';
        public static const DRAFT_ORDERS:String = 'draft_orders';
        public static const DRAFTS:String = 'drafts';
        public static const DRAG_CLICK:String = 'drag_click';
        public static const DRAG_HANDLE:String = 'drag_handle';
        public static const DRAG_INDICATOR:String = 'drag_indicator';
        public static const DRAG_PAN:String = 'drag_pan';
        public static const DRAW:String = 'draw';
        public static const DRAW_ABSTRACT:String = 'draw_abstract';
        public static const DRAW_COLLAGE:String = 'draw_collage';
        public static const DRESSER:String = 'dresser';
        public static const DRIVE_ETA:String = 'drive_eta';
        public static const DRIVE_FILE_MOVE:String = 'drive_file_move';
        public static const DRIVE_FILE_MOVE_OUTLINE:String = 'drive_file_move_outline';
        public static const DRIVE_FILE_MOVE_RTL:String = 'drive_file_move_rtl';
        public static const DRIVE_FILE_RENAME_OUTLINE:String = 'drive_file_rename_outline';
        public static const DRIVE_FOLDER_UPLOAD:String = 'drive_folder_upload';
        public static const DRIVE_SHORTCUT:String = 'drive_shortcut';
        public static const DROPDOWN:String = 'dropdown';
        public static const DRY:String = 'dry';
        public static const DRY_CLEANING:String = 'dry_cleaning';
        public static const DUAL_SCREEN:String = 'dual_screen';
        public static const DUO:String = 'duo';
        public static const DVR:String = 'dvr';
        public static const DYNAMIC_FEED:String = 'dynamic_feed';
        public static const DYNAMIC_FORM:String = 'dynamic_form';
        public static const E_MOBILEDATA:String = 'e_mobiledata';
        public static const E_MOBILEDATA_BADGE:String = 'e_mobiledata_badge';
        public static const E911_AVATAR:String = 'e911_avatar';
        public static const E911_EMERGENCY:String = 'e911_emergency';
        public static const EARBUDS:String = 'earbuds';
        public static const EARBUDS_BATTERY:String = 'earbuds_battery';
        public static const EARLY_ON:String = 'early_on';
        public static const EARTHQUAKE:String = 'earthquake';
        public static const EAST:String = 'east';
        public static const ECG:String = 'ecg';
        public static const ECG_HEART:String = 'ecg_heart';
        public static const ECO:String = 'eco';
        public static const EDA:String = 'eda';
        public static const EDGESENSOR_HIGH:String = 'edgesensor_high';
        public static const EDGESENSOR_LOW:String = 'edgesensor_low';
        public static const EDIT:String = 'edit';
        public static const EDIT_ATTRIBUTES:String = 'edit_attributes';
        public static const EDIT_CALENDAR:String = 'edit_calendar';
        public static const EDIT_DOCUMENT:String = 'edit_document';
        public static const EDIT_LOCATION:String = 'edit_location';
        public static const EDIT_LOCATION_ALT:String = 'edit_location_alt';
        public static const EDIT_NOTE:String = 'edit_note';
        public static const EDIT_NOTIFICATIONS:String = 'edit_notifications';
        public static const EDIT_OFF:String = 'edit_off';
        public static const EDIT_ROAD:String = 'edit_road';
        public static const EDIT_SQUARE:String = 'edit_square';
        public static const EDITOR_CHOICE:String = 'editor_choice';
        public static const EGG:String = 'egg';
        public static const EGG_ALT:String = 'egg_alt';
        public static const EJECT:String = 'eject';
        public static const ELDERLY:String = 'elderly';
        public static const ELDERLY_WOMAN:String = 'elderly_woman';
        public static const ELECTRIC_BIKE:String = 'electric_bike';
        public static const ELECTRIC_BOLT:String = 'electric_bolt';
        public static const ELECTRIC_CAR:String = 'electric_car';
        public static const ELECTRIC_METER:String = 'electric_meter';
        public static const ELECTRIC_MOPED:String = 'electric_moped';
        public static const ELECTRIC_RICKSHAW:String = 'electric_rickshaw';
        public static const ELECTRIC_SCOOTER:String = 'electric_scooter';
        public static const ELECTRICAL_SERVICES:String = 'electrical_services';
        public static const ELEVATION:String = 'elevation';
        public static const ELEVATOR:String = 'elevator';
        public static const EMAIL:String = 'email';
        public static const EMERGENCY:String = 'emergency';
        public static const EMERGENCY_HEAT:String = 'emergency_heat';
        public static const EMERGENCY_HEAT_2:String = 'emergency_heat_2';
        public static const EMERGENCY_HOME:String = 'emergency_home';
        public static const EMERGENCY_RECORDING:String = 'emergency_recording';
        public static const EMERGENCY_SHARE:String = 'emergency_share';
        public static const EMERGENCY_SHARE_OFF:String = 'emergency_share_off';
        public static const EMOJI_EMOTIONS:String = 'emoji_emotions';
        public static const EMOJI_EVENTS:String = 'emoji_events';
        public static const EMOJI_FLAGS:String = 'emoji_flags';
        public static const EMOJI_FOOD_BEVERAGE:String = 'emoji_food_beverage';
        public static const EMOJI_NATURE:String = 'emoji_nature';
        public static const EMOJI_OBJECTS:String = 'emoji_objects';
        public static const EMOJI_PEOPLE:String = 'emoji_people';
        public static const EMOJI_SYMBOLS:String = 'emoji_symbols';
        public static const EMOJI_TRANSPORTATION:String = 'emoji_transportation';
        public static const EMOTICON:String = 'emoticon';
        public static const EMPTY_DASHBOARD:String = 'empty_dashboard';
        public static const ENABLE:String = 'enable';
        public static const ENCRYPTED:String = 'encrypted';
        public static const ENDOCRINOLOGY:String = 'endocrinology';
        public static const ENERGY:String = 'energy';
        public static const ENERGY_PROGRAM_SAVING:String = 'energy_program_saving';
        public static const ENERGY_PROGRAM_TIME_USED:String = 'energy_program_time_used';
        public static const ENERGY_SAVINGS_LEAF:String = 'energy_savings_leaf';
        public static const ENGINEERING:String = 'engineering';
        public static const ENHANCED_ENCRYPTION:String = 'enhanced_encryption';
        public static const ENT:String = 'ent';
        public static const ENTERPRISE:String = 'enterprise';
        public static const ENTERPRISE_OFF:String = 'enterprise_off';
        public static const EQUAL:String = 'equal';
        public static const EQUALIZER:String = 'equalizer';
        public static const ERROR:String = 'error';
        public static const ERROR_CIRCLE_ROUNDED:String = 'error_circle_rounded';
        public static const ERROR_MED:String = 'error_med';
        public static const ERROR_OUTLINE:String = 'error_outline';
        public static const ESCALATOR:String = 'escalator';
        public static const ESCALATOR_WARNING:String = 'escalator_warning';
        public static const EURO:String = 'euro';
        public static const EURO_SYMBOL:String = 'euro_symbol';
        public static const EV_CHARGER:String = 'ev_charger';
        public static const EV_MOBILEDATA_BADGE:String = 'ev_mobiledata_badge';
        public static const EV_SHADOW:String = 'ev_shadow';
        public static const EV_SHADOW_ADD:String = 'ev_shadow_add';
        public static const EV_SHADOW_MINUS:String = 'ev_shadow_minus';
        public static const EV_STATION:String = 'ev_station';
        public static const EVENT:String = 'event';
        public static const EVENT_AVAILABLE:String = 'event_available';
        public static const EVENT_BUSY:String = 'event_busy';
        public static const EVENT_LIST:String = 'event_list';
        public static const EVENT_NOTE:String = 'event_note';
        public static const EVENT_REPEAT:String = 'event_repeat';
        public static const EVENT_SEAT:String = 'event_seat';
        public static const EVENT_UPCOMING:String = 'event_upcoming';
        public static const EXCLAMATION:String = 'exclamation';
        public static const EXERCISE:String = 'exercise';
        public static const EXIT_TO_APP:String = 'exit_to_app';
        public static const EXPAND:String = 'expand';
        public static const EXPAND_ALL:String = 'expand_all';
        public static const EXPAND_CIRCLE_DOWN:String = 'expand_circle_down';
        public static const EXPAND_CIRCLE_RIGHT:String = 'expand_circle_right';
        public static const EXPAND_CIRCLE_UP:String = 'expand_circle_up';
        public static const EXPAND_CONTENT:String = 'expand_content';
        public static const EXPAND_LESS:String = 'expand_less';
        public static const EXPAND_MORE:String = 'expand_more';
        public static const EXPERIMENT:String = 'experiment';
        public static const EXPLICIT:String = 'explicit';
        public static const EXPLORE:String = 'explore';
        public static const EXPLORE_NEARBY:String = 'explore_nearby';
        public static const EXPLORE_OFF:String = 'explore_off';
        public static const EXPLOSION:String = 'explosion';
        public static const EXPORT_NOTES:String = 'export_notes';
        public static const EXPOSURE:String = 'exposure';
        public static const EXPOSURE_NEG_1:String = 'exposure_neg_1';
        public static const EXPOSURE_NEG_2:String = 'exposure_neg_2';
        public static const EXPOSURE_PLUS_1:String = 'exposure_plus_1';
        public static const EXPOSURE_PLUS_2:String = 'exposure_plus_2';
        public static const EXPOSURE_ZERO:String = 'exposure_zero';
        public static const EXTENSION:String = 'extension';
        public static const EXTENSION_OFF:String = 'extension_off';
        public static const EYEGLASSES:String = 'eyeglasses';
        public static const FACE:String = 'face';
        public static const FACE_2:String = 'face_2';
        public static const FACE_3:String = 'face_3';
        public static const FACE_4:String = 'face_4';
        public static const FACE_5:String = 'face_5';
        public static const FACE_6:String = 'face_6';
        public static const FACE_RETOUCHING_NATURAL:String = 'face_retouching_natural';
        public static const FACE_RETOUCHING_OFF:String = 'face_retouching_off';
        public static const FACE_UNLOCK:String = 'face_unlock';
        public static const FACEBOOK:String = 'facebook';
        public static const FACT_CHECK:String = 'fact_check';
        public static const FACTORY:String = 'factory';
        public static const FALLING:String = 'falling';
        public static const FAMILIAR_FACE_AND_ZONE:String = 'familiar_face_and_zone';
        public static const FAMILY_HISTORY:String = 'family_history';
        public static const FAMILY_HOME:String = 'family_home';
        public static const FAMILY_LINK:String = 'family_link';
        public static const FAMILY_RESTROOM:String = 'family_restroom';
        public static const FAMILY_STAR:String = 'family_star';
        public static const FARSIGHT_DIGITAL:String = 'farsight_digital';
        public static const FAST_FORWARD:String = 'fast_forward';
        public static const FAST_REWIND:String = 'fast_rewind';
        public static const FASTFOOD:String = 'fastfood';
        public static const FAUCET:String = 'faucet';
        public static const FAVORITE:String = 'favorite';
        public static const FAVORITE_BORDER:String = 'favorite_border';
        public static const FAX:String = 'fax';
        public static const FEATURE_SEARCH:String = 'feature_search';
        public static const FEATURED_PLAY_LIST:String = 'featured_play_list';
        public static const FEATURED_SEASONAL_AND_GIFTS:String = 'featured_seasonal_and_gifts';
        public static const FEATURED_VIDEO:String = 'featured_video';
        public static const FEED:String = 'feed';
        public static const FEEDBACK:String = 'feedback';
        public static const FEMALE:String = 'female';
        public static const FEMUR:String = 'femur';
        public static const FEMUR_ALT:String = 'femur_alt';
        public static const FENCE:String = 'fence';
        public static const FERTILE:String = 'fertile';
        public static const FESTIVAL:String = 'festival';
        public static const FIBER_DVR:String = 'fiber_dvr';
        public static const FIBER_MANUAL_RECORD:String = 'fiber_manual_record';
        public static const FIBER_NEW:String = 'fiber_new';
        public static const FIBER_PIN:String = 'fiber_pin';
        public static const FIBER_SMART_RECORD:String = 'fiber_smart_record';
        public static const FILE_COPY:String = 'file_copy';
        public static const FILE_COPY_OFF:String = 'file_copy_off';
        public static const FILE_DOWNLOAD:String = 'file_download';
        public static const FILE_DOWNLOAD_DONE:String = 'file_download_done';
        public static const FILE_DOWNLOAD_OFF:String = 'file_download_off';
        public static const FILE_MAP:String = 'file_map';
        public static const FILE_OPEN:String = 'file_open';
        public static const FILE_PRESENT:String = 'file_present';
        public static const FILE_SAVE:String = 'file_save';
        public static const FILE_SAVE_OFF:String = 'file_save_off';
        public static const FILE_UPLOAD:String = 'file_upload';
        public static const FILE_UPLOAD_OFF:String = 'file_upload_off';
        public static const FILTER:String = 'filter';
        public static const FILTER_1:String = 'filter_1';
        public static const FILTER_2:String = 'filter_2';
        public static const FILTER_3:String = 'filter_3';
        public static const FILTER_4:String = 'filter_4';
        public static const FILTER_5:String = 'filter_5';
        public static const FILTER_6:String = 'filter_6';
        public static const FILTER_7:String = 'filter_7';
        public static const FILTER_8:String = 'filter_8';
        public static const FILTER_9:String = 'filter_9';
        public static const FILTER_9_PLUS:String = 'filter_9_plus';
        public static const FILTER_ALT:String = 'filter_alt';
        public static const FILTER_ALT_OFF:String = 'filter_alt_off';
        public static const FILTER_B_AND_W:String = 'filter_b_and_w';
        public static const FILTER_CENTER_FOCUS:String = 'filter_center_focus';
        public static const FILTER_DRAMA:String = 'filter_drama';
        public static const FILTER_FRAMES:String = 'filter_frames';
        public static const FILTER_HDR:String = 'filter_hdr';
        public static const FILTER_LIST:String = 'filter_list';
        public static const FILTER_LIST_ALT:String = 'filter_list_alt';
        public static const FILTER_LIST_OFF:String = 'filter_list_off';
        public static const FILTER_NONE:String = 'filter_none';
        public static const FILTER_RETROLUX:String = 'filter_retrolux';
        public static const FILTER_TILT_SHIFT:String = 'filter_tilt_shift';
        public static const FILTER_VINTAGE:String = 'filter_vintage';
        public static const FINANCE:String = 'finance';
        public static const FINANCE_CHIP:String = 'finance_chip';
        public static const FINANCE_MODE:String = 'finance_mode';
        public static const FIND_IN_PAGE:String = 'find_in_page';
        public static const FIND_REPLACE:String = 'find_replace';
        public static const FINGERPRINT:String = 'fingerprint';
        public static const FIRE_EXTINGUISHER:String = 'fire_extinguisher';
        public static const FIRE_HYDRANT:String = 'fire_hydrant';
        public static const FIRE_HYDRANT_ALT:String = 'fire_hydrant_alt';
        public static const FIRE_TRUCK:String = 'fire_truck';
        public static const FIREPLACE:String = 'fireplace';
        public static const FIRST_PAGE:String = 'first_page';
        public static const FISHFOOD:String = 'fishfood';
        public static const FIT_PAGE:String = 'fit_page';
        public static const FIT_SCREEN:String = 'fit_screen';
        public static const FIT_WIDTH:String = 'fit_width';
        public static const FITBIT:String = 'fitbit';
        public static const FITBIT_ARROW_DOWNWARD:String = 'fitbit_arrow_downward';
        public static const FITBIT_ARROW_UPWARD:String = 'fitbit_arrow_upward';
        public static const FITBIT_CHECK_SMALL:String = 'fitbit_check_small';
        public static const FITNESS_CENTER:String = 'fitness_center';
        public static const FLAG:String = 'flag';
        public static const FLAG_CIRCLE:String = 'flag_circle';
        public static const FLAKY:String = 'flaky';
        public static const FLARE:String = 'flare';
        public static const FLASH_AUTO:String = 'flash_auto';
        public static const FLASH_OFF:String = 'flash_off';
        public static const FLASH_ON:String = 'flash_on';
        public static const FLASHLIGHT_OFF:String = 'flashlight_off';
        public static const FLASHLIGHT_ON:String = 'flashlight_on';
        public static const FLATWARE:String = 'flatware';
        public static const FLEX_DIRECTION:String = 'flex_direction';
        public static const FLEX_NO_WRAP:String = 'flex_no_wrap';
        public static const FLEX_WRAP:String = 'flex_wrap';
        public static const FLIGHT:String = 'flight';
        public static const FLIGHT_CLASS:String = 'flight_class';
        public static const FLIGHT_LAND:String = 'flight_land';
        public static const FLIGHT_TAKEOFF:String = 'flight_takeoff';
        public static const FLIGHTS_AND_HOTELS:String = 'flights_and_hotels';
        public static const FLIGHTSMODE:String = 'flightsmode';
        public static const FLIP:String = 'flip';
        public static const FLIP_CAMERA_ANDROID:String = 'flip_camera_android';
        public static const FLIP_CAMERA_IOS:String = 'flip_camera_ios';
        public static const FLIP_TO_BACK:String = 'flip_to_back';
        public static const FLIP_TO_FRONT:String = 'flip_to_front';
        public static const FLOAT_LANDSCAPE:String = 'float_landscape';
        public static const FLOAT_PORTRAIT:String = 'float_portrait';
        public static const FLOOD:String = 'flood';
        public static const FLOOR:String = 'floor';
        public static const FLOOR_LAMP:String = 'floor_lamp';
        public static const FLOURESCENT:String = 'flourescent';
        public static const FLOWSHEET:String = 'flowsheet';
        public static const FLUID:String = 'fluid';
        public static const FLUID_BALANCE:String = 'fluid_balance';
        public static const FLUID_MED:String = 'fluid_med';
        public static const FLUORESCENT:String = 'fluorescent';
        public static const FLUTTER:String = 'flutter';
        public static const FLUTTER_DASH:String = 'flutter_dash';
        public static const FMD_BAD:String = 'fmd_bad';
        public static const FMD_GOOD:String = 'fmd_good';
        public static const FOGGY:String = 'foggy';
        public static const FOLDED_HANDS:String = 'folded_hands';
        public static const FOLDER:String = 'folder';
        public static const FOLDER_COPY:String = 'folder_copy';
        public static const FOLDER_DATA:String = 'folder_data';
        public static const FOLDER_DELETE:String = 'folder_delete';
        public static const FOLDER_LIMITED:String = 'folder_limited';
        public static const FOLDER_MANAGED:String = 'folder_managed';
        public static const FOLDER_OFF:String = 'folder_off';
        public static const FOLDER_OPEN:String = 'folder_open';
        public static const FOLDER_SHARED:String = 'folder_shared';
        public static const FOLDER_SPECIAL:String = 'folder_special';
        public static const FOLDER_SUPERVISED:String = 'folder_supervised';
        public static const FOLDER_ZIP:String = 'folder_zip';
        public static const FOLLOW_THE_SIGNS:String = 'follow_the_signs';
        public static const FONT_DOWNLOAD:String = 'font_download';
        public static const FONT_DOWNLOAD_OFF:String = 'font_download_off';
        public static const FOOD_BANK:String = 'food_bank';
        public static const FOOT_BONES:String = 'foot_bones';
        public static const FOOTPRINT:String = 'footprint';
        public static const FOR_YOU:String = 'for_you';
        public static const FOREST:String = 'forest';
        public static const FORK_LEFT:String = 'fork_left';
        public static const FORK_RIGHT:String = 'fork_right';
        public static const FORKLIFT:String = 'forklift';
        public static const FORMAT_ALIGN_CENTER:String = 'format_align_center';
        public static const FORMAT_ALIGN_JUSTIFY:String = 'format_align_justify';
        public static const FORMAT_ALIGN_LEFT:String = 'format_align_left';
        public static const FORMAT_ALIGN_RIGHT:String = 'format_align_right';
        public static const FORMAT_BOLD:String = 'format_bold';
        public static const FORMAT_CLEAR:String = 'format_clear';
        public static const FORMAT_COLOR_FILL:String = 'format_color_fill';
        public static const FORMAT_COLOR_RESET:String = 'format_color_reset';
        public static const FORMAT_COLOR_TEXT:String = 'format_color_text';
        public static const FORMAT_H1:String = 'format_h1';
        public static const FORMAT_H2:String = 'format_h2';
        public static const FORMAT_H3:String = 'format_h3';
        public static const FORMAT_H4:String = 'format_h4';
        public static const FORMAT_H5:String = 'format_h5';
        public static const FORMAT_H6:String = 'format_h6';
        public static const FORMAT_IMAGE_LEFT:String = 'format_image_left';
        public static const FORMAT_IMAGE_RIGHT:String = 'format_image_right';
        public static const FORMAT_INDENT_DECREASE:String = 'format_indent_decrease';
        public static const FORMAT_INDENT_INCREASE:String = 'format_indent_increase';
        public static const FORMAT_INK_HIGHLIGHTER:String = 'format_ink_highlighter';
        public static const FORMAT_ITALIC:String = 'format_italic';
        public static const FORMAT_LETTER_SPACING:String = 'format_letter_spacing';
        public static const FORMAT_LETTER_SPACING_2:String = 'format_letter_spacing_2';
        public static const FORMAT_LETTER_SPACING_STANDARD:String = 'format_letter_spacing_standard';
        public static const FORMAT_LETTER_SPACING_WIDE:String = 'format_letter_spacing_wide';
        public static const FORMAT_LETTER_SPACING_WIDER:String = 'format_letter_spacing_wider';
        public static const FORMAT_LINE_SPACING:String = 'format_line_spacing';
        public static const FORMAT_LIST_BULLETED:String = 'format_list_bulleted';
        public static const FORMAT_LIST_BULLETED_ADD:String = 'format_list_bulleted_add';
        public static const FORMAT_LIST_NUMBERED:String = 'format_list_numbered';
        public static const FORMAT_LIST_NUMBERED_RTL:String = 'format_list_numbered_rtl';
        public static const FORMAT_OVERLINE:String = 'format_overline';
        public static const FORMAT_PAINT:String = 'format_paint';
        public static const FORMAT_PARAGRAPH:String = 'format_paragraph';
        public static const FORMAT_QUOTE:String = 'format_quote';
        public static const FORMAT_SHAPES:String = 'format_shapes';
        public static const FORMAT_SIZE:String = 'format_size';
        public static const FORMAT_STRIKETHROUGH:String = 'format_strikethrough';
        public static const FORMAT_TEXT_CLIP:String = 'format_text_clip';
        public static const FORMAT_TEXT_OVERFLOW:String = 'format_text_overflow';
        public static const FORMAT_TEXT_WRAP:String = 'format_text_wrap';
        public static const FORMAT_TEXTDIRECTION_L_TO_R:String = 'format_textdirection_l_to_r';
        public static const FORMAT_TEXTDIRECTION_R_TO_L:String = 'format_textdirection_r_to_l';
        public static const FORMAT_UNDERLINED:String = 'format_underlined';
        public static const FORMAT_UNDERLINED_SQUIGGLE:String = 'format_underlined_squiggle';
        public static const FORMS_ADD_ON:String = 'forms_add_on';
        public static const FORMS_APPS_SCRIPT:String = 'forms_apps_script';
        public static const FORT:String = 'fort';
        public static const FORUM:String = 'forum';
        public static const FORWARD:String = 'forward';
        public static const FORWARD_10:String = 'forward_10';
        public static const FORWARD_30:String = 'forward_30';
        public static const FORWARD_5:String = 'forward_5';
        public static const FORWARD_CIRCLE:String = 'forward_circle';
        public static const FORWARD_MEDIA:String = 'forward_media';
        public static const FORWARD_TO_INBOX:String = 'forward_to_inbox';
        public static const FOUNDATION:String = 'foundation';
        public static const FRAME_INSPECT:String = 'frame_inspect';
        public static const FRAME_PERSON:String = 'frame_person';
        public static const FRAME_PERSON_OFF:String = 'frame_person_off';
        public static const FRAME_RELOAD:String = 'frame_reload';
        public static const FRAME_SOURCE:String = 'frame_source';
        public static const FREE_BREAKFAST:String = 'free_breakfast';
        public static const FREE_CANCELLATION:String = 'free_cancellation';
        public static const FRONT_HAND:String = 'front_hand';
        public static const FRONT_LOADER:String = 'front_loader';
        public static const FULL_COVERAGE:String = 'full_coverage';
        public static const FULL_HD:String = 'full_hd';
        public static const FULL_STACKED_BAR_CHART:String = 'full_stacked_bar_chart';
        public static const FULLSCREEN:String = 'fullscreen';
        public static const FULLSCREEN_EXIT:String = 'fullscreen_exit';
        public static const FUNCTION:String = 'function';
        public static const FUNCTIONS:String = 'functions';
        public static const G_MOBILEDATA:String = 'g_mobiledata';
        public static const G_MOBILEDATA_BADGE:String = 'g_mobiledata_badge';
        public static const G_TRANSLATE:String = 'g_translate';
        public static const GALLERY_THUMBNAIL:String = 'gallery_thumbnail';
        public static const GAMEPAD:String = 'gamepad';
        public static const GAMES:String = 'games';
        public static const GARAGE:String = 'garage';
        public static const GARAGE_DOOR:String = 'garage_door';
        public static const GARAGE_HOME:String = 'garage_home';
        public static const GARDEN_CART:String = 'garden_cart';
        public static const GAS_METER:String = 'gas_meter';
        public static const GASTROENTEROLOGY:String = 'gastroenterology';
        public static const GATE:String = 'gate';
        public static const GAVEL:String = 'gavel';
        public static const GBADGE:String = 'gbadge';
        public static const GENERAL_DEVICE:String = 'general_device';
        public static const GENERATING_TOKENS:String = 'generating_tokens';
        public static const GENETICS:String = 'genetics';
        public static const GENRES:String = 'genres';
        public static const GESTURE:String = 'gesture';
        public static const GESTURE_SELECT:String = 'gesture_select';
        public static const GET_APP:String = 'get_app';
        public static const GIF:String = 'gif';
        public static const GIF_BOX:String = 'gif_box';
        public static const GIRL:String = 'girl';
        public static const GITE:String = 'gite';
        public static const GLASS_CUP:String = 'glass_cup';
        public static const GLEAF:String = 'gleaf';
        public static const GLOBE:String = 'globe';
        public static const GLOBE_ASIA:String = 'globe_asia';
        public static const GLOBE_UK:String = 'globe_uk';
        public static const GLUCOSE:String = 'glucose';
        public static const GLYPHS:String = 'glyphs';
        public static const GMAIL_ADD_ON:String = 'gmail_add_on';
        public static const GMAIL_APPS_SCRIPT:String = 'gmail_apps_script';
        public static const GMAIL_ROOMS:String = 'gmail_rooms';
        public static const GO_TO_LINE:String = 'go_to_line';
        public static const GOLF_COURSE:String = 'golf_course';
        public static const GOOGLE_GUARANTEE:String = 'google_guarantee';
        public static const GOOGLE_HOME_DEVICES:String = 'google_home_devices';
        public static const GOOGLE_PLUS_RESHARE:String = 'google_plus_reshare';
        public static const GOOGLE_TRAVEL:String = 'google_travel';
        public static const GOOGLE_TRAVEL_OUTLINE:String = 'google_travel_outline';
        public static const GOOGLE_TV_REMOTE:String = 'google_tv_remote';
        public static const GOOGLE_WIFI:String = 'google_wifi';
        public static const GOOGLER_TRAVEL:String = 'googler_travel';
        public static const GPP_BAD:String = 'gpp_bad';
        public static const GPP_GOOD:String = 'gpp_good';
        public static const GPP_MAYBE:String = 'gpp_maybe';
        public static const GPS_FIXED:String = 'gps_fixed';
        public static const GPS_NOT_FIXED:String = 'gps_not_fixed';
        public static const GPS_OFF:String = 'gps_off';
        public static const GRADE:String = 'grade';
        public static const GRADIENT:String = 'gradient';
        public static const GRADING:String = 'grading';
        public static const GRAIN:String = 'grain';
        public static const GRAPHIC_EQ:String = 'graphic_eq';
        public static const GRASS:String = 'grass';
        public static const GRID_3X3:String = 'grid_3x3';
        public static const GRID_3X3_OFF:String = 'grid_3x3_off';
        public static const GRID_4X4:String = 'grid_4x4';
        public static const GRID_GOLDENRATIO:String = 'grid_goldenratio';
        public static const GRID_GUIDES:String = 'grid_guides';
        public static const GRID_OFF:String = 'grid_off';
        public static const GRID_ON:String = 'grid_on';
        public static const GRID_VIEW:String = 'grid_view';
        public static const GROCERY:String = 'grocery';
        public static const GROUP:String = 'group';
        public static const GROUP_ADD:String = 'group_add';
        public static const GROUP_AUTO:String = 'group_auto';
        public static const GROUP_OFF:String = 'group_off';
        public static const GROUP_REMOVE:String = 'group_remove';
        public static const GROUP_WORK:String = 'group_work';
        public static const GROUPED_BAR_CHART:String = 'grouped_bar_chart';
        public static const GROUPS:String = 'groups';
        public static const GROUPS_2:String = 'groups_2';
        public static const GROUPS_3:String = 'groups_3';
        public static const GYNECOLOGY:String = 'gynecology';
        public static const H_MOBILEDATA:String = 'h_mobiledata';
        public static const H_MOBILEDATA_BADGE:String = 'h_mobiledata_badge';
        public static const H_PLUS_MOBILEDATA:String = 'h_plus_mobiledata';
        public static const H_PLUS_MOBILEDATA_BADGE:String = 'h_plus_mobiledata_badge';
        public static const HAIL:String = 'hail';
        public static const HALLWAY:String = 'hallway';
        public static const HAND_BONES:String = 'hand_bones';
        public static const HAND_GESTURE:String = 'hand_gesture';
        public static const HANDSHAKE:String = 'handshake';
        public static const HANDYMAN:String = 'handyman';
        public static const HANGOUT_MEETING:String = 'hangout_meeting';
        public static const HANGOUT_VIDEO:String = 'hangout_video';
        public static const HANGOUT_VIDEO_OFF:String = 'hangout_video_off';
        public static const HARD_DRIVE:String = 'hard_drive';
        public static const HARD_DRIVE_2:String = 'hard_drive_2';
        public static const HARDWARE:String = 'hardware';
        public static const HD:String = 'hd';
        public static const HDR_AUTO:String = 'hdr_auto';
        public static const HDR_AUTO_SELECT:String = 'hdr_auto_select';
        public static const HDR_ENHANCED_SELECT:String = 'hdr_enhanced_select';
        public static const HDR_OFF:String = 'hdr_off';
        public static const HDR_OFF_SELECT:String = 'hdr_off_select';
        public static const HDR_ON:String = 'hdr_on';
        public static const HDR_ON_SELECT:String = 'hdr_on_select';
        public static const HDR_PLUS:String = 'hdr_plus';
        public static const HDR_PLUS_OFF:String = 'hdr_plus_off';
        public static const HDR_STRONG:String = 'hdr_strong';
        public static const HDR_WEAK:String = 'hdr_weak';
        public static const HEADPHONES:String = 'headphones';
        public static const HEADPHONES_BATTERY:String = 'headphones_battery';
        public static const HEADSET:String = 'headset';
        public static const HEADSET_MIC:String = 'headset_mic';
        public static const HEADSET_OFF:String = 'headset_off';
        public static const HEALING:String = 'healing';
        public static const HEALTH_AND_BEAUTY:String = 'health_and_beauty';
        public static const HEALTH_AND_SAFETY:String = 'health_and_safety';
        public static const HEALTH_METRICS:String = 'health_metrics';
        public static const HEAP_SNAPSHOT_LARGE:String = 'heap_snapshot_large';
        public static const HEAP_SNAPSHOT_MULTIPLE:String = 'heap_snapshot_multiple';
        public static const HEAP_SNAPSHOT_THUMBNAIL:String = 'heap_snapshot_thumbnail';
        public static const HEARING:String = 'hearing';
        public static const HEARING_DISABLED:String = 'hearing_disabled';
        public static const HEART_BROKEN:String = 'heart_broken';
        public static const HEART_CHECK:String = 'heart_check';
        public static const HEART_MINUS:String = 'heart_minus';
        public static const HEART_PLUS:String = 'heart_plus';
        public static const HEAT:String = 'heat';
        public static const HEAT_PUMP:String = 'heat_pump';
        public static const HEAT_PUMP_BALANCE:String = 'heat_pump_balance';
        public static const HEIGHT:String = 'height';
        public static const HELICOPTER:String = 'helicopter';
        public static const HELP:String = 'help';
        public static const HELP_CENTER:String = 'help_center';
        public static const HELP_CLINIC:String = 'help_clinic';
        public static const HELP_OUTLINE:String = 'help_outline';
        public static const HEMATOLOGY:String = 'hematology';
        public static const HEVC:String = 'hevc';
        public static const HEXAGON:String = 'hexagon';
        public static const HIDE:String = 'hide';
        public static const HIDE_IMAGE:String = 'hide_image';
        public static const HIDE_SOURCE:String = 'hide_source';
        public static const HIGH_DENSITY:String = 'high_density';
        public static const HIGH_QUALITY:String = 'high_quality';
        public static const HIGH_RES:String = 'high_res';
        public static const HIGHLIGHT:String = 'highlight';
        public static const HIGHLIGHT_ALT:String = 'highlight_alt';
        public static const HIGHLIGHT_KEYBOARD_FOCUS:String = 'highlight_keyboard_focus';
        public static const HIGHLIGHT_MOUSE_CURSOR:String = 'highlight_mouse_cursor';
        public static const HIGHLIGHT_OFF:String = 'highlight_off';
        public static const HIGHLIGHT_TEXT_CURSOR:String = 'highlight_text_cursor';
        public static const HIGHLIGHTER_SIZE_1:String = 'highlighter_size_1';
        public static const HIGHLIGHTER_SIZE_2:String = 'highlighter_size_2';
        public static const HIGHLIGHTER_SIZE_3:String = 'highlighter_size_3';
        public static const HIGHLIGHTER_SIZE_4:String = 'highlighter_size_4';
        public static const HIGHLIGHTER_SIZE_5:String = 'highlighter_size_5';
        public static const HIKING:String = 'hiking';
        public static const HISTORY:String = 'history';
        public static const HISTORY_EDU:String = 'history_edu';
        public static const HISTORY_OFF:String = 'history_off';
        public static const HISTORY_TOGGLE_OFF:String = 'history_toggle_off';
        public static const HIVE:String = 'hive';
        public static const HLS:String = 'hls';
        public static const HLS_OFF:String = 'hls_off';
        public static const HOLIDAY_VILLAGE:String = 'holiday_village';
        public static const HOME:String = 'home';
        public static const HOME_AND_GARDEN:String = 'home_and_garden';
        public static const HOME_APP_LOGO:String = 'home_app_logo';
        public static const HOME_FILLED:String = 'home_filled';
        public static const HOME_HEALTH:String = 'home_health';
        public static const HOME_IMPROVEMENT_AND_TOOLS:String = 'home_improvement_and_tools';
        public static const HOME_IOT_DEVICE:String = 'home_iot_device';
        public static const HOME_MAX:String = 'home_max';
        public static const HOME_MAX_DOTS:String = 'home_max_dots';
        public static const HOME_MINI:String = 'home_mini';
        public static const HOME_PIN:String = 'home_pin';
        public static const HOME_REPAIR_SERVICE:String = 'home_repair_service';
        public static const HOME_SPEAKER:String = 'home_speaker';
        public static const HOME_STORAGE:String = 'home_storage';
        public static const HOME_WORK:String = 'home_work';
        public static const HORIZONTAL_DISTRIBUTE:String = 'horizontal_distribute';
        public static const HORIZONTAL_RULE:String = 'horizontal_rule';
        public static const HORIZONTAL_SPLIT:String = 'horizontal_split';
        public static const HOT_TUB:String = 'hot_tub';
        public static const HOTEL:String = 'hotel';
        public static const HOTEL_CLASS:String = 'hotel_class';
        public static const HOURGLASS:String = 'hourglass';
        public static const HOURGLASS_BOTTOM:String = 'hourglass_bottom';
        public static const HOURGLASS_DISABLED:String = 'hourglass_disabled';
        public static const HOURGLASS_EMPTY:String = 'hourglass_empty';
        public static const HOURGLASS_FULL:String = 'hourglass_full';
        public static const HOURGLASS_TOP:String = 'hourglass_top';
        public static const HOUSE:String = 'house';
        public static const HOUSE_SIDING:String = 'house_siding';
        public static const HOUSE_WITH_SHIELD:String = 'house_with_shield';
        public static const HOUSEBOAT:String = 'houseboat';
        public static const HOUSEHOLD_SUPPLIES:String = 'household_supplies';
        public static const HOW_TO_REG:String = 'how_to_reg';
        public static const HOW_TO_VOTE:String = 'how_to_vote';
        public static const HR_RESTING:String = 'hr_resting';
        public static const HTML:String = 'html';
        public static const HTTP:String = 'http';
        public static const HTTPS:String = 'https';
        public static const HUB:String = 'hub';
        public static const HUMERUS:String = 'humerus';
        public static const HUMERUS_ALT:String = 'humerus_alt';
        public static const HUMIDITY_HELPER:String = 'humidity_helper';
        public static const HUMIDITY_HIGH:String = 'humidity_high';
        public static const HUMIDITY_INDOOR:String = 'humidity_indoor';
        public static const HUMIDITY_LOW:String = 'humidity_low';
        public static const HUMIDITY_MID:String = 'humidity_mid';
        public static const HUMIDITY_PERCENTAGE:String = 'humidity_percentage';
        public static const HVAC:String = 'hvac';
        public static const ICE_SKATING:String = 'ice_skating';
        public static const ICECREAM:String = 'icecream';
        public static const IFL:String = 'ifl';
        public static const IFRAME:String = 'iframe';
        public static const IFRAME_OFF:String = 'iframe_off';
        public static const IMAGE:String = 'image';
        public static const IMAGE_ASPECT_RATIO:String = 'image_aspect_ratio';
        public static const IMAGE_NOT_SUPPORTED:String = 'image_not_supported';
        public static const IMAGE_SEARCH:String = 'image_search';
        public static const IMAGESEARCH_ROLLER:String = 'imagesearch_roller';
        public static const IMAGESMODE:String = 'imagesmode';
        public static const IMMUNOLOGY:String = 'immunology';
        public static const IMPORT_CONTACTS:String = 'import_contacts';
        public static const IMPORT_EXPORT:String = 'import_export';
        public static const IMPORTANT_DEVICES:String = 'important_devices';
        public static const IN_HOME_MODE:String = 'in_home_mode';
        public static const INACTIVE_ORDER:String = 'inactive_order';
        public static const INBOX:String = 'inbox';
        public static const INBOX_CUSTOMIZE:String = 'inbox_customize';
        public static const INCOMPLETE_CIRCLE:String = 'incomplete_circle';
        public static const INDETERMINATE_CHECK_BOX:String = 'indeterminate_check_box';
        public static const INDETERMINATE_QUESTION_BOX:String = 'indeterminate_question_box';
        public static const INFO:String = 'info';
        public static const INFO_I:String = 'info_i';
        public static const INFO_OUTLINE:String = 'info_outline';
        public static const INFRARED:String = 'infrared';
        public static const INK_ERASER:String = 'ink_eraser';
        public static const INK_ERASER_OFF:String = 'ink_eraser_off';
        public static const INK_HIGHLIGHTER:String = 'ink_highlighter';
        public static const INK_HIGHLIGHTER_MOVE:String = 'ink_highlighter_move';
        public static const INK_MARKER:String = 'ink_marker';
        public static const INK_PEN:String = 'ink_pen';
        public static const INPATIENT:String = 'inpatient';
        public static const INPUT:String = 'input';
        public static const INPUT_CIRCLE:String = 'input_circle';
        public static const INSERT_CHART:String = 'insert_chart';
        public static const INSERT_CHART_OUTLINED:String = 'insert_chart_outlined';
        public static const INSERT_COMMENT:String = 'insert_comment';
        public static const INSERT_DRIVE_FILE:String = 'insert_drive_file';
        public static const INSERT_EMOTICON:String = 'insert_emoticon';
        public static const INSERT_INVITATION:String = 'insert_invitation';
        public static const INSERT_LINK:String = 'insert_link';
        public static const INSERT_PAGE_BREAK:String = 'insert_page_break';
        public static const INSERT_PHOTO:String = 'insert_photo';
        public static const INSERT_TEXT:String = 'insert_text';
        public static const INSIGHTS:String = 'insights';
        public static const INSTALL_DESKTOP:String = 'install_desktop';
        public static const INSTALL_MOBILE:String = 'install_mobile';
        public static const INSTANT_MIX:String = 'instant_mix';
        public static const INTEGRATION_INSTRUCTIONS:String = 'integration_instructions';
        public static const INTERACTIVE_SPACE:String = 'interactive_space';
        public static const INTERESTS:String = 'interests';
        public static const INTERPRETER_MODE:String = 'interpreter_mode';
        public static const INVENTORY:String = 'inventory';
        public static const INVENTORY_2:String = 'inventory_2';
        public static const INVERT_COLORS:String = 'invert_colors';
        public static const INVERT_COLORS_OFF:String = 'invert_colors_off';
        public static const IOS:String = 'ios';
        public static const IOS_SHARE:String = 'ios_share';
        public static const IRON:String = 'iron';
        public static const ISO:String = 'iso';
        public static const JAMBOARD_KIOSK:String = 'jamboard_kiosk';
        public static const JAVASCRIPT:String = 'javascript';
        public static const JOIN:String = 'join';
        public static const JOIN_FULL:String = 'join_full';
        public static const JOIN_INNER:String = 'join_inner';
        public static const JOIN_LEFT:String = 'join_left';
        public static const JOIN_RIGHT:String = 'join_right';
        public static const JOYSTICK:String = 'joystick';
        public static const JUMP_TO_ELEMENT:String = 'jump_to_element';
        public static const KAYAKING:String = 'kayaking';
        public static const KEBAB_DINING:String = 'kebab_dining';
        public static const KEEP_PUBLIC:String = 'keep_public';
        public static const KETTLE:String = 'kettle';
        public static const KEY:String = 'key';
        public static const KEY_OFF:String = 'key_off';
        public static const KEY_VERTICAL:String = 'key_vertical';
        public static const KEY_VISUALIZER:String = 'key_visualizer';
        public static const KEYBOARD:String = 'keyboard';
        public static const KEYBOARD_ALT:String = 'keyboard_alt';
        public static const KEYBOARD_ARROW_DOWN:String = 'keyboard_arrow_down';
        public static const KEYBOARD_ARROW_LEFT:String = 'keyboard_arrow_left';
        public static const KEYBOARD_ARROW_RIGHT:String = 'keyboard_arrow_right';
        public static const KEYBOARD_ARROW_UP:String = 'keyboard_arrow_up';
        public static const KEYBOARD_BACKSPACE:String = 'keyboard_backspace';
        public static const KEYBOARD_CAPSLOCK:String = 'keyboard_capslock';
        public static const KEYBOARD_CAPSLOCK_BADGE:String = 'keyboard_capslock_badge';
        public static const KEYBOARD_COMMAND_KEY:String = 'keyboard_command_key';
        public static const KEYBOARD_CONTROL_KEY:String = 'keyboard_control_key';
        public static const KEYBOARD_DOUBLE_ARROW_DOWN:String = 'keyboard_double_arrow_down';
        public static const KEYBOARD_DOUBLE_ARROW_LEFT:String = 'keyboard_double_arrow_left';
        public static const KEYBOARD_DOUBLE_ARROW_RIGHT:String = 'keyboard_double_arrow_right';
        public static const KEYBOARD_DOUBLE_ARROW_UP:String = 'keyboard_double_arrow_up';
        public static const KEYBOARD_EXTERNAL_INPUT:String = 'keyboard_external_input';
        public static const KEYBOARD_FULL:String = 'keyboard_full';
        public static const KEYBOARD_HIDE:String = 'keyboard_hide';
        public static const KEYBOARD_KEYS:String = 'keyboard_keys';
        public static const KEYBOARD_OFF:String = 'keyboard_off';
        public static const KEYBOARD_ONSCREEN:String = 'keyboard_onscreen';
        public static const KEYBOARD_OPTION_KEY:String = 'keyboard_option_key';
        public static const KEYBOARD_PREVIOUS_LANGUAGE:String = 'keyboard_previous_language';
        public static const KEYBOARD_RETURN:String = 'keyboard_return';
        public static const KEYBOARD_TAB:String = 'keyboard_tab';
        public static const KEYBOARD_TAB_RTL:String = 'keyboard_tab_rtl';
        public static const KEYBOARD_VOICE:String = 'keyboard_voice';
        public static const KID_STAR:String = 'kid_star';
        public static const KING_BED:String = 'king_bed';
        public static const KITCHEN:String = 'kitchen';
        public static const KITESURFING:String = 'kitesurfing';
        public static const KORMO:String = 'kormo';
        public static const LAB_PANEL:String = 'lab_panel';
        public static const LAB_PROFILE:String = 'lab_profile';
        public static const LAB_RESEARCH:String = 'lab_research';
        public static const LABEL:String = 'label';
        public static const LABEL_IMPORTANT:String = 'label_important';
        public static const LABEL_IMPORTANT_OUTLINE:String = 'label_important_outline';
        public static const LABEL_OFF:String = 'label_off';
        public static const LABEL_OUTLINE:String = 'label_outline';
        public static const LABS:String = 'labs';
        public static const LAN:String = 'lan';
        public static const LANDSCAPE:String = 'landscape';
        public static const LANDSLIDE:String = 'landslide';
        public static const LANGUAGE:String = 'language';
        public static const LANGUAGE_CHINESE_ARRAY:String = 'language_chinese_array';
        public static const LANGUAGE_CHINESE_CANGJIE:String = 'language_chinese_cangjie';
        public static const LANGUAGE_CHINESE_DAYI:String = 'language_chinese_dayi';
        public static const LANGUAGE_CHINESE_PINYIN:String = 'language_chinese_pinyin';
        public static const LANGUAGE_CHINESE_QUICK:String = 'language_chinese_quick';
        public static const LANGUAGE_CHINESE_WUBI:String = 'language_chinese_wubi';
        public static const LANGUAGE_FRENCH:String = 'language_french';
        public static const LANGUAGE_GB_ENGLISH:String = 'language_gb_english';
        public static const LANGUAGE_INTERNATIONAL:String = 'language_international';
        public static const LANGUAGE_JAPANESE_KANA:String = 'language_japanese_kana';
        public static const LANGUAGE_KOREAN_LATIN:String = 'language_korean_latin';
        public static const LANGUAGE_PINYIN:String = 'language_pinyin';
        public static const LANGUAGE_SPANISH:String = 'language_spanish';
        public static const LANGUAGE_US:String = 'language_us';
        public static const LANGUAGE_US_COLEMAK:String = 'language_us_colemak';
        public static const LANGUAGE_US_DVORAK:String = 'language_us_dvorak';
        public static const LAPS:String = 'laps';
        public static const LAPTOP:String = 'laptop';
        public static const LAPTOP_CHROMEBOOK:String = 'laptop_chromebook';
        public static const LAPTOP_MAC:String = 'laptop_mac';
        public static const LAPTOP_WINDOWS:String = 'laptop_windows';
        public static const LASSO_SELECT:String = 'lasso_select';
        public static const LAST_PAGE:String = 'last_page';
        public static const LAUNCH:String = 'launch';
        public static const LAUNCHER_ASSISTANT_OFF:String = 'launcher_assistant_off';
        public static const LAUNCHER_ASSISTANT_ON:String = 'launcher_assistant_on';
        public static const LAUNDRY:String = 'laundry';
        public static const LAYERS:String = 'layers';
        public static const LAYERS_CLEAR:String = 'layers_clear';
        public static const LDA:String = 'lda';
        public static const LEADERBOARD:String = 'leaderboard';
        public static const LEAF_SPARK:String = 'leaf_spark';
        public static const LEAK_ADD:String = 'leak_add';
        public static const LEAK_REMOVE:String = 'leak_remove';
        public static const LEFT_CLICK:String = 'left_click';
        public static const LEFT_PANEL_CLOSE:String = 'left_panel_close';
        public static const LEFT_PANEL_OPEN:String = 'left_panel_open';
        public static const LEGEND_TOGGLE:String = 'legend_toggle';
        public static const LENS:String = 'lens';
        public static const LENS_BLUR:String = 'lens_blur';
        public static const LETTER_SWITCH:String = 'letter_switch';
        public static const LIBRARY_ADD:String = 'library_add';
        public static const LIBRARY_ADD_CHECK:String = 'library_add_check';
        public static const LIBRARY_BOOKS:String = 'library_books';
        public static const LIBRARY_MUSIC:String = 'library_music';
        public static const LICENSE:String = 'license';
        public static const LIFT_TO_TALK:String = 'lift_to_talk';
        public static const LIGHT:String = 'light';
        public static const LIGHT_GROUP:String = 'light_group';
        public static const LIGHT_MODE:String = 'light_mode';
        public static const LIGHT_OFF:String = 'light_off';
        public static const LIGHTBULB:String = 'lightbulb';
        public static const LIGHTBULB_CIRCLE:String = 'lightbulb_circle';
        public static const LIGHTBULB_OUTLINE:String = 'lightbulb_outline';
        public static const LIGHTNING_STAND:String = 'lightning_stand';
        public static const LINE_AXIS:String = 'line_axis';
        public static const LINE_CURVE:String = 'line_curve';
        public static const LINE_END:String = 'line_end';
        public static const LINE_END_ARROW:String = 'line_end_arrow';
        public static const LINE_END_ARROW_NOTCH:String = 'line_end_arrow_notch';
        public static const LINE_END_CIRCLE:String = 'line_end_circle';
        public static const LINE_END_DIAMOND:String = 'line_end_diamond';
        public static const LINE_END_SQUARE:String = 'line_end_square';
        public static const LINE_START:String = 'line_start';
        public static const LINE_START_ARROW:String = 'line_start_arrow';
        public static const LINE_START_ARROW_NOTCH:String = 'line_start_arrow_notch';
        public static const LINE_START_CIRCLE:String = 'line_start_circle';
        public static const LINE_START_DIAMOND:String = 'line_start_diamond';
        public static const LINE_START_SQUARE:String = 'line_start_square';
        public static const LINE_STYLE:String = 'line_style';
        public static const LINE_WEIGHT:String = 'line_weight';
        public static const LINEAR_SCALE:String = 'linear_scale';
        public static const LINK:String = 'link';
        public static const LINK_OFF:String = 'link_off';
        public static const LINKED_CAMERA:String = 'linked_camera';
        public static const LINKED_SERVICES:String = 'linked_services';
        public static const LIQUOR:String = 'liquor';
        public static const LIST:String = 'list';
        public static const LIST_ALT:String = 'list_alt';
        public static const LIST_ALT_ADD:String = 'list_alt_add';
        public static const LISTS:String = 'lists';
        public static const LIVE_HELP:String = 'live_help';
        public static const LIVE_TV:String = 'live_tv';
        public static const LIVING:String = 'living';
        public static const LOCAL_ACTIVITY:String = 'local_activity';
        public static const LOCAL_AIRPORT:String = 'local_airport';
        public static const LOCAL_ATM:String = 'local_atm';
        public static const LOCAL_BAR:String = 'local_bar';
        public static const LOCAL_CAFE:String = 'local_cafe';
        public static const LOCAL_CAR_WASH:String = 'local_car_wash';
        public static const LOCAL_CONVENIENCE_STORE:String = 'local_convenience_store';
        public static const LOCAL_DINING:String = 'local_dining';
        public static const LOCAL_DRINK:String = 'local_drink';
        public static const LOCAL_FIRE_DEPARTMENT:String = 'local_fire_department';
        public static const LOCAL_FLORIST:String = 'local_florist';
        public static const LOCAL_GAS_STATION:String = 'local_gas_station';
        public static const LOCAL_GROCERY_STORE:String = 'local_grocery_store';
        public static const LOCAL_HOSPITAL:String = 'local_hospital';
        public static const LOCAL_HOTEL:String = 'local_hotel';
        public static const LOCAL_LAUNDRY_SERVICE:String = 'local_laundry_service';
        public static const LOCAL_LIBRARY:String = 'local_library';
        public static const LOCAL_MALL:String = 'local_mall';
        public static const LOCAL_MOVIES:String = 'local_movies';
        public static const LOCAL_OFFER:String = 'local_offer';
        public static const LOCAL_PARKING:String = 'local_parking';
        public static const LOCAL_PHARMACY:String = 'local_pharmacy';
        public static const LOCAL_PHONE:String = 'local_phone';
        public static const LOCAL_PIZZA:String = 'local_pizza';
        public static const LOCAL_PLAY:String = 'local_play';
        public static const LOCAL_POLICE:String = 'local_police';
        public static const LOCAL_POST_OFFICE:String = 'local_post_office';
        public static const LOCAL_PRINTSHOP:String = 'local_printshop';
        public static const LOCAL_SEE:String = 'local_see';
        public static const LOCAL_SHIPPING:String = 'local_shipping';
        public static const LOCAL_TAXI:String = 'local_taxi';
        public static const LOCATION_AUTOMATION:String = 'location_automation';
        public static const LOCATION_AWAY:String = 'location_away';
        public static const LOCATION_CHIP:String = 'location_chip';
        public static const LOCATION_CITY:String = 'location_city';
        public static const LOCATION_DISABLED:String = 'location_disabled';
        public static const LOCATION_HOME:String = 'location_home';
        public static const LOCATION_OFF:String = 'location_off';
        public static const LOCATION_ON:String = 'location_on';
        public static const LOCATION_PIN:String = 'location_pin';
        public static const LOCATION_SEARCHING:String = 'location_searching';
        public static const LOCK:String = 'lock';
        public static const LOCK_CLOCK:String = 'lock_clock';
        public static const LOCK_OPEN:String = 'lock_open';
        public static const LOCK_OPEN_RIGHT:String = 'lock_open_right';
        public static const LOCK_OUTLINE:String = 'lock_outline';
        public static const LOCK_PERSON:String = 'lock_person';
        public static const LOCK_RESET:String = 'lock_reset';
        public static const LOGIN:String = 'login';
        public static const LOGO_DEV:String = 'logo_dev';
        public static const LOGOUT:String = 'logout';
        public static const LOOKS:String = 'looks';
        public static const LOOKS_3:String = 'looks_3';
        public static const LOOKS_4:String = 'looks_4';
        public static const LOOKS_5:String = 'looks_5';
        public static const LOOKS_6:String = 'looks_6';
        public static const LOOKS_ONE:String = 'looks_one';
        public static const LOOKS_TWO:String = 'looks_two';
        public static const LOOP:String = 'loop';
        public static const LOUPE:String = 'loupe';
        public static const LOW_DENSITY:String = 'low_density';
        public static const LOW_PRIORITY:String = 'low_priority';
        public static const LOYALTY:String = 'loyalty';
        public static const LTE_MOBILEDATA:String = 'lte_mobiledata';
        public static const LTE_MOBILEDATA_BADGE:String = 'lte_mobiledata_badge';
        public static const LTE_PLUS_MOBILEDATA:String = 'lte_plus_mobiledata';
        public static const LTE_PLUS_MOBILEDATA_BADGE:String = 'lte_plus_mobiledata_badge';
        public static const LUGGAGE:String = 'luggage';
        public static const LUNCH_DINING:String = 'lunch_dining';
        public static const LYRICS:String = 'lyrics';
        public static const MACHINE_IMAGE:String = 'machine_image';
        public static const MACRO_AUTO:String = 'macro_auto';
        public static const MACRO_OFF:String = 'macro_off';
        public static const MAGIC_BUTTON:String = 'magic_button';
        public static const MAGIC_EXCHANGE:String = 'magic_exchange';
        public static const MAGIC_TETHER:String = 'magic_tether';
        public static const MAGNIFICATION_LARGE:String = 'magnification_large';
        public static const MAGNIFICATION_SMALL:String = 'magnification_small';
        public static const MAGNIFY_DOCKED:String = 'magnify_docked';
        public static const MAGNIFY_FULLSCREEN:String = 'magnify_fullscreen';
        public static const MAIL:String = 'mail';
        public static const MAIL_LOCK:String = 'mail_lock';
        public static const MAIL_OUTLINE:String = 'mail_outline';
        public static const MALE:String = 'male';
        public static const MAN:String = 'man';
        public static const MAN_2:String = 'man_2';
        public static const MAN_3:String = 'man_3';
        public static const MAN_4:String = 'man_4';
        public static const MANAGE_ACCOUNTS:String = 'manage_accounts';
        public static const MANAGE_HISTORY:String = 'manage_history';
        public static const MANAGE_SEARCH:String = 'manage_search';
        public static const MANGA:String = 'manga';
        public static const MANUFACTURING:String = 'manufacturing';
        public static const MAP:String = 'map';
        public static const MAPS_HOME_WORK:String = 'maps_home_work';
        public static const MAPS_UGC:String = 'maps_ugc';
        public static const MARGIN:String = 'margin';
        public static const MARK_AS_UNREAD:String = 'mark_as_unread';
        public static const MARK_CHAT_READ:String = 'mark_chat_read';
        public static const MARK_CHAT_UNREAD:String = 'mark_chat_unread';
        public static const MARK_EMAIL_READ:String = 'mark_email_read';
        public static const MARK_EMAIL_UNREAD:String = 'mark_email_unread';
        public static const MARK_UNREAD_CHAT_ALT:String = 'mark_unread_chat_alt';
        public static const MARKDOWN:String = 'markdown';
        public static const MARKDOWN_COPY:String = 'markdown_copy';
        public static const MARKDOWN_PASTE:String = 'markdown_paste';
        public static const MARKUNREAD:String = 'markunread';
        public static const MARKUNREAD_MAILBOX:String = 'markunread_mailbox';
        public static const MASKED_TRANSITIONS:String = 'masked_transitions';
        public static const MASKS:String = 'masks';
        public static const MATCH_CASE:String = 'match_case';
        public static const MATCH_WORD:String = 'match_word';
        public static const MATTER:String = 'matter';
        public static const MAXIMIZE:String = 'maximize';
        public static const MEASURING_TAPE:String = 'measuring_tape';
        public static const MEDIA_BLUETOOTH_OFF:String = 'media_bluetooth_off';
        public static const MEDIA_BLUETOOTH_ON:String = 'media_bluetooth_on';
        public static const MEDIA_LINK:String = 'media_link';
        public static const MEDIA_OUTPUT:String = 'media_output';
        public static const MEDIA_OUTPUT_OFF:String = 'media_output_off';
        public static const MEDIATION:String = 'mediation';
        public static const MEDICAL_INFORMATION:String = 'medical_information';
        public static const MEDICAL_MASK:String = 'medical_mask';
        public static const MEDICAL_SERVICES:String = 'medical_services';
        public static const MEDICATION:String = 'medication';
        public static const MEDICATION_LIQUID:String = 'medication_liquid';
        public static const MEETING_ROOM:String = 'meeting_room';
        public static const MEMORY:String = 'memory';
        public static const MEMORY_ALT:String = 'memory_alt';
        public static const MENSTRUAL_HEALTH:String = 'menstrual_health';
        public static const MENU:String = 'menu';
        public static const MENU_BOOK:String = 'menu_book';
        public static const MENU_OPEN:String = 'menu_open';
        public static const MERGE:String = 'merge';
        public static const MERGE_TYPE:String = 'merge_type';
        public static const MESSAGE:String = 'message';
        public static const METABOLISM:String = 'metabolism';
        public static const MFG_NEST_YALE_LOCK:String = 'mfg_nest_yale_lock';
        public static const MIC:String = 'mic';
        public static const MIC_DOUBLE:String = 'mic_double';
        public static const MIC_EXTERNAL_OFF:String = 'mic_external_off';
        public static const MIC_EXTERNAL_ON:String = 'mic_external_on';
        public static const MIC_NOISE_CANCEL_HIGH:String = 'mic_noise_cancel_high';
        public static const MIC_NOISE_CANCEL_LOW:String = 'mic_noise_cancel_low';
        public static const MIC_NOISE_CANCEL_OFF:String = 'mic_noise_cancel_off';
        public static const MIC_NONE:String = 'mic_none';
        public static const MIC_OFF:String = 'mic_off';
        public static const MICROBIOLOGY:String = 'microbiology';
        public static const MICROWAVE:String = 'microwave';
        public static const MICROWAVE_GEN:String = 'microwave_gen';
        public static const MILITARY_TECH:String = 'military_tech';
        public static const MIMO:String = 'mimo';
        public static const MIMO_DISCONNECT:String = 'mimo_disconnect';
        public static const MINDFULNESS:String = 'mindfulness';
        public static const MINIMIZE:String = 'minimize';
        public static const MINOR_CRASH:String = 'minor_crash';
        public static const MINTMARK:String = 'mintmark';
        public static const MISCELLANEOUS_SERVICES:String = 'miscellaneous_services';
        public static const MISSED_VIDEO_CALL:String = 'missed_video_call';
        public static const MISSING_CONTROLLER:String = 'missing_controller';
        public static const MIST:String = 'mist';
        public static const MITRE:String = 'mitre';
        public static const MIXTURE_MED:String = 'mixture_med';
        public static const MMS:String = 'mms';
        public static const MOBILE_FRIENDLY:String = 'mobile_friendly';
        public static const MOBILE_OFF:String = 'mobile_off';
        public static const MOBILE_SCREEN_SHARE:String = 'mobile_screen_share';
        public static const MOBILEDATA_OFF:String = 'mobiledata_off';
        public static const MODE:String = 'mode';
        public static const MODE_COMMENT:String = 'mode_comment';
        public static const MODE_COOL:String = 'mode_cool';
        public static const MODE_COOL_OFF:String = 'mode_cool_off';
        public static const MODE_DUAL:String = 'mode_dual';
        public static const MODE_EDIT:String = 'mode_edit';
        public static const MODE_EDIT_OUTLINE:String = 'mode_edit_outline';
        public static const MODE_FAN:String = 'mode_fan';
        public static const MODE_FAN_OFF:String = 'mode_fan_off';
        public static const MODE_HEAT:String = 'mode_heat';
        public static const MODE_HEAT_COOL:String = 'mode_heat_cool';
        public static const MODE_HEAT_OFF:String = 'mode_heat_off';
        public static const MODE_NIGHT:String = 'mode_night';
        public static const MODE_OF_TRAVEL:String = 'mode_of_travel';
        public static const MODE_OFF_ON:String = 'mode_off_on';
        public static const MODE_STANDBY:String = 'mode_standby';
        public static const MODEL_TRAINING:String = 'model_training';
        public static const MONETIZATION_ON:String = 'monetization_on';
        public static const MONEY:String = 'money';
        public static const MONEY_OFF:String = 'money_off';
        public static const MONEY_OFF_CSRED:String = 'money_off_csred';
        public static const MONITOR:String = 'monitor';
        public static const MONITOR_HEART:String = 'monitor_heart';
        public static const MONITOR_WEIGHT:String = 'monitor_weight';
        public static const MONITOR_WEIGHT_GAIN:String = 'monitor_weight_gain';
        public static const MONITOR_WEIGHT_LOSS:String = 'monitor_weight_loss';
        public static const MONITORING:String = 'monitoring';
        public static const MONOCHROME_PHOTOS:String = 'monochrome_photos';
        public static const MOOD:String = 'mood';
        public static const MOOD_BAD:String = 'mood_bad';
        public static const MOP:String = 'mop';
        public static const MOPED:String = 'moped';
        public static const MORE:String = 'more';
        public static const MORE_DOWN:String = 'more_down';
        public static const MORE_HORIZ:String = 'more_horiz';
        public static const MORE_TIME:String = 'more_time';
        public static const MORE_UP:String = 'more_up';
        public static const MORE_VERT:String = 'more_vert';
        public static const MOSQUE:String = 'mosque';
        public static const MOTION_BLUR:String = 'motion_blur';
        public static const MOTION_MODE:String = 'motion_mode';
        public static const MOTION_PHOTOS_AUTO:String = 'motion_photos_auto';
        public static const MOTION_PHOTOS_OFF:String = 'motion_photos_off';
        public static const MOTION_PHOTOS_ON:String = 'motion_photos_on';
        public static const MOTION_PHOTOS_PAUSE:String = 'motion_photos_pause';
        public static const MOTION_PHOTOS_PAUSED:String = 'motion_photos_paused';
        public static const MOTION_SENSE:String = 'motion_sense';
        public static const MOTION_SENSOR_ACTIVE:String = 'motion_sensor_active';
        public static const MOTION_SENSOR_ALERT:String = 'motion_sensor_alert';
        public static const MOTION_SENSOR_IDLE:String = 'motion_sensor_idle';
        public static const MOTION_SENSOR_URGENT:String = 'motion_sensor_urgent';
        public static const MOTORCYCLE:String = 'motorcycle';
        public static const MOUNTAIN_FLAG:String = 'mountain_flag';
        public static const MOUSE:String = 'mouse';
        public static const MOVE:String = 'move';
        public static const MOVE_DOWN:String = 'move_down';
        public static const MOVE_GROUP:String = 'move_group';
        public static const MOVE_ITEM:String = 'move_item';
        public static const MOVE_LOCATION:String = 'move_location';
        public static const MOVE_SELECTION_DOWN:String = 'move_selection_down';
        public static const MOVE_SELECTION_LEFT:String = 'move_selection_left';
        public static const MOVE_SELECTION_RIGHT:String = 'move_selection_right';
        public static const MOVE_SELECTION_UP:String = 'move_selection_up';
        public static const MOVE_TO_INBOX:String = 'move_to_inbox';
        public static const MOVE_UP:String = 'move_up';
        public static const MOVED_LOCATION:String = 'moved_location';
        public static const MOVIE:String = 'movie';
        public static const MOVIE_CREATION:String = 'movie_creation';
        public static const MOVIE_EDIT:String = 'movie_edit';
        public static const MOVIE_FILTER:String = 'movie_filter';
        public static const MOVIE_INFO:String = 'movie_info';
        public static const MOVING:String = 'moving';
        public static const MOVING_BEDS:String = 'moving_beds';
        public static const MOVING_MINISTRY:String = 'moving_ministry';
        public static const MP:String = 'mp';
        public static const MULTICOOKER:String = 'multicooker';
        public static const MULTILINE_CHART:String = 'multiline_chart';
        public static const MULTIPLE_STOP:String = 'multiple_stop';
        public static const MUSEUM:String = 'museum';
        public static const MUSIC_CAST:String = 'music_cast';
        public static const MUSIC_NOTE:String = 'music_note';
        public static const MUSIC_OFF:String = 'music_off';
        public static const MUSIC_VIDEO:String = 'music_video';
        public static const MY_LOCATION:String = 'my_location';
        public static const MYSTERY:String = 'mystery';
        public static const NAT:String = 'nat';
        public static const NATURE:String = 'nature';
        public static const NATURE_PEOPLE:String = 'nature_people';
        public static const NAVIGATE_BEFORE:String = 'navigate_before';
        public static const NAVIGATE_NEXT:String = 'navigate_next';
        public static const NAVIGATION:String = 'navigation';
        public static const NEAR_ME:String = 'near_me';
        public static const NEAR_ME_DISABLED:String = 'near_me_disabled';
        public static const NEARBY:String = 'nearby';
        public static const NEARBY_ERROR:String = 'nearby_error';
        public static const NEARBY_OFF:String = 'nearby_off';
        public static const NEARBY_SHARE:String = 'nearby_share';
        public static const NEPHROLOGY:String = 'nephrology';
        public static const NEST_AUDIO:String = 'nest_audio';
        public static const NEST_CAM_FLOODLIGHT:String = 'nest_cam_floodlight';
        public static const NEST_CAM_INDOOR:String = 'nest_cam_indoor';
        public static const NEST_CAM_IQ:String = 'nest_cam_iq';
        public static const NEST_CAM_IQ_OUTDOOR:String = 'nest_cam_iq_outdoor';
        public static const NEST_CAM_MAGNET_MOUNT:String = 'nest_cam_magnet_mount';
        public static const NEST_CAM_OUTDOOR:String = 'nest_cam_outdoor';
        public static const NEST_CAM_STAND:String = 'nest_cam_stand';
        public static const NEST_CAM_WALL_MOUNT:String = 'nest_cam_wall_mount';
        public static const NEST_CAM_WIRED_STAND:String = 'nest_cam_wired_stand';
        public static const NEST_CLOCK_FARSIGHT_ANALOG:String = 'nest_clock_farsight_analog';
        public static const NEST_CLOCK_FARSIGHT_DIGITAL:String = 'nest_clock_farsight_digital';
        public static const NEST_CONNECT:String = 'nest_connect';
        public static const NEST_DETECT:String = 'nest_detect';
        public static const NEST_DISPLAY:String = 'nest_display';
        public static const NEST_DISPLAY_MAX:String = 'nest_display_max';
        public static const NEST_DOORBELL_VISITOR:String = 'nest_doorbell_visitor';
        public static const NEST_ECO:String = 'nest_eco';
        public static const NEST_ECO_LEAF:String = 'nest_eco_leaf';
        public static const NEST_FARSIGHT_WEATHER:String = 'nest_farsight_weather';
        public static const NEST_FOUND_SAVINGS:String = 'nest_found_savings';
        public static const NEST_GALE_WIFI:String = 'nest_gale_wifi';
        public static const NEST_HEAT_LINK_E:String = 'nest_heat_link_e';
        public static const NEST_HEAT_LINK_GEN_3:String = 'nest_heat_link_gen_3';
        public static const NEST_HELLO_DOORBELL:String = 'nest_hello_doorbell';
        public static const NEST_LOCATOR_TAG:String = 'nest_locator_tag';
        public static const NEST_MINI:String = 'nest_mini';
        public static const NEST_MULTI_ROOM:String = 'nest_multi_room';
        public static const NEST_PROTECT:String = 'nest_protect';
        public static const NEST_REMOTE:String = 'nest_remote';
        public static const NEST_REMOTE_COMFORT_SENSOR:String = 'nest_remote_comfort_sensor';
        public static const NEST_SECURE_ALARM:String = 'nest_secure_alarm';
        public static const NEST_SUNBLOCK:String = 'nest_sunblock';
        public static const NEST_TAG:String = 'nest_tag';
        public static const NEST_THERMOSTAT:String = 'nest_thermostat';
        public static const NEST_THERMOSTAT_E_EU:String = 'nest_thermostat_e_eu';
        public static const NEST_THERMOSTAT_GEN_3:String = 'nest_thermostat_gen_3';
        public static const NEST_THERMOSTAT_SENSOR:String = 'nest_thermostat_sensor';
        public static const NEST_THERMOSTAT_SENSOR_EU:String = 'nest_thermostat_sensor_eu';
        public static const NEST_THERMOSTAT_ZIRCONIUM_EU:String = 'nest_thermostat_zirconium_eu';
        public static const NEST_TRUE_RADIANT:String = 'nest_true_radiant';
        public static const NEST_WAKE_ON_APPROACH:String = 'nest_wake_on_approach';
        public static const NEST_WAKE_ON_PRESS:String = 'nest_wake_on_press';
        public static const NEST_WIFI_GALE:String = 'nest_wifi_gale';
        public static const NEST_WIFI_MISTRAL:String = 'nest_wifi_mistral';
        public static const NEST_WIFI_POINT:String = 'nest_wifi_point';
        public static const NEST_WIFI_POINT_VENTO:String = 'nest_wifi_point_vento';
        public static const NEST_WIFI_PRO:String = 'nest_wifi_pro';
        public static const NEST_WIFI_PRO_2:String = 'nest_wifi_pro_2';
        public static const NEST_WIFI_ROUTER:String = 'nest_wifi_router';
        public static const NETWORK_CELL:String = 'network_cell';
        public static const NETWORK_CHECK:String = 'network_check';
        public static const NETWORK_INTELLIGENCE_HISTORY:String = 'network_intelligence_history';
        public static const NETWORK_INTELLIGENCE_UPDATE:String = 'network_intelligence_update';
        public static const NETWORK_LOCKED:String = 'network_locked';
        public static const NETWORK_MANAGE:String = 'network_manage';
        public static const NETWORK_NODE:String = 'network_node';
        public static const NETWORK_PING:String = 'network_ping';
        public static const NETWORK_WIFI:String = 'network_wifi';
        public static const NETWORK_WIFI_1_BAR:String = 'network_wifi_1_bar';
        public static const NETWORK_WIFI_1_BAR_LOCKED:String = 'network_wifi_1_bar_locked';
        public static const NETWORK_WIFI_2_BAR:String = 'network_wifi_2_bar';
        public static const NETWORK_WIFI_2_BAR_LOCKED:String = 'network_wifi_2_bar_locked';
        public static const NETWORK_WIFI_3_BAR:String = 'network_wifi_3_bar';
        public static const NETWORK_WIFI_3_BAR_LOCKED:String = 'network_wifi_3_bar_locked';
        public static const NETWORK_WIFI_LOCKED:String = 'network_wifi_locked';
        public static const NEUROLOGY:String = 'neurology';
        public static const NEW_LABEL:String = 'new_label';
        public static const NEW_RELEASES:String = 'new_releases';
        public static const NEW_WINDOW:String = 'new_window';
        public static const NEWS:String = 'news';
        public static const NEWSMODE:String = 'newsmode';
        public static const NEWSPAPER:String = 'newspaper';
        public static const NEWSSTAND:String = 'newsstand';
        public static const NEXT_PLAN:String = 'next_plan';
        public static const NEXT_WEEK:String = 'next_week';
        public static const NFC:String = 'nfc';
        public static const NIGHT_SHELTER:String = 'night_shelter';
        public static const NIGHT_SIGHT_AUTO:String = 'night_sight_auto';
        public static const NIGHT_SIGHT_AUTO_OFF:String = 'night_sight_auto_off';
        public static const NIGHT_SIGHT_MAX:String = 'night_sight_max';
        public static const NIGHTLIFE:String = 'nightlife';
        public static const NIGHTLIGHT:String = 'nightlight';
        public static const NIGHTLIGHT_BADGE:String = 'nightlight_badge';
        public static const NIGHTLIGHT_OFF:String = 'nightlight_off';
        public static const NIGHTLIGHT_ROUND:String = 'nightlight_round';
        public static const NIGHTS_STAY:String = 'nights_stay';
        public static const NO_ACCOUNTS:String = 'no_accounts';
        public static const NO_ADULT_CONTENT:String = 'no_adult_content';
        public static const NO_BACKPACK:String = 'no_backpack';
        public static const NO_CELL:String = 'no_cell';
        public static const NO_CRASH:String = 'no_crash';
        public static const NO_DRINKS:String = 'no_drinks';
        public static const NO_ENCRYPTION:String = 'no_encryption';
        public static const NO_ENCRYPTION_GMAILERRORRED:String = 'no_encryption_gmailerrorred';
        public static const NO_FLASH:String = 'no_flash';
        public static const NO_FOOD:String = 'no_food';
        public static const NO_LUGGAGE:String = 'no_luggage';
        public static const NO_MEALS:String = 'no_meals';
        public static const NO_MEALS_OULINE:String = 'no_meals_ouline';
        public static const NO_MEETING_ROOM:String = 'no_meeting_room';
        public static const NO_PHOTOGRAPHY:String = 'no_photography';
        public static const NO_SIM:String = 'no_sim';
        public static const NO_SOUND:String = 'no_sound';
        public static const NO_STROLLER:String = 'no_stroller';
        public static const NO_TRANSFER:String = 'no_transfer';
        public static const NOISE_AWARE:String = 'noise_aware';
        public static const NOISE_CONTROL_OFF:String = 'noise_control_off';
        public static const NOISE_CONTROL_ON:String = 'noise_control_on';
        public static const NORDIC_WALKING:String = 'nordic_walking';
        public static const NORTH:String = 'north';
        public static const NORTH_EAST:String = 'north_east';
        public static const NORTH_WEST:String = 'north_west';
        public static const NOT_ACCESSIBLE:String = 'not_accessible';
        public static const NOT_ACCESSIBLE_FORWARD:String = 'not_accessible_forward';
        public static const NOT_INTERESTED:String = 'not_interested';
        public static const NOT_LISTED_LOCATION:String = 'not_listed_location';
        public static const NOT_STARTED:String = 'not_started';
        public static const NOTE:String = 'note';
        public static const NOTE_ADD:String = 'note_add';
        public static const NOTE_ALT:String = 'note_alt';
        public static const NOTE_STACK:String = 'note_stack';
        public static const NOTE_STACK_ADD:String = 'note_stack_add';
        public static const NOTES:String = 'notes';
        public static const NOTIFICATION_ADD:String = 'notification_add';
        public static const NOTIFICATION_IMPORTANT:String = 'notification_important';
        public static const NOTIFICATION_MULTIPLE:String = 'notification_multiple';
        public static const NOTIFICATIONS:String = 'notifications';
        public static const NOTIFICATIONS_ACTIVE:String = 'notifications_active';
        public static const NOTIFICATIONS_NONE:String = 'notifications_none';
        public static const NOTIFICATIONS_OFF:String = 'notifications_off';
        public static const NOTIFICATIONS_PAUSED:String = 'notifications_paused';
        public static const NOTIFICATIONS_UNREAD:String = 'notifications_unread';
        public static const NUMBERS:String = 'numbers';
        public static const NUTRITION:String = 'nutrition';
        public static const ODS:String = 'ods';
        public static const ODT:String = 'odt';
        public static const OFFLINE_BOLT:String = 'offline_bolt';
        public static const OFFLINE_PIN:String = 'offline_pin';
        public static const OFFLINE_SHARE:String = 'offline_share';
        public static const OIL_BARREL:String = 'oil_barrel';
        public static const ON_DEVICE_TRAINING:String = 'on_device_training';
        public static const ON_HUB_DEVICE:String = 'on_hub_device';
        public static const ONCOLOGY:String = 'oncology';
        public static const ONDEMAND_VIDEO:String = 'ondemand_video';
        public static const ONLINE_PREDICTION:String = 'online_prediction';
        public static const ONSEN:String = 'onsen';
        public static const OPACITY:String = 'opacity';
        public static const OPEN_IN_BROWSER:String = 'open_in_browser';
        public static const OPEN_IN_FULL:String = 'open_in_full';
        public static const OPEN_IN_NEW:String = 'open_in_new';
        public static const OPEN_IN_NEW_DOWN:String = 'open_in_new_down';
        public static const OPEN_IN_NEW_OFF:String = 'open_in_new_off';
        public static const OPEN_IN_PHONE:String = 'open_in_phone';
        public static const OPEN_JAM:String = 'open_jam';
        public static const OPEN_WITH:String = 'open_with';
        public static const OPHTHALMOLOGY:String = 'ophthalmology';
        public static const ORAL_DISEASE:String = 'oral_disease';
        public static const ORDER_APPROVE:String = 'order_approve';
        public static const ORDER_PLAY:String = 'order_play';
        public static const ORDERS:String = 'orders';
        public static const ORTHOPEDICS:String = 'orthopedics';
        public static const OTHER_ADMISSION:String = 'other_admission';
        public static const OTHER_HOUSES:String = 'other_houses';
        public static const OUTBOND:String = 'outbond';
        public static const OUTBOUND:String = 'outbound';
        public static const OUTBOX:String = 'outbox';
        public static const OUTBOX_ALT:String = 'outbox_alt';
        public static const OUTDOOR_GARDEN:String = 'outdoor_garden';
        public static const OUTDOOR_GRILL:String = 'outdoor_grill';
        public static const OUTGOING_MAIL:String = 'outgoing_mail';
        public static const OUTLET:String = 'outlet';
        public static const OUTLINED_FLAG:String = 'outlined_flag';
        public static const OUTPATIENT:String = 'outpatient';
        public static const OUTPATIENT_MED:String = 'outpatient_med';
        public static const OUTPUT:String = 'output';
        public static const OUTPUT_CIRCLE:String = 'output_circle';
        public static const OVEN:String = 'oven';
        public static const OVEN_GEN:String = 'oven_gen';
        public static const OVERVIEW:String = 'overview';
        public static const OVERVIEW_KEY:String = 'overview_key';
        public static const OXYGEN_SATURATION:String = 'oxygen_saturation';
        public static const P2P:String = 'p2p';
        public static const PACE:String = 'pace';
        public static const PACEMAKER:String = 'pacemaker';
        public static const PACKAGE:String = 'package';
        public static const PACKAGE_2:String = 'package_2';
        public static const PACKET_MIRRORING:String = 'packet_mirroring';
        public static const PADDING:String = 'padding';
        public static const PAGE_CONTROL:String = 'page_control';
        public static const PAGE_INFO:String = 'page_info';
        public static const PAGELESS:String = 'pageless';
        public static const PAGES:String = 'pages';
        public static const PAGEVIEW:String = 'pageview';
        public static const PAID:String = 'paid';
        public static const PALETTE:String = 'palette';
        public static const PALLET:String = 'pallet';
        public static const PAN_TOOL:String = 'pan_tool';
        public static const PAN_TOOL_ALT:String = 'pan_tool_alt';
        public static const PAN_ZOOM:String = 'pan_zoom';
        public static const PANORAMA:String = 'panorama';
        public static const PANORAMA_FISH_EYE:String = 'panorama_fish_eye';
        public static const PANORAMA_HORIZONTAL:String = 'panorama_horizontal';
        public static const PANORAMA_HORIZONTAL_SELECT:String = 'panorama_horizontal_select';
        public static const PANORAMA_PHOTOSPHERE:String = 'panorama_photosphere';
        public static const PANORAMA_PHOTOSPHERE_SELECT:String = 'panorama_photosphere_select';
        public static const PANORAMA_VERTICAL:String = 'panorama_vertical';
        public static const PANORAMA_VERTICAL_SELECT:String = 'panorama_vertical_select';
        public static const PANORAMA_WIDE_ANGLE:String = 'panorama_wide_angle';
        public static const PANORAMA_WIDE_ANGLE_SELECT:String = 'panorama_wide_angle_select';
        public static const PARAGLIDING:String = 'paragliding';
        public static const PARK:String = 'park';
        public static const PARTLY_CLOUDY_DAY:String = 'partly_cloudy_day';
        public static const PARTLY_CLOUDY_NIGHT:String = 'partly_cloudy_night';
        public static const PARTNER_EXCHANGE:String = 'partner_exchange';
        public static const PARTNER_REPORTS:String = 'partner_reports';
        public static const PARTY_MODE:String = 'party_mode';
        public static const PASSKEY:String = 'passkey';
        public static const PASSWORD:String = 'password';
        public static const PATIENT_LIST:String = 'patient_list';
        public static const PATTERN:String = 'pattern';
        public static const PAUSE:String = 'pause';
        public static const PAUSE_CIRCLE:String = 'pause_circle';
        public static const PAUSE_CIRCLE_FILLED:String = 'pause_circle_filled';
        public static const PAUSE_CIRCLE_OUTLINE:String = 'pause_circle_outline';
        public static const PAUSE_PRESENTATION:String = 'pause_presentation';
        public static const PAYMENT:String = 'payment';
        public static const PAYMENTS:String = 'payments';
        public static const PDF_OFF:String = 'pdf_off';
        public static const PEDAL_BIKE:String = 'pedal_bike';
        public static const PEDIATRICS:String = 'pediatrics';
        public static const PEN_SIZE_1:String = 'pen_size_1';
        public static const PEN_SIZE_2:String = 'pen_size_2';
        public static const PEN_SIZE_3:String = 'pen_size_3';
        public static const PEN_SIZE_4:String = 'pen_size_4';
        public static const PEN_SIZE_5:String = 'pen_size_5';
        public static const PENDING:String = 'pending';
        public static const PENDING_ACTIONS:String = 'pending_actions';
        public static const PENTAGON:String = 'pentagon';
        public static const PEOPLE:String = 'people';
        public static const PEOPLE_ALT:String = 'people_alt';
        public static const PEOPLE_OUTLINE:String = 'people_outline';
        public static const PERCENT:String = 'percent';
        public static const PERFORMANCE_MAX:String = 'performance_max';
        public static const PERGOLA:String = 'pergola';
        public static const PERM_CAMERA_MIC:String = 'perm_camera_mic';
        public static const PERM_CONTACT_CALENDAR:String = 'perm_contact_calendar';
        public static const PERM_DATA_SETTING:String = 'perm_data_setting';
        public static const PERM_DEVICE_INFORMATION:String = 'perm_device_information';
        public static const PERM_IDENTITY:String = 'perm_identity';
        public static const PERM_MEDIA:String = 'perm_media';
        public static const PERM_PHONE_MSG:String = 'perm_phone_msg';
        public static const PERM_SCAN_WIFI:String = 'perm_scan_wifi';
        public static const PERSON:String = 'person';
        public static const PERSON_2:String = 'person_2';
        public static const PERSON_3:String = 'person_3';
        public static const PERSON_4:String = 'person_4';
        public static const PERSON_ADD:String = 'person_add';
        public static const PERSON_ADD_ALT:String = 'person_add_alt';
        public static const PERSON_ADD_ALT_1:String = 'person_add_alt_1';
        public static const PERSON_ADD_DISABLED:String = 'person_add_disabled';
        public static const PERSON_ALERT:String = 'person_alert';
        public static const PERSON_APRON:String = 'person_apron';
        public static const PERSON_BOOK:String = 'person_book';
        public static const PERSON_CANCEL:String = 'person_cancel';
        public static const PERSON_CELEBRATE:String = 'person_celebrate';
        public static const PERSON_CHECK:String = 'person_check';
        public static const PERSON_EDIT:String = 'person_edit';
        public static const PERSON_FILLED:String = 'person_filled';
        public static const PERSON_OFF:String = 'person_off';
        public static const PERSON_OUTLINE:String = 'person_outline';
        public static const PERSON_PIN:String = 'person_pin';
        public static const PERSON_PIN_CIRCLE:String = 'person_pin_circle';
        public static const PERSON_PLAY:String = 'person_play';
        public static const PERSON_RAISED_HAND:String = 'person_raised_hand';
        public static const PERSON_REMOVE:String = 'person_remove';
        public static const PERSON_REMOVE_ALT_1:String = 'person_remove_alt_1';
        public static const PERSON_SEARCH:String = 'person_search';
        public static const PERSONAL_BAG:String = 'personal_bag';
        public static const PERSONAL_BAG_OFF:String = 'personal_bag_off';
        public static const PERSONAL_BAG_QUESTION:String = 'personal_bag_question';
        public static const PERSONAL_INJURY:String = 'personal_injury';
        public static const PERSONAL_PLACES:String = 'personal_places';
        public static const PERSONAL_VIDEO:String = 'personal_video';
        public static const PEST_CONTROL:String = 'pest_control';
        public static const PEST_CONTROL_RODENT:String = 'pest_control_rodent';
        public static const PET_SUPPLIES:String = 'pet_supplies';
        public static const PETS:String = 'pets';
        public static const PHISHING:String = 'phishing';
        public static const PHONE:String = 'phone';
        public static const PHONE_ANDROID:String = 'phone_android';
        public static const PHONE_BLUETOOTH_SPEAKER:String = 'phone_bluetooth_speaker';
        public static const PHONE_CALLBACK:String = 'phone_callback';
        public static const PHONE_DISABLED:String = 'phone_disabled';
        public static const PHONE_ENABLED:String = 'phone_enabled';
        public static const PHONE_FORWARDED:String = 'phone_forwarded';
        public static const PHONE_IN_TALK:String = 'phone_in_talk';
        public static const PHONE_IN_TALK_WATCHFACE_INDICATOR:String = 'phone_in_talk_watchface_indicator';
        public static const PHONE_IPHONE:String = 'phone_iphone';
        public static const PHONE_LOCKED:String = 'phone_locked';
        public static const PHONE_MISSED:String = 'phone_missed';
        public static const PHONE_PAUSED:String = 'phone_paused';
        public static const PHONELINK:String = 'phonelink';
        public static const PHONELINK_ERASE:String = 'phonelink_erase';
        public static const PHONELINK_LOCK:String = 'phonelink_lock';
        public static const PHONELINK_OFF:String = 'phonelink_off';
        public static const PHONELINK_RING:String = 'phonelink_ring';
        public static const PHONELINK_RING_OFF:String = 'phonelink_ring_off';
        public static const PHONELINK_SETUP:String = 'phonelink_setup';
        public static const PHOTO:String = 'photo';
        public static const PHOTO_ALBUM:String = 'photo_album';
        public static const PHOTO_AUTO_MERGE:String = 'photo_auto_merge';
        public static const PHOTO_CAMERA:String = 'photo_camera';
        public static const PHOTO_CAMERA_BACK:String = 'photo_camera_back';
        public static const PHOTO_CAMERA_FRONT:String = 'photo_camera_front';
        public static const PHOTO_FILTER:String = 'photo_filter';
        public static const PHOTO_FRAME:String = 'photo_frame';
        public static const PHOTO_LIBRARY:String = 'photo_library';
        public static const PHOTO_PRINTS:String = 'photo_prints';
        public static const PHOTO_SIZE_SELECT_ACTUAL:String = 'photo_size_select_actual';
        public static const PHOTO_SIZE_SELECT_LARGE:String = 'photo_size_select_large';
        public static const PHOTO_SIZE_SELECT_SMALL:String = 'photo_size_select_small';
        public static const PHP:String = 'php';
        public static const PHYSICAL_THERAPY:String = 'physical_therapy';
        public static const PIANO:String = 'piano';
        public static const PIANO_OFF:String = 'piano_off';
        public static const PICTURE_AS_PDF:String = 'picture_as_pdf';
        public static const PICTURE_IN_PICTURE:String = 'picture_in_picture';
        public static const PICTURE_IN_PICTURE_ALT:String = 'picture_in_picture_alt';
        public static const PICTURE_IN_PICTURE_CENTER:String = 'picture_in_picture_center';
        public static const PICTURE_IN_PICTURE_LARGE:String = 'picture_in_picture_large';
        public static const PICTURE_IN_PICTURE_MEDIUM:String = 'picture_in_picture_medium';
        public static const PICTURE_IN_PICTURE_MOBILE:String = 'picture_in_picture_mobile';
        public static const PICTURE_IN_PICTURE_OFF:String = 'picture_in_picture_off';
        public static const PICTURE_IN_PICTURE_SMALL:String = 'picture_in_picture_small';
        public static const PIE_CHART:String = 'pie_chart';
        public static const PIE_CHART_OUTLINE:String = 'pie_chart_outline';
        public static const PIE_CHART_OUTLINED:String = 'pie_chart_outlined';
        public static const PILL:String = 'pill';
        public static const PILL_OFF:String = 'pill_off';
        public static const PIN:String = 'pin';
        public static const PIN_DROP:String = 'pin_drop';
        public static const PIN_END:String = 'pin_end';
        public static const PIN_INVOKE:String = 'pin_invoke';
        public static const PINCH:String = 'pinch';
        public static const PINCH_ZOOM_IN:String = 'pinch_zoom_in';
        public static const PINCH_ZOOM_OUT:String = 'pinch_zoom_out';
        public static const PIP:String = 'pip';
        public static const PIP_EXIT:String = 'pip_exit';
        public static const PIVOT_TABLE_CHART:String = 'pivot_table_chart';
        public static const PIX:String = 'pix';
        public static const PIXEL_3_3XL_3A:String = 'pixel_3_3xl_3a';
        public static const PLACE:String = 'place';
        public static const PLACE_ITEM:String = 'place_item';
        public static const PLAGIARISM:String = 'plagiarism';
        public static const PLANNER_BANNER_AD_PT:String = 'planner_banner_ad_pt';
        public static const PLANNER_REVIEW:String = 'planner_review';
        public static const PLAY_ARROW:String = 'play_arrow';
        public static const PLAY_CIRCLE:String = 'play_circle';
        public static const PLAY_CIRCLE_FILLED:String = 'play_circle_filled';
        public static const PLAY_CIRCLE_OUTLINE:String = 'play_circle_outline';
        public static const PLAY_DISABLED:String = 'play_disabled';
        public static const PLAY_FOR_WORK:String = 'play_for_work';
        public static const PLAY_LESSON:String = 'play_lesson';
        public static const PLAY_PASS:String = 'play_pass';
        public static const PLAY_PAUSE:String = 'play_pause';
        public static const PLAY_SHAPES:String = 'play_shapes';
        public static const PLAYING_CARDS:String = 'playing_cards';
        public static const PLAYLIST_ADD:String = 'playlist_add';
        public static const PLAYLIST_ADD_CHECK:String = 'playlist_add_check';
        public static const PLAYLIST_ADD_CHECK_CIRCLE:String = 'playlist_add_check_circle';
        public static const PLAYLIST_ADD_CIRCLE:String = 'playlist_add_circle';
        public static const PLAYLIST_PLAY:String = 'playlist_play';
        public static const PLAYLIST_REMOVE:String = 'playlist_remove';
        public static const PLUMBING:String = 'plumbing';
        public static const PLUS_ONE:String = 'plus_one';
        public static const PODCASTS:String = 'podcasts';
        public static const PODIATRY:String = 'podiatry';
        public static const PODIUM:String = 'podium';
        public static const POINT_OF_SALE:String = 'point_of_sale';
        public static const POINT_SCAN:String = 'point_scan';
        public static const POLICY:String = 'policy';
        public static const POLL:String = 'poll';
        public static const POLYLINE:String = 'polyline';
        public static const POLYMER:String = 'polymer';
        public static const POOL:String = 'pool';
        public static const PORTABLE_WIFI_OFF:String = 'portable_wifi_off';
        public static const PORTRAIT:String = 'portrait';
        public static const PORTRAIT_LIGHTING:String = 'portrait_lighting';
        public static const PORTRAIT_LIGHTING_OFF:String = 'portrait_lighting_off';
        public static const POSITION_BOTTOM_LEFT:String = 'position_bottom_left';
        public static const POSITION_BOTTOM_RIGHT:String = 'position_bottom_right';
        public static const POSITION_TOP_RIGHT:String = 'position_top_right';
        public static const POST:String = 'post';
        public static const POST_ADD:String = 'post_add';
        public static const POTTED_PLANT:String = 'potted_plant';
        public static const POWER:String = 'power';
        public static const POWER_INPUT:String = 'power_input';
        public static const POWER_OFF:String = 'power_off';
        public static const POWER_ROUNDED:String = 'power_rounded';
        public static const POWER_SETTINGS_NEW:String = 'power_settings_new';
        public static const PRAYER_TIMES:String = 'prayer_times';
        public static const PRECISION_MANUFACTURING:String = 'precision_manufacturing';
        public static const PREGNANCY:String = 'pregnancy';
        public static const PREGNANT_WOMAN:String = 'pregnant_woman';
        public static const PRELIMINARY:String = 'preliminary';
        public static const PRESCRIPTIONS:String = 'prescriptions';
        public static const PRESENT_TO_ALL:String = 'present_to_all';
        public static const PREVIEW:String = 'preview';
        public static const PREVIEW_OFF:String = 'preview_off';
        public static const PRICE_CHANGE:String = 'price_change';
        public static const PRICE_CHECK:String = 'price_check';
        public static const PRINT:String = 'print';
        public static const PRINT_ADD:String = 'print_add';
        public static const PRINT_CONNECT:String = 'print_connect';
        public static const PRINT_DISABLED:String = 'print_disabled';
        public static const PRINT_ERROR:String = 'print_error';
        public static const PRINT_LOCK:String = 'print_lock';
        public static const PRIORITY:String = 'priority';
        public static const PRIORITY_HIGH:String = 'priority_high';
        public static const PRIVACY:String = 'privacy';
        public static const PRIVACY_SCREEN:String = 'privacy_screen';
        public static const PRIVACY_SCREEN_OFF:String = 'privacy_screen_off';
        public static const PRIVACY_TIP:String = 'privacy_tip';
        public static const PRIVATE_CONNECTIVITY:String = 'private_connectivity';
        public static const PROBLEM:String = 'problem';
        public static const PROCEDURE:String = 'procedure';
        public static const PROCESS_CHART:String = 'process_chart';
        public static const PRODUCTION_QUANTITY_LIMITS:String = 'production_quantity_limits';
        public static const PRODUCTIVITY:String = 'productivity';
        public static const PROGRESS_ACTIVITY:String = 'progress_activity';
        public static const PROMPT_SUGGESTION:String = 'prompt_suggestion';
        public static const PROPANE:String = 'propane';
        public static const PROPANE_TANK:String = 'propane_tank';
        public static const PSYCHIATRY:String = 'psychiatry';
        public static const PSYCHOLOGY:String = 'psychology';
        public static const PSYCHOLOGY_ALT:String = 'psychology_alt';
        public static const PUBLIC:String = 'public';
        public static const PUBLIC_OFF:String = 'public_off';
        public static const PUBLISH:String = 'publish';
        public static const PUBLISHED_WITH_CHANGES:String = 'published_with_changes';
        public static const PULMONOLOGY:String = 'pulmonology';
        public static const PULSE_ALERT:String = 'pulse_alert';
        public static const PUNCH_CLOCK:String = 'punch_clock';
        public static const PUSH_PIN:String = 'push_pin';
        public static const QR_CODE:String = 'qr_code';
        public static const QR_CODE_2:String = 'qr_code_2';
        public static const QR_CODE_2_ADD:String = 'qr_code_2_add';
        public static const QR_CODE_SCANNER:String = 'qr_code_scanner';
        public static const QUERY_BUILDER:String = 'query_builder';
        public static const QUERY_STATS:String = 'query_stats';
        public static const QUESTION_ANSWER:String = 'question_answer';
        public static const QUESTION_EXCHANGE:String = 'question_exchange';
        public static const QUESTION_MARK:String = 'question_mark';
        public static const QUEUE:String = 'queue';
        public static const QUEUE_MUSIC:String = 'queue_music';
        public static const QUEUE_PLAY_NEXT:String = 'queue_play_next';
        public static const QUICK_PHRASES:String = 'quick_phrases';
        public static const QUICK_REFERENCE:String = 'quick_reference';
        public static const QUICK_REFERENCE_ALL:String = 'quick_reference_all';
        public static const QUICK_REORDER:String = 'quick_reorder';
        public static const QUICKREPLY:String = 'quickreply';
        public static const QUIET_TIME:String = 'quiet_time';
        public static const QUIET_TIME_ACTIVE:String = 'quiet_time_active';
        public static const QUIZ:String = 'quiz';
        public static const R_MOBILEDATA:String = 'r_mobiledata';
        public static const RADAR:String = 'radar';
        public static const RADIO:String = 'radio';
        public static const RADIO_BUTTON_CHECKED:String = 'radio_button_checked';
        public static const RADIO_BUTTON_PARTIAL:String = 'radio_button_partial';
        public static const RADIO_BUTTON_UNCHECKED:String = 'radio_button_unchecked';
        public static const RADIOLOGY:String = 'radiology';
        public static const RAILWAY_ALERT:String = 'railway_alert';
        public static const RAINY:String = 'rainy';
        public static const RAINY_HEAVY:String = 'rainy_heavy';
        public static const RAINY_LIGHT:String = 'rainy_light';
        public static const RAINY_SNOW:String = 'rainy_snow';
        public static const RAMEN_DINING:String = 'ramen_dining';
        public static const RAMP_LEFT:String = 'ramp_left';
        public static const RAMP_RIGHT:String = 'ramp_right';
        public static const RANGE_HOOD:String = 'range_hood';
        public static const RATE_REVIEW:String = 'rate_review';
        public static const RAVEN:String = 'raven';
        public static const RAW_OFF:String = 'raw_off';
        public static const RAW_ON:String = 'raw_on';
        public static const READ_MORE:String = 'read_more';
        public static const READINESS_SCORE:String = 'readiness_score';
        public static const REAL_ESTATE_AGENT:String = 'real_estate_agent';
        public static const REAR_CAMERA:String = 'rear_camera';
        public static const REBASE:String = 'rebase';
        public static const REBASE_EDIT:String = 'rebase_edit';
        public static const RECEIPT:String = 'receipt';
        public static const RECEIPT_LONG:String = 'receipt_long';
        public static const RECENT_ACTORS:String = 'recent_actors';
        public static const RECENT_PATIENT:String = 'recent_patient';
        public static const RECOMMEND:String = 'recommend';
        public static const RECORD_VOICE_OVER:String = 'record_voice_over';
        public static const RECTANGLE:String = 'rectangle';
        public static const RECYCLING:String = 'recycling';
        public static const REDEEM:String = 'redeem';
        public static const REDO:String = 'redo';
        public static const REDUCE_CAPACITY:String = 'reduce_capacity';
        public static const REFRESH:String = 'refresh';
        public static const REGULAR_EXPRESSION:String = 'regular_expression';
        public static const RELAX:String = 'relax';
        public static const RELEASE_ALERT:String = 'release_alert';
        public static const REMEMBER_ME:String = 'remember_me';
        public static const REMINDER:String = 'reminder';
        public static const REMOTE_GEN:String = 'remote_gen';
        public static const REMOVE:String = 'remove';
        public static const REMOVE_CIRCLE:String = 'remove_circle';
        public static const REMOVE_CIRCLE_OUTLINE:String = 'remove_circle_outline';
        public static const REMOVE_DONE:String = 'remove_done';
        public static const REMOVE_FROM_QUEUE:String = 'remove_from_queue';
        public static const REMOVE_MODERATOR:String = 'remove_moderator';
        public static const REMOVE_RED_EYE:String = 'remove_red_eye';
        public static const REMOVE_ROAD:String = 'remove_road';
        public static const REMOVE_SELECTION:String = 'remove_selection';
        public static const REMOVE_SHOPPING_CART:String = 'remove_shopping_cart';
        public static const REOPEN_WINDOW:String = 'reopen_window';
        public static const REORDER:String = 'reorder';
        public static const REPARTITION:String = 'repartition';
        public static const REPEAT:String = 'repeat';
        public static const REPEAT_ON:String = 'repeat_on';
        public static const REPEAT_ONE:String = 'repeat_one';
        public static const REPEAT_ONE_ON:String = 'repeat_one_on';
        public static const REPLAY:String = 'replay';
        public static const REPLAY_10:String = 'replay_10';
        public static const REPLAY_30:String = 'replay_30';
        public static const REPLAY_5:String = 'replay_5';
        public static const REPLAY_CIRCLE_FILLED:String = 'replay_circle_filled';
        public static const REPLY:String = 'reply';
        public static const REPLY_ALL:String = 'reply_all';
        public static const REPORT:String = 'report';
        public static const REPORT_GMAILERRORRED:String = 'report_gmailerrorred';
        public static const REPORT_OFF:String = 'report_off';
        public static const REPORT_PROBLEM:String = 'report_problem';
        public static const REQUEST_PAGE:String = 'request_page';
        public static const REQUEST_QUOTE:String = 'request_quote';
        public static const RESET_IMAGE:String = 'reset_image';
        public static const RESET_TV:String = 'reset_tv';
        public static const RESET_WRENCH:String = 'reset_wrench';
        public static const RESIZE:String = 'resize';
        public static const RESPIRATORY_RATE:String = 'respiratory_rate';
        public static const RESPONSIVE_LAYOUT:String = 'responsive_layout';
        public static const RESTART_ALT:String = 'restart_alt';
        public static const RESTAURANT:String = 'restaurant';
        public static const RESTAURANT_MENU:String = 'restaurant_menu';
        public static const RESTORE:String = 'restore';
        public static const RESTORE_FROM_TRASH:String = 'restore_from_trash';
        public static const RESTORE_PAGE:String = 'restore_page';
        public static const RESUME:String = 'resume';
        public static const RETENTION:String = 'retention';
        public static const REVIEWS:String = 'reviews';
        public static const REWARDED_ADS:String = 'rewarded_ads';
        public static const RHEUMATOLOGY:String = 'rheumatology';
        public static const RIB_CAGE:String = 'rib_cage';
        public static const RICE_BOWL:String = 'rice_bowl';
        public static const RIGHT_CLICK:String = 'right_click';
        public static const RIGHT_PANEL_CLOSE:String = 'right_panel_close';
        public static const RIGHT_PANEL_OPEN:String = 'right_panel_open';
        public static const RING_VOLUME:String = 'ring_volume';
        public static const RIPPLES:String = 'ripples';
        public static const ROBOT:String = 'robot';
        public static const ROBOT_2:String = 'robot_2';
        public static const ROCKET:String = 'rocket';
        public static const ROCKET_LAUNCH:String = 'rocket_launch';
        public static const ROLLER_SHADES:String = 'roller_shades';
        public static const ROLLER_SHADES_CLOSED:String = 'roller_shades_closed';
        public static const ROLLER_SKATING:String = 'roller_skating';
        public static const ROOFING:String = 'roofing';
        public static const ROOM:String = 'room';
        public static const ROOM_PREFERENCES:String = 'room_preferences';
        public static const ROOM_SERVICE:String = 'room_service';
        public static const ROTATE_90_DEGREES_CCW:String = 'rotate_90_degrees_ccw';
        public static const ROTATE_90_DEGREES_CW:String = 'rotate_90_degrees_cw';
        public static const ROTATE_LEFT:String = 'rotate_left';
        public static const ROTATE_RIGHT:String = 'rotate_right';
        public static const ROUNDABOUT_LEFT:String = 'roundabout_left';
        public static const ROUNDABOUT_RIGHT:String = 'roundabout_right';
        public static const ROUNDED_CORNER:String = 'rounded_corner';
        public static const ROUTE:String = 'route';
        public static const ROUTER:String = 'router';
        public static const ROUTINE:String = 'routine';
        public static const ROWING:String = 'rowing';
        public static const RSS_FEED:String = 'rss_feed';
        public static const RSVP:String = 'rsvp';
        public static const RTT:String = 'rtt';
        public static const RUBRIC:String = 'rubric';
        public static const RULE:String = 'rule';
        public static const RULE_FOLDER:String = 'rule_folder';
        public static const RULE_SETTINGS:String = 'rule_settings';
        public static const RUN_CIRCLE:String = 'run_circle';
        public static const RUNNING_WITH_ERRORS:String = 'running_with_errors';
        public static const RV_HOOKUP:String = 'rv_hookup';
        public static const SAD_TAB:String = 'sad_tab';
        public static const SAFETY_CHECK:String = 'safety_check';
        public static const SAFETY_CHECK_OFF:String = 'safety_check_off';
        public static const SAFETY_DIVIDER:String = 'safety_divider';
        public static const SAILING:String = 'sailing';
        public static const SALINITY:String = 'salinity';
        public static const SANITIZER:String = 'sanitizer';
        public static const SATELLITE:String = 'satellite';
        public static const SATELLITE_ALT:String = 'satellite_alt';
        public static const SAUNA:String = 'sauna';
        public static const SAVE:String = 'save';
        public static const SAVE_ALT:String = 'save_alt';
        public static const SAVE_AS:String = 'save_as';
        public static const SAVED_SEARCH:String = 'saved_search';
        public static const SAVINGS:String = 'savings';
        public static const SCALE:String = 'scale';
        public static const SCAN:String = 'scan';
        public static const SCAN_DELETE:String = 'scan_delete';
        public static const SCANNER:String = 'scanner';
        public static const SCATTER_PLOT:String = 'scatter_plot';
        public static const SCENE:String = 'scene';
        public static const SCHEDULE:String = 'schedule';
        public static const SCHEDULE_SEND:String = 'schedule_send';
        public static const SCHEMA:String = 'schema';
        public static const SCHOOL:String = 'school';
        public static const SCIENCE:String = 'science';
        public static const SCIENCE_OFF:String = 'science_off';
        public static const SCORE:String = 'score';
        public static const SCOREBOARD:String = 'scoreboard';
        public static const SCREEN_ATTENTION:String = 'screen_attention';
        public static const SCREEN_ATTENTION_OFF:String = 'screen_attention_off';
        public static const SCREEN_LOCK_LANDSCAPE:String = 'screen_lock_landscape';
        public static const SCREEN_LOCK_PORTRAIT:String = 'screen_lock_portrait';
        public static const SCREEN_LOCK_ROTATION:String = 'screen_lock_rotation';
        public static const SCREEN_RECORD:String = 'screen_record';
        public static const SCREEN_ROTATION:String = 'screen_rotation';
        public static const SCREEN_ROTATION_ALT:String = 'screen_rotation_alt';
        public static const SCREEN_ROTATION_UP:String = 'screen_rotation_up';
        public static const SCREEN_SEARCH_DESKTOP:String = 'screen_search_desktop';
        public static const SCREEN_SHARE:String = 'screen_share';
        public static const SCREENCAST:String = 'screencast';
        public static const SCREENSHOT:String = 'screenshot';
        public static const SCREENSHOT_FRAME:String = 'screenshot_frame';
        public static const SCREENSHOT_KEYBOARD:String = 'screenshot_keyboard';
        public static const SCREENSHOT_MONITOR:String = 'screenshot_monitor';
        public static const SCREENSHOT_REGION:String = 'screenshot_region';
        public static const SCREENSHOT_TABLET:String = 'screenshot_tablet';
        public static const SCROLLABLE_HEADER:String = 'scrollable_header';
        public static const SCUBA_DIVING:String = 'scuba_diving';
        public static const SD:String = 'sd';
        public static const SD_CARD:String = 'sd_card';
        public static const SD_CARD_ALERT:String = 'sd_card_alert';
        public static const SD_STORAGE:String = 'sd_storage';
        public static const SDK:String = 'sdk';
        public static const SEARCH:String = 'search';
        public static const SEARCH_CHECK:String = 'search_check';
        public static const SEARCH_HANDS_FREE:String = 'search_hands_free';
        public static const SEARCH_OFF:String = 'search_off';
        public static const SECURITY:String = 'security';
        public static const SECURITY_KEY:String = 'security_key';
        public static const SECURITY_PRO_MONITORING:String = 'security_pro_monitoring';
        public static const SECURITY_UPDATE:String = 'security_update';
        public static const SECURITY_UPDATE_GOOD:String = 'security_update_good';
        public static const SECURITY_UPDATE_WARNING:String = 'security_update_warning';
        public static const SEGMENT:String = 'segment';
        public static const SELECT:String = 'select';
        public static const SELECT_ALL:String = 'select_all';
        public static const SELECT_CHECK_BOX:String = 'select_check_box';
        public static const SELECT_TO_SPEAK:String = 'select_to_speak';
        public static const SELECT_WINDOW:String = 'select_window';
        public static const SELECT_WINDOW_OFF:String = 'select_window_off';
        public static const SELF_CARE:String = 'self_care';
        public static const SELF_IMPROVEMENT:String = 'self_improvement';
        public static const SELL:String = 'sell';
        public static const SEND:String = 'send';
        public static const SEND_AND_ARCHIVE:String = 'send_and_archive';
        public static const SEND_MONEY:String = 'send_money';
        public static const SEND_TIME_EXTENSION:String = 'send_time_extension';
        public static const SEND_TO_MOBILE:String = 'send_to_mobile';
        public static const SENSOR_DOOR:String = 'sensor_door';
        public static const SENSOR_OCCUPIED:String = 'sensor_occupied';
        public static const SENSOR_WINDOW:String = 'sensor_window';
        public static const SENSORS:String = 'sensors';
        public static const SENSORS_KRX:String = 'sensors_krx';
        public static const SENSORS_KRX_OFF:String = 'sensors_krx_off';
        public static const SENSORS_OFF:String = 'sensors_off';
        public static const SENTIMENT_CALM:String = 'sentiment_calm';
        public static const SENTIMENT_CONTENT:String = 'sentiment_content';
        public static const SENTIMENT_DISSATISFIED:String = 'sentiment_dissatisfied';
        public static const SENTIMENT_EXCITED:String = 'sentiment_excited';
        public static const SENTIMENT_EXTREMELY_DISSATISFIED:String = 'sentiment_extremely_dissatisfied';
        public static const SENTIMENT_FRUSTRATED:String = 'sentiment_frustrated';
        public static const SENTIMENT_NEUTRAL:String = 'sentiment_neutral';
        public static const SENTIMENT_SAD:String = 'sentiment_sad';
        public static const SENTIMENT_SATISFIED:String = 'sentiment_satisfied';
        public static const SENTIMENT_SATISFIED_ALT:String = 'sentiment_satisfied_alt';
        public static const SENTIMENT_STRESSED:String = 'sentiment_stressed';
        public static const SENTIMENT_VERY_DISSATISFIED:String = 'sentiment_very_dissatisfied';
        public static const SENTIMENT_VERY_SATISFIED:String = 'sentiment_very_satisfied';
        public static const SENTIMENT_WORRIED:String = 'sentiment_worried';
        public static const SERVICE_DIRECTORY:String = 'service_directory';
        public static const SERVICE_TOOLBOX:String = 'service_toolbox';
        public static const SET_MEAL:String = 'set_meal';
        public static const SETTINGS:String = 'settings';
        public static const SETTINGS_ACCESSIBILITY:String = 'settings_accessibility';
        public static const SETTINGS_ACCOUNT_BOX:String = 'settings_account_box';
        public static const SETTINGS_ALERT:String = 'settings_alert';
        public static const SETTINGS_APPLICATIONS:String = 'settings_applications';
        public static const SETTINGS_B_ROLL:String = 'settings_b_roll';
        public static const SETTINGS_BACKUP_RESTORE:String = 'settings_backup_restore';
        public static const SETTINGS_BLUETOOTH:String = 'settings_bluetooth';
        public static const SETTINGS_BRIGHTNESS:String = 'settings_brightness';
        public static const SETTINGS_CELL:String = 'settings_cell';
        public static const SETTINGS_CINEMATIC_BLUR:String = 'settings_cinematic_blur';
        public static const SETTINGS_ETHERNET:String = 'settings_ethernet';
        public static const SETTINGS_HEART:String = 'settings_heart';
        public static const SETTINGS_INPUT_ANTENNA:String = 'settings_input_antenna';
        public static const SETTINGS_INPUT_COMPONENT:String = 'settings_input_component';
        public static const SETTINGS_INPUT_COMPOSITE:String = 'settings_input_composite';
        public static const SETTINGS_INPUT_HDMI:String = 'settings_input_hdmi';
        public static const SETTINGS_INPUT_SVIDEO:String = 'settings_input_svideo';
        public static const SETTINGS_MOTION_MODE:String = 'settings_motion_mode';
        public static const SETTINGS_NIGHT_SIGHT:String = 'settings_night_sight';
        public static const SETTINGS_OVERSCAN:String = 'settings_overscan';
        public static const SETTINGS_PANORAMA:String = 'settings_panorama';
        public static const SETTINGS_PHONE:String = 'settings_phone';
        public static const SETTINGS_PHOTO_CAMERA:String = 'settings_photo_camera';
        public static const SETTINGS_POWER:String = 'settings_power';
        public static const SETTINGS_REMOTE:String = 'settings_remote';
        public static const SETTINGS_SLOW_MOTION:String = 'settings_slow_motion';
        public static const SETTINGS_SUGGEST:String = 'settings_suggest';
        public static const SETTINGS_SYSTEM_DAYDREAM:String = 'settings_system_daydream';
        public static const SETTINGS_TIMELAPSE:String = 'settings_timelapse';
        public static const SETTINGS_VIDEO_CAMERA:String = 'settings_video_camera';
        public static const SETTINGS_VOICE:String = 'settings_voice';
        public static const SETTOP_COMPONENT:String = 'settop_component';
        public static const SEVERE_COLD:String = 'severe_cold';
        public static const SHADOW:String = 'shadow';
        public static const SHADOW_ADD:String = 'shadow_add';
        public static const SHADOW_MINUS:String = 'shadow_minus';
        public static const SHAPE_LINE:String = 'shape_line';
        public static const SHAPES:String = 'shapes';
        public static const SHARE:String = 'share';
        public static const SHARE_LOCATION:String = 'share_location';
        public static const SHARE_OFF:String = 'share_off';
        public static const SHARE_REVIEWS:String = 'share_reviews';
        public static const SHARE_WINDOWS:String = 'share_windows';
        public static const SHEETS_ADD_ON:String = 'sheets_add_on';
        public static const SHEETS_APPS_SCRIPT:String = 'sheets_apps_script';
        public static const SHEETS_RTL:String = 'sheets_rtl';
        public static const SHELF_AUTO_HIDE:String = 'shelf_auto_hide';
        public static const SHELF_POSITION:String = 'shelf_position';
        public static const SHELVES:String = 'shelves';
        public static const SHIELD:String = 'shield';
        public static const SHIELD_LOCK:String = 'shield_lock';
        public static const SHIELD_LOCKED:String = 'shield_locked';
        public static const SHIELD_MOON:String = 'shield_moon';
        public static const SHIELD_PERSON:String = 'shield_person';
        public static const SHIELD_QUESTION:String = 'shield_question';
        public static const SHIELD_SPARK:String = 'shield_spark';
        public static const SHIELD_WITH_HEART:String = 'shield_with_heart';
        public static const SHIELD_WITH_HOUSE:String = 'shield_with_house';
        public static const SHIFT:String = 'shift';
        public static const SHIFT_LOCK:String = 'shift_lock';
        public static const SHOP:String = 'shop';
        public static const SHOP_2:String = 'shop_2';
        public static const SHOP_TWO:String = 'shop_two';
        public static const SHOPPING_BAG:String = 'shopping_bag';
        public static const SHOPPING_BASKET:String = 'shopping_basket';
        public static const SHOPPING_CART:String = 'shopping_cart';
        public static const SHOPPING_CART_CHECKOUT:String = 'shopping_cart_checkout';
        public static const SHOPPING_CART_OFF:String = 'shopping_cart_off';
        public static const SHOPPINGMODE:String = 'shoppingmode';
        public static const SHORT_STAY:String = 'short_stay';
        public static const SHORT_TEXT:String = 'short_text';
        public static const SHORTCUT:String = 'shortcut';
        public static const SHOW_CHART:String = 'show_chart';
        public static const SHOWER:String = 'shower';
        public static const SHUFFLE:String = 'shuffle';
        public static const SHUFFLE_ON:String = 'shuffle_on';
        public static const SHUTTER_SPEED:String = 'shutter_speed';
        public static const SHUTTER_SPEED_ADD:String = 'shutter_speed_add';
        public static const SHUTTER_SPEED_MINUS:String = 'shutter_speed_minus';
        public static const SICK:String = 'sick';
        public static const SIDE_NAVIGATION:String = 'side_navigation';
        public static const SIGN_LANGUAGE:String = 'sign_language';
        public static const SIGNAL_CELLULAR_0_BAR:String = 'signal_cellular_0_bar';
        public static const SIGNAL_CELLULAR_1_BAR:String = 'signal_cellular_1_bar';
        public static const SIGNAL_CELLULAR_2_BAR:String = 'signal_cellular_2_bar';
        public static const SIGNAL_CELLULAR_3_BAR:String = 'signal_cellular_3_bar';
        public static const SIGNAL_CELLULAR_4_BAR:String = 'signal_cellular_4_bar';
        public static const SIGNAL_CELLULAR_ADD:String = 'signal_cellular_add';
        public static const SIGNAL_CELLULAR_ALT:String = 'signal_cellular_alt';
        public static const SIGNAL_CELLULAR_ALT_1_BAR:String = 'signal_cellular_alt_1_bar';
        public static const SIGNAL_CELLULAR_ALT_2_BAR:String = 'signal_cellular_alt_2_bar';
        public static const SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_0_BAR:String = 'signal_cellular_connected_no_internet_0_bar';
        public static const SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_1_BAR:String = 'signal_cellular_connected_no_internet_1_bar';
        public static const SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_2_BAR:String = 'signal_cellular_connected_no_internet_2_bar';
        public static const SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_3_BAR:String = 'signal_cellular_connected_no_internet_3_bar';
        public static const SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_4_BAR:String = 'signal_cellular_connected_no_internet_4_bar';
        public static const SIGNAL_CELLULAR_NO_SIM:String = 'signal_cellular_no_sim';
        public static const SIGNAL_CELLULAR_NODATA:String = 'signal_cellular_nodata';
        public static const SIGNAL_CELLULAR_NULL:String = 'signal_cellular_null';
        public static const SIGNAL_CELLULAR_OFF:String = 'signal_cellular_off';
        public static const SIGNAL_CELLULAR_PAUSE:String = 'signal_cellular_pause';
        public static const SIGNAL_DISCONNECTED:String = 'signal_disconnected';
        public static const SIGNAL_WIFI_0_BAR:String = 'signal_wifi_0_bar';
        public static const SIGNAL_WIFI_1_BAR:String = 'signal_wifi_1_bar';
        public static const SIGNAL_WIFI_1_BAR_LOCK:String = 'signal_wifi_1_bar_lock';
        public static const SIGNAL_WIFI_2_BAR:String = 'signal_wifi_2_bar';
        public static const SIGNAL_WIFI_2_BAR_LOCK:String = 'signal_wifi_2_bar_lock';
        public static const SIGNAL_WIFI_3_BAR:String = 'signal_wifi_3_bar';
        public static const SIGNAL_WIFI_3_BAR_LOCK:String = 'signal_wifi_3_bar_lock';
        public static const SIGNAL_WIFI_4_BAR:String = 'signal_wifi_4_bar';
        public static const SIGNAL_WIFI_4_BAR_LOCK:String = 'signal_wifi_4_bar_lock';
        public static const SIGNAL_WIFI_BAD:String = 'signal_wifi_bad';
        public static const SIGNAL_WIFI_CONNECTED_NO_INTERNET_0:String = 'signal_wifi_connected_no_internet_0';
        public static const SIGNAL_WIFI_CONNECTED_NO_INTERNET_1:String = 'signal_wifi_connected_no_internet_1';
        public static const SIGNAL_WIFI_CONNECTED_NO_INTERNET_2:String = 'signal_wifi_connected_no_internet_2';
        public static const SIGNAL_WIFI_CONNECTED_NO_INTERNET_3:String = 'signal_wifi_connected_no_internet_3';
        public static const SIGNAL_WIFI_CONNECTED_NO_INTERNET_4:String = 'signal_wifi_connected_no_internet_4';
        public static const SIGNAL_WIFI_OFF:String = 'signal_wifi_off';
        public static const SIGNAL_WIFI_STATUSBAR_1_BAR:String = 'signal_wifi_statusbar_1_bar';
        public static const SIGNAL_WIFI_STATUSBAR_2_BAR:String = 'signal_wifi_statusbar_2_bar';
        public static const SIGNAL_WIFI_STATUSBAR_3_BAR:String = 'signal_wifi_statusbar_3_bar';
        public static const SIGNAL_WIFI_STATUSBAR_4_BAR:String = 'signal_wifi_statusbar_4_bar';
        public static const SIGNAL_WIFI_STATUSBAR_CONNECTED_NO_INTERNET:String = 'signal_wifi_statusbar_connected_no_internet';
        public static const SIGNAL_WIFI_STATUSBAR_CONNECTED_NO_INTERNET_1:String = 'signal_wifi_statusbar_connected_no_internet_1';
        public static const SIGNAL_WIFI_STATUSBAR_CONNECTED_NO_INTERNET_2:String = 'signal_wifi_statusbar_connected_no_internet_2';
        public static const SIGNAL_WIFI_STATUSBAR_CONNECTED_NO_INTERNET_3:String = 'signal_wifi_statusbar_connected_no_internet_3';
        public static const SIGNAL_WIFI_STATUSBAR_CONNECTED_NO_INTERNET_4:String = 'signal_wifi_statusbar_connected_no_internet_4';
        public static const SIGNAL_WIFI_STATUSBAR_NOT_CONNECTED:String = 'signal_wifi_statusbar_not_connected';
        public static const SIGNAL_WIFI_STATUSBAR_NULL:String = 'signal_wifi_statusbar_null';
        public static const SIGNATURE:String = 'signature';
        public static const SIGNPOST:String = 'signpost';
        public static const SIM_CARD:String = 'sim_card';
        public static const SIM_CARD_ALERT:String = 'sim_card_alert';
        public static const SIM_CARD_DOWNLOAD:String = 'sim_card_download';
        public static const SINGLE_BED:String = 'single_bed';
        public static const SIP:String = 'sip';
        public static const SKATEBOARDING:String = 'skateboarding';
        public static const SKELETON:String = 'skeleton';
        public static const SKILLET:String = 'skillet';
        public static const SKILLET_COOKTOP:String = 'skillet_cooktop';
        public static const SKIP_NEXT:String = 'skip_next';
        public static const SKIP_PREVIOUS:String = 'skip_previous';
        public static const SKULL:String = 'skull';
        public static const SLEDDING:String = 'sledding';
        public static const SLEEP:String = 'sleep';
        public static const SLEEP_SCORE:String = 'sleep_score';
        public static const SLIDE_LIBRARY:String = 'slide_library';
        public static const SLIDERS:String = 'sliders';
        public static const SLIDES_ADD_ON:String = 'slides_add_on';
        public static const SLIDES_APPS_SCRIPT:String = 'slides_apps_script';
        public static const SLIDESHOW:String = 'slideshow';
        public static const SLOW_MOTION_VIDEO:String = 'slow_motion_video';
        public static const SMART_BUTTON:String = 'smart_button';
        public static const SMART_DISPLAY:String = 'smart_display';
        public static const SMART_OUTLET:String = 'smart_outlet';
        public static const SMART_SCREEN:String = 'smart_screen';
        public static const SMART_TOY:String = 'smart_toy';
        public static const SMART_VENTILATION:String = 'smart_ventilation';
        public static const SMARTPHONE:String = 'smartphone';
        public static const SMB_SHARE:String = 'smb_share';
        public static const SMOKE_FREE:String = 'smoke_free';
        public static const SMOKING_ROOMS:String = 'smoking_rooms';
        public static const SMS:String = 'sms';
        public static const SMS_FAILED:String = 'sms_failed';
        public static const SNIPPET_FOLDER:String = 'snippet_folder';
        public static const SNOOZE:String = 'snooze';
        public static const SNOWBOARDING:String = 'snowboarding';
        public static const SNOWING:String = 'snowing';
        public static const SNOWING_HEAVY:String = 'snowing_heavy';
        public static const SNOWMOBILE:String = 'snowmobile';
        public static const SNOWSHOEING:String = 'snowshoeing';
        public static const SOAP:String = 'soap';
        public static const SOCIAL_DISTANCE:String = 'social_distance';
        public static const SOCIAL_LEADERBOARD:String = 'social_leaderboard';
        public static const SOLAR_POWER:String = 'solar_power';
        public static const SORT:String = 'sort';
        public static const SORT_BY_ALPHA:String = 'sort_by_alpha';
        public static const SOS:String = 'sos';
        public static const SOUND_DETECTION_DOG_BARKING:String = 'sound_detection_dog_barking';
        public static const SOUND_DETECTION_GLASS_BREAK:String = 'sound_detection_glass_break';
        public static const SOUND_DETECTION_LOUD_SOUND:String = 'sound_detection_loud_sound';
        public static const SOUND_SAMPLER:String = 'sound_sampler';
        public static const SOUND_SENSING:String = 'sound_sensing';
        public static const SOUP_KITCHEN:String = 'soup_kitchen';
        public static const SOURCE:String = 'source';
        public static const SOURCE_ENVIRONMENT:String = 'source_environment';
        public static const SOURCE_NOTES:String = 'source_notes';
        public static const SOUTH:String = 'south';
        public static const SOUTH_AMERICA:String = 'south_america';
        public static const SOUTH_EAST:String = 'south_east';
        public static const SOUTH_WEST:String = 'south_west';
        public static const SPA:String = 'spa';
        public static const SPACE_BAR:String = 'space_bar';
        public static const SPACE_DASHBOARD:String = 'space_dashboard';
        public static const SPATIAL_AUDIO:String = 'spatial_audio';
        public static const SPATIAL_AUDIO_OFF:String = 'spatial_audio_off';
        public static const SPATIAL_TRACKING:String = 'spatial_tracking';
        public static const SPEAKER:String = 'speaker';
        public static const SPEAKER_GROUP:String = 'speaker_group';
        public static const SPEAKER_NOTES:String = 'speaker_notes';
        public static const SPEAKER_NOTES_OFF:String = 'speaker_notes_off';
        public static const SPEAKER_PHONE:String = 'speaker_phone';
        public static const SPECIAL_CHARACTER:String = 'special_character';
        public static const SPECIFIC_GRAVITY:String = 'specific_gravity';
        public static const SPEECH_TO_TEXT:String = 'speech_to_text';
        public static const SPEED:String = 'speed';
        public static const SPEED_0_5:String = 'speed_0_5';
        public static const SPEED_1_2:String = 'speed_1_2';
        public static const SPEED_1_5:String = 'speed_1_5';
        public static const SPEED_2X:String = 'speed_2x';
        public static const SPELLCHECK:String = 'spellcheck';
        public static const SPLITSCREEN:String = 'splitscreen';
        public static const SPLITSCREEN_ADD:String = 'splitscreen_add';
        public static const SPLITSCREEN_BOTTOM:String = 'splitscreen_bottom';
        public static const SPLITSCREEN_LEFT:String = 'splitscreen_left';
        public static const SPLITSCREEN_RIGHT:String = 'splitscreen_right';
        public static const SPLITSCREEN_TOP:String = 'splitscreen_top';
        public static const SPLITSCREEN_VERTICAL_ADD:String = 'splitscreen_vertical_add';
        public static const SPO2:String = 'spo2';
        public static const SPOKE:String = 'spoke';
        public static const SPOOF:String = 'spoof';
        public static const SPORTS:String = 'sports';
        public static const SPORTS_AND_OUTDOORS:String = 'sports_and_outdoors';
        public static const SPORTS_BAR:String = 'sports_bar';
        public static const SPORTS_BASEBALL:String = 'sports_baseball';
        public static const SPORTS_BASKETBALL:String = 'sports_basketball';
        public static const SPORTS_CRICKET:String = 'sports_cricket';
        public static const SPORTS_ESPORTS:String = 'sports_esports';
        public static const SPORTS_FOOTBALL:String = 'sports_football';
        public static const SPORTS_GOLF:String = 'sports_golf';
        public static const SPORTS_GYMNASTICS:String = 'sports_gymnastics';
        public static const SPORTS_HANDBALL:String = 'sports_handball';
        public static const SPORTS_HOCKEY:String = 'sports_hockey';
        public static const SPORTS_KABADDI:String = 'sports_kabaddi';
        public static const SPORTS_MARTIAL_ARTS:String = 'sports_martial_arts';
        public static const SPORTS_MMA:String = 'sports_mma';
        public static const SPORTS_MOTORSPORTS:String = 'sports_motorsports';
        public static const SPORTS_RUGBY:String = 'sports_rugby';
        public static const SPORTS_SCORE:String = 'sports_score';
        public static const SPORTS_SOCCER:String = 'sports_soccer';
        public static const SPORTS_TENNIS:String = 'sports_tennis';
        public static const SPORTS_VOLLEYBALL:String = 'sports_volleyball';
        public static const SPRINKLER:String = 'sprinkler';
        public static const SPRINT:String = 'sprint';
        public static const SQUARE:String = 'square';
        public static const SQUARE_FOOT:String = 'square_foot';
        public static const SSID_CHART:String = 'ssid_chart';
        public static const STABILIZATION:String = 'stabilization';
        public static const STABILIZATION_ACTION:String = 'stabilization_action';
        public static const STABILIZATION_LOCK:String = 'stabilization_lock';
        public static const STABILIZATION_PAN:String = 'stabilization_pan';
        public static const STACK:String = 'stack';
        public static const STACK_OFF:String = 'stack_off';
        public static const STACK_STAR:String = 'stack_star';
        public static const STACKED_BAR_CHART:String = 'stacked_bar_chart';
        public static const STACKED_EMAIL:String = 'stacked_email';
        public static const STACKED_INBOX:String = 'stacked_inbox';
        public static const STACKED_LINE_CHART:String = 'stacked_line_chart';
        public static const STACKS:String = 'stacks';
        public static const STADIA_CONTROLLER:String = 'stadia_controller';
        public static const STADIUM:String = 'stadium';
        public static const STAIRS:String = 'stairs';
        public static const STAR:String = 'star';
        public static const STAR_BORDER:String = 'star_border';
        public static const STAR_BORDER_PURPLE500:String = 'star_border_purple500';
        public static const STAR_HALF:String = 'star_half';
        public static const STAR_OUTLINE:String = 'star_outline';
        public static const STAR_PURPLE500:String = 'star_purple500';
        public static const STAR_RATE:String = 'star_rate';
        public static const STAR_RATE_HALF:String = 'star_rate_half';
        public static const STARS:String = 'stars';
        public static const START:String = 'start';
        public static const STAT_0:String = 'stat_0';
        public static const STAT_1:String = 'stat_1';
        public static const STAT_2:String = 'stat_2';
        public static const STAT_3:String = 'stat_3';
        public static const STAT_MINUS_1:String = 'stat_minus_1';
        public static const STAT_MINUS_2:String = 'stat_minus_2';
        public static const STAT_MINUS_3:String = 'stat_minus_3';
        public static const STATEFUL:String = 'stateful';
        public static const STAY_CURRENT_LANDSCAPE:String = 'stay_current_landscape';
        public static const STAY_CURRENT_PORTRAIT:String = 'stay_current_portrait';
        public static const STAY_PRIMARY_LANDSCAPE:String = 'stay_primary_landscape';
        public static const STAY_PRIMARY_PORTRAIT:String = 'stay_primary_portrait';
        public static const STEP:String = 'step';
        public static const STEP_INTO:String = 'step_into';
        public static const STEP_OUT:String = 'step_out';
        public static const STEP_OVER:String = 'step_over';
        public static const STEPPERS:String = 'steppers';
        public static const STEPS:String = 'steps';
        public static const STETHOSCOPE:String = 'stethoscope';
        public static const STETHOSCOPE_ARROW:String = 'stethoscope_arrow';
        public static const STETHOSCOPE_CHECK:String = 'stethoscope_check';
        public static const STICKY_NOTE:String = 'sticky_note';
        public static const STICKY_NOTE_2:String = 'sticky_note_2';
        public static const STOCK_MEDIA:String = 'stock_media';
        public static const STOCKPOT:String = 'stockpot';
        public static const STOP:String = 'stop';
        public static const STOP_CIRCLE:String = 'stop_circle';
        public static const STOP_SCREEN_SHARE:String = 'stop_screen_share';
        public static const STORAGE:String = 'storage';
        public static const STORE:String = 'store';
        public static const STORE_MALL_DIRECTORY:String = 'store_mall_directory';
        public static const STOREFRONT:String = 'storefront';
        public static const STORM:String = 'storm';
        public static const STRAIGHT:String = 'straight';
        public static const STRAIGHTEN:String = 'straighten';
        public static const STRATEGY:String = 'strategy';
        public static const STREAM:String = 'stream';
        public static const STREAM_APPS:String = 'stream_apps';
        public static const STREETVIEW:String = 'streetview';
        public static const STRESS_MANAGEMENT:String = 'stress_management';
        public static const STRIKETHROUGH_S:String = 'strikethrough_s';
        public static const STROKE_FULL:String = 'stroke_full';
        public static const STROKE_PARTIAL:String = 'stroke_partial';
        public static const STROLLER:String = 'stroller';
        public static const STYLE:String = 'style';
        public static const STYLER:String = 'styler';
        public static const STYLUS:String = 'stylus';
        public static const STYLUS_LASER_POINTER:String = 'stylus_laser_pointer';
        public static const STYLUS_NOTE:String = 'stylus_note';
        public static const SUBDIRECTORY_ARROW_LEFT:String = 'subdirectory_arrow_left';
        public static const SUBDIRECTORY_ARROW_RIGHT:String = 'subdirectory_arrow_right';
        public static const SUBHEADER:String = 'subheader';
        public static const SUBJECT:String = 'subject';
        public static const SUBSCRIPT:String = 'subscript';
        public static const SUBSCRIPTIONS:String = 'subscriptions';
        public static const SUBTITLES:String = 'subtitles';
        public static const SUBTITLES_OFF:String = 'subtitles_off';
        public static const SUBWAY:String = 'subway';
        public static const SUMMARIZE:String = 'summarize';
        public static const SUNNY:String = 'sunny';
        public static const SUNNY_SNOWING:String = 'sunny_snowing';
        public static const SUPERSCRIPT:String = 'superscript';
        public static const SUPERVISED_USER_CIRCLE:String = 'supervised_user_circle';
        public static const SUPERVISED_USER_CIRCLE_OFF:String = 'supervised_user_circle_off';
        public static const SUPERVISOR_ACCOUNT:String = 'supervisor_account';
        public static const SUPPORT:String = 'support';
        public static const SUPPORT_AGENT:String = 'support_agent';
        public static const SURFING:String = 'surfing';
        public static const SURGICAL:String = 'surgical';
        public static const SURROUND_SOUND:String = 'surround_sound';
        public static const SWAP_CALLS:String = 'swap_calls';
        public static const SWAP_DRIVING_APPS:String = 'swap_driving_apps';
        public static const SWAP_DRIVING_APPS_WHEEL:String = 'swap_driving_apps_wheel';
        public static const SWAP_HORIZ:String = 'swap_horiz';
        public static const SWAP_HORIZONTAL_CIRCLE:String = 'swap_horizontal_circle';
        public static const SWAP_VERT:String = 'swap_vert';
        public static const SWAP_VERTICAL_CIRCLE:String = 'swap_vertical_circle';
        public static const SWEEP:String = 'sweep';
        public static const SWIPE:String = 'swipe';
        public static const SWIPE_DOWN:String = 'swipe_down';
        public static const SWIPE_DOWN_ALT:String = 'swipe_down_alt';
        public static const SWIPE_LEFT:String = 'swipe_left';
        public static const SWIPE_LEFT_ALT:String = 'swipe_left_alt';
        public static const SWIPE_RIGHT:String = 'swipe_right';
        public static const SWIPE_RIGHT_ALT:String = 'swipe_right_alt';
        public static const SWIPE_UP:String = 'swipe_up';
        public static const SWIPE_UP_ALT:String = 'swipe_up_alt';
        public static const SWIPE_VERTICAL:String = 'swipe_vertical';
        public static const SWITCH:String = 'switch';
        public static const SWITCH_ACCESS:String = 'switch_access';
        public static const SWITCH_ACCESS_2:String = 'switch_access_2';
        public static const SWITCH_ACCESS_SHORTCUT:String = 'switch_access_shortcut';
        public static const SWITCH_ACCESS_SHORTCUT_ADD:String = 'switch_access_shortcut_add';
        public static const SWITCH_ACCOUNT:String = 'switch_account';
        public static const SWITCH_CAMERA:String = 'switch_camera';
        public static const SWITCH_LEFT:String = 'switch_left';
        public static const SWITCH_RIGHT:String = 'switch_right';
        public static const SWITCH_VIDEO:String = 'switch_video';
        public static const SWITCHES:String = 'switches';
        public static const SWORD_ROSE:String = 'sword_rose';
        public static const SWORDS:String = 'swords';
        public static const SYMPTOMS:String = 'symptoms';
        public static const SYNAGOGUE:String = 'synagogue';
        public static const SYNC:String = 'sync';
        public static const SYNC_ALT:String = 'sync_alt';
        public static const SYNC_DISABLED:String = 'sync_disabled';
        public static const SYNC_LOCK:String = 'sync_lock';
        public static const SYNC_PROBLEM:String = 'sync_problem';
        public static const SYNC_SAVED_LOCALLY:String = 'sync_saved_locally';
        public static const SYRINGE:String = 'syringe';
        public static const SYSTEM_SECURITY_UPDATE:String = 'system_security_update';
        public static const SYSTEM_SECURITY_UPDATE_GOOD:String = 'system_security_update_good';
        public static const SYSTEM_SECURITY_UPDATE_WARNING:String = 'system_security_update_warning';
        public static const SYSTEM_UPDATE:String = 'system_update';
        public static const SYSTEM_UPDATE_ALT:String = 'system_update_alt';
        public static const TAB:String = 'tab';
        public static const TAB_CLOSE:String = 'tab_close';
        public static const TAB_CLOSE_RIGHT:String = 'tab_close_right';
        public static const TAB_DUPLICATE:String = 'tab_duplicate';
        public static const TAB_GROUP:String = 'tab_group';
        public static const TAB_MOVE:String = 'tab_move';
        public static const TAB_NEW_RIGHT:String = 'tab_new_right';
        public static const TAB_RECENT:String = 'tab_recent';
        public static const TAB_UNSELECTED:String = 'tab_unselected';
        public static const TABLE:String = 'table';
        public static const TABLE_BAR:String = 'table_bar';
        public static const TABLE_CHART:String = 'table_chart';
        public static const TABLE_CHART_VIEW:String = 'table_chart_view';
        public static const TABLE_LAMP:String = 'table_lamp';
        public static const TABLE_RESTAURANT:String = 'table_restaurant';
        public static const TABLE_ROWS:String = 'table_rows';
        public static const TABLE_ROWS_NARROW:String = 'table_rows_narrow';
        public static const TABLE_VIEW:String = 'table_view';
        public static const TABLET:String = 'tablet';
        public static const TABLET_ANDROID:String = 'tablet_android';
        public static const TABLET_MAC:String = 'tablet_mac';
        public static const TABS:String = 'tabs';
        public static const TACTIC:String = 'tactic';
        public static const TAG:String = 'tag';
        public static const TAG_FACES:String = 'tag_faces';
        public static const TAKEOUT_DINING:String = 'takeout_dining';
        public static const TAMPER_DETECTION_OFF:String = 'tamper_detection_off';
        public static const TAMPER_DETECTION_ON:String = 'tamper_detection_on';
        public static const TAP_AND_PLAY:String = 'tap_and_play';
        public static const TAPAS:String = 'tapas';
        public static const TARGET:String = 'target';
        public static const TASK:String = 'task';
        public static const TASK_ALT:String = 'task_alt';
        public static const TAUNT:String = 'taunt';
        public static const TAXI_ALERT:String = 'taxi_alert';
        public static const TEAM_DASHBOARD:String = 'team_dashboard';
        public static const TEMP_PREFERENCES_CUSTOM:String = 'temp_preferences_custom';
        public static const TEMP_PREFERENCES_ECO:String = 'temp_preferences_eco';
        public static const TEMPLE_BUDDHIST:String = 'temple_buddhist';
        public static const TEMPLE_HINDU:String = 'temple_hindu';
        public static const TENANCY:String = 'tenancy';
        public static const TERMINAL:String = 'terminal';
        public static const TERRAIN:String = 'terrain';
        public static const TEXT_AD:String = 'text_ad';
        public static const TEXT_DECREASE:String = 'text_decrease';
        public static const TEXT_FIELDS:String = 'text_fields';
        public static const TEXT_FIELDS_ALT:String = 'text_fields_alt';
        public static const TEXT_FORMAT:String = 'text_format';
        public static const TEXT_INCREASE:String = 'text_increase';
        public static const TEXT_ROTATE_UP:String = 'text_rotate_up';
        public static const TEXT_ROTATE_VERTICAL:String = 'text_rotate_vertical';
        public static const TEXT_ROTATION_ANGLEDOWN:String = 'text_rotation_angledown';
        public static const TEXT_ROTATION_ANGLEUP:String = 'text_rotation_angleup';
        public static const TEXT_ROTATION_DOWN:String = 'text_rotation_down';
        public static const TEXT_ROTATION_NONE:String = 'text_rotation_none';
        public static const TEXT_SELECT_END:String = 'text_select_end';
        public static const TEXT_SELECT_JUMP_TO_BEGINNING:String = 'text_select_jump_to_beginning';
        public static const TEXT_SELECT_JUMP_TO_END:String = 'text_select_jump_to_end';
        public static const TEXT_SELECT_MOVE_BACK_CHARACTER:String = 'text_select_move_back_character';
        public static const TEXT_SELECT_MOVE_BACK_WORD:String = 'text_select_move_back_word';
        public static const TEXT_SELECT_MOVE_DOWN:String = 'text_select_move_down';
        public static const TEXT_SELECT_MOVE_FORWARD_CHARACTER:String = 'text_select_move_forward_character';
        public static const TEXT_SELECT_MOVE_FORWARD_WORD:String = 'text_select_move_forward_word';
        public static const TEXT_SELECT_MOVE_UP:String = 'text_select_move_up';
        public static const TEXT_SELECT_START:String = 'text_select_start';
        public static const TEXT_SNIPPET:String = 'text_snippet';
        public static const TEXT_TO_SPEECH:String = 'text_to_speech';
        public static const TEXTSMS:String = 'textsms';
        public static const TEXTURE:String = 'texture';
        public static const TEXTURE_ADD:String = 'texture_add';
        public static const TEXTURE_MINUS:String = 'texture_minus';
        public static const THEATER_COMEDY:String = 'theater_comedy';
        public static const THEATERS:String = 'theaters';
        public static const THERMOMETER:String = 'thermometer';
        public static const THERMOMETER_ADD:String = 'thermometer_add';
        public static const THERMOMETER_GAIN:String = 'thermometer_gain';
        public static const THERMOMETER_LOSS:String = 'thermometer_loss';
        public static const THERMOMETER_MINUS:String = 'thermometer_minus';
        public static const THERMOSTAT:String = 'thermostat';
        public static const THERMOSTAT_AUTO:String = 'thermostat_auto';
        public static const THERMOSTAT_CARBON:String = 'thermostat_carbon';
        public static const THINGS_TO_DO:String = 'things_to_do';
        public static const THREAD_UNREAD:String = 'thread_unread';
        public static const THUMB_DOWN:String = 'thumb_down';
        public static const THUMB_DOWN_ALT:String = 'thumb_down_alt';
        public static const THUMB_DOWN_OFF:String = 'thumb_down_off';
        public static const THUMB_DOWN_OFF_ALT:String = 'thumb_down_off_alt';
        public static const THUMB_UP:String = 'thumb_up';
        public static const THUMB_UP_ALT:String = 'thumb_up_alt';
        public static const THUMB_UP_OFF:String = 'thumb_up_off';
        public static const THUMB_UP_OFF_ALT:String = 'thumb_up_off_alt';
        public static const THUMBNAIL_BAR:String = 'thumbnail_bar';
        public static const THUMBS_UP_DOWN:String = 'thumbs_up_down';
        public static const THUNDERSTORM:String = 'thunderstorm';
        public static const TIBIA:String = 'tibia';
        public static const TIBIA_ALT:String = 'tibia_alt';
        public static const TIME_AUTO:String = 'time_auto';
        public static const TIME_TO_LEAVE:String = 'time_to_leave';
        public static const TIMELAPSE:String = 'timelapse';
        public static const TIMELINE:String = 'timeline';
        public static const TIMER:String = 'timer';
        public static const TIMER_10:String = 'timer_10';
        public static const TIMER_10_ALT_1:String = 'timer_10_alt_1';
        public static const TIMER_10_SELECT:String = 'timer_10_select';
        public static const TIMER_3:String = 'timer_3';
        public static const TIMER_3_ALT_1:String = 'timer_3_alt_1';
        public static const TIMER_3_SELECT:String = 'timer_3_select';
        public static const TIMER_OFF:String = 'timer_off';
        public static const TIPS_AND_UPDATES:String = 'tips_and_updates';
        public static const TIRE_REPAIR:String = 'tire_repair';
        public static const TITLE:String = 'title';
        public static const TOAST:String = 'toast';
        public static const TOC:String = 'toc';
        public static const TODAY:String = 'today';
        public static const TOGGLE_OFF:String = 'toggle_off';
        public static const TOGGLE_ON:String = 'toggle_on';
        public static const TOKEN:String = 'token';
        public static const TOLL:String = 'toll';
        public static const TONALITY:String = 'tonality';
        public static const TOOLBAR:String = 'toolbar';
        public static const TOOLS_FLAT_HEAD:String = 'tools_flat_head';
        public static const TOOLS_INSTALLATION_KIT:String = 'tools_installation_kit';
        public static const TOOLS_LADDER:String = 'tools_ladder';
        public static const TOOLS_LEVEL:String = 'tools_level';
        public static const TOOLS_PHILLIPS:String = 'tools_phillips';
        public static const TOOLS_PLIERS_WIRE_STRIPPER:String = 'tools_pliers_wire_stripper';
        public static const TOOLS_POWER_DRILL:String = 'tools_power_drill';
        public static const TOOLS_WRENCH:String = 'tools_wrench';
        public static const TOOLTIP:String = 'tooltip';
        public static const TOP_PANEL_CLOSE:String = 'top_panel_close';
        public static const TOP_PANEL_OPEN:String = 'top_panel_open';
        public static const TOPIC:String = 'topic';
        public static const TORNADO:String = 'tornado';
        public static const TOTAL_DISSOLVED_SOLIDS:String = 'total_dissolved_solids';
        public static const TOUCH_APP:String = 'touch_app';
        public static const TOUCHPAD_MOUSE:String = 'touchpad_mouse';
        public static const TOUCHPAD_MOUSE_OFF:String = 'touchpad_mouse_off';
        public static const TOUR:String = 'tour';
        public static const TOYS:String = 'toys';
        public static const TOYS_AND_GAMES:String = 'toys_and_games';
        public static const TOYS_FAN:String = 'toys_fan';
        public static const TRACK_CHANGES:String = 'track_changes';
        public static const TRAFFIC:String = 'traffic';
        public static const TRAIL_LENGTH:String = 'trail_length';
        public static const TRAIL_LENGTH_MEDIUM:String = 'trail_length_medium';
        public static const TRAIL_LENGTH_SHORT:String = 'trail_length_short';
        public static const TRAIN:String = 'train';
        public static const TRAM:String = 'tram';
        public static const TRANSCRIBE:String = 'transcribe';
        public static const TRANSFER_WITHIN_A_STATION:String = 'transfer_within_a_station';
        public static const TRANSFORM:String = 'transform';
        public static const TRANSGENDER:String = 'transgender';
        public static const TRANSIT_ENTEREXIT:String = 'transit_enterexit';
        public static const TRANSITION_CHOP:String = 'transition_chop';
        public static const TRANSITION_DISSOLVE:String = 'transition_dissolve';
        public static const TRANSITION_FADE:String = 'transition_fade';
        public static const TRANSITION_PUSH:String = 'transition_push';
        public static const TRANSITION_SLIDE:String = 'transition_slide';
        public static const TRANSLATE:String = 'translate';
        public static const TRANSPORTATION:String = 'transportation';
        public static const TRAVEL:String = 'travel';
        public static const TRAVEL_EXPLORE:String = 'travel_explore';
        public static const TRAVEL_LUGGAGE_AND_BAGS:String = 'travel_luggage_and_bags';
        public static const TRENDING_DOWN:String = 'trending_down';
        public static const TRENDING_FLAT:String = 'trending_flat';
        public static const TRENDING_UP:String = 'trending_up';
        public static const TRIP:String = 'trip';
        public static const TRIP_ORIGIN:String = 'trip_origin';
        public static const TROLLEY:String = 'trolley';
        public static const TROPHY:String = 'trophy';
        public static const TROUBLESHOOT:String = 'troubleshoot';
        public static const TRY:String = 'try';
        public static const TSUNAMI:String = 'tsunami';
        public static const TSV:String = 'tsv';
        public static const TTY:String = 'tty';
        public static const TUNE:String = 'tune';
        public static const TUNGSTEN:String = 'tungsten';
        public static const TURN_LEFT:String = 'turn_left';
        public static const TURN_RIGHT:String = 'turn_right';
        public static const TURN_SHARP_LEFT:String = 'turn_sharp_left';
        public static const TURN_SHARP_RIGHT:String = 'turn_sharp_right';
        public static const TURN_SLIGHT_LEFT:String = 'turn_slight_left';
        public static const TURN_SLIGHT_RIGHT:String = 'turn_slight_right';
        public static const TURNED_IN:String = 'turned_in';
        public static const TURNED_IN_NOT:String = 'turned_in_not';
        public static const TV:String = 'tv';
        public static const TV_GEN:String = 'tv_gen';
        public static const TV_GUIDE:String = 'tv_guide';
        public static const TV_OFF:String = 'tv_off';
        public static const TV_OPTIONS_EDIT_CHANNELS:String = 'tv_options_edit_channels';
        public static const TV_OPTIONS_INPUT_SETTINGS:String = 'tv_options_input_settings';
        public static const TV_REMOTE:String = 'tv_remote';
        public static const TV_SIGNIN:String = 'tv_signin';
        public static const TV_WITH_ASSISTANT:String = 'tv_with_assistant';
        public static const TWO_PAGER:String = 'two_pager';
        public static const TWO_WHEELER:String = 'two_wheeler';
        public static const TYPE_SPECIMEN:String = 'type_specimen';
        public static const U_TURN_LEFT:String = 'u_turn_left';
        public static const U_TURN_RIGHT:String = 'u_turn_right';
        public static const ULNA_RADIUS:String = 'ulna_radius';
        public static const ULNA_RADIUS_ALT:String = 'ulna_radius_alt';
        public static const UMBRELLA:String = 'umbrella';
        public static const UNARCHIVE:String = 'unarchive';
        public static const UNBLOCK_FLIPPED:String = 'unblock_flipped';
        public static const UNDO:String = 'undo';
        public static const UNFLOAT_LANDSCAPE:String = 'unfloat_landscape';
        public static const UNFLOAT_PORTRAIT:String = 'unfloat_portrait';
        public static const UNFOLD_LESS:String = 'unfold_less';
        public static const UNFOLD_LESS_DOUBLE:String = 'unfold_less_double';
        public static const UNFOLD_MORE:String = 'unfold_more';
        public static const UNFOLD_MORE_DOUBLE:String = 'unfold_more_double';
        public static const UNGROUP:String = 'ungroup';
        public static const UNIVERSAL_CURRENCY:String = 'universal_currency';
        public static const UNIVERSAL_CURRENCY_ALT:String = 'universal_currency_alt';
        public static const UNIVERSAL_LOCAL:String = 'universal_local';
        public static const UNKNOWN_2:String = 'unknown_2';
        public static const UNKNOWN_5:String = 'unknown_5';
        public static const UNKNOWN_DOCUMENT:String = 'unknown_document';
        public static const UNKNOWN_MED:String = 'unknown_med';
        public static const UNLICENSE:String = 'unlicense';
        public static const UNPIN:String = 'unpin';
        public static const UNPUBLISHED:String = 'unpublished';
        public static const UNSUBSCRIBE:String = 'unsubscribe';
        public static const UPCOMING:String = 'upcoming';
        public static const UPDATE:String = 'update';
        public static const UPDATE_DISABLED:String = 'update_disabled';
        public static const UPGRADE:String = 'upgrade';
        public static const UPLOAD:String = 'upload';
        public static const UPLOAD_2:String = 'upload_2';
        public static const UPLOAD_FILE:String = 'upload_file';
        public static const UROLOGY:String = 'urology';
        public static const USB:String = 'usb';
        public static const USB_OFF:String = 'usb_off';
        public static const USER_ATTRIBUTES:String = 'user_attributes';
        public static const VACCINES:String = 'vaccines';
        public static const VACUUM:String = 'vacuum';
        public static const VALVE:String = 'valve';
        public static const VAPE_FREE:String = 'vape_free';
        public static const VAPING_ROOMS:String = 'vaping_rooms';
        public static const VARIABLE_ADD:String = 'variable_add';
        public static const VARIABLE_INSERT:String = 'variable_insert';
        public static const VARIABLE_REMOVE:String = 'variable_remove';
        public static const VARIABLES:String = 'variables';
        public static const VENTILATOR:String = 'ventilator';
        public static const VERIFIED:String = 'verified';
        public static const VERIFIED_USER:String = 'verified_user';
        public static const VERTICAL_ALIGN_BOTTOM:String = 'vertical_align_bottom';
        public static const VERTICAL_ALIGN_CENTER:String = 'vertical_align_center';
        public static const VERTICAL_ALIGN_TOP:String = 'vertical_align_top';
        public static const VERTICAL_DISTRIBUTE:String = 'vertical_distribute';
        public static const VERTICAL_SHADES:String = 'vertical_shades';
        public static const VERTICAL_SHADES_CLOSED:String = 'vertical_shades_closed';
        public static const VERTICAL_SPLIT:String = 'vertical_split';
        public static const VIBRATION:String = 'vibration';
        public static const VIDEO_AUDIO_CALL:String = 'video_audio_call';
        public static const VIDEO_CALL:String = 'video_call';
        public static const VIDEO_CAMERA_BACK:String = 'video_camera_back';
        public static const VIDEO_CAMERA_FRONT:String = 'video_camera_front';
        public static const VIDEO_CAMERA_FRONT_OFF:String = 'video_camera_front_off';
        public static const VIDEO_CHAT:String = 'video_chat';
        public static const VIDEO_FILE:String = 'video_file';
        public static const VIDEO_LABEL:String = 'video_label';
        public static const VIDEO_LIBRARY:String = 'video_library';
        public static const VIDEO_SEARCH:String = 'video_search';
        public static const VIDEO_SETTINGS:String = 'video_settings';
        public static const VIDEO_STABLE:String = 'video_stable';
        public static const VIDEOCAM:String = 'videocam';
        public static const VIDEOCAM_OFF:String = 'videocam_off';
        public static const VIDEOGAME_ASSET:String = 'videogame_asset';
        public static const VIDEOGAME_ASSET_OFF:String = 'videogame_asset_off';
        public static const VIEW_AGENDA:String = 'view_agenda';
        public static const VIEW_ARRAY:String = 'view_array';
        public static const VIEW_CAROUSEL:String = 'view_carousel';
        public static const VIEW_COLUMN:String = 'view_column';
        public static const VIEW_COLUMN_2:String = 'view_column_2';
        public static const VIEW_COMFY:String = 'view_comfy';
        public static const VIEW_COMFY_ALT:String = 'view_comfy_alt';
        public static const VIEW_COMPACT:String = 'view_compact';
        public static const VIEW_COMPACT_ALT:String = 'view_compact_alt';
        public static const VIEW_COZY:String = 'view_cozy';
        public static const VIEW_DAY:String = 'view_day';
        public static const VIEW_HEADLINE:String = 'view_headline';
        public static const VIEW_IN_AR:String = 'view_in_ar';
        public static const VIEW_IN_AR_NEW:String = 'view_in_ar_new';
        public static const VIEW_IN_AR_OFF:String = 'view_in_ar_off';
        public static const VIEW_KANBAN:String = 'view_kanban';
        public static const VIEW_LIST:String = 'view_list';
        public static const VIEW_MODULE:String = 'view_module';
        public static const VIEW_QUILT:String = 'view_quilt';
        public static const VIEW_SIDEBAR:String = 'view_sidebar';
        public static const VIEW_STREAM:String = 'view_stream';
        public static const VIEW_TIMELINE:String = 'view_timeline';
        public static const VIEW_WEEK:String = 'view_week';
        public static const VIGNETTE:String = 'vignette';
        public static const VILLA:String = 'villa';
        public static const VISIBILITY:String = 'visibility';
        public static const VISIBILITY_LOCK:String = 'visibility_lock';
        public static const VISIBILITY_OFF:String = 'visibility_off';
        public static const VITAL_SIGNS:String = 'vital_signs';
        public static const VITALS:String = 'vitals';
        public static const VOICE_CHAT:String = 'voice_chat';
        public static const VOICE_OVER_OFF:String = 'voice_over_off';
        public static const VOICE_SELECTION:String = 'voice_selection';
        public static const VOICEMAIL:String = 'voicemail';
        public static const VOLCANO:String = 'volcano';
        public static const VOLUME_DOWN:String = 'volume_down';
        public static const VOLUME_DOWN_ALT:String = 'volume_down_alt';
        public static const VOLUME_MUTE:String = 'volume_mute';
        public static const VOLUME_OFF:String = 'volume_off';
        public static const VOLUME_UP:String = 'volume_up';
        public static const VOLUNTEER_ACTIVISM:String = 'volunteer_activism';
        public static const VOTING_CHIP:String = 'voting_chip';
        public static const VPN_GOOGLEONE:String = 'vpn_googleone';
        public static const VPN_KEY:String = 'vpn_key';
        public static const VPN_KEY_ALERT:String = 'vpn_key_alert';
        public static const VPN_KEY_OFF:String = 'vpn_key_off';
        public static const VPN_LOCK:String = 'vpn_lock';
        public static const VR180_CREATE2D:String = 'vr180_create2d';
        public static const VR180_CREATE2D_OFF:String = 'vr180_create2d_off';
        public static const VRPANO:String = 'vrpano';
        public static const WALL_ART:String = 'wall_art';
        public static const WALL_LAMP:String = 'wall_lamp';
        public static const WALLET:String = 'wallet';
        public static const WALLPAPER:String = 'wallpaper';
        public static const WALLPAPER_SLIDESHOW:String = 'wallpaper_slideshow';
        public static const WARD:String = 'ward';
        public static const WAREHOUSE:String = 'warehouse';
        public static const WARNING:String = 'warning';
        public static const WARNING_AMBER:String = 'warning_amber';
        public static const WARNING_OFF:String = 'warning_off';
        public static const WASH:String = 'wash';
        public static const WATCH:String = 'watch';
        public static const WATCH_BUTTON_PRESS:String = 'watch_button_press';
        public static const WATCH_LATER:String = 'watch_later';
        public static const WATCH_OFF:String = 'watch_off';
        public static const WATCH_SCREENTIME:String = 'watch_screentime';
        public static const WATCH_WAKE:String = 'watch_wake';
        public static const WATER:String = 'water';
        public static const WATER_BOTTLE:String = 'water_bottle';
        public static const WATER_BOTTLE_LARGE:String = 'water_bottle_large';
        public static const WATER_DAMAGE:String = 'water_damage';
        public static const WATER_DO:String = 'water_do';
        public static const WATER_DROP:String = 'water_drop';
        public static const WATER_EC:String = 'water_ec';
        public static const WATER_FULL:String = 'water_full';
        public static const WATER_HEATER:String = 'water_heater';
        public static const WATER_LOCK:String = 'water_lock';
        public static const WATER_LOSS:String = 'water_loss';
        public static const WATER_LUX:String = 'water_lux';
        public static const WATER_MEDIUM:String = 'water_medium';
        public static const WATER_ORP:String = 'water_orp';
        public static const WATER_PH:String = 'water_ph';
        public static const WATER_PUMP:String = 'water_pump';
        public static const WATER_VOC:String = 'water_voc';
        public static const WATERFALL_CHART:String = 'waterfall_chart';
        public static const WAVES:String = 'waves';
        public static const WAVING_HAND:String = 'waving_hand';
        public static const WB_AUTO:String = 'wb_auto';
        public static const WB_CLOUDY:String = 'wb_cloudy';
        public static const WB_INCANDESCENT:String = 'wb_incandescent';
        public static const WB_IRIDESCENT:String = 'wb_iridescent';
        public static const WB_SHADE:String = 'wb_shade';
        public static const WB_SUNNY:String = 'wb_sunny';
        public static const WB_TWIGHLIGHT:String = 'wb_twighlight';
        public static const WB_TWILIGHT:String = 'wb_twilight';
        public static const WC:String = 'wc';
        public static const WEATHER_HAIL:String = 'weather_hail';
        public static const WEATHER_MIX:String = 'weather_mix';
        public static const WEATHER_SNOWY:String = 'weather_snowy';
        public static const WEB:String = 'web';
        public static const WEB_ASSET:String = 'web_asset';
        public static const WEB_ASSET_OFF:String = 'web_asset_off';
        public static const WEB_STORIES:String = 'web_stories';
        public static const WEB_TRAFFIC:String = 'web_traffic';
        public static const WEBHOOK:String = 'webhook';
        public static const WEEKEND:String = 'weekend';
        public static const WEIGHT:String = 'weight';
        public static const WEST:String = 'west';
        public static const WHATSAPP:String = 'whatsapp';
        public static const WHATSHOT:String = 'whatshot';
        public static const WHEELCHAIR_PICKUP:String = 'wheelchair_pickup';
        public static const WHERE_TO_VOTE:String = 'where_to_vote';
        public static const WHITEBOARD:String = 'whiteboard';
        public static const WIDGETS:String = 'widgets';
        public static const WIDTH:String = 'width';
        public static const WIDTH_FULL:String = 'width_full';
        public static const WIDTH_NORMAL:String = 'width_normal';
        public static const WIDTH_WIDE:String = 'width_wide';
        public static const WIFI:String = 'wifi';
        public static const WIFI_1_BAR:String = 'wifi_1_bar';
        public static const WIFI_2_BAR:String = 'wifi_2_bar';
        public static const WIFI_ADD:String = 'wifi_add';
        public static const WIFI_CALLING:String = 'wifi_calling';
        public static const WIFI_CALLING_1:String = 'wifi_calling_1';
        public static const WIFI_CALLING_2:String = 'wifi_calling_2';
        public static const WIFI_CALLING_3:String = 'wifi_calling_3';
        public static const WIFI_CHANNEL:String = 'wifi_channel';
        public static const WIFI_FIND:String = 'wifi_find';
        public static const WIFI_HOME:String = 'wifi_home';
        public static const WIFI_LOCK:String = 'wifi_lock';
        public static const WIFI_NOTIFICATION:String = 'wifi_notification';
        public static const WIFI_OFF:String = 'wifi_off';
        public static const WIFI_PASSWORD:String = 'wifi_password';
        public static const WIFI_PROTECTED_SETUP:String = 'wifi_protected_setup';
        public static const WIFI_PROXY:String = 'wifi_proxy';
        public static const WIFI_TETHERING:String = 'wifi_tethering';
        public static const WIFI_TETHERING_ERROR:String = 'wifi_tethering_error';
        public static const WIFI_TETHERING_ERROR_ROUNDED:String = 'wifi_tethering_error_rounded';
        public static const WIFI_TETHERING_OFF:String = 'wifi_tethering_off';
        public static const WIND_POWER:String = 'wind_power';
        public static const WINDOW:String = 'window';
        public static const WINDOW_CLOSED:String = 'window_closed';
        public static const WINDOW_OPEN:String = 'window_open';
        public static const WINDOW_SENSOR:String = 'window_sensor';
        public static const WINE_BAR:String = 'wine_bar';
        public static const WOMAN:String = 'woman';
        public static const WOMAN_2:String = 'woman_2';
        public static const WORK:String = 'work';
        public static const WORK_ALERT:String = 'work_alert';
        public static const WORK_HISTORY:String = 'work_history';
        public static const WORK_OFF:String = 'work_off';
        public static const WORK_OUTLINE:String = 'work_outline';
        public static const WORK_UPDATE:String = 'work_update';
        public static const WORKSPACE_PREMIUM:String = 'workspace_premium';
        public static const WORKSPACES:String = 'workspaces';
        public static const WORKSPACES_FILLED:String = 'workspaces_filled';
        public static const WORKSPACES_OUTLINE:String = 'workspaces_outline';
        public static const WOUNDS_INJURIES:String = 'wounds_injuries';
        public static const WRAP_TEXT:String = 'wrap_text';
        public static const WRIST:String = 'wrist';
        public static const WRONG_LOCATION:String = 'wrong_location';
        public static const WYSIWYG:String = 'wysiwyg';
        public static const YARD:String = 'yard';
        public static const YOUR_TRIPS:String = 'your_trips';
        public static const YOUTUBE_ACTIVITY:String = 'youtube_activity';
        public static const YOUTUBE_SEARCHED_FOR:String = 'youtube_searched_for';
        public static const ZONE_PERSON_ALERT:String = 'zone_person_alert';
        public static const ZONE_PERSON_IDLE:String = 'zone_person_idle';
        public static const ZONE_PERSON_URGENT:String = 'zone_person_urgent';
        public static const ZOOM_IN:String = 'zoom_in';
        public static const ZOOM_IN_MAP:String = 'zoom_in_map';
        public static const ZOOM_OUT:String = 'zoom_out';
        public static const ZOOM_OUT_MAP:String = 'zoom_out_map';
    }
}
