/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.J2clSourceFileChecker;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

final class J2clStringValueOfRewriterPass
extends AbstractPeepholeOptimization {
    private static final String METHOD_NAME = "module$exports$java$lang$String$impl.m_valueOf__java_lang_Object";
    private boolean shouldRunJ2clPasses = false;

    J2clStringValueOfRewriterPass() {
    }

    @Override
    void beginTraversal(AbstractCompiler compiler) {
        super.beginTraversal(compiler);
        this.shouldRunJ2clPasses = J2clSourceFileChecker.shouldRunJ2clPasses(compiler);
    }

    @Override
    public Node optimizeSubtree(Node node) {
        if (!this.shouldRunJ2clPasses || !J2clStringValueOfRewriterPass.isStringValueOfCall(node)) {
            return node;
        }
        Node replacement = this.tryRewriteStringValueOfCall(node);
        if (replacement != node) {
            replacement = replacement.useSourceInfoIfMissingFrom(node);
            node.replaceWith(replacement);
            this.compiler.reportChangeToEnclosingScope(replacement);
        }
        return replacement;
    }

    private Node tryRewriteStringValueOfCall(Node n) {
        Node param = n.getSecondChild();
        if (NodeUtil.isUndefined(param)) {
            return IR.string("null");
        }
        if (NodeUtil.isDefinedValue(param) && !param.isArrayLit()) {
            return NodeUtil.newCallNode(IR.name("String").useSourceInfoFrom(n), param.detach());
        }
        return n;
    }

    private static boolean isStringValueOfCall(Node node) {
        return node.isCall() && node.hasXChildren(2) && J2clStringValueOfRewriterPass.isStringValueOfMethodName(node.getFirstChild());
    }

    private static boolean isStringValueOfMethodName(Node fnName) {
        return fnName.isQualifiedName() && fnName.getOriginalQualifiedName().equals(METHOD_NAME);
    }
}

