/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package org.apache.royale.compiler.problems;

import org.apache.royale.abc.graph.IBasicBlock;
import org.apache.royale.abc.graph.IFlowgraph;

/**
 * Internal compiler problem created when the code generator produces code in a
 * method body that underflows the operand stack.
 * <p>
 * This compiler problem is created when AET, detects a operand stack underflow
 * in
 * org.apache.royale.abc.semantics.MethodBodyInfo#computeFrameCounts(IDiagnosticsVisitor).
 */
public final class OperandStackUnderflowProblem extends InvalidByteCodeGeneratedProblem implements IOperandStackUnderflowProblem
{
    public static final String DESCRIPTION =
        "Generated byte code contains an operand stack underflow.";

    public static final int errorCode = 1546;
    
    public OperandStackUnderflowProblem(IFlowgraph cfg, IBasicBlock b, int instructionIndex)
    {
        super(computeSourceLocationForBlockAndInstruction(cfg, b, instructionIndex));
        
    }
}
