/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.ant;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.royale.compiler.ant.config.BaseConfigVariable;
import org.apache.royale.compiler.ant.config.ConfigVariable;
import org.apache.royale.compiler.ant.config.IOptionSource;
import org.apache.royale.compiler.ant.config.NestedAttributeElement;
import org.apache.royale.compiler.ant.config.OptionSpec;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;

public abstract class FlexTask
extends Java {
    protected static OptionSpec RUNTIME_SHARED_LIBRARY_PATH = new OptionSpec("runtime-shared-library-path", "rslp");
    private final String taskName;
    protected final ConfigVariable[] configVariables;
    private final String toolJARFileName;
    private final String toolClassName;
    private final String toolMethodName;
    private final String toolFailureMethodName;
    protected final Commandline cmdline;
    protected List<IOptionSource> nestedAttribs;
    protected boolean fork;
    private ClassLoader originalContextClassLoader;

    protected FlexTask(String taskName, ConfigVariable[] configVariables, String toolJARFileName, String toolClassName, String toolMethodName, String toolFailureMethodName) {
        this.taskName = taskName;
        this.configVariables = configVariables;
        this.toolJARFileName = toolJARFileName;
        this.toolClassName = toolClassName;
        this.toolMethodName = toolMethodName;
        this.toolFailureMethodName = toolFailureMethodName;
        this.cmdline = new Commandline();
    }

    protected NestedAttributeElement createElem(String attrib, OptionSpec spec) {
        NestedAttributeElement e = new NestedAttributeElement(attrib, spec, this);
        this.nestedAttribs.add(e);
        return e;
    }

    protected NestedAttributeElement createElem(String[] attribs, OptionSpec spec) {
        NestedAttributeElement e = new NestedAttributeElement(attribs, spec, this);
        this.nestedAttribs.add(e);
        return e;
    }

    protected NestedAttributeElement createElemAllowAppend(String[] attribs, OptionSpec spec) {
        NestedAttributeElement e = new NestedAttributeElement(attribs, spec, this, true);
        this.nestedAttribs.add(e);
        return e;
    }

    public void setFork(boolean f) {
        super.setFork(f);
        this.fork = f;
    }

    public void setDynamicAttribute(String attributeName, String value) {
        ConfigVariable var = null;
        for (int i = 0; i < this.configVariables.length && var == null; ++i) {
            if (!this.configVariables[i].matches(attributeName)) continue;
            var = this.configVariables[i];
        }
        if (var == null) {
            throw new BuildException("The <" + this.taskName + "> type doesn't support the \"" + attributeName + "\" attribute.", this.getLocation());
        }
        var.set(value);
    }

    public Object createDynamicElement(String elementName) {
        BaseConfigVariable var = null;
        for (int i = 0; i < this.configVariables.length && var == null; ++i) {
            if (!this.configVariables[i].matches(elementName)) continue;
            var = this.configVariables[i];
        }
        if (var != null) {
            return this.createElem(elementName, var.getSpec());
        }
        throw new BuildException("The <" + this.taskName + "> type doesn't support the \"" + elementName + "\" nested element.", this.getLocation());
    }

    protected abstract void prepareCommandline() throws BuildException;

    public final void execute() throws BuildException {
        String royaleHomeProperty = this.getProject().getProperty("ROYALE_HOME");
        if (royaleHomeProperty == null) {
            royaleHomeProperty = this.getProject().getProperty("FLEX_HOME");
        }
        if (royaleHomeProperty == null) {
            throw new BuildException("ROYALE_HOME or FLEX_HOME must be set to use the Flex Ant Tasks");
        }
        String compilerHomeProperty = this.getProject().getProperty("ROYALE_COMPILER_HOME");
        if (compilerHomeProperty == null) {
            throw new BuildException("ROYALE_COMPILER_HOME must be set to use the Flex Ant Tasks");
        }
        System.setProperty("ROYALE_HOME", royaleHomeProperty);
        String royalelibProperty = royaleHomeProperty.concat("/frameworks/");
        System.setProperty("royalelib", royalelibProperty);
        Environment.Variable variable = new Environment.Variable();
        variable.setKey("royalelib");
        variable.setValue(royaleHomeProperty);
        this.addSysproperty(variable);
        this.cmdline.createArgument().setValue("+royalelib=" + royalelibProperty);
        this.prepareCommandline();
        if (this.fork) {
            this.executeOutOfProcess();
        } else {
            this.executeInProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeOutOfProcess() throws BuildException {
        try {
            Class<?> toolClass = this.resolveClass(this.toolClassName);
            super.setClassname(this.toolClassName);
            String line = Commandline.toString((String[])this.cmdline.getArguments());
            super.createArg().setLine(line);
            int exitCode = super.executeJava();
            if (this.isFatalFailure(toolClass, exitCode)) {
                throw new BuildException(this.taskName + " task failed.");
            }
        }
        finally {
            if (this.originalContextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(this.originalContextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInProcess() throws BuildException {
        try {
            Class<?> toolClass = this.resolveClass(this.toolClassName);
            this.log("FlexTask.execute: " + this.cmdline, 4);
            int exitCode = -1;
            try {
                Method toolMethod = toolClass.getMethod(this.toolMethodName, String[].class);
                Object result = toolMethod.invoke(null, new Object[]{this.cmdline.getArguments()});
                exitCode = (Integer)result;
            }
            catch (Exception e) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                e.printStackTrace(printWriter);
                this.log(stringWriter.toString(), 4);
                throw new BuildException("Unable to run " + this.toolMethodName + ": " + e.getMessage(), (Throwable)e);
            }
            if (this.isFatalFailure(toolClass, exitCode)) {
                throw new BuildException(this.taskName + " task failed");
            }
        }
        finally {
            if (this.originalContextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(this.originalContextClassLoader);
            }
        }
    }

    private boolean isFatalFailure(Class<?> toolClass, int exitCode) {
        boolean fatal = true;
        try {
            Method toolFailureMethod = toolClass.getMethod(this.toolFailureMethodName, Integer.TYPE);
            Object result = toolFailureMethod.invoke(null, exitCode);
            fatal = (Boolean)result;
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            this.log(stringWriter.toString(), 4);
            throw new BuildException("Unable to run " + this.toolFailureMethodName + ": " + e.getMessage(), (Throwable)e);
        }
        return fatal;
    }

    private Class<?> resolveClass(String className) {
        Class<?> result;
        block9: {
            result = null;
            try {
                result = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException ignoredClassNotFoundException) {
                String royaleHomeProperty = this.getProject().getProperty("ROYALE_COMPILER_HOME");
                if (royaleHomeProperty != null) {
                    File royaleHome = new File(royaleHomeProperty);
                    if (royaleHome.exists()) {
                        File jarFile = new File(royaleHome + "/lib", this.toolJARFileName);
                        if (jarFile.exists()) {
                            try {
                                URL url = jarFile.toURI().toURL();
                                URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{url});
                                result = Class.forName(className, true, urlClassLoader);
                                this.originalContextClassLoader = Thread.currentThread().getContextClassLoader();
                                Thread.currentThread().setContextClassLoader(urlClassLoader);
                                if (this.fork) {
                                    super.setClasspath(new Path(this.getProject(), jarFile.getAbsolutePath()));
                                }
                            }
                            catch (MalformedURLException malformedURLException) {
                                malformedURLException.printStackTrace();
                                break block9;
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new BuildException("The class " + className + " was not found in jar file " + this.toolJARFileName, this.getLocation());
                            }
                        }
                        throw new BuildException("File does not exist: " + this.toolJARFileName, this.getLocation());
                    }
                    throw new BuildException("ROYALE_COMPILER_HOME does not exist.", this.getLocation());
                }
                throw new BuildException("The class, " + className + ", must be in the classpath or the ROYALE_COMPILER_HOME property must be set.", this.getLocation());
            }
        }
        return result;
    }
}

