/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo.reference;

import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;
import org.apache.servicecomb.provider.pojo.Invoker;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class PojoReferenceMeta
implements FactoryBean<Object>,
InitializingBean {
    private String microserviceName;
    private String schemaId;
    private Class<?> consumerIntf;
    private Object proxy;

    public Object getProxy() {
        return this.getObject();
    }

    public Object getObject() {
        return this.proxy;
    }

    public Class<?> getObjectType() {
        return this.consumerIntf;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setConsumerIntf(Class<?> intf) {
        this.consumerIntf = intf;
    }

    public void setMicroserviceName(String microserviceName) {
        this.microserviceName = microserviceName;
    }

    public void setSchemaId(String schemaId) {
        this.schemaId = schemaId;
    }

    public void afterPropertiesSet() {
        if (this.consumerIntf == null) {
            throw new ServiceCombException(String.format("microserviceName=%s, schemaid=%s, \ndo not support implicit interface anymore, \nbecause that caused problems:\n  1.the startup process relies on other microservices\n  2.cyclic dependent microservices can not be deployed\nsuggest to use @RpcReference or <cse:rpc-reference id=\"...\" microservice-name=\"...\" schema-id=\"...\" interface=\"...\"></cse:rpc-reference>.", this.microserviceName, this.schemaId));
        }
        this.proxy = Invoker.createProxy(this.microserviceName, this.schemaId, this.consumerIntf);
    }
}

