/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.faultinjection;

import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.faultinjection.AbstractFault;
import org.apache.servicecomb.faultinjection.FaultInjectionUtil;
import org.apache.servicecomb.faultinjection.FaultParam;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbortFault
extends AbstractFault {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbortFault.class);
    public static final String ABORTED_ERROR_MSG = "aborted by fault inject";

    @Override
    public void injectFault(Invocation invocation, FaultParam faultParam, AsyncResponse asyncResponse) {
        if (!this.shouldAbort(invocation, faultParam)) {
            asyncResponse.success((Object)"success");
            return;
        }
        int errorCode = FaultInjectionUtil.getFaultInjectionConfig(invocation, "abort.httpStatus");
        if (errorCode == -1) {
            LOGGER.debug("Fault injection: Abort error code is not configured");
            asyncResponse.success((Object)"success");
            return;
        }
        CommonExceptionData errorData = new CommonExceptionData(ABORTED_ERROR_MSG);
        asyncResponse.consumerFail((Throwable)new InvocationException(errorCode, ABORTED_ERROR_MSG, (Object)errorData));
    }

    private boolean shouldAbort(Invocation invocation, FaultParam faultParam) {
        int abortPercent = FaultInjectionUtil.getFaultInjectionConfig(invocation, "abort.percent");
        if (abortPercent == -1) {
            LOGGER.debug("Fault injection: Abort percentage is not configured");
            return false;
        }
        return FaultInjectionUtil.isFaultNeedToInject(faultParam.getReqCount(), abortPercent);
    }

    @Override
    public int getOrder() {
        return 200;
    }
}

