/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core;

import org.apache.servicecomb.config.priority.PriorityPropertyManager;
import org.apache.servicecomb.core.ProducerProvider;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.filter.FilterChainsManager;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClients;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;

public class SCBApplicationListener
implements ApplicationListener<ApplicationEvent>,
Ordered,
ApplicationContextAware,
EnvironmentAware {
    private Class<?> initEventClass = ContextRefreshedEvent.class;
    private ApplicationContext applicationContext;
    private final SCBEngine scbEngine;

    public SCBApplicationListener(SCBEngine scbEngine) {
        this.scbEngine = scbEngine;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.applicationContext == applicationContext) {
            return;
        }
        this.applicationContext = applicationContext;
        BeanUtils.setContext((ApplicationContext)applicationContext);
        HttpClients.load();
    }

    public void setEnvironment(Environment environment) {
        this.scbEngine.init();
    }

    public void setInitEventClass(Class<?> initEventClass) {
        this.initEventClass = initEventClass;
    }

    public int getOrder() {
        return -1000;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.initEventClass.isInstance(event)) {
            if (this.applicationContext instanceof AbstractApplicationContext) {
                ((AbstractApplicationContext)this.applicationContext).registerShutdownHook();
            }
            this.scbEngine.setPriorityPropertyManager((PriorityPropertyManager)this.applicationContext.getBean(PriorityPropertyManager.class));
            this.scbEngine.setFilterChainsManager((FilterChainsManager)this.applicationContext.getBean(FilterChainsManager.class));
            this.scbEngine.getProducerProviderManager().getProducerProviderList().addAll(this.applicationContext.getBeansOfType(ProducerProvider.class).values());
            this.scbEngine.run();
        } else if (event instanceof ContextClosedEvent && SCBEngine.getInstance() != null) {
            SCBEngine.getInstance().destroy();
        }
    }
}

