/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.priority;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.servicecomb.config.priority.PriorityProperty;
import org.apache.servicecomb.config.priority.PriorityPropertyType;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.springframework.core.env.Environment;

public class PriorityPropertyFactory {
    private final Map<PriorityPropertyType<?>, PriorityProperty<?>> properties = new ConcurrentHashMapEx();
    private final Environment environment;

    public PriorityPropertyFactory(Environment environment) {
        this.environment = environment;
    }

    @VisibleForTesting
    public Stream<PriorityProperty<?>> getProperties() {
        return this.properties.values().stream();
    }

    public <T> PriorityProperty<T> getOrCreate(Type type, T invalidValue, T defaultValue, String ... priorityKeys) {
        PriorityPropertyType<T> propertyType = new PriorityPropertyType<T>(type, invalidValue, defaultValue, priorityKeys);
        return this.properties.computeIfAbsent(propertyType, key -> new PriorityProperty(this.environment, key));
    }
}

