/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.examples;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.XML;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlExampleGenerator {
    protected final Logger LOGGER = LoggerFactory.getLogger(XmlExampleGenerator.class);
    public static String NEWLINE = "\n";
    public static String TAG_START = "<";
    public static String CLOSE_TAG = ">";
    public static String TAG_END = "</";
    private static String EMPTY = "";
    protected Map<String, Schema> examples;

    public XmlExampleGenerator(Map<String, Schema> examples) {
        this.examples = examples;
        if (examples == null) {
            this.examples = new HashMap<String, Schema>();
        }
    }

    public String toXml(Schema schema) {
        return this.toXml(null, schema, 0, Collections.emptySet());
    }

    protected String toXml(Schema schema, int indent, Collection<String> path) {
        Schema actualSchema;
        if (schema == null) {
            return "";
        }
        if (StringUtils.isNotEmpty((CharSequence)schema.get$ref()) && (actualSchema = this.examples.get(schema.get$ref())) != null) {
            return this.modelImplToXml(actualSchema, indent, path);
        }
        return this.modelImplToXml(schema, indent, path);
    }

    protected String modelImplToXml(Schema schema, int indent, Collection<String> path) {
        Schema s;
        Map properties;
        String modelName = schema.getName();
        if (path.contains(modelName)) {
            return EMPTY;
        }
        HashSet<String> selfPath = new HashSet<String>(path);
        selfPath.add(modelName);
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<String, Schema> attributes = new LinkedHashMap<String, Schema>();
        LinkedHashMap<String, Schema> elements = new LinkedHashMap<String, Schema>();
        String name = modelName;
        XML xml = schema.getXml();
        if (xml != null && xml.getName() != null) {
            name = xml.getName();
        }
        if ((properties = schema.getProperties()) != null && !properties.isEmpty()) {
            for (String pName : properties.keySet()) {
                Schema property = (Schema)properties.get(pName);
                if (property != null && property.getXml() != null && property.getXml().getAttribute() != null && property.getXml().getAttribute().booleanValue()) {
                    attributes.put(pName, property);
                    continue;
                }
                elements.put(pName, property);
            }
        }
        sb.append(this.indent(indent)).append(TAG_START);
        sb.append(name);
        for (String pName : attributes.keySet()) {
            s = (Schema)attributes.get(pName);
            sb.append(" ").append(pName).append("=").append(this.quote(this.toXml(null, s, 0, selfPath)));
        }
        sb.append(CLOSE_TAG);
        sb.append(NEWLINE);
        for (String pName : elements.keySet()) {
            String asXml = this.toXml(pName, s = (Schema)elements.get(pName), indent + 1, selfPath);
            if (StringUtils.isEmpty((CharSequence)asXml)) continue;
            sb.append(asXml);
            sb.append(NEWLINE);
        }
        sb.append(this.indent(indent)).append(TAG_END).append(name).append(CLOSE_TAG);
        return sb.toString();
    }

    protected String quote(String string) {
        return "\"" + string + "\"";
    }

    protected String toXml(String name, Schema schema, int indent, Collection<String> path) {
        if (schema == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (ModelUtils.isArraySchema(schema)) {
            ArraySchema as = (ArraySchema)schema;
            Schema inner = as.getItems();
            boolean wrapped = false;
            if (schema.getXml() != null && schema.getXml().getWrapped() != null && schema.getXml().getWrapped().booleanValue()) {
                wrapped = true;
            }
            if (wrapped) {
                String asXml;
                String prefix = EMPTY;
                if (name != null) {
                    sb.append(this.indent(indent));
                    sb.append(this.openTag(name));
                    prefix = NEWLINE;
                }
                if (StringUtils.isNotEmpty((CharSequence)(asXml = this.toXml(name, inner, indent + 1, path)))) {
                    sb.append(prefix).append(asXml);
                }
                if (name != null) {
                    sb.append(NEWLINE);
                    sb.append(this.indent(indent));
                    sb.append(this.closeTag(name));
                }
            } else {
                sb.append(this.toXml(name, inner, indent, path));
            }
        } else if (StringUtils.isNotEmpty((CharSequence)schema.get$ref())) {
            Schema actualSchema = this.examples.get(schema.get$ref());
            sb.append(this.toXml(actualSchema, indent, path));
        } else {
            if (name != null) {
                sb.append(this.indent(indent));
                sb.append(this.openTag(name));
            }
            sb.append(this.getExample(schema));
            if (name != null) {
                sb.append(this.closeTag(name));
            }
        }
        return sb.toString();
    }

    protected String getExample(Schema schema) {
        if (schema.getExample() != null) {
            return schema.getExample().toString();
        }
        if (ModelUtils.isDateTimeSchema(schema)) {
            return "2000-01-23T04:56:07.000Z";
        }
        if (ModelUtils.isDateSchema(schema)) {
            return "2000-01-23";
        }
        if (ModelUtils.isBooleanSchema(schema)) {
            return "true";
        }
        if (ModelUtils.isNumberSchema(schema)) {
            if (ModelUtils.isFloatSchema(schema)) {
                return "1.3579";
            }
            return "3.149";
        }
        if (ModelUtils.isPasswordSchema(schema)) {
            return "********";
        }
        if (ModelUtils.isUUIDSchema(schema)) {
            return "046b6c7f-0b8a-43b9-b35d-6489e6daee91";
        }
        if (ModelUtils.isURISchema(schema)) {
            return "https://openapi-generator.tech";
        }
        if (ModelUtils.isStringSchema(schema)) {
            return "aeiou";
        }
        if (ModelUtils.isIntegerSchema(schema)) {
            if (ModelUtils.isLongSchema(schema)) {
                return "123456789";
            }
            return "123";
        }
        this.LOGGER.debug("default example value not implemented for {}. Default to UNDEFINED_EXAMPLE_VALUE", (Object)schema);
        return "UNDEFINED_EXAMPLE_VALUE";
    }

    protected String openTag(String name) {
        return "<" + name + ">";
    }

    protected String closeTag(String name) {
        return "</" + name + ">";
    }

    protected String indent(int indent) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }
}

