/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractGoCodegen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoGinServerCodegen
extends AbstractGoCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoGinServerCodegen.class);
    protected String apiVersion = "1.0.0";
    protected int serverPort = 8080;
    protected String projectName = "openapi-server";
    protected String apiPath = "go";

    public GoGinServerCodegen() {
        this.outputFolder = "generated-code/go";
        this.modelTemplateFiles.put("model.mustache", ".go");
        this.apiTemplateFiles.put("controller-api.mustache", ".go");
        this.templateDir = "go-gin-server";
        this.embeddedTemplateDir = "go-gin-server";
        this.setReservedWordsLowerCase(Arrays.asList("string", "bool", "uint", "uint8", "uint16", "uint32", "uint64", "int", "int8", "int16", "int32", "int64", "float32", "float64", "complex64", "complex128", "rune", "byte", "uintptr", "break", "default", "func", "interface", "select", "case", "defer", "go", "map", "struct", "chan", "else", "goto", "package", "switch", "const", "fallthrough", "if", "range", "type", "continue", "for", "import", "return", "var", "error", "nil"));
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            if (op.path == null) continue;
            op.path = op.path.replaceAll("\\{(.*?)\\}", ":$1");
        }
        return objs;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.setPackageName("openapi");
        }
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.additionalProperties.put("serverPort", this.serverPort);
        this.additionalProperties.put("apiPath", this.apiPath);
        this.additionalProperties.put("packageName", this.packageName);
        this.modelPackage = this.packageName;
        this.apiPackage = this.packageName;
        this.supportingFiles.add(new SupportingFile("openapi.mustache", "api", "openapi.yaml"));
        this.supportingFiles.add(new SupportingFile("main.mustache", "", "main.go"));
        this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", "", "Dockerfile"));
        this.supportingFiles.add(new SupportingFile("routers.mustache", this.apiPath, "routers.go"));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", this.apiPath, "README.md"));
    }

    @Override
    public String apiPackage() {
        return this.apiPath;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "go-gin-server";
    }

    @Override
    public String getHelp() {
        return "Generates a Go server library with the gin framework using OpenAPI-Generator.By default, it will also generate service classes.";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }
}

