/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.library.validator;

import com.github.fge.jsonschema.core.util.Dictionary;
import com.github.fge.jsonschema.core.util.DictionaryBuilder;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.keyword.validator.KeywordValidatorFactory;
import com.github.fge.jsonschema.keyword.validator.ReflectionKeywordValidatorFactory;
import com.github.fge.jsonschema.keyword.validator.common.DependenciesValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.AllOfValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.AnyOfValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.DraftV4TypeValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.MaxPropertiesValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.MinPropertiesValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.MultipleOfValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.NotValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.OneOfValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.RequiredKeywordValidator;
import com.github.fge.jsonschema.library.validator.CommonValidatorDictionary;

public final class DraftV4ValidatorDictionary {
    private static final Dictionary<KeywordValidatorFactory> DICTIONARY;

    private DraftV4ValidatorDictionary() {
    }

    public static Dictionary<KeywordValidatorFactory> get() {
        return DICTIONARY;
    }

    private static KeywordValidatorFactory factory(String name, Class<? extends KeywordValidator> c) {
        return new ReflectionKeywordValidatorFactory(name, c);
    }

    static {
        DictionaryBuilder builder = Dictionary.newBuilder();
        builder.addAll(CommonValidatorDictionary.get());
        String keyword = "multipleOf";
        Class c = MultipleOfValidator.class;
        builder.addEntry(keyword, (Object)DraftV4ValidatorDictionary.factory(keyword, c));
        keyword = "minProperties";
        c = MinPropertiesValidator.class;
        builder.addEntry(keyword, (Object)DraftV4ValidatorDictionary.factory(keyword, c));
        keyword = "maxProperties";
        c = MaxPropertiesValidator.class;
        builder.addEntry(keyword, (Object)DraftV4ValidatorDictionary.factory(keyword, c));
        keyword = "required";
        c = RequiredKeywordValidator.class;
        builder.addEntry(keyword, (Object)DraftV4ValidatorDictionary.factory(keyword, c));
        keyword = "dependencies";
        c = DependenciesValidator.class;
        builder.addEntry(keyword, (Object)DraftV4ValidatorDictionary.factory(keyword, c));
        keyword = "anyOf";
        c = AnyOfValidator.class;
        builder.addEntry(keyword, (Object)DraftV4ValidatorDictionary.factory(keyword, c));
        keyword = "allOf";
        c = AllOfValidator.class;
        builder.addEntry(keyword, (Object)DraftV4ValidatorDictionary.factory(keyword, c));
        keyword = "oneOf";
        c = OneOfValidator.class;
        builder.addEntry(keyword, (Object)DraftV4ValidatorDictionary.factory(keyword, c));
        keyword = "not";
        c = NotValidator.class;
        builder.addEntry(keyword, (Object)DraftV4ValidatorDictionary.factory(keyword, c));
        keyword = "type";
        c = DraftV4TypeValidator.class;
        builder.addEntry(keyword, (Object)DraftV4ValidatorDictionary.factory(keyword, c));
        DICTIONARY = builder.freeze();
    }
}

