/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.provider.consumer;

import com.netflix.config.DynamicPropertyFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.core.ConsumerProvider;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.serviceregistry.consumer.AppManager;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersionRule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsumerProviderManager {
    @Autowired(required=false)
    private List<ConsumerProvider> consumerProviderList = Collections.emptyList();
    private AppManager appManager;
    private Map<String, ReferenceConfig> referenceConfigMap = new ConcurrentHashMapEx();

    public void setAppManager(AppManager appManager) {
        this.appManager = appManager;
    }

    public void init() throws Exception {
        for (ConsumerProvider provider : this.consumerProviderList) {
            provider.init();
        }
    }

    public ReferenceConfig createReferenceConfig(String microserviceName, String versionRule, String transport) {
        ReferenceConfig referenceConfig = new ReferenceConfig(this.appManager, microserviceName, versionRule, transport);
        MicroserviceVersionRule microserviceVersionRule = referenceConfig.getMicroserviceVersionRule();
        if (microserviceVersionRule.getLatestMicroserviceVersion() == null) {
            throw new IllegalStateException(String.format("Probably invoke a service before it is registered, or no instance found for it, appId=%s, name=%s", microserviceVersionRule.getAppId(), microserviceVersionRule.getMicroserviceName()));
        }
        return referenceConfig;
    }

    public ReferenceConfig createReferenceConfig(String microserviceName) {
        String key = "servicecomb.references." + microserviceName;
        String defaultVersionRule = DynamicPropertyFactory.getInstance().getStringProperty("servicecomb.references.version-rule", "0.0.0+").get();
        String versionRule = DynamicPropertyFactory.getInstance().getStringProperty(key + ".version-rule", defaultVersionRule).get();
        String defaultTransport = DynamicPropertyFactory.getInstance().getStringProperty("servicecomb.references.transport", "").get();
        String transport = DynamicPropertyFactory.getInstance().getStringProperty(key + ".transport", defaultTransport).get();
        return this.createReferenceConfig(microserviceName, versionRule, transport);
    }

    public ReferenceConfig getReferenceConfig(String microserviceName) {
        return this.referenceConfigMap.computeIfAbsent(microserviceName, this::createReferenceConfig);
    }

    public ReferenceConfig setTransport(String microserviceName, String transport) {
        ReferenceConfig config = this.getReferenceConfig(microserviceName);
        config.setTransport(transport);
        return config;
    }
}

