/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.response;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.swagger.converter.SwaggerToClassGenerator;
import org.apache.servicecomb.swagger.invocation.context.HttpStatus;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.response.ResponseMeta;
import org.apache.servicecomb.swagger.invocation.response.ResponseMetaMapper;

public class ResponsesMeta {
    private static final JavaType COMMON_EXCEPTION_JAVA_TYPE = SimpleType.constructUnsafe(CommonExceptionData.class);
    private static final JavaType OBJECT_JAVA_TYPE = SimpleType.constructUnsafe(Object.class);
    private static final ResponseMetaMapper GLOBAL_DEFAULT_MAPPER = (ResponseMetaMapper)SPIServiceUtils.getPriorityHighestService(ResponseMetaMapper.class);
    private Map<Integer, ResponseMeta> responseMap = new HashMap<Integer, ResponseMeta>();
    private ResponseMeta defaultResponse;

    public void init(SwaggerToClassGenerator swaggerToClassGenerator, Operation operation, Type returnType) {
        this.initSuccessResponse(returnType);
        this.initGlobalDefaultMapper();
        for (Map.Entry entry : operation.getResponses().entrySet()) {
            if ("default".equals(entry.getKey())) {
                this.defaultResponse = new ResponseMeta();
                this.defaultResponse.init(swaggerToClassGenerator, (Response)entry.getValue());
                continue;
            }
            Integer statusCode = Integer.parseInt((String)entry.getKey());
            ResponseMeta responseMeta = this.responseMap.computeIfAbsent(statusCode, k -> new ResponseMeta());
            responseMeta.init(swaggerToClassGenerator, (Response)entry.getValue());
        }
        this.initInternalErrorResponse();
        if (this.defaultResponse == null) {
            ResponseMeta responseMeta = new ResponseMeta();
            responseMeta.setJavaType(OBJECT_JAVA_TYPE);
            this.defaultResponse = responseMeta;
        }
    }

    protected void initSuccessResponse(Type returnType) {
        ResponseMeta successResponse = new ResponseMeta();
        successResponse.setJavaType(TypeFactory.defaultInstance().constructType(returnType));
        this.responseMap.put(Response.Status.OK.getStatusCode(), successResponse);
    }

    protected void initInternalErrorResponse() {
        ResponseMeta internalErrorResponse = new ResponseMeta();
        internalErrorResponse.setJavaType(COMMON_EXCEPTION_JAVA_TYPE);
        this.responseMap.putIfAbsent(490, internalErrorResponse);
        this.responseMap.putIfAbsent(590, internalErrorResponse);
    }

    protected void initGlobalDefaultMapper() {
        Map<Integer, ResponseMeta> mappers;
        if (GLOBAL_DEFAULT_MAPPER != null && (mappers = GLOBAL_DEFAULT_MAPPER.getMapper()) != null) {
            this.responseMap.putAll(mappers);
        }
    }

    public ResponseMeta findResponseMeta(int statusCode) {
        ResponseMeta responseMeta = this.responseMap.get(statusCode);
        if (responseMeta == null) {
            if (HttpStatus.isSuccess((int)statusCode)) {
                return this.responseMap.get(Response.Status.OK.getStatusCode());
            }
            return this.defaultResponse;
        }
        return responseMeta;
    }
}

