/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.generator.annotation;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.ArrayList;
import org.apache.servicecomb.toolkit.generator.annotation.ClassAnnotationProcessor;
import org.apache.servicecomb.toolkit.generator.context.OasContext;

public class OpenApiDefinitionClassAnnotationProcessor
implements ClassAnnotationProcessor<OpenAPIDefinition, OasContext> {
    @Override
    public void process(OpenAPIDefinition openAPIDefinition, OasContext context) {
        Info infoAnnotation = openAPIDefinition.info();
        io.swagger.v3.oas.models.info.Info info = new io.swagger.v3.oas.models.info.Info();
        License license = new License();
        Contact contact = new Contact();
        license.url(infoAnnotation.license().url());
        license.name(infoAnnotation.license().name());
        contact.name(infoAnnotation.contact().name());
        contact.url(infoAnnotation.contact().url());
        contact.email(infoAnnotation.contact().email());
        info.description(infoAnnotation.description()).title(infoAnnotation.title()).version(infoAnnotation.version()).license(license).contact(contact);
        context.getOpenAPI().info(info);
        if (openAPIDefinition.servers() != null) {
            ArrayList<Server> serverList = new ArrayList<Server>();
            for (io.swagger.v3.oas.annotations.servers.Server server : openAPIDefinition.servers()) {
                Server server2 = new Server();
                server2.url(server.url());
                server2.description(server.description());
                serverList.add(server2);
            }
            context.getOpenAPI().servers(serverList);
        }
        if (openAPIDefinition.tags() != null) {
            ArrayList<Tag> tagList = new ArrayList<Tag>();
            for (io.swagger.v3.oas.annotations.servers.Server server : openAPIDefinition.tags()) {
                Tag tag = new Tag();
                tag.name(server.name()).description(server.description());
                tagList.add(tag);
            }
            context.getOpenAPI().tags(tagList);
        }
    }
}

