/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.generator.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverterContextImpl;
import io.swagger.v3.core.jackson.ModelResolver;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.core.util.RefUtils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import org.apache.servicecomb.toolkit.generator.annotation.ModelInterceptor;
import org.apache.servicecomb.toolkit.generator.util.ArrayModelConverter;
import org.apache.servicecomb.toolkit.generator.util.RequestResponse;

public class ModelConverter {
    private static final ModelConverterContextImpl context;
    private static final List<ModelInterceptor> interceptorMgr;

    public static void registerInterceptor(ModelInterceptor interceptor) {
        interceptorMgr.add(interceptor);
        interceptorMgr.sort(Comparator.comparingInt(ModelInterceptor::order));
    }

    public static void unRegisterInterceptor(ModelInterceptor interceptor) {
        interceptorMgr.remove(interceptor);
    }

    public static Schema getSchema(Type cls) {
        return ModelConverter.getSchema(cls, null, null);
    }

    public static Schema getSchema(Type cls, Components components, RequestResponse requestResponse) {
        Schema schema;
        for (ModelInterceptor interceptor : interceptorMgr) {
            Schema schema2 = interceptor.process(cls, components);
            if (schema2 == null) continue;
            return schema2;
        }
        if (cls instanceof Class && requestResponse != null) {
            List<Type> beanProperties = null;
            switch (requestResponse) {
                case REQUEST: {
                    beanProperties = ModelConverter.getRequestBeanTypes((Class)cls);
                    break;
                }
                case RESPONSE: {
                    beanProperties = ModelConverter.getResponseBeanTypes((Class)cls);
                    break;
                }
            }
            Optional.ofNullable(beanProperties).ifPresent(properties -> properties.forEach(type -> {
                if (type instanceof ParameterizedType) {
                    Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
                    Arrays.stream(actualTypeArguments).forEach(arg -> ModelConverter.getSchema(arg, components, requestResponse));
                }
                if (type instanceof Class) {
                    ModelConverter.getSchema(type, components, requestResponse);
                }
            }));
        }
        if ((schema = PrimitiveType.createProperty((Type)cls)) == null) {
            schema = context.resolve(new AnnotatedType(cls));
        }
        if (schema == null && cls == List.class) {
            schema = new ArraySchema();
            ((ArraySchema)schema).setItems((Schema)new ObjectSchema());
        }
        if (components == null) {
            return schema;
        }
        Schema refSchema = schema;
        if (ModelConverter.shouldExtractRef(schema)) {
            ModelConverter.ensureSchemaNameExist(schema);
            schema.$ref(null);
            components.addSchemas(schema.getName(), schema);
            refSchema = new Schema();
            refSchema.set$ref(RefUtils.constructRef((String)schema.getName()));
        }
        if (schema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)schema;
            Schema itemSchema = arraySchema.getItems();
            if (ModelConverter.shouldExtractRef(itemSchema)) {
                ModelConverter.ensureSchemaNameExist(itemSchema);
                itemSchema.$ref(null);
                components.addSchemas(itemSchema.getName(), itemSchema);
                Schema itemRefSchema = new Schema();
                itemRefSchema.set$ref(RefUtils.constructRef((String)itemSchema.getName()));
                arraySchema.setItems(itemRefSchema);
            }
            refSchema = arraySchema;
        }
        return refSchema;
    }

    private static void ensureSchemaNameExist(Schema schema) {
        if (schema.getName() != null) {
            return;
        }
        if (schema.get$ref() != null) {
            schema.setName((String)RefUtils.extractSimpleName((String)schema.get$ref()).getKey());
            return;
        }
    }

    public static boolean shouldExtractRef(Schema schema) {
        return schema.getName() != null || schema.get$ref() != null;
    }

    public static ObjectMapper mapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    public static List<Type> getRequestBeanTypes(Class cls) {
        if (cls.isPrimitive()) {
            return null;
        }
        Method[] declaredMethods = cls.getDeclaredMethods();
        ArrayList<Type> beanProperties = new ArrayList<Type>();
        for (Method method : declaredMethods) {
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || !method.getName().startsWith("set") || method.getName().length() <= 3 || !Character.isUpperCase(method.getName().charAt(3)) || !method.getReturnType().equals(Void.TYPE) || method.getParameterCount() != 1) continue;
            beanProperties.add(method.getGenericParameterTypes()[0]);
        }
        return beanProperties;
    }

    public static List<Type> getResponseBeanTypes(Class cls) {
        if (cls.isPrimitive()) {
            return null;
        }
        Method[] declaredMethods = cls.getDeclaredMethods();
        ArrayList<Type> beanPropertyTypes = new ArrayList<Type>();
        for (Method method : declaredMethods) {
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || !method.getName().startsWith("get") || method.getName().length() <= 3 || !Character.isUpperCase(method.getName().charAt(3)) || method.getReturnType().equals(Void.TYPE) || method.getParameterCount() != 0) continue;
            beanPropertyTypes.add(method.getGenericReturnType());
        }
        return beanPropertyTypes;
    }

    static {
        interceptorMgr = new ArrayList<ModelInterceptor>();
        ServiceLoader.load(ModelInterceptor.class).forEach(ModelConverter::registerInterceptor);
        ArrayModelConverter arrayModelConverter = new ArrayModelConverter(ModelConverter.mapper());
        ModelResolver modelResolver = new ModelResolver(ModelConverter.mapper());
        context = new ModelConverterContextImpl(Arrays.asList(new io.swagger.v3.core.converter.ModelConverter[]{arrayModelConverter, modelResolver}));
    }
}

