/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.util;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class StringCaseUtils {
    private static final Pattern LOWER_CAMEL_CASE = Pattern.compile("^[a-z]+((\\d)|([A-Z0-9][a-z0-9]+))*([A-Z])?$");
    private static final Pattern UPPER_CAMEL_CASE = Pattern.compile("^[A-Z]([a-z0-9]+[A-Z]?)*$");
    private static final Pattern UPPER_HYPHEN_CASE = Pattern.compile("^([A-Z][a-z0-9]*-)*([A-Z][a-z0-9]*)$");

    private StringCaseUtils() {
    }

    public static boolean isLowerCamelCase(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        return LOWER_CAMEL_CASE.matcher(string).matches();
    }

    public static boolean isUpperCamelCase(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        return UPPER_CAMEL_CASE.matcher(string).matches();
    }

    public static boolean isUpperHyphenCase(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        return UPPER_HYPHEN_CASE.matcher(string).matches();
    }

    public static boolean isMatchCase(String expectedCase, String string) {
        switch (expectedCase) {
            case "upper-camel-case": {
                return StringCaseUtils.isUpperCamelCase(string);
            }
            case "lower-camel-case": {
                return StringCaseUtils.isLowerCamelCase(string);
            }
            case "upper-hyphen-case": {
                return StringCaseUtils.isUpperHyphenCase(string);
            }
        }
        throw new IllegalArgumentException("Unrecognized case: " + expectedCase);
    }
}

