/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.matchers.text;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.mockito.ArgumentMatcher;
import org.mockito.internal.matchers.ContainsExtraTypeInfo;
import org.mockito.internal.matchers.text.FormattedText;
import org.mockito.internal.matchers.text.MatcherToString;
import org.mockito.internal.matchers.text.ValuePrinter;
import org.mockito.internal.reporting.PrintSettings;

public class MatchersPrinter {
    public String getArgumentsLine(List<ArgumentMatcher> matchers, PrintSettings printSettings) {
        Iterator<FormattedText> args = this.applyPrintSettings(matchers, printSettings);
        return ValuePrinter.printValues("(", ", ", ");", args);
    }

    public String getArgumentsBlock(List<ArgumentMatcher> matchers, PrintSettings printSettings) {
        Iterator<FormattedText> args = this.applyPrintSettings(matchers, printSettings);
        return ValuePrinter.printValues("(\n    ", ",\n    ", "\n);", args);
    }

    private Iterator<FormattedText> applyPrintSettings(List<ArgumentMatcher> matchers, PrintSettings printSettings) {
        LinkedList<FormattedText> out = new LinkedList<FormattedText>();
        int i = 0;
        for (ArgumentMatcher matcher : matchers) {
            if (matcher instanceof ContainsExtraTypeInfo && printSettings.extraTypeInfoFor(i)) {
                out.add(new FormattedText(((ContainsExtraTypeInfo)((Object)matcher)).toStringWithType()));
            } else {
                out.add(new FormattedText(MatcherToString.toString(matcher)));
            }
            ++i;
        }
        return out.iterator();
    }
}

