/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractCppCodegen;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PistacheServerCodegen
extends AbstractCppCodegen {
    protected String implFolder = "impl";

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "pistache-server";
    }

    @Override
    public String getHelp() {
        return "Generates a C++ API server (based on Pistache)";
    }

    public PistacheServerCodegen() {
        this.apiPackage = "io.swagger.server.api";
        this.modelPackage = "io.swagger.server.model";
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-source.mustache", ".cpp");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-source.mustache", ".cpp");
        this.apiTemplateFiles.put("api-impl-header.mustache", ".h");
        this.apiTemplateFiles.put("api-impl-source.mustache", ".cpp");
        this.apiTemplateFiles.put("main-api-server.mustache", ".cpp");
        this.templateDir = "pistache-server";
        this.embeddedTemplateDir = "pistache-server";
        this.cliOptions.clear();
        this.reservedWords = new HashSet();
        this.supportingFiles.add(new SupportingFile("modelbase-header.mustache", "model", "ModelBase.h"));
        this.supportingFiles.add(new SupportingFile("modelbase-source.mustache", "model", "ModelBase.cpp"));
        this.supportingFiles.add(new SupportingFile("cmake.mustache", "", "CMakeLists.txt"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("int", "char", "bool", "long", "float", "double", "int32_t", "int64_t"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("date", "std::string");
        this.typeMapping.put("DateTime", "std::string");
        this.typeMapping.put("string", "std::string");
        this.typeMapping.put("integer", "int32_t");
        this.typeMapping.put("long", "int64_t");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("array", "std::vector");
        this.typeMapping.put("map", "std::map");
        this.typeMapping.put("file", "std::string");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("binary", "std::string");
        this.typeMapping.put("number", "double");
        this.typeMapping.put("UUID", "std::string");
        this.importMapping = new HashMap();
        this.importMapping.put("std::vector", "#include <vector>");
        this.importMapping.put("std::map", "#include <map>");
        this.importMapping.put("std::string", "#include <string>");
        this.importMapping.put("Object", "#include \"Object.h\"");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.additionalProperties.put("modelNamespaceDeclarations", this.modelPackage.split("\\."));
        this.additionalProperties.put("modelNamespace", this.modelPackage.replaceAll("\\.", "::"));
        this.additionalProperties.put("apiNamespaceDeclarations", this.apiPackage.split("\\."));
        this.additionalProperties.put("apiNamespace", this.apiPackage.replaceAll("\\.", "::"));
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String toModelImport(String name) {
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        return "#include \"" + name + ".h\"";
    }

    @Override
    public CodegenModel fromModel(String name, Model model, Map<String, Model> allDefinitions) {
        CodegenModel codegenModel = super.fromModel(name, model, allDefinitions);
        Set<String> oldImports = codegenModel.imports;
        codegenModel.imports = new HashSet<String>();
        for (String imp : oldImports) {
            String newImp = this.toModelImport(imp);
            if (newImp.isEmpty()) continue;
            codegenModel.imports.add(newImp);
        }
        return codegenModel;
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Model> definitions, Swagger swagger) {
        Response methodResponse;
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, definitions, swagger);
        if (operation.getResponses() != null && !operation.getResponses().isEmpty() && (methodResponse = this.findMethodResponse(operation.getResponses())) != null && methodResponse.getSchema() != null) {
            CodegenProperty cm = this.fromProperty("response", methodResponse.getSchema());
            op.vendorExtensions.put("x-codegen-response", cm);
            if (cm.datatype == "HttpContent") {
                op.vendorExtensions.put("x-codegen-response-ishttpcontent", true);
            }
        }
        String pathForPistache = path.replaceAll("\\{(.*?)}", ":$1");
        op.vendorExtensions.put("x-codegen-pistache-path", pathForPistache);
        return op;
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        String classname = (String)operations.get("classname");
        operations.put("classnameSnakeUpperCase", DefaultCodegen.underscore(classname).toUpperCase());
        operations.put("classnameSnakeLowerCase", DefaultCodegen.underscore(classname).toLowerCase());
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            boolean consumeJson = false;
            boolean isParsingSupported = true;
            if (op.bodyParam != null) {
                if (op.bodyParam.vendorExtensions == null) {
                    op.bodyParam.vendorExtensions = new HashMap<String, Object>();
                }
                op.bodyParam.vendorExtensions.put("x-codegen-pistache-isStringOrDate", op.bodyParam.isString || op.bodyParam.isDate);
            }
            if (op.consumes != null) {
                for (Map<String, String> consume : op.consumes) {
                    if (consume.get("mediaType") == null || !consume.get("mediaType").equals("application/json")) continue;
                    consumeJson = true;
                }
            }
            op.httpMethod = op.httpMethod.substring(0, 1).toUpperCase() + op.httpMethod.substring(1).toLowerCase();
            for (CodegenParameter param : op.allParams) {
                if (param.isFormParam) {
                    isParsingSupported = false;
                }
                if (param.isFile) {
                    isParsingSupported = false;
                }
                if (param.isCookieParam) {
                    isParsingSupported = false;
                }
                if (param.isHeaderParam) {
                    param.dataType = "Optional<Net::Http::Header::Raw>";
                    param.baseType = "Optional<Net::Http::Header::Raw>";
                    continue;
                }
                if (!param.isQueryParam) continue;
                if (param.isPrimitiveType) {
                    param.dataType = "Optional<" + param.dataType + ">";
                    continue;
                }
                param.dataType = "Optional<" + param.baseType + ">";
                param.baseType = "Optional<" + param.baseType + ">";
            }
            if (op.vendorExtensions == null) {
                op.vendorExtensions = new HashMap<String, Object>();
            }
            op.vendorExtensions.put("x-codegen-pistache-consumesJson", consumeJson);
            op.vendorExtensions.put("x-codegen-pistache-isParsingSupported", isParsingSupported);
        }
        return objs;
    }

    @Override
    public String toModelFilename(String name) {
        return this.initialCaps(name);
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String result = super.apiFilename(templateName, tag);
        if (templateName.endsWith("impl-header.mustache")) {
            int ix = result.lastIndexOf(47);
            result = result.substring(0, ix) + result.substring(ix, result.length() - 2) + "Impl.h";
            result = result.replace(this.apiFileFolder(), this.implFileFolder());
        } else if (templateName.endsWith("impl-source.mustache")) {
            int ix = result.lastIndexOf(47);
            result = result.substring(0, ix) + result.substring(ix, result.length() - 4) + "Impl.cpp";
            result = result.replace(this.apiFileFolder(), this.implFileFolder());
        } else if (templateName.endsWith("api-server.mustache")) {
            int ix = result.lastIndexOf(47);
            result = result.substring(0, ix) + result.substring(ix, result.length() - 4) + "MainServer.cpp";
            result = result.replace(this.apiFileFolder(), this.outputFolder);
        }
        return result;
    }

    @Override
    public String toApiFilename(String name) {
        return this.initialCaps(name) + "Api";
    }

    @Override
    public String getTypeDeclaration(Property p) {
        String swaggerType = this.getSwaggerType(p);
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "<std::string, " + this.getTypeDeclaration(inner) + ">";
        }
        if (p instanceof StringProperty || p instanceof DateProperty || p instanceof DateTimeProperty || p instanceof FileProperty || this.languageSpecificPrimitives.contains(swaggerType)) {
            return this.toModelName(swaggerType);
        }
        return "std::shared_ptr<" + swaggerType + ">";
    }

    @Override
    public String toDefaultValue(Property p) {
        if (p instanceof StringProperty) {
            return "\"\"";
        }
        if (p instanceof BooleanProperty) {
            return "false";
        }
        if (p instanceof DateProperty) {
            return "\"\"";
        }
        if (p instanceof DateTimeProperty) {
            return "\"\"";
        }
        if (p instanceof DoubleProperty) {
            return "0.0";
        }
        if (p instanceof FloatProperty) {
            return "0.0f";
        }
        if (p instanceof LongProperty) {
            return "0L";
        }
        if (p instanceof IntegerProperty || p instanceof BaseIntegerProperty) {
            return "0";
        }
        if (p instanceof DecimalProperty) {
            return "0.0";
        }
        if (p instanceof MapProperty) {
            MapProperty ap = (MapProperty)p;
            String inner = this.getSwaggerType(ap.getAdditionalProperties());
            return "std::map<std::string, " + inner + ">()";
        }
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            String inner = this.getSwaggerType(ap.getItems());
            if (!this.languageSpecificPrimitives.contains(inner)) {
                inner = "std::shared_ptr<" + inner + ">";
            }
            return "std::vector<" + inner + ">()";
        }
        if (p instanceof RefProperty) {
            RefProperty rp = (RefProperty)p;
            return "new " + this.toModelName(rp.getSimpleRef()) + "()";
        }
        return "nullptr";
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        boolean isString;
        super.postProcessParameter(parameter);
        boolean isPrimitiveType = parameter.isPrimitiveType == Boolean.TRUE;
        boolean isListContainer = parameter.isListContainer == Boolean.TRUE;
        boolean bl = isString = parameter.isString == Boolean.TRUE;
        if (!(isPrimitiveType || isListContainer || isString || parameter.dataType.startsWith("std::shared_ptr"))) {
            parameter.dataType = "std::shared_ptr<" + parameter.dataType + ">";
        }
    }

    @Override
    public String modelFileFolder() {
        return (this.outputFolder + "/model").replace("/", File.separator);
    }

    @Override
    public String apiFileFolder() {
        return (this.outputFolder + "/api").replace("/", File.separator);
    }

    private String implFileFolder() {
        return (this.outputFolder + "/" + this.implFolder).replace("/", File.separator);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toModelName(String type) {
        if (this.typeMapping.keySet().contains(type) || this.typeMapping.values().contains(type) || this.importMapping.values().contains(type) || this.defaultIncludes.contains(type) || this.languageSpecificPrimitives.contains(type)) {
            return type;
        }
        return Character.toUpperCase(type.charAt(0)) + type.substring(1);
    }

    @Override
    public String toApiName(String type) {
        return Character.toUpperCase(type.charAt(0)) + type.substring(1) + "Api";
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }
}

