/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassMaker {
    public static void compile(String projectPath) throws IOException, TimeoutException, InterruptedException {
        Runtime runtime = Runtime.getRuntime();
        boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
        String mvnCommand = (isWindows ? "mvn.cmd" : "mvn") + " clean package -f " + projectPath;
        Process exec = runtime.exec(mvnCommand);
        Worker worker = new Worker(exec);
        worker.start();
        ProcessStatus ps = worker.getProcessStatus();
        try {
            worker.join(30000L);
            if (ps.exitCode == 1) {
                throw new RuntimeException("Command exec fail,command is: " + mvnCommand);
            }
            if (ps.exitCode == -257) {
                worker.interrupt();
                throw new TimeoutException();
            }
        }
        catch (InterruptedException e) {
            worker.interrupt();
            throw e;
        }
    }

    private static abstract class ExecReader
    extends Thread {
        public final Logger LOGGER;
        private final InputStream is;
        private final String readerName;

        public ExecReader(InputStream is, String readerName) {
            this.is = is;
            this.readerName = readerName;
            this.LOGGER = LoggerFactory.getLogger((String)(ExecReader.class.getName() + "-" + readerName));
        }

        @Override
        public void run() {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.is));
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    this.afterReadLine(line);
                }
            }
            catch (IOException e) {
                this.LOGGER.error(this.readerName, (Throwable)e);
            }
        }

        public abstract void afterReadLine(String var1);
    }

    public static class ProcessStatus {
        static final int CODE_STARTED = -257;
        static final int CODE_FAIL = 1;
        volatile int exitCode;
        volatile String output;
    }

    private static class Worker
    extends Thread {
        private final Process process;
        private ProcessStatus ps;

        private Worker(Process process) {
            this.process = process;
            this.ps = new ProcessStatus();
        }

        @Override
        public void run() {
            try {
                new ExecReader(this.process.getInputStream(), "Command Exec Result Reader"){

                    @Override
                    public void afterReadLine(String line) {
                        this.LOGGER.info(line);
                    }
                }.start();
                new ExecReader(this.process.getErrorStream(), "Command Exec Error Reader"){

                    @Override
                    public void afterReadLine(String line) {
                        this.LOGGER.error(line);
                    }
                }.start();
                this.ps.exitCode = this.process.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        ProcessStatus getProcessStatus() {
            return this.ps;
        }
    }
}

