/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import javax.servlet.http.Cookie;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class MockCookie
extends Cookie {
    private static final long serialVersionUID = 4312531139502726325L;
    @Nullable
    private String sameSite;

    public MockCookie(String name, String value) {
        super(name, value);
    }

    public void setSameSite(@Nullable String sameSite) {
        this.sameSite = sameSite;
    }

    @Nullable
    public String getSameSite() {
        return this.sameSite;
    }

    public static MockCookie parse(String setCookieHeader) {
        Assert.notNull((Object)setCookieHeader, (String)"Set-Cookie header must not be null");
        String[] cookieParts = setCookieHeader.split("\\s*=\\s*", 2);
        Assert.isTrue((cookieParts.length == 2 ? 1 : 0) != 0, () -> "Invalid Set-Cookie header '" + setCookieHeader + "'");
        String name = cookieParts[0];
        String[] valueAndAttributes = cookieParts[1].split("\\s*;\\s*", 2);
        String value = valueAndAttributes[0];
        String[] attributes = valueAndAttributes.length > 1 ? valueAndAttributes[1].split("\\s*;\\s*") : new String[]{};
        MockCookie cookie = new MockCookie(name, value);
        for (String attribute : attributes) {
            if (attribute.startsWith("Domain")) {
                cookie.setDomain(MockCookie.extractAttributeValue(attribute, setCookieHeader));
                continue;
            }
            if (attribute.startsWith("Max-Age")) {
                cookie.setMaxAge(Integer.parseInt(MockCookie.extractAttributeValue(attribute, setCookieHeader)));
                continue;
            }
            if (attribute.startsWith("Path")) {
                cookie.setPath(MockCookie.extractAttributeValue(attribute, setCookieHeader));
                continue;
            }
            if (attribute.startsWith("Secure")) {
                cookie.setSecure(true);
                continue;
            }
            if (attribute.startsWith("HttpOnly")) {
                cookie.setHttpOnly(true);
                continue;
            }
            if (!attribute.startsWith("SameSite")) continue;
            cookie.setSameSite(MockCookie.extractAttributeValue(attribute, setCookieHeader));
        }
        return cookie;
    }

    private static String extractAttributeValue(String attribute, String header) {
        String[] nameAndValue = attribute.split("=");
        Assert.isTrue((nameAndValue.length == 2 ? 1 : 0) != 0, () -> "No value in attribute '" + nameAndValue[0] + "' for Set-Cookie header '" + header + "'");
        return nameAndValue[1];
    }
}

