/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.codegen;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.servicecomb.toolkit.codegen.AbstractMultiDirectoryStrategy;
import org.apache.servicecomb.toolkit.codegen.ServiceType;
import org.openapitools.codegen.SupportingFile;

public class SpringCloudMultiDirectoryStrategy
extends AbstractMultiDirectoryStrategy {
    private String consumerTemplateFolder = "consumer/openfeign";
    private String providerTemplateFolder = "provider/servlet";
    private String apiConsumerTemplate = this.consumerTemplateFolder + "/apiConsumer.mustache";

    @Override
    public String modelDirectory() {
        return Optional.ofNullable((String)this.propertiesMap.get("modelProjectName")).orElse("model");
    }

    @Override
    public String providerDirectory() {
        return Optional.ofNullable((String)this.propertiesMap.get("providerProjectName")).orElse("provider");
    }

    @Override
    public String consumerDirectory() {
        return Optional.ofNullable((String)this.propertiesMap.get("consumerProjectName")).orElse("consumer");
    }

    @Override
    public void processSupportingFile(List<SupportingFile> supportingFiles) {
        super.processSupportingFile(supportingFiles);
        this.processProvider(supportingFiles);
        this.processConsumer(supportingFiles);
        this.processModel(supportingFiles);
        this.propertiesMap.put("isMultipleModule", true);
        supportingFiles.add(new SupportingFile("project/pom.mustache", "", "pom.xml"));
    }

    private void processModel(List<SupportingFile> supportingFiles) {
        this.propertiesMap.computeIfAbsent("modelArtifactId", k -> this.modelDirectory());
        this.propertiesMap.put("modelProjectName", this.modelDirectory());
        supportingFiles.add(new SupportingFile("model/pom.mustache", this.modelDirectory(), "pom.xml"));
    }

    private void processProvider(List<SupportingFile> supportingFiles) {
        supportingFiles.add(new SupportingFile(this.providerTemplateFolder + "/applicationYml.mustache", this.resourcesFolder(this.providerDirectory()), "application.yml"));
        supportingFiles.add(new SupportingFile(this.providerTemplateFolder + "/pom.mustache", this.providerDirectory(), "pom.xml"));
        supportingFiles.add(new SupportingFile(this.providerTemplateFolder + "/Application.mustache", this.mainClassFolder(this.providerDirectory()), "Application.java"));
        this.propertiesMap.computeIfAbsent("providerArtifactId", k -> this.providerDirectory());
        this.propertiesMap.put("providerProjectName", this.providerDirectory());
    }

    private void processConsumer(List<SupportingFile> supportingFiles) {
        supportingFiles.add(new SupportingFile(this.consumerTemplateFolder + "/applicationYml.mustache", this.resourcesFolder(this.consumerDirectory()), "application.yml"));
        supportingFiles.add(new SupportingFile(this.consumerTemplateFolder + "/pom.mustache", this.consumerDirectory(), "pom.xml"));
        supportingFiles.add(new SupportingFile(this.consumerTemplateFolder + "/Application.mustache", this.mainClassFolder(this.consumerDirectory()), "Application.java"));
        this.propertiesMap.computeIfAbsent("consumerArtifactId", k -> this.consumerDirectory());
        this.propertiesMap.put("consumerProjectName", this.consumerDirectory());
        this.propertiesMap.put(this.apiConsumerTemplate, ServiceType.CONSUMER.getValue());
        Map apiTemplateFiles = (Map)this.propertiesMap.get("apiTemplateFiles");
        apiTemplateFiles.put(this.apiConsumerTemplate, ".java");
    }
}

