/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JMSPropertyType;
import org.apache.cxf.transport.jms.uri.JMSEndpoint;
import org.apache.cxf.transport.jms.util.JMSMessageConverter;
import org.apache.cxf.transport.jms.util.JMSUtil;

final class JMSMessageUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(JMSMessageUtils.class);

    private JMSMessageUtils() {
    }

    public static Message asCXFMessage(javax.jms.Message message, String headerType) throws UnsupportedEncodingException, JMSException {
        MessageImpl inMessage = new MessageImpl();
        JMSMessageUtils.populateIncomingContext(message, (Message)inMessage, headerType);
        JMSMessageUtils.retrieveAndSetPayload((Message)inMessage, message);
        return inMessage;
    }

    public static void retrieveAndSetPayload(Message inMessage, javax.jms.Message message) throws UnsupportedEncodingException, JMSException {
        String messageType = null;
        Object converted = new JMSMessageConverter().fromMessage(message);
        if (converted instanceof String) {
            inMessage.setContent(Reader.class, (Object)new StringReader((String)converted));
            messageType = "text";
        } else if (converted instanceof byte[]) {
            inMessage.setContent(InputStream.class, (Object)new ByteArrayInputStream((byte[])converted));
            messageType = "byte";
        } else {
            messageType = "unknown";
        }
        TreeMap<String, List<String>> headers = CastUtils.cast((Map)((Map)inMessage.get((Object)Message.PROTOCOL_HEADERS)));
        if (headers == null) {
            headers = new TreeMap<String, List<String>>();
            inMessage.put((Object)Message.PROTOCOL_HEADERS, headers);
        }
        headers.put("JMSMessageType", Collections.singletonList(messageType));
    }

    private static void populateIncomingContext(javax.jms.Message message, Message inMessage, String messageType) throws UnsupportedEncodingException, JMSException {
        JMSMessageHeadersType messageProperties = null;
        messageProperties = (JMSMessageHeadersType)inMessage.get((Object)messageType);
        if (messageProperties == null) {
            messageProperties = new JMSMessageHeadersType();
            inMessage.put((Object)messageType, (Object)messageProperties);
        }
        messageProperties.setJMSCorrelationID(message.getJMSCorrelationID());
        messageProperties.setJMSDeliveryMode(message.getJMSDeliveryMode());
        messageProperties.setJMSExpiration(message.getJMSExpiration());
        messageProperties.setJMSMessageID(message.getJMSMessageID());
        messageProperties.setJMSPriority(message.getJMSPriority());
        messageProperties.setJMSRedelivered(message.getJMSRedelivered());
        messageProperties.setJMSTimeStamp(message.getJMSTimestamp());
        messageProperties.setJMSType(message.getJMSType());
        if (message.getJMSReplyTo() != null) {
            Destination replyTo = message.getJMSReplyTo();
            if (replyTo instanceof Queue) {
                messageProperties.setJMSReplyTo(((Queue)replyTo).getQueueName());
            } else if (replyTo instanceof Topic) {
                messageProperties.setJMSReplyTo(((Topic)replyTo).getTopicName());
            }
        }
        TreeMap<String, List<String>> protHeaders = new TreeMap<String, List<String>>();
        List<JMSPropertyType> props = messageProperties.getProperty();
        Enumeration enm = CastUtils.cast((Enumeration)message.getPropertyNames());
        while (enm.hasMoreElements()) {
            String name = (String)enm.nextElement();
            String val = message.getStringProperty(name);
            JMSPropertyType prop = new JMSPropertyType();
            prop.setName(name);
            prop.setValue(val);
            props.add(prop);
            protHeaders.put(name, Collections.singletonList(val));
            if (name.equals("Content-Type") || name.equals("SOAPJMS_contentType") && val != null) {
                inMessage.put((Object)"Content-Type", (Object)val);
                inMessage.put((Object)Message.ENCODING, (Object)JMSMessageUtils.getEncoding(val));
            }
            if (!name.equals(Message.RESPONSE_CODE)) continue;
            inMessage.put((Object)Message.RESPONSE_CODE, (Object)Integer.valueOf(val));
        }
        inMessage.put((Object)Message.PROTOCOL_HEADERS, protHeaders);
        JMSMessageUtils.populateIncomingMessageProperties(message, inMessage, messageProperties);
    }

    private static void populateIncomingMessageProperties(javax.jms.Message jmsMessage, Message inMessage, JMSMessageHeadersType messageProperties) throws UnsupportedEncodingException, JMSException {
        if (jmsMessage.propertyExists("SOAPJMS_targetService")) {
            messageProperties.setSOAPJMSTargetService(jmsMessage.getStringProperty("SOAPJMS_targetService"));
        }
        if (jmsMessage.propertyExists("SOAPJMS_bindingVersion")) {
            messageProperties.setSOAPJMSBindingVersion(jmsMessage.getStringProperty("SOAPJMS_bindingVersion"));
        }
        if (jmsMessage.propertyExists("SOAPJMS_contentType")) {
            messageProperties.setSOAPJMSContentType(jmsMessage.getStringProperty("SOAPJMS_contentType"));
        }
        if (jmsMessage.propertyExists("SOAPJMS_contentEncoding")) {
            messageProperties.setSOAPJMSContentEncoding(jmsMessage.getStringProperty("SOAPJMS_contentEncoding"));
        }
        if (jmsMessage.propertyExists("SOAPJMS_soapAction")) {
            messageProperties.setSOAPJMSSOAPAction(jmsMessage.getStringProperty("SOAPJMS_soapAction"));
        }
        if (jmsMessage.propertyExists("SOAPJMS_isFault")) {
            messageProperties.setSOAPJMSIsFault(jmsMessage.getBooleanProperty("SOAPJMS_isFault"));
        }
        if (jmsMessage.propertyExists("SOAPJMS_requestURI")) {
            messageProperties.setSOAPJMSRequestURI(jmsMessage.getStringProperty("SOAPJMS_requestURI"));
            TreeMap<String, List<String>> headers = CastUtils.cast((Map)((Map)inMessage.get((Object)Message.PROTOCOL_HEADERS)));
            if (headers == null) {
                headers = new TreeMap<String, List<String>>();
                inMessage.put((Object)Message.PROTOCOL_HEADERS, headers);
            }
            try {
                String requestURI = jmsMessage.getStringProperty("SOAPJMS_requestURI");
                JMSEndpoint endpoint = new JMSEndpoint(requestURI);
                if (endpoint.getTargetService() != null) {
                    headers.put("target.service.inrequesturi", Collections.singletonList("true"));
                }
                if (requestURI != null) {
                    inMessage.put((Object)"org.apache.cxf.request.uri", (Object)requestURI);
                }
            }
            catch (Exception e) {
                headers.put("malformed.requesturi", Collections.singletonList("true"));
            }
        }
        if (messageProperties.isSetSOAPJMSContentType()) {
            String contentType = messageProperties.getSOAPJMSContentType();
            inMessage.put((Object)"Content-Type", (Object)contentType);
            inMessage.put((Object)Message.ENCODING, (Object)JMSMessageUtils.getEncoding(contentType));
        }
    }

    public static SecurityContext buildSecurityContext(javax.jms.Message message, JMSConfiguration config) throws JMSException {
        String tempUserName = message.getStringProperty("JMSXUserID");
        if (tempUserName == null && config.isJmsProviderTibcoEms()) {
            tempUserName = message.getStringProperty("JMS_TIBCO_SENDER");
        }
        if (tempUserName == null) {
            return null;
        }
        final String jmsUserName = tempUserName;
        final Principal principal = new Principal(){

            @Override
            public String getName() {
                return jmsUserName;
            }
        };
        SecurityContext securityContext = new SecurityContext(){

            public Principal getUserPrincipal() {
                return principal;
            }

            public boolean isUserInRole(String role) {
                return false;
            }
        };
        return securityContext;
    }

    static String getEncoding(String ct) throws UnsupportedEncodingException {
        String normalizedEncoding;
        String[] tokens;
        String contentType = ct.toLowerCase();
        String enc = null;
        for (String token : tokens = StringUtils.split((String)contentType, (String)";")) {
            int index = token.indexOf("charset=");
            if (index < 0) continue;
            enc = token.substring(index + 8);
            break;
        }
        if ((normalizedEncoding = HttpHeaderHelper.mapCharset(enc, (String)StandardCharsets.UTF_8.name())) == null) {
            String m = new org.apache.cxf.common.i18n.Message("INVALID_ENCODING_MSG", LOG, new Object[]{enc}).toString();
            LOG.log(Level.WARNING, m);
            throw new UnsupportedEncodingException(m);
        }
        return normalizedEncoding;
    }

    private static String getContentType(Message message) {
        TreeMap headers;
        String contentType = (String)message.get((Object)"Content-Type");
        String enc = (String)message.get((Object)Message.ENCODING);
        if (null != contentType) {
            if (enc != null && contentType.indexOf("charset=") == -1 && !contentType.toLowerCase().contains("multipart/related")) {
                contentType = contentType + "; charset=" + enc;
            }
        } else {
            contentType = enc != null ? "text/xml; charset=" + enc : "text/xml";
        }
        if (null == (headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS))))) {
            headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            message.put((Object)Message.PROTOCOL_HEADERS, headers);
        }
        return contentType;
    }

    private static String getContentEncoding(Message message) {
        List l;
        Map headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (headers != null && (l = (List)headers.get("Content-Encoding")) != null && !l.isEmpty()) {
            return (String)l.get(0);
        }
        return null;
    }

    public static javax.jms.Message asJMSMessage(JMSConfiguration jmsConfig, Message outMessage, Object payload, String messageType, Session session, String correlationId, String headerType) throws JMSException {
        javax.jms.Message jmsMessage = JMSUtil.createAndSetPayload(payload, session, messageType);
        JMSMessageHeadersType messageProperties = JMSMessageUtils.getOrCreateHeader(outMessage, headerType);
        JMSMessageUtils.prepareJMSMessageHeaderProperties(messageProperties, outMessage, jmsConfig);
        JMSMessageUtils.prepareJMSMessageProperties(messageProperties, outMessage, jmsConfig.getTargetService(), jmsConfig.getRequestURI());
        JMSMessageUtils.setJMSMessageProperties(jmsMessage, messageProperties);
        jmsMessage.setJMSCorrelationID(correlationId);
        return jmsMessage;
    }

    private static JMSMessageHeadersType getOrCreateHeader(Message message, String headerName) {
        JMSMessageHeadersType messageProperties = (JMSMessageHeadersType)message.get((Object)headerName);
        if (messageProperties == null) {
            messageProperties = new JMSMessageHeadersType();
            message.put((Object)headerName, (Object)messageProperties);
        }
        return messageProperties;
    }

    static void setJMSMessageProperties(javax.jms.Message jmsMessage, JMSMessageHeadersType messageProperties) throws JMSException {
        if (messageProperties == null) {
            return;
        }
        JMSMessageUtils.setProp(jmsMessage, "SOAPJMS_targetService", messageProperties.getSOAPJMSTargetService());
        JMSMessageUtils.setProp(jmsMessage, "SOAPJMS_bindingVersion", messageProperties.getSOAPJMSBindingVersion());
        JMSMessageUtils.setProp(jmsMessage, "SOAPJMS_contentType", messageProperties.getSOAPJMSContentType());
        JMSMessageUtils.setProp(jmsMessage, "SOAPJMS_contentEncoding", messageProperties.getSOAPJMSContentEncoding());
        JMSMessageUtils.setProp(jmsMessage, "SOAPJMS_soapAction", messageProperties.getSOAPJMSSOAPAction());
        JMSMessageUtils.setProp(jmsMessage, "SOAPJMS_requestURI", messageProperties.getSOAPJMSRequestURI());
        if (messageProperties.isSetSOAPJMSIsFault()) {
            jmsMessage.setBooleanProperty("SOAPJMS_isFault", messageProperties.isSOAPJMSIsFault());
        }
        if (messageProperties.isSetProperty()) {
            for (JMSPropertyType prop : messageProperties.getProperty()) {
                jmsMessage.setStringProperty(prop.getName(), prop.getValue());
            }
        }
    }

    private static void setProp(javax.jms.Message jmsMessage, String name, String value) throws JMSException {
        if (value != null) {
            jmsMessage.setStringProperty(name, value);
        }
    }

    private static void prepareJMSMessageHeaderProperties(JMSMessageHeadersType messageProperteis, Message outMessage, JMSConfiguration jmsConfig) {
        if (!messageProperteis.isSetJMSDeliveryMode()) {
            messageProperteis.setJMSDeliveryMode(jmsConfig.getDeliveryMode());
        }
        if (!messageProperteis.isSetTimeToLive()) {
            messageProperteis.setTimeToLive(jmsConfig.getTimeToLive());
        }
        if (!messageProperteis.isSetJMSPriority()) {
            messageProperteis.setJMSPriority(jmsConfig.getPriority());
        }
    }

    private static void prepareJMSMessageProperties(JMSMessageHeadersType messageProperties, Message outMessage, String targetService, String requestURI) {
        boolean isSoapMessage;
        Map headers = CastUtils.cast((Map)((Map)outMessage.get((Object)Message.PROTOCOL_HEADERS)));
        boolean bl = isSoapMessage = !MessageUtils.isTrue((Object)outMessage.getExchange().get((Object)"org.apache.cxf.rest.message"));
        if (isSoapMessage) {
            String soapAction;
            if (!messageProperties.isSetSOAPJMSTargetService()) {
                messageProperties.setSOAPJMSTargetService(targetService);
            }
            if (!messageProperties.isSetSOAPJMSBindingVersion()) {
                messageProperties.setSOAPJMSBindingVersion("1.0");
            }
            messageProperties.setSOAPJMSContentType(JMSMessageUtils.getContentType(outMessage));
            if (JMSMessageUtils.getContentEncoding(outMessage) != null) {
                messageProperties.setSOAPJMSContentEncoding(JMSMessageUtils.getContentEncoding(outMessage));
            }
            if ((soapAction = JMSMessageUtils.getSoapAction(messageProperties, outMessage, headers)) != null) {
                messageProperties.setSOAPJMSSOAPAction(soapAction);
            }
            if (!messageProperties.isSetSOAPJMSIsFault()) {
                boolean bl2 = outMessage.getContent(Exception.class) != null;
                messageProperties.setSOAPJMSIsFault(bl2);
            }
            if (!messageProperties.isSetSOAPJMSRequestURI()) {
                messageProperties.setSOAPJMSRequestURI(requestURI);
            }
        } else {
            if (MessageUtils.isRequestor((Message)outMessage)) {
                JMSMessageUtils.addJMSPropertiesFromMessage(messageProperties, outMessage, "org.apache.cxf.request.method", "org.apache.cxf.request.uri", "Accept");
            } else {
                JMSMessageUtils.addJMSPropertyFromMessage(messageProperties, outMessage, Message.RESPONSE_CODE);
            }
            JMSMessageUtils.addJMSPropertyFromMessage(messageProperties, outMessage, "Content-Type");
        }
        if (headers != null) {
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                JMSPropertyType prop = JMSMessageUtils.asJmsProperty(entry);
                messageProperties.getProperty().add(prop);
            }
        }
    }

    private static JMSPropertyType asJmsProperty(Map.Entry<String, List<String>> ent) {
        JMSPropertyType prop = new JMSPropertyType();
        prop.setName(ent.getKey());
        if (ent.getValue().size() > 1) {
            StringBuilder b = new StringBuilder();
            for (String s : ent.getValue()) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(s);
            }
            prop.setValue(b.toString());
        } else {
            prop.setValue(ent.getValue().get(0));
        }
        return prop;
    }

    private static String getSoapAction(JMSMessageHeadersType messageProperties, Message outMessage, Map<String, List<String>> headers) {
        List<String> action;
        String soapAction = null;
        if (headers != null && (action = headers.remove("SOAPAction")) != null && action.size() > 0) {
            soapAction = action.get(0);
        }
        if (soapAction == null) {
            soapAction = messageProperties.getSOAPJMSSOAPAction();
        }
        if (soapAction == null) {
            soapAction = JMSMessageUtils.extractActionFromSoap12(outMessage);
        }
        return soapAction;
    }

    private static void addJMSPropertiesFromMessage(JMSMessageHeadersType messageProperties, Message message, String ... keys) {
        for (String key : keys) {
            JMSMessageUtils.addJMSPropertyFromMessage(messageProperties, message, key);
        }
    }

    private static void addJMSPropertyFromMessage(JMSMessageHeadersType messageProperties, Message message, String key) {
        Object value = message.get((Object)key);
        if (value != null) {
            JMSPropertyType prop = new JMSPropertyType();
            prop.setName(key);
            prop.setValue(value.toString());
            messageProperties.getProperty().add(prop);
        }
    }

    public static String getMessageType(javax.jms.Message request) {
        String msgType = request instanceof TextMessage ? "text" : (request instanceof BytesMessage ? "byte" : "binary");
        return msgType;
    }

    private static String extractActionFromSoap12(Message message) {
        String ct = (String)message.get((Object)"Content-Type");
        if (ct == null) {
            return null;
        }
        int start = ct.indexOf("action=");
        if (start != -1) {
            int end;
            if (ct.charAt(start + 7) == '\"') {
                end = ct.indexOf(34, start += 8);
            } else {
                end = ct.indexOf(59, start += 7);
                if (end == -1) {
                    end = ct.length();
                }
            }
            return ct.substring(start, end);
        }
        return null;
    }

    public static boolean isMtomEnabled(Message message) {
        return MessageUtils.isTrue((Object)message.getContextualProperty("mtom-enabled"));
    }
}

