/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.util;

import java.util.HashMap;
import java.util.Map;
import org.ops4j.lang.NullArgumentException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicePropertiesUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ServicePropertiesUtils.class);

    private ServicePropertiesUtils() {
    }

    public static String getStringProperty(ServiceReference<?> serviceReference, String key) {
        NullArgumentException.validateNotNull(serviceReference, "Service reference");
        NullArgumentException.validateNotEmpty(key, true, "Property key");
        Object value = serviceReference.getProperty(key);
        if (value != null && !(value instanceof String)) {
            LOG.error("Property [" + key + "] value must be a String");
            return null;
        }
        return (String)value;
    }

    public static Map<String, Object> getSubsetStartingWith(ServiceReference<?> serviceReference, String prefix) {
        HashMap<String, Object> subset = new HashMap<String, Object>();
        for (String key : serviceReference.getPropertyKeys()) {
            if (key == null || !key.startsWith(prefix) || key.trim().length() <= prefix.length()) continue;
            subset.put(key.substring(prefix.length()), serviceReference.getProperty(key));
        }
        if (subset.isEmpty()) {
            return null;
        }
        return subset;
    }
}

