/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.container;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.aries.blueprint.ExtendedReferenceMetadata;
import org.apache.aries.blueprint.container.AbstractServiceReferenceRecipe;
import org.apache.aries.blueprint.container.AggregateConverter;
import org.apache.aries.blueprint.container.Voidable;
import org.apache.aries.blueprint.di.CollectionRecipe;
import org.apache.aries.blueprint.di.Recipe;
import org.apache.aries.blueprint.di.ValueRecipe;
import org.apache.aries.blueprint.services.ExtendedBlueprintContainer;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.container.ReifiedType;
import org.osgi.service.blueprint.container.ServiceUnavailableException;
import org.osgi.service.blueprint.reflect.ReferenceMetadata;
import org.osgi.service.blueprint.reflect.ServiceReferenceMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceRecipe
extends AbstractServiceReferenceRecipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceRecipe.class);
    private final ReferenceMetadata metadata;
    private Object proxy;
    private final Object monitor = new Object();
    private volatile ServiceReference trackedServiceReference;
    private volatile Object trackedService;
    private Object defaultBean;
    private final Collection<Class<?>> proxyChildBeanClasses;
    private final Collection<WeakReference<Voidable>> proxiedChildren;

    public ReferenceRecipe(String name, ExtendedBlueprintContainer blueprintContainer, ReferenceMetadata metadata, ValueRecipe filterRecipe, CollectionRecipe listenersRecipe, List<Recipe> explicitDependencies) {
        super(name, blueprintContainer, (ServiceReferenceMetadata)metadata, filterRecipe, listenersRecipe, explicitDependencies);
        this.metadata = metadata;
        this.proxyChildBeanClasses = metadata instanceof ExtendedReferenceMetadata ? ((ExtendedReferenceMetadata)metadata).getProxyChildBeanClasses() : null;
        this.proxiedChildren = this.proxyChildBeanClasses != null ? new ArrayList<WeakReference<Voidable>>() : null;
    }

    @Override
    protected Object internalCreate() throws ComponentDefinitionException {
        try {
            if (this.explicitDependencies != null) {
                for (Recipe recipe : this.explicitDependencies) {
                    recipe.create();
                }
            }
            HashSet interfaces = new HashSet();
            Class clz = this.getInterfaceClass();
            if (clz != null) {
                interfaces.add(clz);
            }
            if (this.metadata instanceof ExtendedReferenceMetadata) {
                interfaces.addAll(this.loadAllClasses(((ExtendedReferenceMetadata)this.metadata).getExtraInterfaces()));
            }
            this.proxy = this.createProxy(new ServiceDispatcher(), interfaces);
            ServiceProxyWrapper wrapper = new ServiceProxyWrapper();
            this.addPartialObject(wrapper);
            this.createListeners();
            this.updateListeners();
            return wrapper;
        }
        catch (ComponentDefinitionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ComponentDefinitionException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        Object object = this.monitor;
        synchronized (object) {
            this.unbind();
            this.monitor.notifyAll();
        }
    }

    @Override
    protected void retrack() {
        ServiceReference ref = this.getBestServiceReference();
        if (ref != null) {
            this.bind(ref);
        } else {
            this.unbind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void track(ServiceReference ref) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.trackedServiceReference == null) {
                this.retrack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void untrack(ServiceReference ref) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.trackedServiceReference == ref) {
                this.retrack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind(ServiceReference ref) {
        LOGGER.debug("Binding reference {} to {}", (Object)this.getName(), (Object)ref);
        Object object = this.monitor;
        synchronized (object) {
            ServiceReference oldReference = this.trackedServiceReference;
            this.trackedServiceReference = ref;
            this.voidProxiedChildren();
            this.bind(this.trackedServiceReference, this.proxy);
            if (ref != oldReference) {
                if (oldReference != null && this.trackedService != null) {
                    try {
                        this.blueprintContainer.getBundleContext().ungetService(oldReference);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                this.trackedService = null;
            }
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbind() {
        LOGGER.debug("Unbinding reference {}", (Object)this.getName());
        Object object = this.monitor;
        synchronized (object) {
            if (this.trackedServiceReference != null) {
                this.unbind(this.trackedServiceReference, this.proxy);
                ServiceReference oldReference = this.trackedServiceReference;
                this.trackedServiceReference = null;
                this.voidProxiedChildren();
                if (this.trackedService != null) {
                    try {
                        this.getBundleContextForServiceLookup().ungetService(oldReference);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    this.trackedService = null;
                }
                this.monitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getService() throws InterruptedException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.isStarted() && this.trackedServiceReference == null && this.metadata.getTimeout() > 0L && this.metadata.getAvailability() == 1) {
                this.blueprintContainer.getEventDispatcher().blueprintEvent(this.createWaitingevent());
                this.monitor.wait(this.metadata.getTimeout());
            }
            Object result = null;
            if (this.trackedServiceReference == null) {
                if (!this.isStarted()) throw new ServiceUnavailableException("The Blueprint container is being or has been destroyed: " + this.getOsgiFilter(), this.getOsgiFilter());
                boolean failed = true;
                if (this.metadata.getAvailability() == 2 && this.metadata instanceof ExtendedReferenceMetadata) {
                    if (this.defaultBean == null) {
                        String defaultBeanId = ((ExtendedReferenceMetadata)this.metadata).getDefaultBean();
                        if (defaultBeanId != null) {
                            this.defaultBean = this.blueprintContainer.getComponentInstance(defaultBeanId);
                            failed = false;
                        }
                    } else {
                        failed = false;
                    }
                    result = this.defaultBean;
                }
                if (!failed) return result;
                if (this.metadata.getAvailability() == 1) {
                    LOGGER.info("Timeout expired when waiting for mandatory OSGi service reference {}", (Object)this.getOsgiFilter());
                    throw new ServiceUnavailableException("Timeout expired when waiting for mandatory OSGi service reference: " + this.getOsgiFilter(), this.getOsgiFilter());
                }
                LOGGER.info("No matching service for optional OSGi service reference {}", (Object)this.getOsgiFilter());
                throw new ServiceUnavailableException("No matching service for optional OSGi service reference: " + this.getOsgiFilter(), this.getOsgiFilter());
            }
            if (this.trackedService == null) {
                this.trackedService = this.getServiceSecurely(this.trackedServiceReference);
            }
            if (this.trackedService != null) return this.trackedService;
            throw new IllegalStateException("getService() returned null for " + this.trackedServiceReference);
        }
    }

    private BlueprintEvent createWaitingevent() {
        return new BlueprintEvent(7, this.blueprintContainer.getBundleContext().getBundle(), this.blueprintContainer.getExtenderBundle(), new String[]{this.getOsgiFilter()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceReference getServiceReference() throws InterruptedException {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.optional) {
                this.getService();
            }
            return this.trackedServiceReference;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void voidProxiedChildren() {
        if (this.proxyChildBeanClasses != null) {
            Collection<WeakReference<Voidable>> collection = this.proxiedChildren;
            synchronized (collection) {
                Iterator<WeakReference<Voidable>> it = this.proxiedChildren.iterator();
                while (it.hasNext()) {
                    Voidable v = (Voidable)it.next().get();
                    if (v == null) {
                        it.remove();
                        continue;
                    }
                    v.voidReference();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVoidableChild(Voidable v) {
        if (this.proxyChildBeanClasses != null) {
            Collection<WeakReference<Voidable>> collection = this.proxiedChildren;
            synchronized (collection) {
                this.proxiedChildren.add(new WeakReference<Voidable>(v));
            }
        } else {
            throw new IllegalStateException("Proxying of child beans is disabled for this recipe");
        }
    }

    public Collection<Class<?>> getProxyChildBeanClasses() {
        return this.proxyChildBeanClasses;
    }

    public class ServiceProxyWrapper
    implements AggregateConverter.Convertible {
        @Override
        public Object convert(ReifiedType type) throws Exception {
            if (type.getRawClass() == ServiceReference.class) {
                return ReferenceRecipe.this.getServiceReference();
            }
            if (type.getRawClass().isInstance(ReferenceRecipe.this.proxy)) {
                return ReferenceRecipe.this.proxy;
            }
            throw new ComponentDefinitionException("Unable to convert to " + type);
        }
    }

    public class ServiceDispatcher
    implements Callable<Object> {
        @Override
        public Object call() throws Exception {
            return ReferenceRecipe.this.getService();
        }
    }
}

