/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.io.PrintStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.camel.commands.AbstractCamelCommand;
import org.apache.camel.commands.CamelController;

public class CatalogEipListCommand
extends AbstractCamelCommand {
    private static final String NAME_COLUMN_LABEL = "Name";
    private static final String LABEL_COLUMN_LABEL = "Label";
    private static final String DESCRIPTION_COLUMN_LABEL = "Description";
    private static final int DEFAULT_COLUMN_WIDTH_INCREMENT = 0;
    private static final String DEFAULT_FIELD_PREAMBLE = " ";
    private static final String DEFAULT_FIELD_POSTAMBLE = " ";
    private static final String DEFAULT_HEADER_PREAMBLE = " ";
    private static final String DEFAULT_HEADER_POSTAMBLE = " ";
    private static final int DEFAULT_FORMAT_BUFFER_LENGTH = 24;
    private static final int MAX_COLUMN_WIDTH = 120;
    private static final int MIN_COLUMN_WIDTH = 12;
    private boolean verbose;
    private String label;

    public CatalogEipListCommand(boolean verbose, String label) {
        this.verbose = verbose;
        this.label = label;
    }

    @Override
    public Object execute(CamelController camelController, PrintStream out, PrintStream err) throws Exception {
        List<Map<String, String>> models = camelController.listEipsCatalog(this.label);
        if (models == null || models.isEmpty()) {
            return null;
        }
        Map<String, Integer> columnWidths = this.computeColumnWidths(models);
        String headerFormat = this.buildFormatString(columnWidths, true);
        String rowFormat = this.buildFormatString(columnWidths, false);
        if (this.verbose) {
            out.println(String.format(headerFormat, NAME_COLUMN_LABEL, LABEL_COLUMN_LABEL, DESCRIPTION_COLUMN_LABEL));
            out.println(String.format(headerFormat, "----", "-----", "-----------"));
        } else {
            out.println(String.format(headerFormat, NAME_COLUMN_LABEL, LABEL_COLUMN_LABEL));
            out.println(String.format(headerFormat, "----", "-----"));
        }
        for (Map<String, String> component : models) {
            String label;
            String name;
            if (this.verbose) {
                name = this.safeNull(component.get("name"));
                label = this.safeNull(component.get("label"));
                String description = this.safeNull(component.get("description"));
                out.println(String.format(rowFormat, name, label, description));
                continue;
            }
            name = this.safeNull(component.get("name"));
            label = this.safeNull(component.get("label"));
            out.println(String.format(rowFormat, name, label));
        }
        return null;
    }

    private Map<String, Integer> computeColumnWidths(Iterable<Map<String, String>> components) throws Exception {
        if (components == null) {
            return null;
        }
        int maxNameLen = NAME_COLUMN_LABEL.length();
        int maxLabelLen = LABEL_COLUMN_LABEL.length();
        int maxDescriptionLen = DESCRIPTION_COLUMN_LABEL.length();
        for (Map<String, String> component : components) {
            String description;
            String label;
            String name = component.get("name");
            if (name != null) {
                maxNameLen = Math.max(maxNameLen, name.length());
            }
            if ((label = component.get("label")) != null) {
                maxLabelLen = Math.max(maxLabelLen, label.length());
            }
            if ((description = component.get("description")) == null) continue;
            maxDescriptionLen = Math.max(maxDescriptionLen, description.length());
        }
        Hashtable<String, Integer> retval = new Hashtable<String, Integer>(3);
        retval.put(NAME_COLUMN_LABEL, maxNameLen);
        retval.put(LABEL_COLUMN_LABEL, maxLabelLen);
        retval.put(DESCRIPTION_COLUMN_LABEL, maxDescriptionLen);
        return retval;
    }

    private String buildFormatString(Map<String, Integer> columnWidths, boolean isHeader) {
        String fieldPostamble;
        String fieldPreamble;
        if (isHeader) {
            fieldPreamble = " ";
            fieldPostamble = " ";
        } else {
            fieldPreamble = " ";
            fieldPostamble = " ";
        }
        int columnWidthIncrement = 0;
        if (this.verbose) {
            int nameLen = Math.min(columnWidths.get(NAME_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
            int labelLen = Math.min(columnWidths.get(LABEL_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
            int descriptionLen = Math.min(columnWidths.get(DESCRIPTION_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
            nameLen = Math.max(12, nameLen);
            labelLen = Math.max(12, labelLen);
            descriptionLen = Math.max(12, descriptionLen);
            StringBuilder retval = new StringBuilder(24);
            retval.append(fieldPreamble).append("%-").append(nameLen).append('.').append(nameLen).append('s').append(fieldPostamble).append(' ');
            retval.append(fieldPreamble).append("%-").append(labelLen).append('.').append(labelLen).append('s').append(fieldPostamble).append(' ');
            retval.append(fieldPreamble).append("%-").append(descriptionLen).append('.').append(descriptionLen).append('s').append(fieldPostamble).append(' ');
            return retval.toString();
        }
        int nameLen = Math.min(columnWidths.get(NAME_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        int labelLen = Math.min(columnWidths.get(LABEL_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        nameLen = Math.max(12, nameLen);
        labelLen = Math.max(12, labelLen);
        StringBuilder retval = new StringBuilder(24);
        retval.append(fieldPreamble).append("%-").append(nameLen).append('.').append(nameLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(labelLen).append('.').append(labelLen).append('s').append(fieldPostamble).append(' ');
        return retval.toString();
    }

    private int getMaxColumnWidth() {
        if (this.verbose) {
            return Integer.MAX_VALUE;
        }
        return 120;
    }
}

