/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.internal.introspection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.jexl2.internal.introspection.ClassMap;
import org.apache.commons.jexl2.internal.introspection.MethodKey;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntrospectorBase {
    protected final Log rlog;
    private final Map<Class<?>, ClassMap> classMethodMaps = new HashMap();
    private ClassLoader loader;
    private final Map<MethodKey, Constructor<?>> constructorsMap = new HashMap();
    private final Map<String, Class<?>> constructibleClasses = new HashMap();
    private static final Constructor<?> CTOR_MISS = CacheMiss.class.getConstructors()[0];

    public IntrospectorBase(Log log) {
        this.rlog = log;
        this.loader = this.getClass().getClassLoader();
    }

    public Method getMethod(Class<?> c, MethodKey key) {
        try {
            ClassMap classMap = this.getMap(c);
            return classMap.findMethod(key);
        }
        catch (MethodKey.AmbiguousException ae) {
            if (this.rlog != null) {
                this.rlog.error((Object)("ambiguous method invocation: " + c.getName() + "." + key.debugString()));
            }
            return null;
        }
    }

    public Field getField(Class<?> c, String key) {
        ClassMap classMap = this.getMap(c);
        return classMap.findField(c, key);
    }

    public String[] getFieldNames(Class<?> c) {
        if (c == null) {
            return new String[0];
        }
        ClassMap classMap = this.getMap(c);
        return classMap.getFieldNames();
    }

    public String[] getMethodNames(Class<?> c) {
        if (c == null) {
            return new String[0];
        }
        ClassMap classMap = this.getMap(c);
        return classMap.getMethodNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoader(ClassLoader cloader) {
        if (cloader == null) {
            cloader = this.getClass().getClassLoader();
        }
        if (!cloader.equals(this.loader)) {
            Map<MethodKey, Constructor<?>> map = this.constructorsMap;
            synchronized (map) {
                this.loader = cloader;
                this.constructorsMap.clear();
                this.constructibleClasses.clear();
            }
        }
    }

    public Constructor<?> getConstructor(MethodKey key) {
        return this.getConstructor(null, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constructor<?> getConstructor(Class<?> c, MethodKey key) {
        try {
            Constructor<?> ctor = null;
            Map<MethodKey, Constructor<?>> map = this.constructorsMap;
            synchronized (map) {
                ctor = this.constructorsMap.get(key);
                if (CTOR_MISS.equals(ctor)) {
                    return null;
                }
                if (ctor == null) {
                    String cname = key.getMethod();
                    Class<?> clazz = this.constructibleClasses.get(cname);
                    try {
                        if (clazz == null) {
                            clazz = c != null && c.getName().equals(key.getMethod()) ? c : this.loader.loadClass(cname);
                            this.constructibleClasses.put(cname, clazz);
                        }
                        LinkedList l = new LinkedList();
                        for (Constructor<?> ictor : clazz.getConstructors()) {
                            l.add(ictor);
                        }
                        ctor = key.getMostSpecificConstructor(l);
                        if (ctor != null) {
                            this.constructorsMap.put(key, ctor);
                        } else {
                            this.constructorsMap.put(key, CTOR_MISS);
                        }
                    }
                    catch (ClassNotFoundException xnotfound) {
                        if (this.rlog.isDebugEnabled()) {
                            this.rlog.debug((Object)("could not load class " + cname), (Throwable)xnotfound);
                        }
                        ctor = null;
                    }
                    catch (MethodKey.AmbiguousException xambiguous) {
                        this.rlog.warn((Object)("ambiguous ctor detected for " + cname), (Throwable)xambiguous);
                        ctor = null;
                    }
                }
            }
            return ctor;
        }
        catch (MethodKey.AmbiguousException ae) {
            if (this.rlog != null) {
                this.rlog.error((Object)("ambiguous constructor invocation: new " + key.debugString()));
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassMap getMap(Class<?> c) {
        Map<Class<?>, ClassMap> map = this.classMethodMaps;
        synchronized (map) {
            ClassMap classMap = this.classMethodMaps.get(c);
            if (classMap == null) {
                classMap = new ClassMap(c, this.rlog);
                this.classMethodMaps.put(c, classMap);
            }
            return classMap;
        }
    }

    private static class CacheMiss {
    }
}

