/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.LocalTransactionEventListener;
import org.apache.activemq.TransactionContext;
import org.apache.activemq.ra.ActiveMQConnectionRequestInfo;
import org.apache.activemq.ra.LocalAndXATransaction;
import org.apache.activemq.ra.ManagedConnectionProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQManagedConnection
implements ManagedConnection,
ExceptionListener {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQManagedConnection.class);
    private PrintWriter logWriter;
    private final ActiveMQConnection physicalConnection;
    private final TransactionContext transactionContext;
    private final List<ManagedConnectionProxy> proxyConnections = new CopyOnWriteArrayList<ManagedConnectionProxy>();
    private final List<ConnectionEventListener> listeners = new CopyOnWriteArrayList<ConnectionEventListener>();
    private final LocalAndXATransaction localAndXATransaction;
    private Subject subject;
    private ActiveMQConnectionRequestInfo info;
    private boolean destroyed;

    public ActiveMQManagedConnection(Subject subject, ActiveMQConnection physicalConnection, ActiveMQConnectionRequestInfo info) throws ResourceException {
        try {
            this.subject = subject;
            this.info = info;
            this.physicalConnection = physicalConnection;
            this.transactionContext = new TransactionContext(physicalConnection);
            this.localAndXATransaction = new LocalAndXATransaction(this.transactionContext){

                @Override
                public void setInManagedTx(boolean inManagedTx) throws JMSException {
                    super.setInManagedTx(inManagedTx);
                    for (ManagedConnectionProxy proxy : ActiveMQManagedConnection.this.proxyConnections) {
                        proxy.setUseSharedTxContext(inManagedTx);
                    }
                }
            };
            this.transactionContext.setLocalTransactionEventListener(new LocalTransactionEventListener(){

                @Override
                public void beginEvent() {
                    ActiveMQManagedConnection.this.fireBeginEvent();
                }

                @Override
                public void commitEvent() {
                    ActiveMQManagedConnection.this.fireCommitEvent();
                }

                @Override
                public void rollbackEvent() {
                    ActiveMQManagedConnection.this.fireRollbackEvent();
                }
            });
            physicalConnection.setExceptionListener(this);
        }
        catch (JMSException e) {
            throw new ResourceException("Could not create a new connection: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean isInManagedTx() {
        return this.localAndXATransaction.isInManagedTx();
    }

    public static boolean matches(Object x, Object y) {
        if (x == null ^ y == null) {
            return false;
        }
        return x == null || x.equals(y);
    }

    public void associate(Subject subject, ActiveMQConnectionRequestInfo info) throws JMSException {
        if (!ActiveMQManagedConnection.matches(info.getUserName(), this.info.getUserName()) || !ActiveMQManagedConnection.matches(info.getPassword(), this.info.getPassword())) {
            this.physicalConnection.changeUserInfo(info.getUserName(), info.getPassword());
        }
        if (info.getClientid() != null && info.getClientid().length() > 0) {
            this.physicalConnection.setClientID(info.getClientid());
        }
        this.subject = subject;
        this.info = info;
    }

    public Connection getPhysicalConnection() {
        return this.physicalConnection;
    }

    private void fireBeginEvent() {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 2);
        for (ConnectionEventListener l : this.listeners) {
            l.localTransactionStarted(event);
        }
    }

    private void fireCommitEvent() {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 3);
        for (ConnectionEventListener l : this.listeners) {
            l.localTransactionCommitted(event);
        }
    }

    private void fireRollbackEvent() {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 4);
        for (ConnectionEventListener l : this.listeners) {
            l.localTransactionRolledback(event);
        }
    }

    private void fireCloseEvent(ManagedConnectionProxy proxy) {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
        event.setConnectionHandle((Object)proxy);
        for (ConnectionEventListener l : this.listeners) {
            l.connectionClosed(event);
        }
    }

    private void fireErrorOccurredEvent(Exception error) {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 5, error);
        for (ConnectionEventListener l : this.listeners) {
            l.connectionErrorOccurred(event);
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        ManagedConnectionProxy proxy = new ManagedConnectionProxy(this, info);
        this.proxyConnections.add(proxy);
        return proxy;
    }

    private boolean isDestroyed() {
        return this.destroyed;
    }

    public void destroy() throws ResourceException {
        if (this.isDestroyed()) {
            return;
        }
        try {
            this.cleanup();
        }
        finally {
            try {
                this.physicalConnection.close();
                this.destroyed = true;
            }
            catch (JMSException e) {
                LOG.trace("Error occurred during close of a JMS connection.", (Throwable)e);
            }
        }
    }

    public void cleanup() throws ResourceException {
        if (this.isDestroyed()) {
            return;
        }
        for (ManagedConnectionProxy proxy : this.proxyConnections) {
            proxy.cleanup();
        }
        this.proxyConnections.clear();
        try {
            this.physicalConnection.doCleanup(true);
        }
        catch (JMSException e) {
            throw new ResourceException("Could not cleanup the ActiveMQ connection: " + (Object)((Object)e), (Throwable)e);
        }
        finally {
            this.localAndXATransaction.cleanup();
        }
    }

    public void associateConnection(Object connection) throws ResourceException {
        if (!(connection instanceof ManagedConnectionProxy)) {
            throw new ResourceException("Not supported : associating connection instance of " + connection.getClass().getName());
        }
        ManagedConnectionProxy proxy = (ManagedConnectionProxy)connection;
        this.proxyConnections.add(proxy);
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove(listener);
    }

    public XAResource getXAResource() throws ResourceException {
        return this.localAndXATransaction;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this.localAndXATransaction;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new ManagedConnectionMetaData(){

            public String getEISProductName() throws ResourceException {
                if (ActiveMQManagedConnection.this.physicalConnection == null) {
                    throw new ResourceException("Not connected.");
                }
                try {
                    return ActiveMQManagedConnection.this.physicalConnection.getMetaData().getJMSProviderName();
                }
                catch (JMSException e) {
                    throw new ResourceException("Error accessing provider.", (Throwable)e);
                }
            }

            public String getEISProductVersion() throws ResourceException {
                if (ActiveMQManagedConnection.this.physicalConnection == null) {
                    throw new ResourceException("Not connected.");
                }
                try {
                    return ActiveMQManagedConnection.this.physicalConnection.getMetaData().getProviderVersion();
                }
                catch (JMSException e) {
                    throw new ResourceException("Error accessing provider.", (Throwable)e);
                }
            }

            public int getMaxConnections() throws ResourceException {
                if (ActiveMQManagedConnection.this.physicalConnection == null) {
                    throw new ResourceException("Not connected.");
                }
                return Integer.MAX_VALUE;
            }

            public String getUserName() throws ResourceException {
                if (ActiveMQManagedConnection.this.physicalConnection == null) {
                    throw new ResourceException("Not connected.");
                }
                try {
                    return ActiveMQManagedConnection.this.physicalConnection.getClientID();
                }
                catch (JMSException e) {
                    throw new ResourceException("Error accessing provider.", (Throwable)e);
                }
            }
        };
    }

    public void setLogWriter(PrintWriter logWriter) throws ResourceException {
        this.logWriter = logWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public boolean matches(Subject subject, ConnectionRequestInfo info) {
        if (info == null) {
            return false;
        }
        if (info.getClass() != ActiveMQConnectionRequestInfo.class) {
            return false;
        }
        if (subject == null ^ this.subject == null) {
            return false;
        }
        if (subject != null && !subject.equals(this.subject)) {
            return false;
        }
        return info.equals((Object)this.info);
    }

    public void proxyClosedEvent(ManagedConnectionProxy proxy) {
        this.proxyConnections.remove(proxy);
        proxy.cleanup();
        this.fireCloseEvent(proxy);
    }

    public void onException(JMSException e) {
        LOG.warn("Connection failed: " + (Object)((Object)e));
        LOG.debug("Cause: ", (Throwable)e);
        for (ManagedConnectionProxy proxy : this.proxyConnections) {
            proxy.onException(e);
        }
        this.fireErrorOccurredEvent((Exception)((Object)e));
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public String toString() {
        return "[" + super.toString() + "," + this.physicalConnection + "]";
    }
}

