/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.io.resource.internal;

import java.net.MalformedURLException;
import java.net.URI;
import org.linkedin.util.io.resource.Resource;
import org.linkedin.util.io.resource.URIResourceFactory;
import org.linkedin.util.io.resource.URLResource;
import org.linkedin.util.io.resource.internal.SchemeURIResourceFactory;

public class SchemeURLResourceFactory
extends SchemeURIResourceFactory {
    private final String _scheme;

    public SchemeURLResourceFactory(String scheme) {
        this._scheme = scheme;
    }

    @Override
    public String getScheme() {
        return this._scheme;
    }

    @Override
    protected Resource doCreateResource(URI uri, URIResourceFactory parent) {
        try {
            return URLResource.createFromRoot(uri.toURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(uri.toString(), e);
        }
    }
}

