/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.direct.DirectConsumer;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ServiceHelper;

public class DirectComponent
extends UriEndpointComponent {
    private final Map<String, DirectConsumer> consumers = new HashMap<String, DirectConsumer>();
    private boolean block;
    @Metadata(defaultValue="30000")
    private long timeout = 30000L;

    public DirectComponent() {
        super(DirectEndpoint.class);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        DirectEndpoint endpoint = new DirectEndpoint(uri, this, this.consumers);
        endpoint.setBlock(this.block);
        endpoint.setTimeout(this.timeout);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.consumers);
        this.consumers.clear();
        super.doStop();
    }

    public boolean isBlock() {
        return this.block;
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

