/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RouteNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.TraceInterceptor;
import org.apache.camel.spi.TracedRouteNodes;
import org.apache.camel.util.MessageHelper;

public class DefaultTraceFormatter
implements TraceFormatter {
    private int breadCrumbLength;
    private int nodeLength;
    private boolean showBreadCrumb = true;
    private boolean showNode = true;
    private boolean showExchangeId;
    private boolean showShortExchangeId;
    private boolean showExchangePattern = true;
    private boolean showProperties;
    private boolean showHeaders = true;
    private boolean showBody = true;
    private boolean showBodyType = true;
    private boolean showOutHeaders;
    private boolean showOutBody;
    private boolean showOutBodyType;
    private boolean showException = true;
    private boolean showRouteId = true;
    private int maxChars = 10000;

    @Override
    public Object format(TraceInterceptor interceptor, ProcessorDefinition<?> node, Exchange exchange) {
        Message in = exchange.getIn();
        Message out = null;
        if (exchange.hasOut()) {
            out = exchange.getOut();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.extractBreadCrumb(interceptor, node, exchange));
        if (this.showExchangePattern) {
            sb.append(", Pattern:").append((Object)exchange.getPattern());
        }
        if (this.showProperties && !exchange.getProperties().isEmpty()) {
            sb.append(", Properties:").append(exchange.getProperties());
        }
        if (this.showHeaders && !in.getHeaders().isEmpty()) {
            sb.append(", Headers:").append(in.getHeaders());
        }
        if (this.showBodyType) {
            sb.append(", BodyType:").append(MessageHelper.getBodyTypeName(in));
        }
        if (this.showBody) {
            sb.append(", Body:").append(MessageHelper.extractBodyForLogging(in, ""));
        }
        if (this.showOutHeaders && out != null) {
            sb.append(", OutHeaders:").append(out.getHeaders());
        }
        if (this.showOutBodyType && out != null) {
            sb.append(", OutBodyType:").append(MessageHelper.getBodyTypeName(out));
        }
        if (this.showOutBody && out != null) {
            sb.append(", OutBody:").append(MessageHelper.extractBodyForLogging(out, ""));
        }
        if (this.showException && exchange.getException() != null) {
            sb.append(", Exception:").append(exchange.getException());
        }
        String s = sb.toString();
        s = s.replaceFirst("<<<,", "<<<");
        if (this.maxChars > 0) {
            if (s.length() > this.maxChars) {
                s = s.substring(0, this.maxChars) + "...";
            }
            return s;
        }
        return s;
    }

    public boolean isShowBody() {
        return this.showBody;
    }

    public void setShowBody(boolean showBody) {
        this.showBody = showBody;
    }

    public boolean isShowBodyType() {
        return this.showBodyType;
    }

    public void setShowBodyType(boolean showBodyType) {
        this.showBodyType = showBodyType;
    }

    public void setShowOutBody(boolean showOutBody) {
        this.showOutBody = showOutBody;
    }

    public boolean isShowOutBody() {
        return this.showOutBody;
    }

    public void setShowOutBodyType(boolean showOutBodyType) {
        this.showOutBodyType = showOutBodyType;
    }

    public boolean isShowOutBodyType() {
        return this.showOutBodyType;
    }

    public boolean isShowBreadCrumb() {
        return this.showBreadCrumb;
    }

    public void setShowBreadCrumb(boolean showBreadCrumb) {
        this.showBreadCrumb = showBreadCrumb;
    }

    public boolean isShowExchangeId() {
        return this.showExchangeId;
    }

    public void setShowExchangeId(boolean showExchangeId) {
        this.showExchangeId = showExchangeId;
    }

    public boolean isShowHeaders() {
        return this.showHeaders;
    }

    public void setShowHeaders(boolean showHeaders) {
        this.showHeaders = showHeaders;
    }

    public boolean isShowOutHeaders() {
        return this.showOutHeaders;
    }

    public void setShowOutHeaders(boolean showOutHeaders) {
        this.showOutHeaders = showOutHeaders;
    }

    public boolean isShowProperties() {
        return this.showProperties;
    }

    public void setShowProperties(boolean showProperties) {
        this.showProperties = showProperties;
    }

    public boolean isShowNode() {
        return this.showNode;
    }

    public void setShowNode(boolean showNode) {
        this.showNode = showNode;
    }

    public boolean isShowExchangePattern() {
        return this.showExchangePattern;
    }

    public void setShowExchangePattern(boolean showExchangePattern) {
        this.showExchangePattern = showExchangePattern;
    }

    public boolean isShowException() {
        return this.showException;
    }

    public void setShowException(boolean showException) {
        this.showException = showException;
    }

    public boolean isShowRouteId() {
        return this.showRouteId;
    }

    public void setShowRouteId(boolean showRouteId) {
        this.showRouteId = showRouteId;
    }

    public int getBreadCrumbLength() {
        return this.breadCrumbLength;
    }

    public void setBreadCrumbLength(int breadCrumbLength) {
        this.breadCrumbLength = breadCrumbLength;
    }

    public boolean isShowShortExchangeId() {
        return this.showShortExchangeId;
    }

    public void setShowShortExchangeId(boolean showShortExchangeId) {
        this.showShortExchangeId = showShortExchangeId;
    }

    public int getNodeLength() {
        return this.nodeLength;
    }

    public void setNodeLength(int nodeLength) {
        this.nodeLength = nodeLength;
    }

    public int getMaxChars() {
        return this.maxChars;
    }

    public void setMaxChars(int maxChars) {
        this.maxChars = maxChars;
    }

    protected String extractRoute(ProcessorDefinition<?> node) {
        RouteDefinition route = ProcessorDefinitionHelper.getRoute(node);
        if (route != null) {
            return route.getId();
        }
        return null;
    }

    protected Object getBreadCrumbID(Exchange exchange) {
        return exchange.getExchangeId();
    }

    protected String getNodeMessage(RouteNode entry, Exchange exchange) {
        String message = entry.getLabel(exchange);
        if (this.nodeLength > 0) {
            return String.format("%1$-" + this.nodeLength + "." + this.nodeLength + "s", message);
        }
        return message;
    }

    protected String extractBreadCrumb(TraceInterceptor interceptor, ProcessorDefinition<?> currentNode, Exchange exchange) {
        String result;
        String id = "";
        if (!(this.showBreadCrumb || this.showExchangeId || this.showShortExchangeId || this.showNode)) {
            return "";
        }
        if (this.showBreadCrumb) {
            id = this.getBreadCrumbID(exchange).toString();
        } else if (this.showExchangeId || this.showShortExchangeId) {
            id = this.getBreadCrumbID(exchange).toString();
            if (this.showShortExchangeId) {
                id = id.substring(id.lastIndexOf(45) + 1);
            }
        }
        String from = "";
        String to = "";
        String route = "";
        if ((this.showNode || this.showRouteId) && exchange.getUnitOfWork() != null) {
            TracedRouteNodes traced = exchange.getUnitOfWork().getTracedRouteNodes();
            RouteNode traceFrom = traced.getSecondLastNode();
            if (traceFrom != null) {
                from = this.getNodeMessage(traceFrom, exchange);
            } else if (exchange.getFromEndpoint() != null) {
                from = "from(" + exchange.getFromEndpoint().getEndpointUri() + ")";
            }
            RouteNode traceTo = traced.getLastNode();
            if (traceTo != null) {
                to = this.getNodeMessage(traceTo, exchange);
                if (traceTo.isAbstract() && traceTo.getProcessorDefinition() == null) {
                    traceTo = traced.getSecondLastNode();
                }
                if (traceTo != null) {
                    route = this.extractRoute(traceTo.getProcessorDefinition());
                }
            }
        }
        if (this.showNode) {
            result = this.showRouteId && route != null ? id.trim() + " >>> (" + route + ") " + from + " --> " + to.trim() + " <<< " : id.trim() + " >>> " + from + " --> " + to.trim() + " <<< ";
            if (interceptor.shouldTraceOutExchanges() && exchange.hasOut()) {
                result = result + " (OUT) ";
            }
        } else {
            result = id;
        }
        if (this.breadCrumbLength > 0) {
            return String.format("%1$-" + this.breadCrumbLength + "." + this.breadCrumbLength + "s", result.trim());
        }
        return result.trim();
    }
}

