/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.journal.active;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.activeio.journal.active.Record;

public final class LogFile {
    private final RandomAccessFile file;
    private final FileChannel channel;
    private final int initialSize;
    private int currentOffset;
    private boolean disposed;

    public LogFile(File file, int initialSize) throws IOException {
        this.initialSize = initialSize;
        boolean initializationNeeeded = !file.exists();
        this.file = new RandomAccessFile(file, "rw");
        this.channel = this.file.getChannel();
        if (initializationNeeeded) {
            this.resize();
        }
        this.channel.position(0L);
        this.reloadCurrentOffset();
    }

    private void seek(int offset) throws IOException {
        if (offset == this.currentOffset) {
            if ((long)this.currentOffset != this.channel.position()) {
                throw new RuntimeException(" " + this.currentOffset + ", " + this.channel.position());
            }
            return;
        }
        this.channel.position(offset);
        this.currentOffset = offset;
    }

    private void reloadCurrentOffset() throws IOException {
        this.currentOffset = (int)this.channel.position();
    }

    private void addToCurrentOffset(int rc) {
        this.currentOffset += rc;
    }

    public boolean loadAndCheckRecord(int offset, Record record) throws IOException {
        try {
            this.seek(offset);
            record.readHeader(this.file);
            if (Record.isChecksumingEnabled()) {
                record.checksum(this.file);
            }
            this.seek(offset + record.getPayloadLength() + 16);
            record.readFooter(this.file);
            this.addToCurrentOffset(record.getRecordLength());
            return true;
        }
        catch (IOException e) {
            this.reloadCurrentOffset();
            return false;
        }
    }

    public void resize() throws IOException {
        this.file.setLength(this.initialSize);
    }

    public void force() throws IOException {
        this.channel.force(false);
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(int offset, ByteBuffer buffer) throws IOException {
        try {
            int size = buffer.remaining();
            this.seek(offset);
            while (buffer.hasRemaining()) {
                this.channel.write(buffer);
            }
            this.addToCurrentOffset(size);
        }
        catch (IOException e) {
            this.reloadCurrentOffset();
        }
    }

    public void readRecordHeader(int offset, Record record) throws IOException {
        this.seek(offset);
        try {
            record.readHeader(this.file);
        }
        catch (IOException e) {
            this.reloadCurrentOffset();
            throw e;
        }
        this.addToCurrentOffset(16);
    }

    public void read(int offset, byte[] answer) throws IOException {
        this.seek(offset);
        this.file.readFully(answer);
        this.addToCurrentOffset(answer.length);
    }

    public void copyTo(File location) throws IOException {
        FileOutputStream fos = new FileOutputStream(location);
        this.channel.transferTo(0L, this.channel.size(), fos.getChannel());
        fos.getChannel().force(false);
        fos.close();
    }
}

