/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.namespace;

import java.io.Serializable;

public class QName
implements Serializable {
    private static final long serialVersionUID = -9120448754896609940L;
    private final String namespaceURI;
    private final String localPart;
    private final String prefix;

    public QName(String localPart) {
        this("", localPart, "");
    }

    public QName(String namespaceURI, String localPart) {
        this(namespaceURI, localPart, "");
    }

    public QName(String namespaceURI, String localPart, String prefix) {
        String string = this.namespaceURI = namespaceURI == null ? "" : namespaceURI;
        if (localPart == null) {
            throw new IllegalArgumentException("local part is required when creating a QName");
        }
        this.localPart = localPart;
        if (prefix == null) {
            throw new IllegalArgumentException("prefix is required when creating a QName");
        }
        this.prefix = prefix;
    }

    public final boolean equals(Object other) {
        if (other == null || !(other instanceof QName)) {
            return false;
        }
        QName qName = (QName)other;
        return this.namespaceURI.equals(qName.namespaceURI) && this.localPart.equals(qName.localPart);
    }

    public final int hashCode() {
        return this.namespaceURI.hashCode() ^ this.localPart.hashCode();
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String toString() {
        if (this.namespaceURI.length() == 0) {
            return this.localPart;
        }
        return "{" + this.namespaceURI + "}" + this.localPart;
    }

    public static QName valueOf(String source) {
        if (source == null) {
            throw new IllegalArgumentException("source QName string is required");
        }
        if (source.length() == 0 || source.charAt(0) != '{') {
            return new QName(source);
        }
        int uriEnd = source.indexOf(125);
        if (uriEnd == -1) {
            throw new IllegalArgumentException("Incorrect QName syntax: " + source);
        }
        String uri = source.substring(1, uriEnd);
        if (uri.length() == 0) {
            throw new IllegalArgumentException("Null namespace URI in QName value: " + source);
        }
        return new QName(uri, source.substring(uriEnd + 1));
    }
}

