/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal;

import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.internal.EPSGFactoryProxy;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.util.FactoryException;

public final class EPSGFactoryProxyDatum
extends EPSGFactoryProxy
implements DatumAuthorityFactory {
    private volatile DatumAuthorityFactory factory;

    DatumAuthorityFactory factory() throws FactoryException {
        DatumAuthorityFactory f = this.factory;
        if (f == null) {
            this.factory = f = (DatumAuthorityFactory)CRS.getAuthorityFactory("EPSG");
        }
        return f;
    }

    public Datum createDatum(String code) throws FactoryException {
        return this.factory().createDatum(code);
    }

    public GeodeticDatum createGeodeticDatum(String code) throws FactoryException {
        return this.factory().createGeodeticDatum(code);
    }

    public Ellipsoid createEllipsoid(String code) throws FactoryException {
        return this.factory().createEllipsoid(code);
    }

    public PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        return this.factory().createPrimeMeridian(code);
    }

    public EngineeringDatum createEngineeringDatum(String code) throws FactoryException {
        return this.factory().createEngineeringDatum(code);
    }

    @Deprecated(since="1.5")
    public ImageDatum createImageDatum(String code) throws FactoryException {
        return this.factory().createImageDatum(code);
    }

    public TemporalDatum createTemporalDatum(String code) throws FactoryException {
        return this.factory().createTemporalDatum(code);
    }

    public VerticalDatum createVerticalDatum(String code) throws FactoryException {
        return this.factory().createVerticalDatum(code);
    }
}

