/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.esri;

import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.Buffer;
import org.apache.sis.coverage.grid.GridDerivation;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.internal.shared.RangeArgument;
import org.apache.sis.image.DataType;
import org.apache.sis.image.internal.shared.ImageUtilities;
import org.apache.sis.image.internal.shared.RasterFactory;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.io.stream.HyperRectangleReader;
import org.apache.sis.io.stream.Region;
import org.apache.sis.pending.jdk.JDK18;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.shared.Numerics;

final class RawRasterReader
extends HyperRectangleReader {
    private static final int BIDIMENSIONAL = 2;
    private static final int X_DIMENSION = 0;
    private static final int Y_DIMENSION = 1;
    final GridGeometry gridGeometry;
    private final DataType dataType;
    final SampleModel layout;
    private final int bandGapBytes;
    private GridGeometry effectiveDomain;

    public RawRasterReader(GridGeometry gridGeometry, DataType dataType, SampleModel layout, int bandGapBytes, ChannelDataInput input) throws DataStoreContentException {
        super(ImageUtilities.toNumberEnum((DataType)dataType), input);
        this.gridGeometry = gridGeometry;
        this.dataType = dataType;
        this.layout = layout;
        this.bandGapBytes = bandGapBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WritableRaster read(GridGeometry domain, RangeArgument range) throws DataStoreException, IOException {
        Buffer[] buffer;
        long[] subsampling;
        int pixelStrideDivisor;
        int pixelStrideNumerator;
        int scanlineStride;
        SampleModel cm;
        int width = this.layout.getWidth();
        int height = this.layout.getHeight();
        if (this.layout instanceof ComponentSampleModel) {
            cm = (ComponentSampleModel)this.layout;
            scanlineStride = ((ComponentSampleModel)cm).getScanlineStride();
            pixelStrideNumerator = ((ComponentSampleModel)cm).getPixelStride();
            pixelStrideDivisor = 1;
        } else {
            cm = (MultiPixelPackedSampleModel)this.layout;
            scanlineStride = ((MultiPixelPackedSampleModel)cm).getScanlineStride();
            pixelStrideNumerator = ((MultiPixelPackedSampleModel)cm).getPixelBitStride();
            pixelStrideDivisor = DataBuffer.getDataTypeSize(this.layout.getDataType());
        }
        long[] fullSize = new long[]{scanlineStride, height};
        long[] regionLower = new long[2];
        long[] regionUpper = (long[])fullSize.clone();
        if (domain == null) {
            domain = this.gridGeometry;
            subsampling = new long[]{1L, 1L};
        } else {
            int firstModifiableDimension = 0;
            GridDerivation gd = this.gridGeometry.derive();
            if (pixelStrideDivisor > 1) {
                gd.chunkSize(new int[]{pixelStrideDivisor / pixelStrideNumerator});
            }
            if (pixelStrideNumerator != pixelStrideDivisor) {
                gd.maximumSubsampling(new long[]{1L});
            }
            if (this.layout.getClass() == ComponentSampleModel.class) {
                firstModifiableDimension = 1;
                gd.chunkSize(new int[]{scanlineStride});
                gd.maximumSubsampling(new long[]{1L});
            }
            GridExtent ex = gd.subgrid(domain).getIntersection();
            for (int i = firstModifiableDimension; i < 2; ++i) {
                regionLower[i] = ex.getLow(i);
                regionUpper[i] = Math.incrementExact(ex.getHigh(i));
            }
            if (0 >= firstModifiableDimension) {
                regionLower[0] = Math.floorDiv(Math.multiplyExact(regionLower[0], pixelStrideNumerator), pixelStrideDivisor);
                regionUpper[0] = JDK18.ceilDiv((long)Math.multiplyExact(regionUpper[0], pixelStrideNumerator), (long)pixelStrideDivisor);
            }
            subsampling = gd.getSubsampling();
            domain = gd.build();
        }
        Region region = new Region(fullSize, regionLower, regionUpper, subsampling);
        int regionWidth = region.getTargetSize(0);
        int regionHeight = region.getTargetSize(1);
        SampleModel sm = this.layout;
        boolean bandSubsetApplied = range.isIdentity();
        if (sm instanceof BandedSampleModel) {
            BandedSampleModel cm2 = (BandedSampleModel)sm;
            if (!ArraysExt.allEquals((int[])cm2.getBandOffsets(), (int)0) && ArraysExt.isRange((int)0, (int[])cm2.getBankIndices())) {
                throw new DataStoreException("Not yet supported.");
            }
            int numBands = range.getNumBands();
            int[] bankIndices = ArraysExt.range((int)0, (int)numBands);
            int[] bandOffsets = new int[numBands];
            long bandStride = Math.addExact(Math.multiplyFull(width, height), (long)this.bandGapBytes);
            long origin = this.getOrigin();
            buffer = new Buffer[numBands];
            try {
                for (int i = 0; i < numBands; ++i) {
                    int band = range.getSourceIndex(i);
                    this.setOrigin(Math.addExact(origin, Math.multiplyExact(bandStride, band)));
                    buffer[range.getTargetIndex((int)i)] = this.readAsBuffer(region, 0);
                }
            }
            finally {
                this.setOrigin(origin);
            }
            if (!bandSubsetApplied) {
                sm = new BandedSampleModel(cm2.getDataType(), width, height, scanlineStride, bankIndices, bandOffsets);
                bandSubsetApplied = true;
            }
        } else {
            buffer = new Buffer[]{this.readAsBuffer(region, 0)};
            regionWidth = Numerics.wholeDiv((int)regionWidth, (int)sm.getNumBands());
        }
        if (regionWidth != width || regionHeight != height) {
            sm = sm.createCompatibleSampleModel(regionWidth, regionHeight);
        }
        DataBuffer data = RasterFactory.wrap((DataType)this.dataType, (Buffer[])buffer);
        WritableRaster raster = WritableRaster.createWritableRaster(sm, data, null);
        if (!bandSubsetApplied) {
            raster = raster.createWritableChild(0, 0, raster.getWidth(), raster.getHeight(), 0, 0, range.getSelectedBands());
        }
        this.effectiveDomain = domain;
        return raster;
    }

    final GridGeometry getEffectiveDomain() {
        GridGeometry domain = this.effectiveDomain;
        this.effectiveDomain = null;
        return domain;
    }
}

