/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.math;

import java.util.Set;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.FunctionRegister;
import org.apache.sis.filter.math.BinaryOperator;
import org.apache.sis.filter.math.Function;
import org.apache.sis.filter.math.Predicate;
import org.apache.sis.filter.math.UnaryOperator;
import org.apache.sis.pending.geoapi.filter.AvailableFunction;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.internal.shared.ViewAsSet;

public final class Registry
implements FunctionRegister {
    @Override
    public String getAuthority() {
        return "SIS";
    }

    @Override
    public Set<String> getNames() {
        return new ViewAsSet(Function.namesAndAliases());
    }

    public AvailableFunction describe(String name) {
        return Function.of(name);
    }

    @Override
    public <R> Expression<R, ?> create(String name, Expression<R, ?>[] parameters) {
        Function function = Function.of(name);
        ArgumentChecks.ensureCountBetween((String)"parameters", (boolean)false, (int)function.getMinParameterCount(), (int)function.getMaxParameterCount(), (int)parameters.length);
        Expression<R, Number> p0 = parameters[0].toValueType(Number.class);
        if (parameters.length == 1) {
            if (function.filter != null) {
                return new Predicate<R>(function, p0);
            }
            return new UnaryOperator<R>(function, p0);
        }
        return new BinaryOperator<R>(function, p0, parameters[1].toValueType(Number.class));
    }
}

